/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.validation.impl;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentDetail;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentInProcessPayment;
import org.kuali.kfs.module.cam.document.AssetPaymentDocument;
import org.kuali.kfs.module.cam.document.validation.impl.AssetPaymentInProcessPaymentValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.mockito.Mockito;

public class AssetPaymentInProcessPaymentValidationTest {
    public static final Integer SEQUENCE_NUMBER1 = 1;

    @Test
    public void testValidate_noInProcessPayments() {
        ArrayList<AssetPaymentInProcessPayment> assetPaymentInProcessPayments = new ArrayList<AssetPaymentInProcessPayment>();
        ArrayList<AssetPaymentDetail> assetPaymentDetails = new ArrayList<AssetPaymentDetail>();
        boolean valid = this.validationHelper(assetPaymentInProcessPayments, assetPaymentDetails);
        TestCase.assertTrue((String)"Nothing needed to be validated, so it should pass.", (boolean)valid);
    }

    @Test
    public void testValidate_inProcessPayments_toZero() {
        List<AssetPaymentInProcessPayment> assetPaymentInProcessPayments = this.generateAssetPaymentInProcessPayments(new KualiDecimal(-25), new KualiDecimal(-25));
        List<AssetPaymentDetail> assetPaymentDetails = this.generateAssetPaymentDetails(new KualiDecimal(50));
        boolean valid = this.validationHelper(assetPaymentInProcessPayments, assetPaymentDetails);
        TestCase.assertTrue((String)"In process payments should balance with the source accounting line.", (boolean)valid);
    }

    @Test
    public void testValidate_inProcessPayments_noneZero() {
        List<AssetPaymentInProcessPayment> assetPaymentInProcessPayments = this.generateAssetPaymentInProcessPayments(new KualiDecimal(-25), new KualiDecimal(-25));
        List<AssetPaymentDetail> assetPaymentDetails = this.generateAssetPaymentDetails(new KualiDecimal(40));
        boolean valid = this.validationHelper(assetPaymentInProcessPayments, assetPaymentDetails);
        Assert.assertFalse((String)"In process payments should not balance with the source accounting line.", (boolean)valid);
    }

    protected List<AssetPaymentInProcessPayment> generateAssetPaymentInProcessPayments(KualiDecimal assetPayment1AccountChargeAmount, KualiDecimal assetPayment2AccountChargeAmount) {
        ArrayList<AssetPaymentInProcessPayment> assetPaymentInProcessPayments = new ArrayList<AssetPaymentInProcessPayment>();
        AssetPayment assetPayment1 = new AssetPayment();
        assetPayment1.setAccountChargeAmount(assetPayment1AccountChargeAmount);
        AssetPaymentInProcessPayment assetPaymentInProcessPayment1 = (AssetPaymentInProcessPayment)Mockito.mock(AssetPaymentInProcessPayment.class);
        Mockito.when((Object)assetPaymentInProcessPayment1.getSequenceNumber()).thenReturn((Object)SEQUENCE_NUMBER1);
        Mockito.when((Object)assetPaymentInProcessPayment1.getAssetPayment()).thenReturn((Object)assetPayment1);
        assetPaymentInProcessPayments.add(assetPaymentInProcessPayment1);
        AssetPayment assetPayment2 = new AssetPayment();
        assetPayment2.setAccountChargeAmount(assetPayment2AccountChargeAmount);
        AssetPaymentInProcessPayment assetPaymentInProcessPayment2 = (AssetPaymentInProcessPayment)Mockito.mock(AssetPaymentInProcessPayment.class);
        Mockito.when((Object)assetPaymentInProcessPayment2.getSequenceNumber()).thenReturn((Object)SEQUENCE_NUMBER1);
        Mockito.when((Object)assetPaymentInProcessPayment2.getAssetPayment()).thenReturn((Object)assetPayment2);
        assetPaymentInProcessPayments.add(assetPaymentInProcessPayment2);
        return assetPaymentInProcessPayments;
    }

    protected List<AssetPaymentDetail> generateAssetPaymentDetails(KualiDecimal assetPaymentDetail1Amount) {
        ArrayList<AssetPaymentDetail> assetPaymentDetails = new ArrayList<AssetPaymentDetail>();
        AssetPaymentDetail assetPaymentDetail = new AssetPaymentDetail();
        assetPaymentDetail.setSequenceNumber(SEQUENCE_NUMBER1);
        assetPaymentDetail.setAmount(assetPaymentDetail1Amount);
        assetPaymentDetails.add(assetPaymentDetail);
        return assetPaymentDetails;
    }

    protected boolean validationHelper(List<AssetPaymentInProcessPayment> assetPaymentInProcessPayments, List<AssetPaymentDetail> assetPaymentDetails) {
        AttributedDocumentEvent attributedDocumentEvent = (AttributedDocumentEvent)Mockito.mock(AttributedDocumentEvent.class);
        AssetPaymentDocument assetPaymentDocument = (AssetPaymentDocument)Mockito.mock(AssetPaymentDocument.class);
        Mockito.when((Object)attributedDocumentEvent.getDocument()).thenReturn((Object)assetPaymentDocument);
        Mockito.when((Object)assetPaymentDocument.getAssetPaymentInProcessPayments()).thenReturn(assetPaymentInProcessPayments);
        Mockito.when((Object)assetPaymentDocument.getSourceAccountingLines()).thenReturn(assetPaymentDetails);
        AssetPaymentInProcessPaymentValidation assetPaymentInProcessPaymentValidation = new AssetPaymentInProcessPaymentValidation();
        return assetPaymentInProcessPaymentValidation.validate(attributedDocumentEvent);
    }
}

