/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam;

/**
 * Holds constants for CAB business parameters.
 */
public class CamsParameterConstants {

    public static class CapitalAsset {
        public static final String CAPITAL_ASSET_OBJECT_LEVELS = "PURCHASING_ACCOUNTS_PAYABLE_OBJECT_LEVELS";
        public static final String POSSIBLE_CAPITAL_ASSET_OBJECT_LEVELS = "PURCHASING_ACCOUNTS_PAYABLE_POSSIBLE_OBJECT_LEVELS";
        public static final String CAPITALIZATION_LIMIT_AMOUNT = "CAPITALIZATION_LIMIT_AMOUNT";
        public static final String RECURRING_CAMS_TRAN_TYPES = "PURCHASING_ASSET_TRANSACTION_TYPES_REQUIRING_RECURRING_PAYMENT_TERMS";
        public static final String PURCHASING_ASSET_TRANSACTION_TYPES_ALLOWING_ASSET_NUMBERS = "PURCHASING_ASSET_TRANSACTION_TYPES_ALLOWING_ASSET_NUMBERS";
        public static final String FINANCIAL_PROCESSING_CAPITAL_OBJECT_SUB_TYPES = "FINANCIAL_PROCESSING_CAPITAL_OBJECT_SUB_TYPES";
        public static final String VENDOR_REQUIRED_FOR_NON_MOVEABLE_ASSET_IND = "VENDOR_REQUIRED_FOR_NON_MOVEABLE_ASSET_IND";
        public static final String MANUFACTURER_REQUIRED_FOR_NON_MOVEABLE_ASSET_IND = "MANUFACTURER_REQUIRED_FOR_NON_MOVEABLE_ASSET_IND";
    }
}
