/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.businessobject;

import org.kuali.kfs.module.cam.CamsPropertyConstants;
import org.kuali.kfs.sys.businessobject.AccountingLineParserBase;

public class AssetPaymentAccountingLineParser extends AccountingLineParserBase {
    protected static final String[] AP_FORMAT =
        {CamsPropertyConstants.AssetPaymentDetail.CHART_OF_ACCOUNTS_CODE, CamsPropertyConstants.AssetPaymentDetail.ACCOUNT_NUMBER, CamsPropertyConstants.AssetPaymentDetail.SUB_ACCOUNT_NUMBER, CamsPropertyConstants.AssetPaymentDetail.FINANCIAL_OBJECT_CODE, CamsPropertyConstants.AssetPaymentDetail.SUB_OBJECT_CODE, CamsPropertyConstants.AssetPaymentDetail.PROJECT_CODE, CamsPropertyConstants.AssetPaymentDetail.ORGANIZATION_REFERENCE_ID, CamsPropertyConstants.AssetPaymentDetail.AMOUNT,
            CamsPropertyConstants.AssetPaymentDetail.PURCHASE_ORDER,
            CamsPropertyConstants.AssetPaymentDetail.REQUISITION_NUMBER,
            CamsPropertyConstants.AssetPaymentDetail.ORIGINATION_CODE,
            CamsPropertyConstants.AssetPaymentDetail.DOCUMENT_NUMBER,
            CamsPropertyConstants.AssetPaymentDetail.DOCUMENT_TYPE_CODE,
            CamsPropertyConstants.AssetPaymentDetail.DOCUMENT_POSTING_DATE
        };

    public AssetPaymentAccountingLineParser() {
        super();
    }

    /**
     * @see org.kuali.kfs.sys.businessobject.AccountingLineParserBase#getSourceAccountingLineFormat()
     */
    @Override
    public String[] getSourceAccountingLineFormat() {
        return removeChartFromFormatIfNeeded(AP_FORMAT);
    }
}
