/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.businessobject;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.sys.businessobject.Building;
import org.kuali.kfs.sys.businessobject.Room;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.location.api.LocationConstants;
import org.kuali.rice.location.framework.campus.CampusEbo;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

/**
 * Class for the barcode inventory error detail
 */
public class BarcodeInventoryErrorDetail extends PersistableBusinessObjectBase {
    private String documentNumber;
    private Long uploadRowNumber;
    private String errorCorrectionStatusCode;
    private String correctorUniversalIdentifier;
    private Timestamp inventoryCorrectionTimestamp;
    private String assetTagNumber;
    private boolean uploadScanIndicator;
    private Timestamp uploadScanTimestamp;
    private String campusCode;
    private String buildingCode;
    private String buildingRoomNumber;
    private String buildingSubRoomNumber;
    private String assetConditionCode;

    // References
    private CampusEbo campus;
    private Room buildingRoom;
    private Building building;
    private AssetCondition condition;

    // error description. This field is not being saved in any table.
    private String errorDescription;

    public BarcodeInventoryErrorDetail() {

    }

    public String getDocumentNumber() {
        return documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public Long getUploadRowNumber() {
        return uploadRowNumber;
    }

    public void setUploadRowNumber(Long uploadRowNumber) {
        this.uploadRowNumber = uploadRowNumber;
    }

    public String getErrorCorrectionStatusCode() {
        return errorCorrectionStatusCode;
    }

    public void setErrorCorrectionStatusCode(String errorCorrectionStatusCode) {
        this.errorCorrectionStatusCode = errorCorrectionStatusCode;
    }

    public String getCorrectorUniversalIdentifier() {
        return correctorUniversalIdentifier;
    }

    public void setCorrectorUniversalIdentifier(String correctorUniversalIdentifier) {
        this.correctorUniversalIdentifier = correctorUniversalIdentifier;
    }

    public Timestamp getInventoryCorrectionTimestamp() {
        return inventoryCorrectionTimestamp;
    }

    public void setInventoryCorrectionTimestamp(Timestamp inventoryCorrectionTimestamp) {
        this.inventoryCorrectionTimestamp = inventoryCorrectionTimestamp;
    }

    public String getAssetTagNumber() {
        return assetTagNumber;
    }

    public void setAssetTagNumber(String assetTagNumber) {
        this.assetTagNumber = assetTagNumber;
    }

    public boolean isUploadScanIndicator() {
        return uploadScanIndicator;
    }

    public void setUploadScanIndicator(boolean uploadScanIndicator) {
        this.uploadScanIndicator = uploadScanIndicator;
    }

    public Timestamp getUploadScanTimestamp() {
        return uploadScanTimestamp;
    }

    public void setUploadScanTimestamp(Timestamp uploadScanTimestamp) {
        this.uploadScanTimestamp = uploadScanTimestamp;
    }

    public String getCampusCode() {
        return campusCode;
    }

    public void setCampusCode(String campusCode) {
        this.campusCode = campusCode;
    }

    public String getBuildingCode() {
        return buildingCode;
    }

    public void setBuildingCode(String buildingCode) {
        this.buildingCode = buildingCode;
    }

    public String getBuildingRoomNumber() {
        return buildingRoomNumber;
    }

    public void setBuildingRoomNumber(String buildingRoomNumber) {
        this.buildingRoomNumber = buildingRoomNumber;
    }

    public String getBuildingSubRoomNumber() {
        return buildingSubRoomNumber;
    }

    public void setBuildingSubRoomNumber(String buildingSubRoomNumber) {
        this.buildingSubRoomNumber = buildingSubRoomNumber;
    }

    public String getAssetConditionCode() {
        return assetConditionCode;
    }

    public void setAssetConditionCode(String assetConditionCode) {
        this.assetConditionCode = assetConditionCode;
    }

    public CampusEbo getCampus() {
        if (StringUtils.isBlank(campusCode)) {
            campus = null;
        } else {
            if (campus == null || !StringUtils.equals(campus.getCode(), campusCode)) {
                ModuleService moduleService = SpringContext.getBean(KualiModuleService.class).getResponsibleModuleService(CampusEbo.class);
                if (moduleService != null) {
                    Map<String, Object> keys = new HashMap<>(1);
                    keys.put(LocationConstants.PrimaryKeyConstants.CODE, campusCode);
                    campus = moduleService.getExternalizableBusinessObject(CampusEbo.class, keys);
                } else {
                    throw new RuntimeException("CONFIGURATION ERROR: No responsible module found for EBO class.  Unable to proceed.");
                }
            }
        }

        return campus;
    }

    public void setCampus(CampusEbo campus) {
        this.campus = campus;
    }

    public Room getBuildingRoom() {
        return buildingRoom;
    }

    public void setBuildingRoom(Room buildingRoom) {
        this.buildingRoom = buildingRoom;
    }

    public Building getBuilding() {
        return building;
    }

    public void setBuilding(Building building) {
        this.building = building;
    }

    public AssetCondition getCondition() {
        return condition;
    }

    public void setCondition(AssetCondition condition) {
        this.condition = condition;
    }

    public String getErrorDescription() {
        return errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }
}
