/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam;

import org.junit.Assert;
import org.kuali.kfs.gl.businessobject.Entry;
import org.kuali.kfs.module.cam.PurApAccountLineGroupTest;
import org.kuali.kfs.module.cam.businessobject.GlAccountLineGroup;
import org.kuali.kfs.module.cam.businessobject.PurApAccountLineGroup;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestAccountRevision;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLineBase;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.util.type.KualiDecimal;

@ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=false)
public class AccountLineGroupTest
extends KualiTestBase {
    public void testEquals() {
        GlAccountLineGroup first = this.createAccountLineGroup(2008, "BL", "BL002323", "--", "7000", "--------", "01", "1001", null, "D");
        GlAccountLineGroup second = this.createAccountLineGroup(2008, "BL", "BL002323", "------", "7000", null, "01", "1001", null, "C");
        PurApAccountLineGroup third = this.createPurApAccountLineGroup(2008, "BL", "BL002323", "---", "7000", null, "01", "1001", "----", new KualiDecimal(100), PaymentRequestAccountRevision.class);
        AccountLineGroupTest.assertEquals((Object)first, (Object)first);
        AccountLineGroupTest.assertEquals((Object)first, (Object)second);
        AccountLineGroupTest.assertEquals((Object)second, (Object)first);
        AccountLineGroupTest.assertEquals((Object)second, (Object)third);
        AccountLineGroupTest.assertEquals((Object)third, (Object)second);
        AccountLineGroupTest.assertEquals((Object)first, (Object)third);
        AccountLineGroupTest.assertEquals((Object)third, (Object)first);
        first = this.createAccountLineGroup(2008, "BA", "BL002323", "--", "7000", null, "01", "1001", null, "C");
        second = this.createAccountLineGroup(2008, "BL", "BL002323", "--", "7000", null, "01", "1001", null, "D");
        third = this.createPurApAccountLineGroup(2008, "BA", "BL002323", "--", "7000", null, "01", "1001", null, new KualiDecimal(100), PaymentRequestAccountRevision.class);
        Assert.assertNotEquals((Object)first, (Object)second);
        Assert.assertNotEquals((Object)second, (Object)first);
        Assert.assertNotEquals((Object)second, (Object)third);
        Assert.assertNotEquals((Object)third, (Object)second);
        AccountLineGroupTest.assertEquals((Object)first, (Object)third);
        AccountLineGroupTest.assertEquals((Object)third, (Object)first);
        first = this.createAccountLineGroup(2008, "BA", "BL002323", "X", "7000", null, "01", "1001", null, "C");
        second = this.createAccountLineGroup(2008, "BA", "BL002323", "XXX", "7000", null, "01", "1001", null, "D");
        third = this.createPurApAccountLineGroup(2008, "BL", "BL002323", "X", "7001", null, "01", "1001", null, new KualiDecimal(100), PaymentRequestAccountRevision.class);
        Assert.assertNotEquals((Object)first, (Object)second);
        Assert.assertNotEquals((Object)second, (Object)first);
        Assert.assertNotEquals((Object)second, (Object)third);
        Assert.assertNotEquals((Object)third, (Object)second);
        Assert.assertNotEquals((Object)first, (Object)third);
        Assert.assertNotEquals((Object)third, (Object)first);
        AccountLineGroupTest.assertNotNull((Object)first);
        AccountLineGroupTest.assertNotNull((Object)second);
        AccountLineGroupTest.assertNotNull((Object)third);
    }

    public void testHashcode() {
        GlAccountLineGroup first = this.createAccountLineGroup(2008, "BL", "BL002323", "--", "7000", "12121", "01", "1001", "A", "C");
        GlAccountLineGroup second = this.createAccountLineGroup(2008, "BL", "BL002323", "--", new String("7000"), "12121", "01", "1001", "A", "C");
        GlAccountLineGroup third = this.createAccountLineGroup(2008, "BL", "BL002323", "", "7000", "12121", "01", "1001", "A", "D");
        AccountLineGroupTest.assertEquals((int)first.hashCode(), (int)second.hashCode());
        AccountLineGroupTest.assertEquals((int)second.hashCode(), (int)third.hashCode());
        AccountLineGroupTest.assertEquals((int)first.hashCode(), (int)third.hashCode());
    }

    private GlAccountLineGroup createAccountLineGroup(Integer i, String chartCode, String acctNum, String subAcctNum, String objCd, String subObjCd, String fiscalPrd, String docNum, String refDocNum, String dbtCrdtCode) {
        Entry entry = new Entry();
        entry.setUniversityFiscalYear(i);
        entry.setChartOfAccountsCode(chartCode);
        entry.setAccountNumber(acctNum);
        entry.setSubAccountNumber(subAcctNum);
        entry.setFinancialObjectCode(objCd);
        entry.setFinancialSubObjectCode(subObjCd);
        entry.setUniversityFiscalPeriodCode(fiscalPrd);
        entry.setDocumentNumber(docNum);
        entry.setReferenceFinancialDocumentNumber(refDocNum);
        entry.setTransactionDebitCreditCode(dbtCrdtCode);
        entry.setTransactionLedgerEntryAmount(KualiDecimal.ZERO);
        return new GlAccountLineGroup(entry);
    }

    private PurApAccountLineGroup createPurApAccountLineGroup(Integer i, String chartCode, String acctNum, String subAcctNum, String objCd, String subObjCd, String fiscalPrd, String docNum, String refDocNum, KualiDecimal amount, Class<? extends PurApAccountingLineBase> clazz) {
        PurApAccountingLineBase entry = this.createEntry(i, chartCode, acctNum, subAcctNum, objCd, subObjCd, fiscalPrd, docNum, amount, clazz);
        return new PurApAccountLineGroupTest.PurApAccountLineGroupTestable(entry, docNum, refDocNum);
    }

    private PurApAccountingLineBase createEntry(Integer i, String chartCode, String acctNum, String subAcctNum, String objCd, String subObjCd, String fiscalPrd, String docNum, KualiDecimal amount, Class<? extends PurApAccountingLineBase> clazz) {
        PurApAccountingLineBase entry = null;
        try {
            entry = clazz.newInstance();
        }
        catch (Exception e) {
            AccountLineGroupTest.fail((String)e.toString());
        }
        entry.setPostingYear(i);
        entry.setChartOfAccountsCode(chartCode);
        entry.setAccountNumber(acctNum);
        entry.setSubAccountNumber(subAcctNum);
        entry.setFinancialObjectCode(objCd);
        entry.setFinancialSubObjectCode(subObjCd);
        entry.setPostingPeriodCode(fiscalPrd);
        entry.setDocumentNumber(docNum);
        entry.setAmount(amount);
        return entry;
    }
}

