/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.cam.batch.service.AssetBarcodeInventoryLoadService;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.BarcodeInventoryErrorDetail;
import org.kuali.kfs.module.cam.document.web.struts.AssetBarCodeInventoryInputFileForm;
import org.kuali.kfs.module.cam.fixture.BarcodeInventoryServiceFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.bomiddle)
public class AssetBarcodeInventoryLoadServiceTest
extends KualiTestBase {
    private static Logger LOG = LogManager.getLogger(AssetBarcodeInventoryLoadServiceTest.class);
    private AssetBarcodeInventoryLoadService assetBarcodeInventoryLoadService;
    private BusinessObjectService businessObjectService;
    private static final String BARCODE = "barcode";
    private static final String ERROR = "error";
    private static final String VALID = "valid";
    private static final String FORMAT = "format";
    private static final String INVALID_FORMAT_MSG = "Invalid file format";

    protected void setUp() throws Exception {
        super.setUp();
        this.assetBarcodeInventoryLoadService = (AssetBarcodeInventoryLoadService)SpringContext.getBean(AssetBarcodeInventoryLoadService.class);
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
    }

    public void testIsFileFormatValid() {
        File[] listOfFiles;
        for (File listOfFile : listOfFiles = this.getFiles(false)) {
            if (!listOfFile.isFile() || listOfFile.length() <= 0L) continue;
            LOG.info("*** testIsFileFormatValid() - Running test on file " + listOfFile.getName());
            if (listOfFile.getName().contains(ERROR) && listOfFile.getName().contains(FORMAT)) {
                AssetBarcodeInventoryLoadServiceTest.assertFalse((String)INVALID_FORMAT_MSG, (boolean)this.assetBarcodeInventoryLoadService.isFileFormatValid(listOfFile));
                continue;
            }
            AssetBarcodeInventoryLoadServiceTest.assertTrue((String)INVALID_FORMAT_MSG, (boolean)this.assetBarcodeInventoryLoadService.isFileFormatValid(listOfFile));
        }
    }

    public void testProcessFile() {
        File[] filesToProcess;
        AssetBarCodeInventoryInputFileForm form = new AssetBarCodeInventoryInputFileForm();
        for (File file : filesToProcess = this.getFiles(true)) {
            LOG.info("*** testProcessFile() - Running test on file " + file.getName());
            try {
                this.assetBarcodeInventoryLoadService.processFile(file, form);
            }
            catch (IllegalArgumentException e) {
                Throwable origin = e;
                for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                    origin = cause;
                }
                AssetBarcodeInventoryLoadServiceTest.assertTrue((boolean)ValidationException.class.isAssignableFrom(origin.getClass()));
            }
        }
    }

    private File[] getFiles(boolean onlyValid) {
        File[] listOfFiles;
        try {
            Class<AssetBarcodeInventoryLoadServiceTest> THIS_CLASS = AssetBarcodeInventoryLoadServiceTest.class;
            String childPath = THIS_CLASS.getPackage().getName().replace('.', '/');
            File directory = new File(new File(THIS_CLASS.getProtectionDomain().getCodeSource().getLocation().toURI()), childPath);
            listOfFiles = !onlyValid ? directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".csv") && name.startsWith(AssetBarcodeInventoryLoadServiceTest.BARCODE) && name.contains(AssetBarcodeInventoryLoadServiceTest.ERROR) || name.contains(AssetBarcodeInventoryLoadServiceTest.VALID);
                }
            }) : directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".csv") && name.startsWith(AssetBarcodeInventoryLoadServiceTest.BARCODE) && name.contains(AssetBarcodeInventoryLoadServiceTest.VALID);
                }
            });
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
        return listOfFiles;
    }

    public void testUpdateAssetInformation() {
        List<BarcodeInventoryErrorDetail> barcodeInventoryErrorDetails = BarcodeInventoryServiceFixture.DATA.getBarcodeInventoryDetail();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        Iterator<BarcodeInventoryErrorDetail> iterator = barcodeInventoryErrorDetails.iterator();
        while (iterator.hasNext()) {
            BarcodeInventoryErrorDetail barcodeInventoryErrorDetail1;
            BarcodeInventoryErrorDetail barcodeInventoryErrorDetail = barcodeInventoryErrorDetail1 = iterator.next();
            this.assetBarcodeInventoryLoadService.updateAssetInformation(barcodeInventoryErrorDetail, false);
            fieldValues.put("campusTagNumber", barcodeInventoryErrorDetail.getAssetTagNumber());
            Asset asset = (Asset)((List)this.businessObjectService.findMatching(Asset.class, fieldValues)).get(0);
            AssetBarcodeInventoryLoadServiceTest.assertTrue((String)"Error on data", (asset.getInventoryScannedCode().equals(barcodeInventoryErrorDetail.isUploadScanIndicator() ? "1" : "0") && asset.getBuildingCode().equals(barcodeInventoryErrorDetail.getBuildingCode()) && asset.getBuildingRoomNumber().equals(barcodeInventoryErrorDetail.getBuildingRoomNumber()) && asset.getBuildingSubRoomNumber().equals(barcodeInventoryErrorDetail.getBuildingSubRoomNumber()) && asset.getCampusCode().equals(barcodeInventoryErrorDetail.getCampusCode()) && asset.getConditionCode().equals(barcodeInventoryErrorDetail.getAssetConditionCode()) ? 1 : 0) != 0);
        }
    }
}

