/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.coreservice.impl.parameter.ParameterServiceImpl;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetRetirementGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetRetirementGlobalDetail;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.module.cam.document.service.impl.AssetServiceImpl;
import org.kuali.kfs.module.cam.document.service.impl.RetirementInfoServiceImpl;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.datetime.DateTimeService;

public class RetirementInfoServiceTest
extends KualiTestBase {
    private RetirementInfoServiceImpl retirementInfoService;
    private DateTimeService dateTimeService;
    private Asset asset;

    protected void setUp() throws Exception {
        super.setUp();
        this.dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
        this.retirementInfoService = new RetirementInfoServiceImpl();
        this.retirementInfoService.setParameterService((ParameterService)this.createParameterService());
        AssetServiceImpl assetServiceImpl = new AssetServiceImpl();
        assetServiceImpl.setParameterService((ParameterService)this.createParameterService());
        this.retirementInfoService.setAssetService((AssetService)assetServiceImpl);
        this.asset = new Asset();
        this.asset.setInventoryStatusCode("R");
    }

    private ParameterServiceImpl createParameterService() {
        return new ParameterServiceImpl(){

            public List<String> getParameterValuesAsString(Class componentClass, String parameterName) {
                ArrayList<String> values = new ArrayList<String>();
                values.add("O");
                values.add("R");
                values.add("E");
                return values;
            }
        };
    }

    private AssetRetirementGlobalDetail createRetirementDetail(String docNumber, int daysToAdd, String docStatus) {
        AssetRetirementGlobalDetail globalDetail = new AssetRetirementGlobalDetail();
        globalDetail.setDocumentNumber(docNumber);
        AssetRetirementGlobal retirementGlobal = new AssetRetirementGlobal(){

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        retirementGlobal.setRetirementDate(new java.sql.Date(DateUtils.addDays((Date)this.dateTimeService.getCurrentDate(), (int)daysToAdd).getTime()));
        FinancialSystemDocumentHeader header = new FinancialSystemDocumentHeader();
        header.setFinancialDocumentStatusCode(docStatus);
        retirementGlobal.setDocumentHeader(header);
        globalDetail.setAssetRetirementGlobal(retirementGlobal);
        return globalDetail;
    }

    public void testRetirementInfoService() {
        this.asset.getAssetRetirementHistory().add(this.createRetirementDetail("12345", 0, "A"));
        this.asset.getAssetRetirementHistory().add(this.createRetirementDetail("123457", 1, "A"));
        this.retirementInfoService.setRetirementInfo(this.asset);
        RetirementInfoServiceTest.assertNotNull((Object)this.asset.getRetirementInfo());
        RetirementInfoServiceTest.assertEquals((String)"123457", (String)this.asset.getRetirementInfo().getDocumentNumber());
    }

    public void testRetirementInfoService_Disapproved() {
        this.asset.getAssetRetirementHistory().add(this.createRetirementDetail("12345", 0, "A"));
        this.asset.getAssetRetirementHistory().add(this.createRetirementDetail("123457", 1, "D"));
        this.retirementInfoService.setRetirementInfo(this.asset);
        RetirementInfoServiceTest.assertNotNull((Object)this.asset.getRetirementInfo());
        RetirementInfoServiceTest.assertEquals((String)"12345", (String)this.asset.getRetirementInfo().getDocumentNumber());
    }

    public void testRetirementInfoService_NotRetired() {
        this.asset.setInventoryStatusCode("A");
        this.retirementInfoService.setRetirementInfo(this.asset);
        RetirementInfoServiceTest.assertNull((Object)this.asset.getRetirementInfo());
    }
}

