/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.validation.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.cam.CamsPropertyConstants;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.module.cam.document.validation.impl.BarcodeInventoryErrorDocumentRule;
import org.mockito.Mockito;

public class BarcodeInventoryErrorDocumentRuleTest {
    public static final String TAG_NUMBER_NON_EXISTENT_ASSET = "12345";
    public static final String TAG_NUMBER_ACTIVE_ASSET = "12345A";
    public static final String TAG_NUMBER_MULTIPLE_ASSETS = "12345M";
    public static final String TAG_NUMBER_MULTIPLE_ASSETS_ONE_ACTIVE = "12345MA";
    public static final String TAG_NUMBER_RETIRED_ASSET = "12345R";
    private AssetService assetService;
    private BarcodeInventoryErrorDocumentRule barcodeInventoryErrorDocumentRule;
    private Asset activeAsset;
    private Asset anotherActiveAsset;
    private Asset retiredAsset;

    @Before
    public void setUp() {
        this.setupAssets();
        this.setupAssetService();
        this.barcodeInventoryErrorDocumentRule = new BarcodeInventoryErrorDocumentRule();
        this.barcodeInventoryErrorDocumentRule.setAssetService(this.assetService);
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    private void setupAssets() {
        this.activeAsset = new Asset();
        this.anotherActiveAsset = new Asset();
        this.retiredAsset = new Asset();
        this.retiredAsset.setInventoryStatusCode("R");
    }

    private void setupAssetService() {
        this.assetService = (AssetService)Mockito.mock(AssetService.class);
        ArrayList<Asset> oneActiveAsset = new ArrayList<Asset>();
        oneActiveAsset.add(this.activeAsset);
        ArrayList<Asset> assets = new ArrayList<Asset>();
        assets.add(this.activeAsset);
        assets.add(this.anotherActiveAsset);
        ArrayList<Asset> retiredAssets = new ArrayList<Asset>();
        retiredAssets.add(this.retiredAsset);
        ArrayList<Asset> oneActiveOneRetiredAssets = new ArrayList<Asset>();
        oneActiveOneRetiredAssets.add(this.activeAsset);
        oneActiveOneRetiredAssets.add(this.retiredAsset);
        Mockito.when((Object)this.assetService.findAssetsMatchingTagNumber(TAG_NUMBER_ACTIVE_ASSET)).thenReturn(oneActiveAsset);
        Mockito.when((Object)this.assetService.findAssetsMatchingTagNumber(TAG_NUMBER_NON_EXISTENT_ASSET)).thenReturn(new ArrayList());
        Mockito.when((Object)this.assetService.findAssetsMatchingTagNumber(TAG_NUMBER_MULTIPLE_ASSETS)).thenReturn(assets);
        Mockito.when((Object)this.assetService.findAssetsMatchingTagNumber(TAG_NUMBER_RETIRED_ASSET)).thenReturn(retiredAssets);
        Mockito.when((Object)this.assetService.findAssetsMatchingTagNumber(TAG_NUMBER_MULTIPLE_ASSETS_ONE_ACTIVE)).thenReturn(oneActiveOneRetiredAssets);
        Mockito.when((Object)this.assetService.isAssetRetired(this.retiredAsset)).thenReturn((Object)true);
    }

    @After
    public void tearDown() {
        this.assetService = null;
        this.barcodeInventoryErrorDocumentRule = null;
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @Test
    public void validateTagNumberAndRetrieveActiveAssetDoesNotExist() {
        Assert.assertNull((Object)this.barcodeInventoryErrorDocumentRule.validateTagNumberAndRetrieveActiveAsset(TAG_NUMBER_NON_EXISTENT_ASSET));
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        this.validateErrorMessages("error.document.capitalAsset.not.found");
    }

    @Test
    public void validateTagNumberAndRetrieveActiveAssetMultipleAssets() {
        Assert.assertNull((Object)this.barcodeInventoryErrorDocumentRule.validateTagNumberAndRetrieveActiveAsset(TAG_NUMBER_MULTIPLE_ASSETS));
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        this.validateErrorMessages("error.document.duplicated.tagNumber");
    }

    @Test
    public void validateTagNumberAndRetrieveActiveAssetRetiredAsset() {
        Assert.assertNull((Object)this.barcodeInventoryErrorDocumentRule.validateTagNumberAndRetrieveActiveAsset(TAG_NUMBER_RETIRED_ASSET));
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        this.validateErrorMessages("error.document.capitalAsset.retired");
    }

    @Test
    public void validateTagNumberAndRetrieveActiveAssetOneActive() {
        Assert.assertEquals((Object)this.activeAsset, (Object)this.barcodeInventoryErrorDocumentRule.validateTagNumberAndRetrieveActiveAsset(TAG_NUMBER_ACTIVE_ASSET));
        Assert.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    public void validateTagNumberAndRetrieveActiveAssetOneActiveOneRetired() {
        Assert.assertEquals((Object)this.activeAsset, (Object)this.barcodeInventoryErrorDocumentRule.validateTagNumberAndRetrieveActiveAsset(TAG_NUMBER_MULTIPLE_ASSETS_ONE_ACTIVE));
        Assert.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    private void validateErrorMessages(String expectedErrorKey) {
        Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
        List errorMessage = (List)errorMessages.get(CamsPropertyConstants.BarcodeInventory.ASSET_TAG_NUMBER);
        Assert.assertNotNull((Object)errorMessage);
        Assert.assertEquals((long)1L, (long)errorMessage.size());
        Assert.assertEquals((Object)expectedErrorKey, (Object)((ErrorMessage)errorMessage.get(0)).getErrorKey());
    }
}

