/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document;

import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.integration.cam.CapitalAssetManagementModuleService;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.maintenance.MaintenanceLock;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KRADServiceLocatorInternal;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetLocationGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetLocationGlobalDetail;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.module.cam.document.validation.impl.AssetLocationGlobalRule;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.FinancialSystemGlobalMaintainable;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.springframework.util.AutoPopulatingList;

public class AssetLocationGlobalMaintainableImpl
extends FinancialSystemGlobalMaintainable {
    private static final Logger LOG = LogManager.getLogger(AssetLocationGlobalMaintainableImpl.class);
    private AssetService assetService;
    private CapitalAssetManagementModuleService capitalAssetManagementModuleService;
    private ConfigurationService configurationService;
    private DocumentService documentService;
    private DateTimeService dateTimeService;
    private IdentityService identityService;
    private NoteService noteService;

    public void addNewLineToCollection(String collectionName) {
        AssetLocationGlobalDetail addAssetLine = (AssetLocationGlobalDetail)((Object)this.newCollectionLines.get(collectionName));
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("capitalAssetNumber", addAssetLine.getCapitalAssetNumber());
        Asset asset = (Asset)this.getBusinessObjectService().findByPrimaryKey(Asset.class, map);
        if (ObjectUtils.isNotNull((Object)((Object)asset)) && ObjectUtils.isNotNull((Object)asset.getCapitalAssetNumber())) {
            if (StringUtils.isBlank((CharSequence)addAssetLine.getCampusCode())) {
                addAssetLine.setCampusCode(asset.getCampusCode());
            }
            if (StringUtils.isBlank((CharSequence)addAssetLine.getBuildingCode())) {
                addAssetLine.setBuildingCode(asset.getBuildingCode());
            }
            if (StringUtils.isBlank((CharSequence)addAssetLine.getBuildingRoomNumber())) {
                addAssetLine.setBuildingRoomNumber(asset.getBuildingRoomNumber());
            }
            if (StringUtils.isBlank((CharSequence)addAssetLine.getBuildingSubRoomNumber())) {
                addAssetLine.setBuildingSubRoomNumber(asset.getBuildingSubRoomNumber());
            }
            if (StringUtils.isBlank((CharSequence)addAssetLine.getCampusTagNumber())) {
                addAssetLine.setCampusTagNumber(asset.getCampusTagNumber());
            }
            addAssetLine.setNewCollectionRecord(true);
        }
        super.addNewLineToCollection(collectionName);
    }

    public void doRouteStatusChange(DocumentHeader documentHeader) {
        super.doRouteStatusChange(documentHeader);
        WorkflowDocument workflowDoc = documentHeader.getWorkflowDocument();
        if (workflowDoc.isCanceled() || workflowDoc.isDisapproved() || workflowDoc.isProcessed() || workflowDoc.isFinal()) {
            this.getCapitalAssetManagementModuleService().deleteAssetLocks(this.getDocumentNumber(), null);
        }
        AssetLocationGlobal assetLocationGlobal = (AssetLocationGlobal)this.getBusinessObject();
        if (workflowDoc.isEnroute()) {
            this.addNoteIfAssetLocationHasNotChanged(assetLocationGlobal);
        }
        if (workflowDoc.isProcessed()) {
            this.updateLastInventoryDateIfNecessary(assetLocationGlobal);
        }
    }

    private void addNoteIfAssetLocationHasNotChanged(AssetLocationGlobal assetLocationGlobal) {
        Document document = KRADServiceLocatorInternal.getDocumentDao().findByDocumentHeaderId(this.getDataDictionaryService().getDocumentClassByTypeName(this.getDocumentTypeName()), this.getDocumentNumber());
        String noteTextPattern = this.getConfigurationService().getPropertyValueAsString("warning.asset.not.changed");
        List<AssetLocationGlobalDetail> assetLocationGlobalDetails = assetLocationGlobal.getAssetLocationGlobalDetails();
        for (AssetLocationGlobalDetail detail : assetLocationGlobalDetails) {
            if (this.getAssetService().hasCapitalAssetLocationDetailsChanged(detail) || detail.isUpdateLastInventoryDate()) continue;
            Object[] arguments = new Object[]{detail.getCapitalAssetNumber().toString()};
            String noteText = MessageFormat.format(noteTextPattern, arguments);
            Note note = this.getDocumentService().createNoteFromDocument(document, noteText);
            note.setAuthorUniversalIdentifier(this.getIdentityService().getPrincipalByPrincipalName("kfs").getPrincipalId());
            document.addNote(note);
            this.getDocumentService().saveDocumentNotes(document);
        }
    }

    private void updateLastInventoryDateIfNecessary(AssetLocationGlobal assetLocationGlobal) {
        for (AssetLocationGlobalDetail assetLocationGlobalDetail : assetLocationGlobal.getAssetLocationGlobalDetails()) {
            if (!assetLocationGlobalDetail.isUpdateLastInventoryDate()) continue;
            Asset asset = (Asset)this.getBusinessObjectService().findByPrimaryKey(Asset.class, assetLocationGlobalDetail.getPrimaryKeys());
            asset.setLastInventoryDate(new Timestamp(this.getDateTimeService().getCurrentSqlDate().getTime()));
            this.getBusinessObjectService().save((PersistableBusinessObject)asset);
        }
    }

    public List<MaintenanceLock> generateMaintenanceLocks() {
        return new ArrayList<MaintenanceLock>();
    }

    public Map<String, String> populateNewCollectionLines(Map<String, String> fieldValues, MaintenanceDocument maintenanceDocument, String methodToCall) {
        String capitalAssetNumber = fieldValues.get("assetLocationGlobalDetails.capitalAssetNumber");
        if (StringUtils.isNotBlank((CharSequence)capitalAssetNumber)) {
            fieldValues.remove("assetLocationGlobalDetails.capitalAssetNumber");
            fieldValues.put("assetLocationGlobalDetails.capitalAssetNumber", capitalAssetNumber.trim());
        }
        return super.populateNewCollectionLines(fieldValues, maintenanceDocument, methodToCall);
    }

    public Class<? extends PersistableBusinessObject> getPrimaryEditedBusinessObjectClass() {
        return Asset.class;
    }

    public void addMultipleValueLookupResults(MaintenanceDocument document, String collectionName, Collection<PersistableBusinessObject> rawValues, boolean needsBlank, PersistableBusinessObject bo) {
        ArrayList<Asset> allowedAssetsCollection = new ArrayList<Asset>();
        String maintDocTypeName = "CASM";
        GlobalVariables.getMessageMap().clearErrorMessages();
        for (PersistableBusinessObject businessObject : rawValues) {
            Asset asset = (Asset)businessObject;
            if (!StringUtils.isNotBlank((CharSequence)"CASM")) continue;
            boolean allowsEdit = this.getBusinessObjectAuthorizationService().canMaintain((Object)asset, GlobalVariables.getUserSession().getPerson(), "CASM");
            if (allowsEdit) {
                allowedAssetsCollection.add(asset);
                continue;
            }
            GlobalVariables.getMessageMap().putErrorForSectionId("Edit List of Assets", "error.asset.authorization", new String[]{GlobalVariables.getUserSession().getPerson().getPrincipalName(), asset.getCapitalAssetNumber().toString()});
        }
        super.addMultipleValueLookupResults(document, collectionName, allowedAssetsCollection, needsBlank, bo);
    }

    public void processAfterRetrieve() {
        super.processAfterRetrieve();
        Document document = KRADServiceLocatorInternal.getDocumentDao().findByDocumentHeaderId(this.getDataDictionaryService().getDocumentClassByTypeName(this.getDocumentTypeName()), this.getDocumentNumber());
        this.processWarningMessages(document);
    }

    private void processWarningMessages(Document document) {
        WorkflowDocument workflowDoc;
        this.clearObsoleteWarningMessages();
        if (!(document == null || (workflowDoc = document.getDocumentHeader().getWorkflowDocument()) == null || workflowDoc.isProcessed() || workflowDoc.isApproved() || workflowDoc.isFinal())) {
            Class ruleClass = this.getDataDictionaryService().getDataDictionary().getDocumentEntry(this.getDocumentTypeName()).getBusinessRulesClass();
            AssetLocationGlobalRule rule = (AssetLocationGlobalRule)KRADServiceLocatorWeb.getKualiRuleService().getBusinessRulesInstance(document, ruleClass);
            List<AssetLocationGlobalDetail> assetLocationGlobalDetails = ((AssetLocationGlobal)this.businessObject).getAssetLocationGlobalDetails();
            for (int i = 0; i < assetLocationGlobalDetails.size(); ++i) {
                AssetLocationGlobalDetail detail = assetLocationGlobalDetails.get(i);
                if (this.shouldCheckForObsoleteNotes(detail)) {
                    this.findAndDeleteObsoleteNotes(document, detail);
                }
                String errorPath = "document.newMaintainableObject.assetLocationGlobalDetails[" + i + "]";
                GlobalVariables.getMessageMap().addToErrorPath(errorPath);
                rule.hasCapitalAssetChangedOrUpdateInventoryDateButtonClicked(detail);
                GlobalVariables.getMessageMap().removeFromErrorPath(errorPath);
            }
        }
    }

    private boolean shouldCheckForObsoleteNotes(AssetLocationGlobalDetail detail) {
        return !detail.isUpdateLastInventoryDate() && GlobalVariables.getUserSession() != null;
    }

    private void clearObsoleteWarningMessages() {
        Map warningMessages = GlobalVariables.getMessageMap().getWarningMessages();
        if (ObjectUtils.isNotNull((Object)warningMessages) && !warningMessages.isEmpty()) {
            warningMessages.entrySet().removeIf(nextWarningMessage -> ((ErrorMessage)((AutoPopulatingList)nextWarningMessage.getValue()).get(0)).getErrorKey().equals("warning.asset.not.changed"));
        }
    }

    public void processAfterPost(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.processAfterPost(document, parameters);
        String customAction = this.findCustomAction(parameters);
        if (this.isActionUpdateLastInventoryDate(customAction)) {
            this.processLastInventoryDateUpdate(document, customAction);
        } else if (this.wasDeleteLineAction(parameters)) {
            this.deleteNotesForDeletedAssetsIfNecessary(document);
        } else {
            this.deleteObsoleteNotes(document);
        }
    }

    private String findCustomAction(Map<String, String[]> parameters) {
        String customAction = null;
        String[] customActions = parameters.get("customAction");
        if (customActions != null) {
            customAction = customActions[0];
        }
        return customAction;
    }

    private boolean isActionUpdateLastInventoryDate(String customAction) {
        if (StringUtils.startsWith((CharSequence)customAction, (CharSequence)"assetLocationGlobalDetails[")) {
            String actualAction = customAction.substring(customAction.indexOf("]") + 2);
            return StringUtils.equals((CharSequence)"lastInventoryDateUpdateButton", (CharSequence)actualAction);
        }
        return false;
    }

    private void processLastInventoryDateUpdate(MaintenanceDocument document, String customAction) {
        WorkflowDocument workflowDoc = document.getDocumentHeader().getWorkflowDocument();
        if (workflowDoc != null && workflowDoc.isInitiated() || workflowDoc.isSaved()) {
            int detailNumber = Character.getNumericValue(customAction.charAt(customAction.indexOf("[") + 1));
            AssetLocationGlobal assetLocationGlobal = (AssetLocationGlobal)document.getDocumentBusinessObject();
            AssetLocationGlobalDetail detail = assetLocationGlobal.getAssetLocationGlobalDetails().get(detailNumber);
            if (this.getAssetService().hasCapitalAssetLocationDetailsChanged(detail)) {
                String errorPath = "document.newMaintainableObject.assetLocationGlobalDetails[" + detailNumber + "]";
                GlobalVariables.getMessageMap().addToErrorPath(errorPath);
                GlobalVariables.getMessageMap().putWarning("capitalAssetNumber", "warning.location.update.unnecessary", new String[]{detail.getCapitalAssetNumber().toString()});
                GlobalVariables.getMessageMap().removeFromErrorPath(errorPath);
            } else {
                detail.setUpdateLastInventoryDate(true);
                Asset asset = (Asset)this.getBusinessObjectService().findByPrimaryKey(Asset.class, assetLocationGlobal.getAssetLocationGlobalDetails().get(detailNumber).getPrimaryKeys());
                String noteText = this.buildNoteTextForInventoryDateUpdate(asset.getCapitalAssetNumber().toString());
                Note lastInventoryDateUpdatedNote = this.getDocumentService().createNoteFromDocument((Document)document, noteText);
                if (this.shouldAddNote(document, noteText)) {
                    lastInventoryDateUpdatedNote.setAuthorUniversalIdentifier(this.getIdentityService().getPrincipalByPrincipalName("kfs").getPrincipalId());
                    document.addNote(lastInventoryDateUpdatedNote);
                    this.getDocumentService().saveDocumentNotes((Document)document);
                }
                this.processWarningMessages((Document)document);
            }
        }
    }

    private String buildNoteTextForInventoryDateUpdate(String capitalAssetNumber) {
        String userPrincipalName = GlobalVariables.getUserSession().getPrincipalName();
        String noteTextPattern = this.getConfigurationService().getPropertyValueAsString("note.last.inventory.date.updated");
        Object[] arguments = new Object[]{userPrincipalName, capitalAssetNumber};
        return MessageFormat.format(noteTextPattern, arguments);
    }

    private boolean shouldAddNote(MaintenanceDocument document, String noteText) {
        boolean shouldAddNote = true;
        for (Note note : document.getNotes()) {
            if (!note.getNoteText().equals(noteText)) continue;
            shouldAddNote = false;
            break;
        }
        return shouldAddNote;
    }

    private boolean wasDeleteLineAction(Map<String, String[]> parameters) {
        String parameterName = this.getMethodToCall(parameters);
        return StringUtils.isNotBlank((CharSequence)parameterName) && parameterName.contains("deleteLine");
    }

    private String getMethodToCall(Map<String, String[]> parameters) {
        for (String key : parameters.keySet()) {
            if (!key.startsWith("methodToCall")) continue;
            return key;
        }
        return null;
    }

    private void deleteNotesForDeletedAssetsIfNecessary(MaintenanceDocument document) {
        Iterator noteIterator = document.getNotes().iterator();
        while (noteIterator.hasNext()) {
            Note note = (Note)noteIterator.next();
            AssetLocationGlobal assetLocationGlobal = (AssetLocationGlobal)document.getDocumentBusinessObject();
            List<AssetLocationGlobalDetail> assetLocationGlobalDetails = assetLocationGlobal.getAssetLocationGlobalDetails();
            boolean noteMatches = false;
            for (AssetLocationGlobalDetail assetLocationGlobalDetail : assetLocationGlobalDetails) {
                if (!note.getNoteText().contains(assetLocationGlobalDetail.getCapitalAssetNumber().toString())) continue;
                noteMatches = true;
                break;
            }
            if (noteMatches) continue;
            noteIterator.remove();
            this.getDocumentService().saveDocumentNotes((Document)document);
            this.getNoteService().deleteNote(note);
        }
    }

    private void deleteObsoleteNotes(MaintenanceDocument document) {
        List<AssetLocationGlobalDetail> assetLocationGlobalDetails = ((AssetLocationGlobal)this.businessObject).getAssetLocationGlobalDetails();
        for (AssetLocationGlobalDetail detail : assetLocationGlobalDetails) {
            if (!this.getAssetService().hasCapitalAssetLocationDetailsChanged(detail) || !detail.isUpdateLastInventoryDate()) continue;
            detail.setUpdateLastInventoryDate(false);
            this.findAndDeleteObsoleteNotes((Document)document, detail);
        }
    }

    private void findAndDeleteObsoleteNotes(Document document, AssetLocationGlobalDetail detail) {
        String noteText = this.buildNoteTextForInventoryDateUpdate(detail.getCapitalAssetNumber().toString());
        Iterator noteIterator = document.getNotes().iterator();
        while (noteIterator.hasNext()) {
            Note note = (Note)noteIterator.next();
            if (!note.getNoteText().equals(noteText)) continue;
            noteIterator.remove();
            this.getDocumentService().saveDocumentNotes(document);
            this.getNoteService().deleteNote(note);
        }
    }

    protected boolean answerSplitNodeQuestion(String nodeName) throws UnsupportedOperationException {
        if ("RequiresOrganizationInactiveReview".equals(nodeName)) {
            return this.isRequiresOrganizationInactiveRouteNode();
        }
        throw new UnsupportedOperationException("Cannot answer split question for this node you call \"" + nodeName + "\"");
    }

    protected boolean isRequiresOrganizationInactiveRouteNode() {
        List<AssetLocationGlobalDetail> assetLocationGlobalDetails = ((AssetLocationGlobal)this.businessObject).getAssetLocationGlobalDetails();
        ArrayList<Long> assets = new ArrayList<Long>();
        for (AssetLocationGlobalDetail assetLocationGlobalDetail : assetLocationGlobalDetails) {
            Asset asset = assetLocationGlobalDetail.getAsset();
            if (asset.getOrganizationOwnerAccount().getOrganization().isActive()) continue;
            assets.add(asset.getCapitalAssetNumber());
        }
        if (assets.isEmpty()) {
            return false;
        }
        try {
            this.getDocumentService().getByDocumentHeaderIdSessionless(this.getDocumentNumber());
        }
        catch (WorkflowException we) {
            LOG.error("Failed to answerSplitNodeQuestion for following routeNode: RequiresOrganizationInactiveReview", (Throwable)we);
            return false;
        }
        return true;
    }

    public AssetService getAssetService() {
        if (this.assetService == null) {
            this.assetService = (AssetService)SpringContext.getBean(AssetService.class);
        }
        return this.assetService;
    }

    public CapitalAssetManagementModuleService getCapitalAssetManagementModuleService() {
        if (this.capitalAssetManagementModuleService == null) {
            this.capitalAssetManagementModuleService = (CapitalAssetManagementModuleService)SpringContext.getBean(CapitalAssetManagementModuleService.class);
        }
        return this.capitalAssetManagementModuleService;
    }

    public ConfigurationService getConfigurationService() {
        if (this.configurationService == null) {
            this.configurationService = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
        }
        return this.configurationService;
    }

    public DocumentService getDocumentService() {
        if (this.documentService == null) {
            this.documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        }
        return this.documentService;
    }

    public DateTimeService getDateTimeService() {
        if (this.dateTimeService == null) {
            this.dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
        }
        return this.dateTimeService;
    }

    public IdentityService getIdentityService() {
        if (this.identityService == null) {
            this.identityService = (IdentityService)SpringContext.getBean(IdentityService.class);
        }
        return this.identityService;
    }

    public NoteService getNoteService() {
        if (this.noteService == null) {
            this.noteService = (NoteService)SpringContext.getBean(NoteService.class);
        }
        return this.noteService;
    }
}

