/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.validation.impl;

import java.util.List;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentDetail;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentInProcessPayment;
import org.kuali.kfs.module.cam.document.AssetPaymentDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class AssetPaymentInProcessPaymentValidation
extends GenericValidation {
    public boolean validate(AttributedDocumentEvent event) {
        boolean valid = true;
        AssetPaymentDocument assetPaymentDocument = (AssetPaymentDocument)event.getDocument();
        if (!assetPaymentDocument.getAssetPaymentInProcessPayments().isEmpty()) {
            valid = this.validateAccountingLinesToInProcessPaymentsSumToZero(assetPaymentDocument.getSourceAccountingLines(), assetPaymentDocument.getAssetPaymentInProcessPayments());
        }
        return valid;
    }

    protected boolean validateAccountingLinesToInProcessPaymentsSumToZero(List<AssetPaymentDetail> sourceAccountingLines, List<AssetPaymentInProcessPayment> assetPaymentInProcessPayments) {
        boolean valid = true;
        for (AssetPaymentDetail sourceAccountingLine : sourceAccountingLines) {
            Integer sequenceNumber = sourceAccountingLine.getSequenceNumber();
            Long capitalAssetNumber = 0L;
            KualiDecimal totalInProcessPayment = new KualiDecimal(0);
            for (AssetPaymentInProcessPayment assetPaymentInProcessPayment : assetPaymentInProcessPayments) {
                if (!sequenceNumber.equals(assetPaymentInProcessPayment.getSequenceNumber())) continue;
                assetPaymentInProcessPayment.refreshReferenceObject("assetPayment");
                totalInProcessPayment = (KualiDecimal)totalInProcessPayment.add((AbstractKualiDecimal)assetPaymentInProcessPayment.getAssetPayment().getAccountChargeAmount());
                capitalAssetNumber = assetPaymentInProcessPayment.getCapitalAssetNumber();
            }
            if (!totalInProcessPayment.isNonZero() || !((KualiDecimal)totalInProcessPayment.add((AbstractKualiDecimal)sourceAccountingLine.getAmount())).isNonZero()) continue;
            GlobalVariables.getMessageMap().putErrorForSectionId("inProcessPaymentErrorSection." + capitalAssetNumber + "." + sequenceNumber, "error.in.process.payment.not.balance", new String[0]);
            valid = false;
        }
        return valid;
    }
}

