/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.validation.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.maintenance.MaintenanceDocumentAuthorizer;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.Pretag;
import org.kuali.kfs.module.cam.businessobject.PretagDetail;
import org.kuali.kfs.module.cam.document.service.PurApInfoService;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.sys.businessobject.Building;
import org.kuali.kfs.sys.businessobject.Room;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.krad.bo.BusinessObject;

public class PretagRule
extends MaintenanceDocumentRuleBase {
    protected PersistableBusinessObject bo;
    protected Pretag newPretag;

    public void setupConvenienceObjects() {
        this.newPretag = (Pretag)((Object)super.getNewBo());
        for (PretagDetail dtl : this.newPretag.getPretagDetails()) {
            dtl.refreshNonUpdateableReferences();
        }
    }

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        boolean success = this.processPretagValidation();
        return success & super.processCustomSaveDocumentBusinessRules(document);
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        MaintenanceDocumentAuthorizer documentAuthorizer = (MaintenanceDocumentAuthorizer)this.getDocumentHelperService().getDocumentAuthorizer((Document)document);
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        boolean success = true;
        if ((workflowDocument.isInitiated() || workflowDocument.isSaved()) && !(success = documentAuthorizer.canCreateOrMaintain(document, GlobalVariables.getUserSession().getPerson()))) {
            this.putFieldError("chartOfAccountsCode", "chart.org.disallowed.by.current.user");
        }
        return success & super.processCustomRouteDocumentBusinessRules(document);
    }

    public boolean processPretagValidation() {
        this.setupConvenienceObjects();
        boolean success = this.checkPurchaseOrderItemExists();
        success &= this.checkAssetRepresentativePrincipalNameExists();
        if (this.newPretag.isActive()) {
            success &= this.checkTotalDetailCount(this.newPretag, false);
            success &= this.isAllCampusBuildingRoomValid(this.newPretag.getPretagDetails());
        } else {
            this.deactivePretagDetails(this.newPretag);
        }
        return success;
    }

    protected boolean checkAssetRepresentativePrincipalNameExists() {
        boolean valid = true;
        if (StringUtils.isNotBlank((CharSequence)this.newPretag.getPersonUniversal().getPrincipalName())) {
            PersonService personService = (PersonService)SpringContext.getBean(PersonService.class);
            Person person = personService.getPersonByPrincipalName(this.newPretag.getPersonUniversal().getPrincipalName());
            if (person != null) {
                this.newPretag.setPersonUniversal(person);
                this.newPretag.setRepresentativeUniversalIdentifier(person.getPrincipalId());
            } else {
                this.putFieldError("personUniversal.principalName", "error.invalid.representative.id", this.newPretag.getPersonUniversal().getPrincipalName());
                this.newPretag.setPersonUniversal(null);
                this.newPretag.setRepresentativeUniversalIdentifier(null);
                valid = false;
            }
        }
        return valid;
    }

    protected boolean checkPurchaseOrderItemExists() {
        boolean valid = true;
        if (StringUtils.isNotBlank((CharSequence)this.newPretag.getPurchaseOrderNumber()) && this.newPretag.getItemLineNumber() != null) {
            PurchaseOrderDocument purchaseOrderDoc = this.getPurApInfoService().getCurrentDocumentForPurchaseOrderIdentifier(Integer.valueOf(this.newPretag.getPurchaseOrderNumber()));
            if (purchaseOrderDoc == null) {
                String label = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDataDictionary().getBusinessObjectEntry(Pretag.class.getName()).getAttributeDefinition("purchaseOrderNumber").getLabel();
                this.putFieldError("purchaseOrderNumber", "error.existence", label);
                valid = false;
            } else if (this.getItemByLineNumber(purchaseOrderDoc, this.newPretag.getItemLineNumber()) == null) {
                String label = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDataDictionary().getBusinessObjectEntry(Pretag.class.getName()).getAttributeDefinition("itemLineNumber").getLabel();
                this.putFieldError("itemLineNumber", "error.existence", label);
                valid = false;
            }
        }
        return valid;
    }

    protected PurApItem getItemByLineNumber(PurchaseOrderDocument purchaseOrderDocument, int lineNumber) {
        List items = purchaseOrderDocument.getItems();
        for (Object entry : items) {
            PurApItem item = (PurApItem)entry;
            if (item.getItemLineNumber() == null || item.getItemLineNumber() != lineNumber) continue;
            return item;
        }
        return null;
    }

    public boolean isAllCampusBuildingRoomValid(List<PretagDetail> details) {
        boolean success = true;
        if (details.size() != 0) {
            int index = 0;
            for (PretagDetail dtl : details) {
                String errorPath = "document.newMaintainableObject.pretagDetails[" + index + "]";
                GlobalVariables.getMessageMap().addToErrorPath(errorPath);
                success &= this.isCampusBuildingRoomValid(dtl);
                GlobalVariables.getMessageMap().removeFromErrorPath(errorPath);
                ++index;
            }
        }
        return success;
    }

    public boolean processCustomAddCollectionLineBusinessRules(MaintenanceDocument document, String collectionName, PersistableBusinessObject bo) {
        this.setupConvenienceObjects();
        Pretag pretag = (Pretag)document.getNewMaintainableObject().getBusinessObject();
        PretagDetail detail = (PretagDetail)bo;
        boolean success = true;
        if (detail.isActive()) {
            detail.setPurchaseOrderNumber(pretag.getPurchaseOrderNumber());
            detail.setItemLineNumber(pretag.getItemLineNumber());
            success = this.checkDuplicateTagNumber(pretag, detail.getCampusTagNumber());
            success &= this.checkTotalDetailCount(pretag, true);
            success &= this.isCampusTagNumberValid(detail);
            success &= this.isCampusBuildingRoomValid(detail);
        }
        return success;
    }

    protected boolean checkDuplicateTagNumber(Pretag pretag, String tagNumber) {
        boolean success = true;
        for (PretagDetail dtl : pretag.getPretagDetails()) {
            if (!dtl.getCampusTagNumber().equals(tagNumber) || !dtl.isActive()) continue;
            GlobalVariables.getMessageMap().putError("campusTagNumber", "error.tag.number.duplicate", new String[]{tagNumber});
            success = false;
        }
        return success;
    }

    public boolean checkTotalDetailCount(Pretag pretag, boolean addLine) {
        boolean success = true;
        if (pretag.getQuantityInvoiced() != null) {
            int totalActiveDetails = this.getActiveDetailsCount(pretag, addLine);
            KualiDecimal totalNumerOfDetails = new KualiDecimal(totalActiveDetails);
            if (pretag.getQuantityInvoiced().compareTo((AbstractKualiDecimal)totalNumerOfDetails) < 0) {
                GlobalVariables.getMessageMap().putError("campusTagNumber", "error.pre.tag.detail.excess", new String[]{pretag.getQuantityInvoiced().toString() + " Total number of detail lines " + totalNumerOfDetails.toString()});
                success = false;
            }
        }
        return success;
    }

    public int getActiveDetailsCount(Pretag pretag, boolean newDetailLine) {
        List<PretagDetail> pretagDetails = pretag.getPretagDetails();
        if (newDetailLine) {
            return this.countActive(pretagDetails) + 1;
        }
        return this.countActive(pretagDetails);
    }

    public boolean isCampusTagNumberValid(PretagDetail dtl) {
        boolean success = true;
        if (dtl.getCampusTagNumber() != null && dtl.isActive() && !dtl.getCampusTagNumber().equalsIgnoreCase("N")) {
            HashMap<String, String> tagMap = new HashMap<String, String>();
            tagMap.put("campusTagNumber", dtl.getCampusTagNumber());
            int matchDetailCount = this.getMatchDetailCount(tagMap);
            if (this.getBoService().countMatching(Asset.class, tagMap) != 0 || matchDetailCount > 0) {
                GlobalVariables.getMessageMap().putError("campusTagNumber", "error.invalid.pre.tag.number", new String[]{dtl.getCampusTagNumber()});
                success = false;
            }
        }
        return success;
    }

    public boolean isCampusBuildingRoomValid(PretagDetail dtl) {
        boolean success = true;
        int originalErrorCount = GlobalVariables.getMessageMap().getErrorCount();
        this.getDictionaryValidationService().validateBusinessObject((BusinessObject)dtl);
        if (StringUtils.isNotBlank((CharSequence)dtl.getCampusCode()) && StringUtils.isNotBlank((CharSequence)dtl.getBuildingCode())) {
            HashMap<String, String> preTagMap = new HashMap<String, String>();
            preTagMap.put("campusCode", dtl.getCampusCode());
            preTagMap.put("buildingCode", dtl.getBuildingCode());
            this.bo = (PersistableBusinessObject)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(Building.class, preTagMap);
            if (this.bo == null) {
                GlobalVariables.getMessageMap().putError("buildingCode", "error.invalid.building.code", new String[]{dtl.getCampusCode(), dtl.getBuildingCode()});
            }
            if (StringUtils.isNotBlank((CharSequence)dtl.getBuildingRoomNumber())) {
                preTagMap.put("buildingRoomNumber", dtl.getBuildingRoomNumber());
                this.bo = (PersistableBusinessObject)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(Room.class, preTagMap);
                if (this.bo == null) {
                    GlobalVariables.getMessageMap().putError("buildingRoomNumber", "error.invalid.room.number", new String[]{dtl.getCampusCode(), dtl.getBuildingCode(), dtl.getBuildingRoomNumber()});
                }
            }
        }
        success = GlobalVariables.getMessageMap().getErrorCount() == originalErrorCount;
        return success;
    }

    public int getMatchDetailCount(Map<String, String> tagMap) {
        Collection pretagDetails = ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findMatching(PretagDetail.class, tagMap);
        return this.countActive(pretagDetails);
    }

    public int countActive(Collection<PretagDetail> pretagDetails) {
        int activeCount = 0;
        for (PretagDetail dtl : pretagDetails) {
            if (!dtl.isActive()) continue;
            ++activeCount;
        }
        return activeCount;
    }

    public void deactivePretagDetails(Pretag pretag) {
        for (PretagDetail dtl : pretag.getPretagDetails()) {
            dtl.setActive(false);
        }
    }

    protected PurApInfoService getPurApInfoService() {
        return (PurApInfoService)SpringContext.getBean(PurApInfoService.class);
    }
}

