/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.util;

import java.math.BigDecimal;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public final class KualiDecimalUtils {
    private KualiDecimalUtils() {
    }

    public static KualiDecimal[] allocateByQuantity(KualiDecimal amount, int divisor) {
        if (amount == null || divisor == 0) {
            KualiDecimal[] kualiDecimalArray;
            if (amount == null) {
                kualiDecimalArray = null;
            } else {
                KualiDecimal[] kualiDecimalArray2 = new KualiDecimal[1];
                kualiDecimalArray = kualiDecimalArray2;
                kualiDecimalArray2[0] = amount;
            }
            return kualiDecimalArray;
        }
        KualiDecimal dividedAmount = (KualiDecimal)amount.divide((AbstractKualiDecimal)new KualiDecimal(divisor));
        KualiDecimal[] amountsArray = new KualiDecimal[divisor];
        for (int i = 0; i < divisor; ++i) {
            amountsArray[i] = dividedAmount;
        }
        KualiDecimal allocatedAmount = (KualiDecimal)dividedAmount.multiply((AbstractKualiDecimal)new KualiDecimal(divisor));
        KualiDecimal reminderAmount = (KualiDecimal)amount.subtract((AbstractKualiDecimal)allocatedAmount);
        int n = ((KualiDecimal)((KualiDecimal)reminderAmount.abs()).multiply((AbstractKualiDecimal)new KualiDecimal(100))).intValue();
        KualiDecimal cent = reminderAmount.isPositive() ? new KualiDecimal(0.01) : new KualiDecimal(-0.01);
        for (int i = divisor - 1; i >= divisor - n; --i) {
            amountsArray[i] = (KualiDecimal)dividedAmount.add((AbstractKualiDecimal)cent);
        }
        return amountsArray;
    }

    public static KualiDecimal[] allocateByRatio(KualiDecimal amount, double[] ratios) {
        if (ratios == null || ratios.length == 0 || amount == null) {
            KualiDecimal[] kualiDecimalArray;
            if (amount == null) {
                kualiDecimalArray = null;
            } else {
                KualiDecimal[] kualiDecimalArray2 = new KualiDecimal[1];
                kualiDecimalArray = kualiDecimalArray2;
                kualiDecimalArray2[0] = amount;
            }
            return kualiDecimalArray;
        }
        KualiDecimal[] amountsArray = new KualiDecimal[ratios.length];
        KualiDecimal allocatedAmount = KualiDecimal.ZERO;
        for (int i = 0; i < ratios.length; ++i) {
            KualiDecimal currAmount;
            amountsArray[i] = currAmount = new KualiDecimal(amount.bigDecimalValue().multiply(new BigDecimal(ratios[i])));
            allocatedAmount = (KualiDecimal)allocatedAmount.add((AbstractKualiDecimal)currAmount);
        }
        KualiDecimal reminderAmount = (KualiDecimal)amount.subtract((AbstractKualiDecimal)allocatedAmount);
        int n = ((KualiDecimal)((KualiDecimal)reminderAmount.abs()).multiply((AbstractKualiDecimal)new KualiDecimal(100))).intValue();
        KualiDecimal cent = reminderAmount.isPositive() ? new KualiDecimal(0.01) : new KualiDecimal(-0.01);
        n = n > ratios.length ? ratios.length : n;
        for (int i = ratios.length - 1; i >= ratios.length - n; --i) {
            amountsArray[i] = (KualiDecimal)amountsArray[i].add((AbstractKualiDecimal)cent);
        }
        return amountsArray;
    }

    public static KualiDecimal safeMultiply(KualiDecimal value, double multiplier) {
        if (value == null) {
            return null;
        }
        return new KualiDecimal(value.bigDecimalValue().multiply(new BigDecimal(multiplier)));
    }

    public static KualiDecimal safeSubtract(KualiDecimal value, KualiDecimal subtrahend) {
        if (subtrahend == null || value == null) {
            return value;
        }
        return (KualiDecimal)value.subtract((AbstractKualiDecimal)subtrahend);
    }
}

