/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.authorization;

import java.util.Map;
import java.util.Set;
import org.kuali.kfs.kns.document.authorization.MaintenanceDocumentAuthorizerBase;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetGlobal;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.BusinessObject;

public class AssetGlobalAuthorizer
extends MaintenanceDocumentAuthorizerBase {
    protected void addRoleQualification(Object businessObject, Map<String, String> attributes) {
        super.addRoleQualification(businessObject, attributes);
        if (businessObject instanceof Asset) {
            Asset asset = (Asset)((Object)businessObject);
            attributes.put("campusCode", asset.getCampusCode());
        }
    }

    public Set<String> getDocumentActions(Document document, Person user, Set<String> documentActionsFromPresentationController) {
        Set documentActionsToReturn = super.getDocumentActions(document, user, documentActionsFromPresentationController);
        if (documentActionsToReturn.contains("canEdit") && documentActionsToReturn.contains("AccountingPeriodViewAction")) {
            if (!super.isAuthorized((BusinessObject)document, "KFS-SYS", "View Accounting Period", user.getPrincipalId())) {
                documentActionsToReturn.remove("AccountingPeriodViewAction");
            } else if (super.isAuthorized((BusinessObject)document, "KFS-SYS", "Edit Accounting Period", user.getPrincipalId())) {
                documentActionsToReturn.add("AccountingPeriodEditAction");
            }
        }
        return documentActionsToReturn;
    }

    protected void addPermissionDetails(Object dataObject, Map<String, String> permissionDetails) {
        super.addPermissionDetails(dataObject, permissionDetails);
        if (dataObject instanceof AssetGlobal) {
            permissionDetails.put("buttonName", "calculateEqualSourceAmountsButton");
            permissionDetails.put("buttonName", "calculateSeparateSourceRemainingAmountButton");
        }
    }
}

