/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.validation.impl;

import java.util.ArrayList;
import org.kuali.kfs.coa.document.validation.impl.MaintenancePreRulesBase;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.businessobject.AssetGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentDetail;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;

public class AssetGlobalPreRules
extends MaintenancePreRulesBase {
    protected boolean doCustomPreRules(MaintenanceDocument document) {
        if (this.hasDifferentObjectSubTypes(document) && !this.isOkHavingDifferentObjectSubTypes()) {
            this.event.setActionForwardName("basic");
            return false;
        }
        return true;
    }

    public boolean hasDifferentObjectSubTypes(MaintenanceDocument document) {
        AssetGlobal assetGlobal = (AssetGlobal)document.getNewMaintainableObject().getBusinessObject();
        boolean invalid = false;
        ArrayList<String> objectSubTypeList = new ArrayList<String>();
        for (AssetPaymentDetail assetPaymentDetail : assetGlobal.getAssetPaymentDetails()) {
            assetPaymentDetail.refreshReferenceObject("objectCode");
            if (!ObjectUtils.isNotNull((Object)assetPaymentDetail.getObjectCode())) continue;
            objectSubTypeList.add(assetPaymentDetail.getObjectCode().getFinancialObjectSubTypeCode());
        }
        if (!this.getAssetService().isObjectSubTypeCompatible(objectSubTypeList)) {
            invalid = true;
        }
        return invalid;
    }

    protected boolean isOkHavingDifferentObjectSubTypes() {
        String parameterDetail = "(module:" + KRADServiceLocatorWeb.getKualiModuleService().getNamespaceCode(AssetGlobal.class) + "/component:" + AssetGlobal.class.getSimpleName() + ")";
        ConfigurationService kualiConfiguration = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
        String continueQuestion = kualiConfiguration.getPropertyValueAsString("document.question.continue.text");
        String warningMessage = kualiConfiguration.getPropertyValueAsString("warning.payment.object.subtype.not_the_same") + " " + "OBJECT_SUB_TYPE_GROUPS" + " " + parameterDetail + ". " + continueQuestion;
        return super.askOrAnalyzeYesNoQuestion("AssetPaymentDifferentObjectSubTypeQuestion", warningMessage);
    }

    protected AssetService getAssetService() {
        return (AssetService)SpringContext.getBean(AssetService.class);
    }

    protected ParameterService getParameterService() {
        return (ParameterService)SpringContext.getBean(ParameterService.class);
    }
}

