/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.web.struts;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.Closure;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.cam.batch.service.AssetBarcodeInventoryLoadService;
import org.kuali.kfs.module.cam.businessobject.BarcodeInventoryErrorDetail;
import org.kuali.kfs.module.cam.document.BarcodeInventoryErrorDocument;
import org.kuali.kfs.module.cam.document.validation.event.ValidateBarcodeInventoryEvent;
import org.kuali.kfs.module.cam.document.web.struts.BarcodeInventoryErrorForm;
import org.kuali.kfs.module.cam.util.BarcodeInventoryErrorDetailPredicate;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.web.struts.FinancialSystemTransactionalDocumentActionBase;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kew.api.exception.WorkflowException;

public class BarcodeInventoryErrorAction
extends FinancialSystemTransactionalDocumentActionBase {
    public ActionForward sendAdHocRequests(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BarcodeInventoryErrorForm bcieForm = (BarcodeInventoryErrorForm)form;
        BarcodeInventoryErrorDocument document = bcieForm.getBarcodeInventoryErrorDocument();
        this.getBusinessObjectService().save(document.getBarcodeInventoryErrorDetail());
        return super.sendAdHocRequests(mapping, (ActionForm)bcieForm, request, response);
    }

    public ActionForward approve(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BarcodeInventoryErrorForm bcieForm = (BarcodeInventoryErrorForm)form;
        BarcodeInventoryErrorDocument document = bcieForm.getBarcodeInventoryErrorDocument();
        if (!document.isDocumentCorrected()) {
            GlobalVariables.getMessageMap().putError("documentNumber", "error.validate.items.before.approval", new String[]{document.getDocumentNumber()});
            return mapping.findForward("basic");
        }
        this.getBusinessObjectService().save(document.getBarcodeInventoryErrorDetail());
        if (this.getAssetBarcodeInventoryLoadService().isCurrentUserInitiator((Document)document)) {
            this.invokeRules(document, false);
        }
        return super.approve(mapping, form, request, response);
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.refresh(mapping, form, request, response);
        BarcodeInventoryErrorForm bcieForm = (BarcodeInventoryErrorForm)form;
        BarcodeInventoryErrorDocument document = bcieForm.getBarcodeInventoryErrorDocument();
        this.invokeRules(document, false);
        return mapping.findForward("basic");
    }

    protected void loadDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        super.loadDocument(kualiDocumentFormBase);
        BarcodeInventoryErrorForm bcieForm = (BarcodeInventoryErrorForm)kualiDocumentFormBase;
        BarcodeInventoryErrorDocument document = bcieForm.getBarcodeInventoryErrorDocument();
        this.invokeRules(document, false);
    }

    public ActionForward searchAndReplace(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BarcodeInventoryErrorForm barcodeInventoryErrorForm = (BarcodeInventoryErrorForm)form;
        BarcodeInventoryErrorDocument document = barcodeInventoryErrorForm.getBarcodeInventoryErrorDocument();
        List<BarcodeInventoryErrorDetail> barcodeInventoryErrorDetails = document.getBarcodeInventoryErrorDetail();
        if (this.validateGlobalReplaceFields(document)) {
            BarcodeInventoryErrorDetailPredicate predicatedClosure = new BarcodeInventoryErrorDetailPredicate(barcodeInventoryErrorForm.getBarcodeInventoryErrorDocument());
            IterableUtils.forEach(barcodeInventoryErrorDetails, (Closure)predicatedClosure);
            document.setBarcodeInventoryErrorDetail(barcodeInventoryErrorDetails);
            barcodeInventoryErrorForm.setDocument((Document)document);
        }
        this.invokeRules(document, false);
        barcodeInventoryErrorForm.getBarcodeInventoryErrorDocument().resetSearchFields();
        barcodeInventoryErrorForm.resetCheckBoxes();
        return mapping.findForward("basic");
    }

    public ActionForward validateLines(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BarcodeInventoryErrorForm barcodeInventoryErrorForm = (BarcodeInventoryErrorForm)form;
        BarcodeInventoryErrorDocument document = barcodeInventoryErrorForm.getBarcodeInventoryErrorDocument();
        String currentUserID = GlobalVariables.getUserSession().getPerson().getPrincipalId();
        ArrayList<Integer> selectedRows = new ArrayList<Integer>();
        int[] selectedCheckboxes = barcodeInventoryErrorForm.getRowCheckbox();
        if (selectedCheckboxes != null) {
            for (int selectedCheckbox : selectedCheckboxes) {
                selectedRows.add(selectedCheckbox);
            }
            this.invokeRules(document, true);
            List<BarcodeInventoryErrorDetail> barcodeInventoryErrorDetails = document.getBarcodeInventoryErrorDetail();
            Object object = barcodeInventoryErrorDetails.iterator();
            while (object.hasNext()) {
                BarcodeInventoryErrorDetail detail = (BarcodeInventoryErrorDetail)((Object)object.next());
                int uploadRowNumber = detail.getUploadRowNumber().intValue();
                if (selectedRows.contains(uploadRowNumber)) {
                    if (!detail.getErrorCorrectionStatusCode().equals("C")) continue;
                    detail.setInventoryCorrectionTimestamp(this.getDateTimeService().getCurrentTimestamp());
                    detail.setCorrectorUniversalIdentifier(currentUserID);
                    this.getAssetBarcodeInventoryLoadService().updateAssetInformation(detail, false);
                    continue;
                }
                if (detail.getInventoryCorrectionTimestamp() != null) continue;
                detail.setErrorCorrectionStatusCode("E");
            }
        } else {
            GlobalVariables.getMessageMap().putErrorForSectionId("commonErrorSection", "error.checkbox.must.be.checked", new String[0]);
        }
        this.getBusinessObjectService().save(document.getBarcodeInventoryErrorDetail());
        this.loadDocument((KualiDocumentFormBase)form);
        barcodeInventoryErrorForm.resetCheckBoxes();
        return mapping.findForward("basic");
    }

    public ActionForward deleteLines(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BarcodeInventoryErrorForm barcodeInventoryErrorForm = (BarcodeInventoryErrorForm)form;
        BarcodeInventoryErrorDocument document = barcodeInventoryErrorForm.getBarcodeInventoryErrorDocument();
        List<BarcodeInventoryErrorDetail> barcodeInventoryErrorDetails = document.getBarcodeInventoryErrorDetail();
        String currentUserID = GlobalVariables.getUserSession().getPerson().getPrincipalId();
        int[] selectedCheckboxes = barcodeInventoryErrorForm.getRowCheckbox();
        if (selectedCheckboxes != null) {
            for (int selectedCheckbox : selectedCheckboxes) {
                for (BarcodeInventoryErrorDetail detail : barcodeInventoryErrorDetails) {
                    if (detail.getUploadRowNumber().compareTo(Long.valueOf(selectedCheckbox)) != 0) continue;
                    detail.setErrorCorrectionStatusCode("D");
                    detail.setInventoryCorrectionTimestamp(this.getDateTimeService().getCurrentTimestamp());
                    detail.setCorrectorUniversalIdentifier(currentUserID);
                }
            }
        } else {
            GlobalVariables.getMessageMap().putErrorForSectionId("commonErrorSection", "error.checkbox.must.be.checked", new String[0]);
        }
        this.getBusinessObjectService().save(document.getBarcodeInventoryErrorDetail());
        barcodeInventoryErrorForm.resetCheckBoxes();
        this.loadDocument((KualiDocumentFormBase)form);
        return mapping.findForward("basic");
    }

    protected boolean validateGlobalReplaceFields(BarcodeInventoryErrorDocument document) {
        if (StringUtils.isBlank((CharSequence)document.getCurrentScanCode()) && StringUtils.isBlank((CharSequence)document.getCurrentCampusCode()) && StringUtils.isBlank((CharSequence)document.getCurrentBuildingNumber()) && StringUtils.isBlank((CharSequence)document.getCurrentRoom()) && StringUtils.isBlank((CharSequence)document.getCurrentSubroom()) && StringUtils.isBlank((CharSequence)document.getCurrentConditionCode()) && StringUtils.isBlank((CharSequence)document.getCurrentTagNumber())) {
            GlobalVariables.getMessageMap().putErrorForSectionId("globalReplaceErrorSection", "error.global.replace.empty.fields", new String[0]);
            return false;
        }
        return true;
    }

    protected void invokeRules(BarcodeInventoryErrorDocument document, boolean updateStatus) {
        this.getKualiRuleService().applyRules((KualiDocumentEvent)new ValidateBarcodeInventoryEvent("", (Document)document, updateStatus));
    }

    protected AssetBarcodeInventoryLoadService getAssetBarcodeInventoryLoadService() {
        return (AssetBarcodeInventoryLoadService)SpringContext.getBean(AssetBarcodeInventoryLoadService.class);
    }

    protected DateTimeService getDateTimeService() {
        return (DateTimeService)SpringContext.getBean(DateTimeService.class);
    }
}

