/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.cam.businessobject.AssetLock;
import org.kuali.kfs.module.cam.dataaccess.CapitalAssetLockDao;
import org.kuali.kfs.module.cam.service.AssetLockService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class AssetLockServiceImpl
implements AssetLockService {
    private static Logger LOG = LogManager.getLogger(AssetLockService.class);
    private BusinessObjectService businessObjectService;
    private CapitalAssetLockDao capitalAssetLockDao;
    private ConfigurationService configurationService;
    private static final Map<String, String> FINANCIAL_DOC_TYPE_MAP = new HashMap<String, String>();
    private static final Map<String, String> ASSET_MAINTAIN_DOC_TYPE_MAP;
    private static final Map<String, String> ASSET_PMT_CHG_DOC_TYPE_MAP;

    protected boolean isPurApDocument(String documentTypeName) {
        return "PREQ".equals(documentTypeName) || "CM".equals(documentTypeName);
    }

    @Override
    public synchronized boolean checkAndSetAssetLocks(List<AssetLock> assetLocks, boolean ignoreLockingInfoForDeletion) {
        if (assetLocks == null || assetLocks.isEmpty() || !assetLocks.iterator().hasNext()) {
            return true;
        }
        AssetLock lock = assetLocks.iterator().next();
        String documentTypeName = lock.getDocumentTypeName();
        String documentNumber = lock.getDocumentNumber();
        ArrayList<Long> assetNumbers = new ArrayList<Long>();
        for (AssetLock assetLock : assetLocks) {
            assetNumbers.add(assetLock.getCapitalAssetNumber());
        }
        if (this.isAssetLocked(assetNumbers, documentTypeName, documentNumber)) {
            return false;
        }
        for (AssetLock assetLock : assetLocks) {
            this.deleteAssetLocks(documentNumber, ignoreLockingInfoForDeletion ? "" : assetLock.getLockingInformation());
        }
        this.businessObjectService.save(assetLocks);
        return true;
    }

    protected Collection getBlockingDocumentTypes(String documentTypeName) {
        if (FINANCIAL_DOC_TYPE_MAP.containsKey(documentTypeName)) {
            return ASSET_PMT_CHG_DOC_TYPE_MAP.values();
        }
        if (ASSET_MAINTAIN_DOC_TYPE_MAP.containsKey(documentTypeName)) {
            ArrayList<String> financialDocTypes = new ArrayList<String>();
            financialDocTypes.addAll(ASSET_MAINTAIN_DOC_TYPE_MAP.values());
            financialDocTypes.addAll(ASSET_PMT_CHG_DOC_TYPE_MAP.values());
            return financialDocTypes;
        }
        if ("AFPINQ".equals(documentTypeName)) {
            return FINANCIAL_DOC_TYPE_MAP.values();
        }
        if ("APREQINQ".equals(documentTypeName)) {
            ArrayList<String> fpAndPurApDocTypes = new ArrayList<String>();
            fpAndPurApDocTypes.add("PREQ");
            fpAndPurApDocTypes.add("CM");
            return fpAndPurApDocTypes;
        }
        return null;
    }

    @Override
    public void deleteAssetLocks(String documentNumber, String lockingInformation) {
        if (StringUtils.isBlank((CharSequence)documentNumber)) {
            return;
        }
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("documentNumber", documentNumber);
        if (StringUtils.isNotBlank((CharSequence)lockingInformation)) {
            fieldValues.put("lockingInformation", lockingInformation);
        }
        this.businessObjectService.deleteMatching(AssetLock.class, fieldValues);
    }

    @Override
    public List<AssetLock> buildAssetLockHelper(List<Long> assetNumbers, String documentNumber, String documentType, String lockingInformation) {
        ArrayList<AssetLock> assetLocks = new ArrayList<AssetLock>();
        for (Long assetNumber : assetNumbers) {
            if (assetNumber == null) continue;
            AssetLock newLock = new AssetLock(documentNumber, assetNumber, lockingInformation, documentType);
            assetLocks.add(newLock);
        }
        return assetLocks;
    }

    protected void addBlockingDocumentErrorMessage(Collection<String> blockingDocuments, String documentTypeName) {
        for (String blockingDocId : blockingDocuments) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("docId", blockingDocId);
            parameters.put("command", "displayDocSearchView");
            String blockingUrl = UrlFactory.parameterizeUrl((String)(this.configurationService.getPropertyValueAsString("kew.url") + "/" + "DocHandler.do"), parameters);
            if (LOG.isDebugEnabled()) {
                LOG.debug("blockingUrl = '" + blockingUrl + "'");
                LOG.debug("Record: " + blockingDocId + "is locked.");
            }
            String[] errorParameters = new String[]{blockingUrl, blockingDocId};
            if (FINANCIAL_DOC_TYPE_MAP.containsKey(documentTypeName)) {
                GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.asset.locked", errorParameters);
                continue;
            }
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.asset.maintenance.locked", errorParameters);
        }
    }

    @Override
    public boolean isAssetLockedByCurrentDocument(String documentNumber, String lockingInformation) {
        Collection assetLocks;
        if (StringUtils.isBlank((CharSequence)documentNumber)) {
            return false;
        }
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("documentNumber", documentNumber);
        if (StringUtils.isNotBlank((CharSequence)lockingInformation)) {
            fieldValues.put("lockingInformation", lockingInformation);
        }
        return (assetLocks = this.businessObjectService.findMatching(AssetLock.class, fieldValues)) != null && !assetLocks.isEmpty();
    }

    @Override
    public boolean isAssetLocked(List<Long> assetNumbers, String documentTypeName, String excludingDocumentNumber) {
        List<String> lockingDocumentNumbers;
        if (assetNumbers == null || assetNumbers.isEmpty()) {
            return false;
        }
        if (!this.isPurApDocument(documentTypeName) && (lockingDocumentNumbers = this.getAssetLockingDocuments(assetNumbers, documentTypeName, excludingDocumentNumber)) != null && !lockingDocumentNumbers.isEmpty()) {
            this.addBlockingDocumentErrorMessage(lockingDocumentNumbers, documentTypeName);
            return true;
        }
        return false;
    }

    @Override
    public List<String> getAssetLockingDocuments(List<Long> assetNumbers, String documentTypeName, String excludingDocumentNumber) {
        Collection blockingDocumentTypes = this.getBlockingDocumentTypes(documentTypeName);
        return this.getCapitalAssetLockDao().getLockingDocumentNumbers(assetNumbers, blockingDocumentTypes, excludingDocumentNumber);
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public CapitalAssetLockDao getCapitalAssetLockDao() {
        return this.capitalAssetLockDao;
    }

    public void setCapitalAssetLockDao(CapitalAssetLockDao capitalAssetLockDao) {
        this.capitalAssetLockDao = capitalAssetLockDao;
    }

    static {
        FINANCIAL_DOC_TYPE_MAP.put("CR", "CR");
        FINANCIAL_DOC_TYPE_MAP.put("AD", "AD");
        FINANCIAL_DOC_TYPE_MAP.put("CCR", "CCR");
        FINANCIAL_DOC_TYPE_MAP.put("DI", "DI");
        FINANCIAL_DOC_TYPE_MAP.put("GEC", "GEC");
        FINANCIAL_DOC_TYPE_MAP.put("IB", "IB");
        FINANCIAL_DOC_TYPE_MAP.put("SB", "SB");
        FINANCIAL_DOC_TYPE_MAP.put("YEDI", "YEDI");
        FINANCIAL_DOC_TYPE_MAP.put("YEGE", "YEGE");
        FINANCIAL_DOC_TYPE_MAP.put("PCDO", "PCDO");
        FINANCIAL_DOC_TYPE_MAP.put("IAA", "IAA");
        ASSET_MAINTAIN_DOC_TYPE_MAP = new HashMap<String, String>();
        ASSET_MAINTAIN_DOC_TYPE_MAP.put("CASM", "CASM");
        ASSET_MAINTAIN_DOC_TYPE_MAP.put("ALOC", "ALOC");
        ASSET_MAINTAIN_DOC_TYPE_MAP.put("ELR", "ELR");
        ASSET_MAINTAIN_DOC_TYPE_MAP.put("BCIE", "BCIE");
        ASSET_MAINTAIN_DOC_TYPE_MAP.put("MPAYCAB", "MPAYCAB");
        ASSET_PMT_CHG_DOC_TYPE_MAP = new HashMap<String, String>();
        ASSET_PMT_CHG_DOC_TYPE_MAP.put("ARG", "ARG");
        ASSET_PMT_CHG_DOC_TYPE_MAP.put("AT", "AT");
        ASSET_PMT_CHG_DOC_TYPE_MAP.put("MPAY", "MPAY");
        ASSET_PMT_CHG_DOC_TYPE_MAP.put("ASEP", "ASEP");
    }
}

