/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.businessobject;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.ObjectSubType;
import org.kuali.kfs.integration.cg.ContractsAndGrantsAgency;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetAcquisitionType;
import org.kuali.kfs.module.cam.businessobject.AssetComponent;
import org.kuali.kfs.module.cam.businessobject.AssetCondition;
import org.kuali.kfs.module.cam.businessobject.AssetDepreciationMethod;
import org.kuali.kfs.module.cam.businessobject.AssetGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetGlobalDetail;
import org.kuali.kfs.module.cam.businessobject.AssetLocation;
import org.kuali.kfs.module.cam.businessobject.AssetOrganization;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.businessobject.AssetRepairHistory;
import org.kuali.kfs.module.cam.businessobject.AssetRetirementGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetRetirementGlobalDetail;
import org.kuali.kfs.module.cam.businessobject.AssetRetirementReason;
import org.kuali.kfs.module.cam.businessobject.AssetStatus;
import org.kuali.kfs.module.cam.businessobject.AssetType;
import org.kuali.kfs.module.cam.businessobject.AssetWarranty;
import org.kuali.kfs.module.cam.document.service.PaymentSummaryService;
import org.kuali.kfs.sys.businessobject.Building;
import org.kuali.kfs.sys.businessobject.Campus;
import org.kuali.kfs.sys.businessobject.Room;
import org.kuali.kfs.sys.businessobject.UniversityDate;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;

public class AssetBase
extends PersistableBusinessObjectBase {
    protected Long capitalAssetNumber;
    protected String capitalAssetDescription;
    protected String capitalAssetTypeCode;
    protected String conditionCode;
    protected Date createDate;
    protected Date receiveDate;
    protected Date loanReturnDate;
    protected Date loanDate;
    protected Date expectedReturnDate;
    protected String financialDocumentPostingPeriodCode;
    protected Integer financialDocumentPostingYear;
    protected String organizationOwnerAccountNumber;
    protected String organizationOwnerChartOfAccountsCode;
    protected String vendorName;
    protected String acquisitionTypeCode;
    protected KualiDecimal totalCostAmount;
    protected KualiDecimal replacementAmount;
    protected KualiDecimal salePrice;
    protected KualiDecimal estimatedSellingPrice;
    protected KualiDecimal salvageAmount;
    protected String campusCode;
    protected String buildingCode;
    protected String buildingRoomNumber;
    protected String buildingSubRoomNumber;
    protected String retirementChartOfAccountsCode;
    protected String retirementAccountNumber;
    protected String retirementReasonCode;
    protected String retirementPeriodCode;
    protected Integer retirementFiscalYear;
    protected String cashReceiptFinancialDocumentNumber;
    protected String primaryDepreciationMethodCode;
    protected Date estimatedFabricationCompletionDate;
    protected KualiDecimal fabricationEstimatedTotalAmount;
    protected String transferOfFundsFinancialDocumentNumber;
    protected String inventoryStatusCode;
    protected String campusTagNumber;
    protected Timestamp lastInventoryDate;
    protected String organizationInventoryName;
    protected String oldTagNumber;
    protected String manufacturerName;
    protected String manufacturerModelNumber;
    protected String serialNumber;
    protected String representativeUniversalIdentifier;
    protected String agencyNumber;
    protected String campusPoliceDepartmentCaseNumber;
    protected String inventoryScannedCode;
    protected boolean active;
    protected Date capitalAssetInServiceDate;
    protected String governmentTagNumber;
    protected String nationalStockNumber;
    protected String landCountyName;
    protected Integer landAcreageSize;
    protected String landParcelNumber;
    protected Date depreciationDate;
    protected String financialObjectSubTypeCode;
    protected Integer fabricationEstimatedRetentionYears;
    protected AssetType capitalAssetType;
    protected Account organizationOwnerAccount;
    protected Chart organizationOwnerChartOfAccounts;
    protected Campus campus;
    protected Room buildingRoom;
    protected Account retirementAccount;
    protected Chart retirementChartOfAccounts;
    protected AccountingPeriod financialDocumentPostingPeriod;
    protected Building building;
    protected AccountingPeriod retirementPeriod;
    protected AssetRetirementReason retirementReason;
    protected DocumentHeader cashReceiptFinancialDocument;
    protected DocumentHeader transferOfFundsFinancialDocument;
    protected AssetCondition condition;
    protected AssetStatus inventoryStatus;
    protected List<AssetPayment> assetPayments = new ArrayList<AssetPayment>();
    protected Person assetRepresentative;
    protected Person borrowerPerson;
    protected AssetOrganization assetOrganization;
    protected String organizationTagNumber;
    protected List<AssetRepairHistory> assetRepairHistory = new ArrayList<AssetRepairHistory>();
    protected AssetWarranty assetWarranty;
    protected List<AssetComponent> assetComponents = new ArrayList<AssetComponent>();
    protected List<AssetLocation> assetLocations = new ArrayList<AssetLocation>();
    protected List<AssetRetirementGlobalDetail> assetRetirementHistory = new ArrayList<AssetRetirementGlobalDetail>();
    protected AssetDepreciationMethod assetPrimaryDepreciationMethod;
    protected List<AssetRetirementGlobal> retirementGlobals = new ArrayList<AssetRetirementGlobal>();
    protected ObjectSubType financialObjectSubType;
    protected AssetAcquisitionType acquisitionType;
    protected ContractsAndGrantsAgency agency;
    protected KualiDecimal paymentTotalCost;
    protected transient AssetGlobal separateHistory;
    protected List<AssetRetirementGlobalDetail> mergeHistory = new ArrayList<AssetRetirementGlobalDetail>();
    protected KualiDecimal federalContribution;
    protected AssetRetirementGlobalDetail retirementInfo;
    protected AssetLocation offCampusLocation;
    protected AssetLocation borrowerLocation;
    protected AssetLocation borrowerStorageLocation;
    protected KualiDecimal accumulatedDepreciation;
    protected KualiDecimal baseAmount;
    protected KualiDecimal bookValue;
    protected KualiDecimal prevYearDepreciation;
    protected KualiDecimal yearToDateDepreciation;
    protected KualiDecimal currentMonthDepreciation;
    protected Date depreciationDateCopy;
    protected transient Integer quantity;
    protected String lookup;
    protected String assetTransferDocumentLookup;
    protected String assetMaintenanceDocumentLookup;
    protected String assetFabricationDocumentLookup;
    protected String assetCreateOrSeparateDocumentLookup;
    protected String assetPaymentDocumentLookup;
    protected String assetEquipmentLoanOrReturnDocumentLookup;
    protected String assetLocationDocumentLookup;
    protected String assetMergeOrRetirementDocumentLookup;
    protected String camsComplexMaintenanceDocumentLookup;
    protected boolean tagged;
    protected String lastInventoryDateUpdateButton;

    public AssetBase() {
    }

    public AssetBase(AssetGlobal assetGlobal, AssetGlobalDetail assetGlobalDetail, boolean separate) {
        this();
        UniversityDateService universityDateService = (UniversityDateService)SpringContext.getBean(UniversityDateService.class);
        UniversityDate date = universityDateService.getCurrentUniversityDate();
        this.setFinancialDocumentPostingYear(date.getUniversityFiscalYear());
        this.setFinancialDocumentPostingPeriodCode(date.getUniversityFiscalAccountingPeriod());
        this.setLastInventoryDate(new Timestamp(((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDate().getTime()));
        this.setPrimaryDepreciationMethodCode("SL");
        this.setInventoryStatusCode(assetGlobal.getInventoryStatusCode());
        this.setConditionCode(assetGlobal.getConditionCode());
        this.setAcquisitionTypeCode(assetGlobal.getAcquisitionTypeCode());
        this.setLandCountyName(assetGlobal.getLandCountyName());
        this.setLandAcreageSize(assetGlobal.getLandAcreageSize());
        this.setLandParcelNumber(assetGlobal.getLandParcelNumber());
        this.setVendorName(assetGlobal.getVendorName());
        this.setOrganizationOwnerAccountNumber(assetGlobal.getOrganizationOwnerAccountNumber());
        this.setOrganizationOwnerChartOfAccountsCode(assetGlobal.getOrganizationOwnerChartOfAccountsCode());
        this.setAgencyNumber(assetGlobal.getAgencyNumber());
        this.setCapitalAssetInServiceDate(assetGlobal.getCapitalAssetInServiceDate());
        this.setDepreciationDate(assetGlobal.getCapitalAssetDepreciationDate());
        this.setCreateDate(assetGlobal.getCreateDate());
        this.setCapitalAssetNumber(assetGlobalDetail.getCapitalAssetNumber());
        this.setCampusCode(assetGlobalDetail.getCampusCode());
        this.setBuildingCode(assetGlobalDetail.getBuildingCode());
        this.setBuildingRoomNumber(assetGlobalDetail.getBuildingRoomNumber());
        this.setBuildingSubRoomNumber(assetGlobalDetail.getBuildingSubRoomNumber());
        this.setSerialNumber(assetGlobalDetail.getSerialNumber());
        this.setOrganizationInventoryName(assetGlobalDetail.getOrganizationInventoryName());
        this.setGovernmentTagNumber(assetGlobalDetail.getGovernmentTagNumber());
        this.setCampusTagNumber(assetGlobalDetail.getCampusTagNumber());
        this.setNationalStockNumber(assetGlobalDetail.getNationalStockNumber());
        AssetOrganization assetOrganization = new AssetOrganization();
        assetOrganization.setCapitalAssetNumber(assetGlobalDetail.getCapitalAssetNumber());
        assetOrganization.setOrganizationAssetTypeIdentifier(assetGlobalDetail.getOrganizationAssetTypeIdentifier());
        this.setAssetOrganization(assetOrganization);
        this.setActive(true);
        if (separate) {
            this.setRepresentativeUniversalIdentifier(assetGlobalDetail.getRepresentativeUniversalIdentifier());
            this.setCapitalAssetTypeCode(assetGlobalDetail.getCapitalAssetTypeCode());
            this.setCapitalAssetDescription(assetGlobalDetail.getCapitalAssetDescription());
            this.setManufacturerName(assetGlobalDetail.getManufacturerName());
            this.setManufacturerModelNumber(assetGlobalDetail.getManufacturerModelNumber());
            this.assetOrganization.setOrganizationText(assetGlobalDetail.getOrganizationText());
        } else {
            this.setRepresentativeUniversalIdentifier(assetGlobalDetail.getRepresentativeUniversalIdentifier());
            this.setCapitalAssetTypeCode(assetGlobal.getCapitalAssetTypeCode());
            this.setCapitalAssetDescription(assetGlobal.getCapitalAssetDescription());
            this.setManufacturerName(assetGlobal.getManufacturerName());
            this.setManufacturerModelNumber(assetGlobal.getManufacturerModelNumber());
            this.assetOrganization.setOrganizationText(assetGlobal.getOrganizationText());
        }
    }

    public KualiDecimal getCurrentMonthDepreciation() {
        return this.currentMonthDepreciation;
    }

    public void setCurrentMonthDepreciation(KualiDecimal currentMonthDepreciation) {
        this.currentMonthDepreciation = currentMonthDepreciation;
    }

    public KualiDecimal getAccumulatedDepreciation() {
        if (this.accumulatedDepreciation == null) {
            ((PaymentSummaryService)SpringContext.getBean(PaymentSummaryService.class)).calculateAndSetPaymentSummary((Asset)this);
        }
        return this.accumulatedDepreciation;
    }

    public void setAccumulatedDepreciation(KualiDecimal accumulatedDepreciation) {
        this.accumulatedDepreciation = accumulatedDepreciation;
    }

    public KualiDecimal getBaseAmount() {
        return this.baseAmount;
    }

    public void setBaseAmount(KualiDecimal baseAmount) {
        this.baseAmount = baseAmount;
    }

    public KualiDecimal getBookValue() {
        if (this.bookValue == null) {
            ((PaymentSummaryService)SpringContext.getBean(PaymentSummaryService.class)).calculateAndSetPaymentSummary((Asset)this);
        }
        return this.bookValue;
    }

    public void setBookValue(KualiDecimal bookValue) {
        this.bookValue = bookValue;
    }

    public KualiDecimal getPrevYearDepreciation() {
        return this.prevYearDepreciation;
    }

    public void setPrevYearDepreciation(KualiDecimal prevYearDepreciation) {
        this.prevYearDepreciation = prevYearDepreciation;
    }

    public KualiDecimal getYearToDateDepreciation() {
        return this.yearToDateDepreciation;
    }

    public void setYearToDateDepreciation(KualiDecimal yearToDateDepreciation) {
        this.yearToDateDepreciation = yearToDateDepreciation;
    }

    public Long getCapitalAssetNumber() {
        return this.capitalAssetNumber;
    }

    public void setCapitalAssetNumber(Long capitalAssetNumber) {
        this.capitalAssetNumber = capitalAssetNumber;
    }

    public String getCapitalAssetDescription() {
        return this.capitalAssetDescription;
    }

    public void setCapitalAssetDescription(String capitalAssetDescription) {
        this.capitalAssetDescription = capitalAssetDescription;
    }

    public String getCapitalAssetTypeCode() {
        return this.capitalAssetTypeCode;
    }

    public void setCapitalAssetTypeCode(String capitalAssetTypeCode) {
        this.capitalAssetTypeCode = capitalAssetTypeCode;
    }

    public String getConditionCode() {
        return this.conditionCode;
    }

    public void setConditionCode(String conditionCode) {
        this.conditionCode = conditionCode;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getReceiveDate() {
        return this.receiveDate;
    }

    public void setReceiveDate(Date receiveDate) {
        this.receiveDate = receiveDate;
    }

    public Date getLoanReturnDate() {
        return this.loanReturnDate;
    }

    public void setLoanReturnDate(Date loanReturnDate) {
        this.loanReturnDate = loanReturnDate;
    }

    public Date getLoanDate() {
        return this.loanDate;
    }

    public void setLoanDate(Date loanDate) {
        this.loanDate = loanDate;
    }

    public Date getExpectedReturnDate() {
        return this.expectedReturnDate;
    }

    public void setExpectedReturnDate(Date expectedReturnDate) {
        this.expectedReturnDate = expectedReturnDate;
    }

    public String getFinancialDocumentPostingPeriodCode() {
        return this.financialDocumentPostingPeriodCode;
    }

    public void setFinancialDocumentPostingPeriodCode(String financialDocumentPostingPeriodCode) {
        this.financialDocumentPostingPeriodCode = financialDocumentPostingPeriodCode;
    }

    public Integer getFinancialDocumentPostingYear() {
        return this.financialDocumentPostingYear;
    }

    public void setFinancialDocumentPostingYear(Integer financialDocumentPostingYear) {
        this.financialDocumentPostingYear = financialDocumentPostingYear;
    }

    public String getOrganizationOwnerAccountNumber() {
        return this.organizationOwnerAccountNumber;
    }

    public void setOrganizationOwnerAccountNumber(String organizationOwnerAccountNumber) {
        this.organizationOwnerAccountNumber = organizationOwnerAccountNumber;
    }

    public String getOrganizationOwnerChartOfAccountsCode() {
        return this.organizationOwnerChartOfAccountsCode;
    }

    public void setOrganizationOwnerChartOfAccountsCode(String organizationOwnerChartOfAccountsCode) {
        this.organizationOwnerChartOfAccountsCode = organizationOwnerChartOfAccountsCode;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    public String getAcquisitionTypeCode() {
        return this.acquisitionTypeCode;
    }

    public void setAcquisitionTypeCode(String acquisitionTypeCode) {
        this.acquisitionTypeCode = acquisitionTypeCode;
    }

    public KualiDecimal getTotalCostAmount() {
        return this.totalCostAmount;
    }

    public void setTotalCostAmount(KualiDecimal totalCostAmount) {
        this.totalCostAmount = totalCostAmount;
    }

    public KualiDecimal getReplacementAmount() {
        return this.replacementAmount;
    }

    public void setReplacementAmount(KualiDecimal replacementAmount) {
        this.replacementAmount = replacementAmount;
    }

    public KualiDecimal getSalePrice() {
        return this.salePrice;
    }

    public void setSalePrice(KualiDecimal salePrice) {
        this.salePrice = salePrice;
    }

    public KualiDecimal getEstimatedSellingPrice() {
        return this.estimatedSellingPrice;
    }

    public void setEstimatedSellingPrice(KualiDecimal estimatedSellingPrice) {
        this.estimatedSellingPrice = estimatedSellingPrice;
    }

    public KualiDecimal getSalvageAmount() {
        if (this.salvageAmount == null) {
            this.salvageAmount = KualiDecimal.ZERO;
        }
        return this.salvageAmount;
    }

    public void setSalvageAmount(KualiDecimal salvageAmount) {
        this.salvageAmount = salvageAmount;
    }

    public String getCampusCode() {
        return this.campusCode;
    }

    public void setCampusCode(String campusCode) {
        this.campusCode = campusCode;
    }

    public String getBuildingCode() {
        return this.buildingCode;
    }

    public void setBuildingCode(String buildingCode) {
        this.buildingCode = buildingCode;
    }

    public String getBuildingRoomNumber() {
        return this.buildingRoomNumber;
    }

    public void setBuildingRoomNumber(String buildingRoomNumber) {
        this.buildingRoomNumber = buildingRoomNumber;
    }

    public String getBuildingSubRoomNumber() {
        return this.buildingSubRoomNumber;
    }

    public void setBuildingSubRoomNumber(String buildingSubRoomNumber) {
        this.buildingSubRoomNumber = buildingSubRoomNumber;
    }

    public String getRetirementChartOfAccountsCode() {
        return this.retirementChartOfAccountsCode;
    }

    public void setRetirementChartOfAccountsCode(String retirementChartOfAccountsCode) {
        this.retirementChartOfAccountsCode = retirementChartOfAccountsCode;
    }

    public String getRetirementAccountNumber() {
        return this.retirementAccountNumber;
    }

    public void setRetirementAccountNumber(String retirementAccountNumber) {
        this.retirementAccountNumber = retirementAccountNumber;
    }

    public String getRetirementReasonCode() {
        return this.retirementReasonCode;
    }

    public void setRetirementReasonCode(String retirementReasonCode) {
        this.retirementReasonCode = retirementReasonCode;
    }

    public String getRetirementPeriodCode() {
        return this.retirementPeriodCode;
    }

    public void setRetirementPeriodCode(String retirementPeriodCode) {
        this.retirementPeriodCode = retirementPeriodCode;
    }

    public Integer getRetirementFiscalYear() {
        return this.retirementFiscalYear;
    }

    public void setRetirementFiscalYear(Integer retirementFiscalYear) {
        this.retirementFiscalYear = retirementFiscalYear;
    }

    public String getCashReceiptFinancialDocumentNumber() {
        return this.cashReceiptFinancialDocumentNumber;
    }

    public void setCashReceiptFinancialDocumentNumber(String cashReceiptFinancialDocumentNumber) {
        this.cashReceiptFinancialDocumentNumber = cashReceiptFinancialDocumentNumber;
    }

    public String getPrimaryDepreciationMethodCode() {
        return this.primaryDepreciationMethodCode;
    }

    public void setPrimaryDepreciationMethodCode(String primaryDepreciationMethodCode) {
        this.primaryDepreciationMethodCode = primaryDepreciationMethodCode;
    }

    public Date getEstimatedFabricationCompletionDate() {
        return this.estimatedFabricationCompletionDate;
    }

    public void setEstimatedFabricationCompletionDate(Date estimatedFabricationCompletionDate) {
        this.estimatedFabricationCompletionDate = estimatedFabricationCompletionDate;
    }

    public KualiDecimal getFabricationEstimatedTotalAmount() {
        return this.fabricationEstimatedTotalAmount;
    }

    public void setFabricationEstimatedTotalAmount(KualiDecimal fabricationEstimatedTotalAmount) {
        this.fabricationEstimatedTotalAmount = fabricationEstimatedTotalAmount;
    }

    public String getTransferOfFundsFinancialDocumentNumber() {
        return this.transferOfFundsFinancialDocumentNumber;
    }

    public void setTransferOfFundsFinancialDocumentNumber(String transferOfFundsFinancialDocumentNumber) {
        this.transferOfFundsFinancialDocumentNumber = transferOfFundsFinancialDocumentNumber;
    }

    public String getInventoryStatusCode() {
        return this.inventoryStatusCode;
    }

    public void setInventoryStatusCode(String inventoryStatusCode) {
        this.inventoryStatusCode = inventoryStatusCode;
    }

    public String getCampusTagNumber() {
        return this.campusTagNumber;
    }

    public void setCampusTagNumber(String campusTagNumber) {
        this.campusTagNumber = campusTagNumber;
    }

    public Timestamp getLastInventoryDate() {
        return this.lastInventoryDate;
    }

    public void setLastInventoryDate(Timestamp lastInventoryDate) {
        this.lastInventoryDate = lastInventoryDate;
    }

    public String getOrganizationInventoryName() {
        return this.organizationInventoryName;
    }

    public void setOrganizationInventoryName(String organizationInventoryName) {
        this.organizationInventoryName = organizationInventoryName;
    }

    public String getOldTagNumber() {
        return this.oldTagNumber;
    }

    public void setOldTagNumber(String oldTagNumber) {
        this.oldTagNumber = oldTagNumber;
    }

    public String getManufacturerName() {
        return this.manufacturerName;
    }

    public void setManufacturerName(String manufacturerName) {
        this.manufacturerName = manufacturerName;
    }

    public String getManufacturerModelNumber() {
        return this.manufacturerModelNumber;
    }

    public void setManufacturerModelNumber(String manufacturerModelNumber) {
        this.manufacturerModelNumber = manufacturerModelNumber;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getRepresentativeUniversalIdentifier() {
        return this.representativeUniversalIdentifier;
    }

    public void setRepresentativeUniversalIdentifier(String representativeUniversalIdentifier) {
        this.representativeUniversalIdentifier = representativeUniversalIdentifier;
    }

    public String getAgencyNumber() {
        return this.agencyNumber;
    }

    public void setAgencyNumber(String agencyNumber) {
        this.agencyNumber = agencyNumber;
    }

    public String getCampusPoliceDepartmentCaseNumber() {
        return this.campusPoliceDepartmentCaseNumber;
    }

    public void setCampusPoliceDepartmentCaseNumber(String campusPoliceDepartmentCaseNumber) {
        this.campusPoliceDepartmentCaseNumber = campusPoliceDepartmentCaseNumber;
    }

    public String getInventoryScannedCode() {
        return this.inventoryScannedCode;
    }

    public void setInventoryScannedCode(String inventoryScannedCode) {
        this.inventoryScannedCode = inventoryScannedCode;
    }

    public Date getCapitalAssetInServiceDate() {
        return this.capitalAssetInServiceDate;
    }

    public void setCapitalAssetInServiceDate(Date capitalAssetInServiceDate) {
        this.capitalAssetInServiceDate = capitalAssetInServiceDate;
    }

    public String getGovernmentTagNumber() {
        return this.governmentTagNumber;
    }

    public void setGovernmentTagNumber(String governmentTagNumber) {
        this.governmentTagNumber = governmentTagNumber;
    }

    public String getNationalStockNumber() {
        return this.nationalStockNumber;
    }

    public void setNationalStockNumber(String nationalStockNumber) {
        this.nationalStockNumber = nationalStockNumber;
    }

    public Integer getLandAcreageSize() {
        return this.landAcreageSize;
    }

    public void setLandAcreageSize(Integer landAcreageSize) {
        this.landAcreageSize = landAcreageSize;
    }

    public String getLandCountyName() {
        return this.landCountyName;
    }

    public void setLandCountyName(String landCountyName) {
        this.landCountyName = landCountyName;
    }

    public String getLandParcelNumber() {
        return this.landParcelNumber;
    }

    public void setLandParcelNumber(String landParcelNumber) {
        this.landParcelNumber = landParcelNumber;
    }

    public Date getDepreciationDate() {
        return this.depreciationDate;
    }

    public void setDepreciationDate(Date depreciationDate) {
        this.depreciationDate = depreciationDate;
    }

    public AssetType getCapitalAssetType() {
        return this.capitalAssetType;
    }

    @Deprecated
    public void setCapitalAssetType(AssetType capitalAssetType) {
        this.capitalAssetType = capitalAssetType;
    }

    public Account getOrganizationOwnerAccount() {
        return this.organizationOwnerAccount;
    }

    @Deprecated
    public void setOrganizationOwnerAccount(Account organizationOwnerAccount) {
        this.organizationOwnerAccount = organizationOwnerAccount;
    }

    public Chart getOrganizationOwnerChartOfAccounts() {
        return this.organizationOwnerChartOfAccounts;
    }

    @Deprecated
    public void setOrganizationOwnerChartOfAccounts(Chart organizationOwnerChartOfAccounts) {
        this.organizationOwnerChartOfAccounts = organizationOwnerChartOfAccounts;
    }

    public Campus getCampus() {
        return this.campus;
    }

    @Deprecated
    public void setCampus(Campus campus) {
        this.campus = campus;
    }

    public Room getBuildingRoom() {
        return this.buildingRoom;
    }

    @Deprecated
    public void setBuildingRoom(Room buildingRoom) {
        this.buildingRoom = buildingRoom;
    }

    public Account getRetirementAccount() {
        return this.retirementAccount;
    }

    @Deprecated
    public void setRetirementAccount(Account retirementAccount) {
        this.retirementAccount = retirementAccount;
    }

    public Chart getRetirementChartOfAccounts() {
        return this.retirementChartOfAccounts;
    }

    @Deprecated
    public void setRetirementChartOfAccounts(Chart retirementChartOfAccounts) {
        this.retirementChartOfAccounts = retirementChartOfAccounts;
    }

    public Building getBuilding() {
        return this.building;
    }

    @Deprecated
    public void setBuilding(Building building) {
        this.building = building;
    }

    public DocumentHeader getCashReceiptFinancialDocument() {
        return this.cashReceiptFinancialDocument;
    }

    @Deprecated
    public void setCashReceiptFinancialDocument(DocumentHeader cashReceiptFinancialDocument) {
        this.cashReceiptFinancialDocument = cashReceiptFinancialDocument;
    }

    public AccountingPeriod getRetirementPeriod() {
        return this.retirementPeriod;
    }

    @Deprecated
    public void setRetirementPeriod(AccountingPeriod retirementPeriod) {
        this.retirementPeriod = retirementPeriod;
    }

    public AssetRetirementReason getRetirementReason() {
        return this.retirementReason;
    }

    @Deprecated
    public void setRetirementReason(AssetRetirementReason retirementReason) {
        this.retirementReason = retirementReason;
    }

    public DocumentHeader getTransferOfFundsFinancialDocument() {
        return this.transferOfFundsFinancialDocument;
    }

    @Deprecated
    public void setTransferOfFundsFinancialDocument(DocumentHeader transferOfFundsFinancialDocument) {
        this.transferOfFundsFinancialDocument = transferOfFundsFinancialDocument;
    }

    public AccountingPeriod getFinancialDocumentPostingPeriod() {
        return this.financialDocumentPostingPeriod;
    }

    @Deprecated
    public void setFinancialDocumentPostingPeriod(AccountingPeriod financialDocumentPostingPeriod) {
        this.financialDocumentPostingPeriod = financialDocumentPostingPeriod;
    }

    public AssetCondition getCondition() {
        return this.condition;
    }

    @Deprecated
    public void setCondition(AssetCondition condition) {
        this.condition = condition;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public List<AssetPayment> getAssetPayments() {
        return this.assetPayments;
    }

    public void setAssetPayments(List<AssetPayment> assetPayments) {
        this.assetPayments = assetPayments;
    }

    public AssetStatus getInventoryStatus() {
        return this.inventoryStatus;
    }

    public void setInventoryStatus(AssetStatus inventoryStatus) {
        this.inventoryStatus = inventoryStatus;
    }

    public Person getAssetRepresentative() {
        this.assetRepresentative = ((PersonService)SpringContext.getBean(PersonService.class)).updatePersonIfNecessary(this.representativeUniversalIdentifier, this.assetRepresentative);
        return this.assetRepresentative;
    }

    @Deprecated
    public void setAssetRepresentative(Person assetRepresentative) {
        this.assetRepresentative = assetRepresentative;
    }

    public Person getBorrowerPerson() {
        if (ObjectUtils.isNotNull((Object)((Object)this.borrowerLocation))) {
            this.borrowerPerson = ((PersonService)SpringContext.getBean(PersonService.class)).updatePersonIfNecessary(this.borrowerLocation.getAssetLocationContactIdentifier(), this.borrowerPerson);
        }
        return this.borrowerPerson;
    }

    public void setBorrowerPerson(Person borrowerPerson) {
        this.borrowerPerson = borrowerPerson;
    }

    public AssetOrganization getAssetOrganization() {
        return this.assetOrganization;
    }

    public void setAssetOrganization(AssetOrganization assetOrganization) {
        this.assetOrganization = assetOrganization;
    }

    public String getOrganizationTagNumber() {
        return this.organizationTagNumber;
    }

    public void setOrganizationTagNumber(String organizationTagNumber) {
        this.organizationTagNumber = organizationTagNumber;
    }

    public List<AssetRepairHistory> getAssetRepairHistory() {
        return this.assetRepairHistory;
    }

    public void setAssetRepairHistory(List<AssetRepairHistory> assetRepairHistory) {
        this.assetRepairHistory = assetRepairHistory;
    }

    public AssetWarranty getAssetWarranty() {
        return this.assetWarranty;
    }

    public void setAssetWarranty(AssetWarranty assetWarranty) {
        this.assetWarranty = assetWarranty;
    }

    public KualiDecimal getPaymentTotalCost() {
        return this.paymentTotalCost;
    }

    public void setPaymentTotalCost(KualiDecimal paymentTotalCost) {
        this.paymentTotalCost = paymentTotalCost;
    }

    public List<AssetComponent> getAssetComponents() {
        return this.assetComponents;
    }

    public void setAssetComponents(List<AssetComponent> assetComponents) {
        this.assetComponents = assetComponents;
    }

    public KualiDecimal getFederalContribution() {
        return this.federalContribution;
    }

    public void setFederalContribution(KualiDecimal federalContribution) {
        this.federalContribution = federalContribution;
    }

    public AssetRetirementGlobalDetail getRetirementInfo() {
        return this.retirementInfo;
    }

    public void setRetirementInfo(AssetRetirementGlobalDetail retirementInfo) {
        this.retirementInfo = retirementInfo;
    }

    public List<AssetLocation> getAssetLocations() {
        return this.assetLocations;
    }

    public void setAssetLocations(List<AssetLocation> assetLocations) {
        this.assetLocations = assetLocations;
    }

    public AssetLocation getOffCampusLocation() {
        return this.offCampusLocation;
    }

    public void setOffCampusLocation(AssetLocation offCampusLocation) {
        this.offCampusLocation = offCampusLocation;
    }

    public List<AssetRetirementGlobalDetail> getAssetRetirementHistory() {
        return this.assetRetirementHistory;
    }

    public void setAssetRetirementHistory(List<AssetRetirementGlobalDetail> assetRetirementHistory) {
        this.assetRetirementHistory = assetRetirementHistory;
    }

    public AssetDepreciationMethod getAssetPrimaryDepreciationMethod() {
        return this.assetPrimaryDepreciationMethod;
    }

    public void setAssetPrimaryDepreciationMethod(AssetDepreciationMethod assetPrimaryDepreciationMethod) {
        this.assetPrimaryDepreciationMethod = assetPrimaryDepreciationMethod;
    }

    public Integer getFabricationEstimatedRetentionYears() {
        return this.fabricationEstimatedRetentionYears;
    }

    public void setFabricationEstimatedRetentionYears(Integer fabricationEstimatedRetentionYears) {
        this.fabricationEstimatedRetentionYears = fabricationEstimatedRetentionYears;
    }

    public List<AssetRetirementGlobal> getRetirementGlobals() {
        return this.retirementGlobals;
    }

    public void setRetirementGlobals(List<AssetRetirementGlobal> retirementGlobals) {
        this.retirementGlobals = retirementGlobals;
    }

    public AssetGlobal getSeparateHistory() {
        return this.separateHistory;
    }

    public void setSeparateHistory(AssetGlobal separateHistory) {
        this.separateHistory = separateHistory;
    }

    public List<AssetRetirementGlobalDetail> getMergeHistory() {
        return this.mergeHistory;
    }

    public void setMergeHistory(List<AssetRetirementGlobalDetail> mergeHistory) {
        this.mergeHistory = mergeHistory;
    }

    public String getFinancialObjectSubTypeCode() {
        return this.financialObjectSubTypeCode;
    }

    public void setFinancialObjectSubTypeCode(String financialObjectSubTypeCode) {
        this.financialObjectSubTypeCode = financialObjectSubTypeCode;
    }

    public ObjectSubType getFinancialObjectSubType() {
        return this.financialObjectSubType;
    }

    @Deprecated
    public void setFinancialObjectSubType(ObjectSubType financialObjectSubType) {
        this.financialObjectSubType = financialObjectSubType;
    }

    public Date getDepreciationDateCopy() {
        return this.depreciationDate;
    }

    @Deprecated
    public void setDepreciationDateCopy(Date depreciationDateCopy) {
        this.depreciationDateCopy = depreciationDateCopy;
    }

    public AssetAcquisitionType getAcquisitionType() {
        return this.acquisitionType;
    }

    public void setAcquisitionType(AssetAcquisitionType acquisitionType) {
        this.acquisitionType = acquisitionType;
    }

    public ContractsAndGrantsAgency getAgency() {
        this.agency = (ContractsAndGrantsAgency)((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(ContractsAndGrantsAgency.class).retrieveExternalizableBusinessObjectIfNecessary((BusinessObject)this, (ExternalizableBusinessObject)this.agency, "agency");
        return this.agency;
    }

    @Deprecated
    public void setAgency(ContractsAndGrantsAgency agency) {
        this.agency = agency;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public boolean isTagged() {
        return this.tagged;
    }

    public void setTagged() {
        this.tagged = !StringUtils.isBlank((CharSequence)this.campusTagNumber);
    }

    public AssetLocation getBorrowerLocation() {
        return this.borrowerLocation;
    }

    public void setBorrowerLocation(AssetLocation borrowerLocation) {
        this.borrowerLocation = borrowerLocation;
    }

    public AssetLocation getBorrowerStorageLocation() {
        return this.borrowerStorageLocation;
    }

    public void setBorrowerStorageLocation(AssetLocation borrowerStorageLocation) {
        this.borrowerStorageLocation = borrowerStorageLocation;
    }

    public String getLastInventoryDateUpdateButton() {
        return this.lastInventoryDateUpdateButton;
    }

    public void setLastInventoryDateUpdateButton(String lastInventoryDateUpdateButton) {
        this.lastInventoryDateUpdateButton = lastInventoryDateUpdateButton;
    }

    public String getLookup() {
        if (this.getCapitalAssetNumber() == null) {
            return "";
        }
        String basePath = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("application.url");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("methodToCall", "search");
        params.put("docFormKey", "88888888");
        params.put("hideReturnLink", "true");
        params.put("capitalAssetNumber", this.getCapitalAssetNumber().toString());
        params.put("returnLocation", "portal.do");
        params.put("businessObjectClassName", AssetPayment.class.getName());
        return UrlFactory.parameterizeUrl((String)(basePath + "/" + "kr/lookup.do"), params);
    }

    protected String getUrlForAssetDocumentLookup(String documentTypeName) {
        if (this.getCapitalAssetNumber() == null) {
            return "";
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("documentTypeName", documentTypeName);
        params.put("documentAttribute.capitalAssetNumber", this.getCapitalAssetNumber().toString());
        return UrlFactory.parameterizeUrl((String)((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("workflow.documentsearch.base.url"), params);
    }

    public String getAssetTransferDocumentLookup() {
        return this.getUrlForAssetDocumentLookup("AT");
    }

    public String getAssetMaintenanceDocumentLookup() {
        return this.getUrlForAssetDocumentLookup("CASM");
    }

    public String getAssetFabricationDocumentLookup() {
        return this.getUrlForAssetDocumentLookup("FR");
    }

    public String getAssetCreateOrSeparateDocumentLookup() {
        return this.getUrlForAssetDocumentLookup("AA");
    }

    public String getAssetPaymentDocumentLookup() {
        return this.getUrlForAssetDocumentLookup("MPAY");
    }

    public String getAssetEquipmentLoanOrReturnDocumentLookup() {
        return this.getUrlForAssetDocumentLookup("ELR");
    }

    public String getAssetLocationDocumentLookup() {
        return this.getUrlForAssetDocumentLookup("ALOC");
    }

    public String getAssetMergeOrRetirementDocumentLookup() {
        return this.getUrlForAssetDocumentLookup("ARG");
    }

    public String getCamsComplexMaintenanceDocumentLookup() {
        return this.getUrlForAssetDocumentLookup("CAMM");
    }

    public List<Collection<PersistableBusinessObject>> buildListOfDeletionAwareLists() {
        ArrayList<Collection<PersistableBusinessObject>> managedLists = new ArrayList<Collection<PersistableBusinessObject>>();
        managedLists.add(new ArrayList<AssetLocation>(this.getAssetLocations()));
        return managedLists;
    }
}

