/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.businessobject.options;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.keyvalues.KeyValuesBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;

public class CamsYearEndAccountingPeriodValuesFinder
extends KeyValuesBase {
    private DateTimeService dateTimeService;
    private ParameterService parameterService;

    public List<KeyValue> getKeyValues() {
        String numberOfPostBackPeriodsParamVal;
        ArrayList<KeyValue> accountingPeriodCodes = new ArrayList<KeyValue>();
        Date date = this.dateTimeService.getCurrentSqlDate();
        AccountingPeriod currentAccountingPeriod = this.getAccountingPeriodService().getByDate(date);
        if (currentAccountingPeriod.isOpen()) {
            accountingPeriodCodes.add((KeyValue)new ConcreteKeyValue(currentAccountingPeriod.getUniversityFiscalPeriodCode() + currentAccountingPeriod.getUniversityFiscalYear(), currentAccountingPeriod.getUniversityFiscalPeriodName()));
        }
        if (StringUtils.isNotBlank((CharSequence)(numberOfPostBackPeriodsParamVal = this.parameterService.getParameterValueAsString("KFS-SYS", "Document", "NUMBER_OF_POSTBACK_PERIODS"))) && Integer.parseInt(numberOfPostBackPeriodsParamVal) > 0) {
            for (int i = 1; i <= Integer.parseInt(numberOfPostBackPeriodsParamVal); ++i) {
                int currentFiscalYear = currentAccountingPeriod.getUniversityFiscalYear();
                int currentFiscalPeriod = Integer.parseInt(currentAccountingPeriod.getUniversityFiscalPeriodCode());
                if (currentFiscalPeriod == 1) {
                    --currentFiscalYear;
                    currentFiscalPeriod = 13;
                } else {
                    --currentFiscalPeriod;
                }
                currentAccountingPeriod = this.getAccountingPeriodService().getByPeriod(StringUtils.leftPad((String)Integer.toString(currentFiscalPeriod), (int)2, (String)"0"), Integer.valueOf(currentFiscalYear));
                if (!currentAccountingPeriod.isOpen()) continue;
                accountingPeriodCodes.add((KeyValue)new ConcreteKeyValue(currentAccountingPeriod.getUniversityFiscalPeriodCode() + currentAccountingPeriod.getUniversityFiscalYear(), currentAccountingPeriod.getUniversityFiscalPeriodName()));
            }
        }
        return accountingPeriodCodes;
    }

    private AccountingPeriodService getAccountingPeriodService() {
        return (AccountingPeriodService)SpringContext.getBean(AccountingPeriodService.class);
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

