/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document;

import java.sql.Date;
import java.util.ArrayList;
import org.kuali.kfs.integration.cam.CapitalAssetManagementModuleService;
import org.kuali.kfs.krad.document.DocumentBase;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.rules.rule.event.SaveDocumentEvent;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.document.AssetTransferDocument;
import org.kuali.kfs.module.cam.document.service.EquipmentLoanOrReturnService;
import org.kuali.kfs.sys.businessobject.Country;
import org.kuali.kfs.sys.businessobject.PostalCode;
import org.kuali.kfs.sys.businessobject.State;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocumentBase;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;

public class EquipmentLoanOrReturnDocument
extends FinancialSystemTransactionalDocumentBase {
    protected String hiddenFieldForError;
    protected String documentNumber;
    protected Date loanDate;
    protected Date expectedReturnDate;
    protected Date loanReturnDate;
    protected String borrowerUniversalIdentifier;
    protected String borrowerAddress;
    protected String borrowerCityName;
    protected String borrowerStateCode;
    protected String borrowerZipCode;
    protected String borrowerCountryCode;
    protected String borrowerPhoneNumber;
    protected String borrowerStorageAddress;
    protected String borrowerStorageCityName;
    protected String borrowerStorageStateCode;
    protected String borrowerStorageZipCode;
    protected String borrowerStorageCountryCode;
    protected String borrowerStoragePhoneNumber;
    protected Long capitalAssetNumber;
    protected Country borrowerCountry;
    protected Country borrowerStorageCountry;
    protected State borrowerState;
    protected State borrowerStorageState;
    protected Person borrowerPerson;
    protected Asset asset;
    protected PostalCode borrowerPostalZipCode;
    protected PostalCode borrowerStoragePostalZipCode;
    protected boolean newLoan;
    protected boolean returnLoan;

    public Asset getAsset() {
        return this.asset;
    }

    public void setAsset(Asset asset) {
        this.asset = asset;
    }

    public Country getBorrowerCountry() {
        return this.borrowerCountry;
    }

    public void setBorrowerCountry(Country borrowerCountry) {
        this.borrowerCountry = borrowerCountry;
    }

    public State getBorrowerState() {
        return this.borrowerState;
    }

    public void setBorrowerState(State borrowerState) {
        this.borrowerState = borrowerState;
    }

    public Country getBorrowerStorageCountry() {
        return this.borrowerStorageCountry;
    }

    public void setBorrowerStorageCountry(Country borrowerStorageCountry) {
        this.borrowerStorageCountry = borrowerStorageCountry;
    }

    public State getBorrowerStorageState() {
        return this.borrowerStorageState;
    }

    public void setBorrowerStorageState(State borrowerStorageState) {
        this.borrowerStorageState = borrowerStorageState;
    }

    public Person getBorrowerPerson() {
        this.borrowerPerson = ((PersonService)SpringContext.getBean(PersonService.class)).updatePersonIfNecessary(this.borrowerUniversalIdentifier, this.borrowerPerson);
        return this.borrowerPerson;
    }

    public void setBorrowerPerson(Person borrowerPerson) {
        this.borrowerPerson = borrowerPerson;
    }

    public String getBorrowerAddress() {
        return this.borrowerAddress;
    }

    public void setBorrowerAddress(String borrowerAddress) {
        this.borrowerAddress = borrowerAddress;
    }

    public String getBorrowerCityName() {
        return this.borrowerCityName;
    }

    public void setBorrowerCityName(String borrowerCityName) {
        this.borrowerCityName = borrowerCityName;
    }

    public String getBorrowerCountryCode() {
        return this.borrowerCountryCode;
    }

    public void setBorrowerCountryCode(String borrowerCountryCode) {
        this.borrowerCountryCode = borrowerCountryCode;
    }

    public String getBorrowerPhoneNumber() {
        return this.borrowerPhoneNumber;
    }

    public void setBorrowerPhoneNumber(String borrowerPhoneNumber) {
        this.borrowerPhoneNumber = borrowerPhoneNumber;
    }

    public String getBorrowerStateCode() {
        return this.borrowerStateCode;
    }

    public void setBorrowerStateCode(String borrowerStateCode) {
        this.borrowerStateCode = borrowerStateCode;
    }

    public String getBorrowerStorageAddress() {
        return this.borrowerStorageAddress;
    }

    public void setBorrowerStorageAddress(String borrowerStorageAddress) {
        this.borrowerStorageAddress = borrowerStorageAddress;
    }

    public String getBorrowerStorageCityName() {
        return this.borrowerStorageCityName;
    }

    public void setBorrowerStorageCityName(String borrowerStorageCityName) {
        this.borrowerStorageCityName = borrowerStorageCityName;
    }

    public String getBorrowerStorageCountryCode() {
        return this.borrowerStorageCountryCode;
    }

    public void setBorrowerStorageCountryCode(String borrowerStorageCountryCode) {
        this.borrowerStorageCountryCode = borrowerStorageCountryCode;
    }

    public String getBorrowerStoragePhoneNumber() {
        return this.borrowerStoragePhoneNumber;
    }

    public void setBorrowerStoragePhoneNumber(String borrowerStoragePhoneNumber) {
        this.borrowerStoragePhoneNumber = borrowerStoragePhoneNumber;
    }

    public String getBorrowerStorageStateCode() {
        return this.borrowerStorageStateCode;
    }

    public void setBorrowerStorageStateCode(String borrowerStorageStateCode) {
        this.borrowerStorageStateCode = borrowerStorageStateCode;
    }

    public String getBorrowerStorageZipCode() {
        return this.borrowerStorageZipCode;
    }

    public void setBorrowerStorageZipCode(String borrowerStorageZipCode) {
        this.borrowerStorageZipCode = borrowerStorageZipCode;
    }

    public PostalCode getBorrowerPostalZipCode() {
        return this.borrowerPostalZipCode;
    }

    public void setBorrowerPostalZipCode(PostalCode borrowerPostalZipCode) {
        this.borrowerPostalZipCode = borrowerPostalZipCode;
    }

    public PostalCode getBorrowerStoragePostalZipCode() {
        return this.borrowerStoragePostalZipCode;
    }

    public void setborrowerStoragePostalZipCode(PostalCode borrowerStoragePostalZipCode) {
        this.borrowerStoragePostalZipCode = borrowerStoragePostalZipCode;
    }

    public String getBorrowerUniversalIdentifier() {
        return this.borrowerUniversalIdentifier;
    }

    public void setBorrowerUniversalIdentifier(String borrowerUniversalIdentifier) {
        this.borrowerUniversalIdentifier = borrowerUniversalIdentifier;
    }

    public String getBorrowerZipCode() {
        return this.borrowerZipCode;
    }

    public void setBorrowerZipCode(String borrowerZipCode) {
        this.borrowerZipCode = borrowerZipCode;
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public Date getExpectedReturnDate() {
        return this.expectedReturnDate;
    }

    public void setExpectedReturnDate(Date expectedReturnDate) {
        this.expectedReturnDate = expectedReturnDate;
    }

    public Date getLoanDate() {
        if (this.loanDate != null) {
            return this.loanDate;
        }
        return ((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDate();
    }

    public void setLoanDate(Date loanDate) {
        this.loanDate = loanDate;
    }

    public Date getLoanReturnDate() {
        return this.loanReturnDate;
    }

    public void setLoanReturnDate(Date loanReturnDate) {
        this.loanReturnDate = loanReturnDate;
    }

    public void postProcessSave(KualiDocumentEvent event) {
        super.postProcessSave(event);
        if (!(event instanceof SaveDocumentEvent)) {
            ArrayList<Long> capitalAssetNumbers = new ArrayList<Long>();
            if (this.getCapitalAssetNumber() != null) {
                capitalAssetNumbers.add(this.getCapitalAssetNumber());
            }
            if (!this.getCapitalAssetManagementModuleService().storeAssetLocks(capitalAssetNumbers, this.getDocumentNumber(), "ELR", null)) {
                throw new ValidationException("Asset " + capitalAssetNumbers.toString() + " is being locked by other documents.");
            }
        }
    }

    protected CapitalAssetManagementModuleService getCapitalAssetManagementModuleService() {
        return (CapitalAssetManagementModuleService)SpringContext.getBean(CapitalAssetManagementModuleService.class);
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        WorkflowDocument workflowDocument = this.getDocumentHeader().getWorkflowDocument();
        if (workflowDocument.isProcessed()) {
            ((EquipmentLoanOrReturnService)SpringContext.getBean(EquipmentLoanOrReturnService.class)).processApprovedEquipmentLoanOrReturn(this);
        }
        if (workflowDocument.isCanceled() || workflowDocument.isDisapproved() || workflowDocument.isProcessed()) {
            this.getCapitalAssetManagementModuleService().deleteAssetLocks(this.getDocumentNumber(), null);
        }
    }

    public boolean answerSplitNodeQuestion(String nodeName) throws UnsupportedOperationException {
        if ("RequiresOrganizationInactiveReview".equals(nodeName)) {
            return AssetTransferDocument.isRequiresOrganizationInactiveRouteNode((DocumentBase)this, this.asset);
        }
        return super.answerSplitNodeQuestion(nodeName);
    }

    public Long getCapitalAssetNumber() {
        return this.capitalAssetNumber;
    }

    public void setCapitalAssetNumber(Long capitalAssetNumber) {
        this.capitalAssetNumber = capitalAssetNumber;
    }

    public boolean isNewLoan() {
        return this.newLoan;
    }

    public void setNewLoan(boolean newLoan) {
        this.newLoan = newLoan;
    }

    public boolean isReturnLoan() {
        return this.returnLoan;
    }

    public void setReturnLoan(boolean returnLoan) {
        this.returnLoan = returnLoan;
    }

    public String getHiddenFieldForError() {
        return this.hiddenFieldForError;
    }

    public void setHiddenFieldForError(String hiddenFieldForError) {
        this.hiddenFieldForError = hiddenFieldForError;
    }
}

