/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.dataaccess.impl;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.module.cam.CamsConstants;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetObjectCode;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.document.dataaccess.DepreciableAssetsDao;
import org.kuali.kfs.module.cam.document.dataaccess.DepreciationBatchDao;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;

public class DepreciableAssetsDaoOjb
extends PlatformAwareDaoBaseOjb
implements DepreciableAssetsDao {
    private static final Logger LOG = LogManager.getLogger(DepreciableAssetsDaoOjb.class);
    private DepreciationBatchDao depreciationBatchDao;
    protected static final String[] REPORT_GROUP = new String[]{"*** BEFORE RUNNING DEPRECIATION PROCESS ****", "*** AFTER RUNNING DEPRECIATION PROCESS ****"};

    @Override
    public List<String[]> generateStatistics(boolean beforeDepreciationReport, List<String> documentNumbers, Integer fiscalYear, Integer fiscalMonth, Calendar depreciationDate, String depreciationRunDate, Collection<AssetObjectCode> assetObjectCodes, int fiscalStartMonth, String errorMessage) {
        LOG.debug("generateStatistics() started");
        LOG.info("DEPRECIATION BATCH - generating statistics for report - " + (beforeDepreciationReport ? "Before part." : "After part"));
        ArrayList<String[]> reportLine = new ArrayList<String[]>();
        NumberFormat usdFormat = NumberFormat.getCurrencyInstance(Locale.US);
        String[] columns = new String[2];
        columns[1] = "******************";
        columns[0] = beforeDepreciationReport ? REPORT_GROUP[0] : REPORT_GROUP[1];
        reportLine.add((String[])columns.clone());
        if (beforeDepreciationReport) {
            columns[0] = "Depreciation Run Date";
            columns[1] = depreciationRunDate;
            reportLine.add((String[])columns.clone());
            columns[0] = "Fiscal Year";
            columns[1] = fiscalYear.toString();
            reportLine.add((String[])columns.clone());
            columns[0] = "Fiscal Month";
            columns[1] = fiscalMonth.toString();
            reportLine.add((String[])columns.clone());
            columns[0] = "Number of assets fully depreciated";
            columns[1] = this.depreciationBatchDao.getFullyDepreciatedAssetCount().toString();
            reportLine.add((String[])columns.clone());
        }
        LOG.info("DEPRECIATION BATCH - Getting DocumentHeader row count.");
        ReportQueryByCriteria q = QueryFactory.newReportQuery(DocumentHeader.class, (Criteria)new Criteria());
        q.setAttributes(new String[]{"count(*)"});
        Iterator i = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)q);
        Object[] data = (Object[])i.next();
        columns[0] = "Document header table - record count";
        columns[1] = this.convertCountValueToString(data[0]);
        reportLine.add((String[])columns.clone());
        LOG.info("DEPRECIATION BATCH - Getting general ledger pending entry row count.");
        q = QueryFactory.newReportQuery(GeneralLedgerPendingEntry.class, (Criteria)new Criteria());
        q.setAttributes(new String[]{"count(*)"});
        i = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)q);
        data = (Object[])i.next();
        columns[0] = "General ledger pending entry table - record count";
        columns[1] = this.convertCountValueToString(data[0]);
        reportLine.add((String[])columns.clone());
        if (beforeDepreciationReport) {
            LOG.info("DEPRECIATION BATCH - Getting assets row count.");
            q = QueryFactory.newReportQuery(Asset.class, (Criteria)new Criteria());
            q.setAttributes(new String[]{"count(*)"});
            i = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)q);
            data = (Object[])i.next();
            columns[0] = "Asset table - record count";
            columns[1] = this.convertCountValueToString(data[0]);
            reportLine.add((String[])columns.clone());
        }
        LOG.info("DEPRECIATION BATCH - Getting assets payment row count, depreciation base amount, accumulated depreciation amount, and every months depreciation amount.");
        q = QueryFactory.newReportQuery(AssetPayment.class, (Criteria)new Criteria());
        q.setAttributes(new String[]{"count(*)", "SUM(primaryDepreciationBaseAmount)", "SUM(accumulatedPrimaryDepreciationAmount)", "SUM(previousYearPrimaryDepreciationAmount)", "SUM(period1Depreciation1Amount)", "SUM(period2Depreciation1Amount)", "SUM(period3Depreciation1Amount)", "SUM(period4Depreciation1Amount)", "SUM(period5Depreciation1Amount)", "SUM(period6Depreciation1Amount)", "SUM(period7Depreciation1Amount)", "SUM(period8Depreciation1Amount)", "SUM(period9Depreciation1Amount)", "SUM(period10Depreciation1Amount)", "SUM(period11Depreciation1Amount)", "SUM(period12Depreciation1Amount)"});
        i = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)q);
        data = new Object[16];
        if (i.hasNext()) {
            data = (Object[])i.next();
        } else {
            for (int c = 0; c < 16; ++c) {
                data[c] = new KualiDecimal(0);
            }
        }
        if (beforeDepreciationReport) {
            columns[0] = "Asset payment table - record count";
            columns[1] = this.convertCountValueToString(data[0]);
            reportLine.add((String[])columns.clone());
        }
        columns[0] = "Depreciation base amount";
        columns[1] = usdFormat.format(data[1]);
        reportLine.add((String[])columns.clone());
        columns[0] = "Current year - accumulated depreciation";
        columns[1] = usdFormat.format(data[2]);
        reportLine.add((String[])columns.clone());
        columns[0] = "Previous year - accumulated depreciation";
        columns[1] = usdFormat.format(data[3]);
        reportLine.add((String[])columns.clone());
        KualiDecimal yearToDateDepreciationAmt = new KualiDecimal(0);
        boolean isJanuaryTheFirstFiscalMonth = fiscalStartMonth == 1;
        int col = 4;
        int currentMonth = fiscalStartMonth - 1;
        int monthCounter = 1;
        while (monthCounter <= 12) {
            columns[0] = CamsConstants.MONTHS[currentMonth] + " depreciation amount";
            columns[1] = usdFormat.format(data[col]);
            reportLine.add((String[])columns.clone());
            yearToDateDepreciationAmt = (KualiDecimal)yearToDateDepreciationAmt.add((AbstractKualiDecimal)((KualiDecimal)data[col]));
            ++col;
            if (!isJanuaryTheFirstFiscalMonth && currentMonth == 11) {
                currentMonth = -1;
            }
            ++monthCounter;
            ++currentMonth;
        }
        columns[0] = "Year to date depreciation amount";
        columns[1] = usdFormat.format(yearToDateDepreciationAmt);
        reportLine.add((String[])columns.clone());
        if (beforeDepreciationReport) {
            int federallyOwnedAssetPaymentCount = Integer.valueOf(this.depreciationBatchDao.getFederallyOwnedAssetAndPaymentCount(fiscalYear, fiscalMonth, depreciationDate)[1].toString());
            int retiredAndTransferredAssetCount = this.depreciationBatchDao.getTransferDocLockedAssetCount() + this.depreciationBatchDao.getRetireDocLockedAssetCount();
            columns[0] = "Object code table - record count";
            columns[1] = this.convertCountValueToString(this.getAssetObjectCodesCount(fiscalYear));
            reportLine.add((String[])columns.clone());
            columns[0] = "Plant fund account table - record count";
            columns[1] = this.convertCountValueToString(this.getCOAsCount());
            reportLine.add((String[])columns.clone());
            LOG.info("DEPRECIATION BATCH - Getting asset payment row count, depreciation base amount, accumulated depreciation amount, and every months depreciation amount.");
            data = this.depreciationBatchDao.getAssetAndPaymentCount(fiscalYear, fiscalMonth, depreciationDate, true);
            int eligibleAssetPaymentCount = new Integer(data[1].toString());
            int totalAssetPayments = eligibleAssetPaymentCount + federallyOwnedAssetPaymentCount;
            columns[0] = "Asset payments eligible for depreciation";
            columns[1] = totalAssetPayments + "";
            reportLine.add((String[])columns.clone());
            columns[0] = "Number of assets with pending AR or AT documents";
            columns[1] = retiredAndTransferredAssetCount + "";
            reportLine.add((String[])columns.clone());
            columns[0] = "Asset payments ineligible for depreciation (Federally owned assets)";
            columns[1] = federallyOwnedAssetPaymentCount + "";
            reportLine.add((String[])columns.clone());
            columns[0] = "Asset payments eligible for depreciation - After excluding federally owned assets";
            columns[1] = eligibleAssetPaymentCount + "";
            reportLine.add((String[])columns.clone());
            columns[0] = "Assets eligible for depreciation";
            columns[1] = data[0].toString();
            reportLine.add((String[])columns.clone());
            Set<Long> transferDocPendingAssets = this.depreciationBatchDao.getTransferDocPendingAssets();
            if (transferDocPendingAssets.size() > 0) {
                columns[0] = "Assets with pending transfer documents";
                columns[1] = StringUtils.join(transferDocPendingAssets, (String)",");
                reportLine.add((String[])columns.clone());
            }
        }
        if (!beforeDepreciationReport) {
            KualiDecimal amount;
            List<String> depreExpObjCodes = this.getExpenseObjectCodes(assetObjectCodes);
            List<String> accumulatedDepreciationObjCodes = this.getAccumulatedDepreciationObjectCodes(assetObjectCodes);
            KualiDecimal debits = new KualiDecimal(0);
            KualiDecimal credits = new KualiDecimal(0);
            columns[0] = "Document Number(s)";
            columns[1] = documentNumbers.toString();
            reportLine.add((String[])columns.clone());
            LOG.info("DEPRECIATION BATCH - calculating the debit amount for expense object codes.");
            Criteria criteria = new Criteria();
            criteria.addIn("financialObjectCode", depreExpObjCodes);
            criteria.addEqualTo("transactionDebitCreditCode", (Object)"D");
            criteria.addIn("documentNumber", documentNumbers);
            q = QueryFactory.newReportQuery(GeneralLedgerPendingEntry.class, (Criteria)criteria);
            q.setAttributes(new String[]{"SUM(transactionLedgerEntryAmount)"});
            i = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)q);
            data = (Object[])i.next();
            KualiDecimal deprAmtDebit = amount = data[0] == null ? new KualiDecimal(0) : (KualiDecimal)data[0];
            columns[0] = "Debit - Depreciation Expense object codes: " + depreExpObjCodes.toString();
            columns[1] = usdFormat.format(amount);
            reportLine.add((String[])columns.clone());
            debits = (KualiDecimal)debits.add((AbstractKualiDecimal)amount);
            LOG.info("DEPRECIATION BATCH - calculating the credit amount for accumulated depreciation object codes.");
            criteria = new Criteria();
            criteria.addIn("financialObjectCode", accumulatedDepreciationObjCodes);
            criteria.addEqualTo("transactionDebitCreditCode", (Object)"C");
            criteria.addIn("documentNumber", documentNumbers);
            q = QueryFactory.newReportQuery(GeneralLedgerPendingEntry.class, (Criteria)criteria);
            q.setAttributes(new String[]{"SUM(transactionLedgerEntryAmount)"});
            i = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)q);
            data = (Object[])i.next();
            amount = data[0] == null ? new KualiDecimal(0) : (KualiDecimal)data[0];
            columns[0] = "Credit - Accumulated depreciation object codes: " + accumulatedDepreciationObjCodes.toString();
            columns[1] = usdFormat.format(amount);
            reportLine.add((String[])columns.clone());
            credits = (KualiDecimal)credits.add((AbstractKualiDecimal)amount);
            LOG.info("DEPRECIATION BATCH - calculating the debit amount for accumulated depreciation object codes.");
            criteria = new Criteria();
            criteria.addIn("financialObjectCode", accumulatedDepreciationObjCodes);
            criteria.addEqualTo("transactionDebitCreditCode", (Object)"D");
            criteria.addIn("documentNumber", documentNumbers);
            q = QueryFactory.newReportQuery(GeneralLedgerPendingEntry.class, (Criteria)criteria);
            q.setAttributes(new String[]{"SUM(transactionLedgerEntryAmount)"});
            i = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)q);
            data = (Object[])i.next();
            amount = data[0] == null ? new KualiDecimal(0) : (KualiDecimal)data[0];
            columns[0] = "Debit - Accumulated depreciation object codes:" + accumulatedDepreciationObjCodes.toString();
            columns[1] = usdFormat.format(amount);
            reportLine.add((String[])columns.clone());
            debits = (KualiDecimal)debits.add((AbstractKualiDecimal)amount);
            LOG.info("DEPRECIATION BATCH - calculating the credit amount for expense object codes.");
            criteria = new Criteria();
            criteria.addIn("financialObjectCode", depreExpObjCodes);
            criteria.addEqualTo("transactionDebitCreditCode", (Object)"C");
            criteria.addIn("documentNumber", documentNumbers);
            q = QueryFactory.newReportQuery(GeneralLedgerPendingEntry.class, (Criteria)criteria);
            q.setAttributes(new String[]{"SUM(transactionLedgerEntryAmount)"});
            i = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)q);
            data = (Object[])i.next();
            KualiDecimal deprAmtCredit = amount = data[0] == null ? new KualiDecimal(0) : (KualiDecimal)data[0];
            columns[0] = "Credit - Depreciation Expense object codes:" + depreExpObjCodes.toString();
            columns[1] = usdFormat.format(amount);
            reportLine.add((String[])columns.clone());
            credits = (KualiDecimal)credits.add((AbstractKualiDecimal)amount);
            columns[0] = "Current Month";
            columns[1] = usdFormat.format(deprAmtDebit.subtract((AbstractKualiDecimal)deprAmtCredit));
            reportLine.add((String[])columns.clone());
            columns[0] = "Total Debits";
            columns[1] = usdFormat.format(debits);
            reportLine.add((String[])columns.clone());
            columns[0] = "Total Credits";
            columns[1] = usdFormat.format(credits);
            reportLine.add((String[])columns.clone());
            columns[0] = "Total Debits - Total Credits";
            columns[1] = usdFormat.format(debits.subtract((AbstractKualiDecimal)credits));
            reportLine.add((String[])columns.clone());
        }
        LOG.info("DEPRECIATION BATCH - Finished generating statistics for report - " + (beforeDepreciationReport ? "Before part." : "After part"));
        return reportLine;
    }

    protected Object getCOAsCount() {
        LOG.debug("getCOAsCount() started");
        LOG.info("DEPRECIATION BATCH - Getting the number of campus plant fund accounts.");
        Criteria criteria = new Criteria();
        ReportQueryByCriteria q = QueryFactory.newReportQuery(Account.class, (Criteria)criteria);
        q.setAttributes(new String[]{"count(organization.campusPlantAccountNumber)"});
        Iterator i = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)q);
        Object[] data = !i.hasNext() ? new Object[]{new BigDecimal(0)} : (Object[])i.next();
        LOG.info("DEPRECIATION BATCH - Finished getting the number of campus plant fund accounts.");
        return data[0];
    }

    protected List<String> getExpenseObjectCodes(Collection<AssetObjectCode> assetObjectCodesCollection) {
        LOG.debug("getExpenseObjectCodes() started");
        LOG.info("DEPRECIATION BATCH - Getting expense object codes");
        ArrayList<String> depreExpObjCodes = new ArrayList<String>();
        for (AssetObjectCode assetObjectCode : assetObjectCodesCollection) {
            String objCode = assetObjectCode.getDepreciationExpenseFinancialObjectCode();
            if (objCode == null || "".equals(objCode) || depreExpObjCodes.contains(objCode)) continue;
            depreExpObjCodes.add(objCode);
        }
        LOG.info("DEPRECIATION BATCH - Finished getting expense object codes which are:" + ((Object)depreExpObjCodes).toString());
        return depreExpObjCodes;
    }

    protected List<String> getAccumulatedDepreciationObjectCodes(Collection<AssetObjectCode> assetObjectCodesCollection) {
        LOG.debug("getAccumulatedDepreciationObjectCodes() started");
        LOG.info("DEPRECIATION BATCH - Getting accum depreciation object codes");
        ArrayList<String> accumulatedDepreciationObjCodes = new ArrayList<String>();
        for (AssetObjectCode assetObjectCode : assetObjectCodesCollection) {
            String objCode = assetObjectCode.getAccumulatedDepreciationFinancialObjectCode();
            if (objCode == null || "".equals(objCode) || accumulatedDepreciationObjCodes.contains(objCode)) continue;
            accumulatedDepreciationObjCodes.add(objCode);
        }
        LOG.info("DEPRECIATION BATCH - Finished getting accum depreciation object codes which are:" + ((Object)accumulatedDepreciationObjCodes).toString());
        return accumulatedDepreciationObjCodes;
    }

    protected Object getAssetObjectCodesCount(Integer fiscalYear) {
        LOG.debug("getAssetObjectCodesCount() started");
        LOG.info("DEPRECIATION BATCH - Getting asset object code count.");
        Criteria criteria = new Criteria();
        criteria.addEqualTo("universityFiscalYear", (Object)fiscalYear);
        ReportQueryByCriteria q = QueryFactory.newReportQuery(AssetObjectCode.class, (Criteria)criteria);
        q.setAttributes(new String[]{"count(objectCode.financialObjectCode)"});
        Iterator i = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)q);
        Object[] data = (Object[])i.next();
        LOG.info("DEPRECIATION BATCH - Finished getting asset object code count which is: " + data[0]);
        LOG.debug("DepreciableAssetsDAoOjb.getAssetObjectCodesCount() -  ended");
        return data[0];
    }

    protected String convertCountValueToString(Object fieldValue) {
        if (fieldValue == null) {
            return "0.0";
        }
        if (fieldValue instanceof BigDecimal) {
            return fieldValue.toString();
        }
        return ((Long)fieldValue).toString();
    }

    public void setDepreciationBatchDao(DepreciationBatchDao depreciationBatchDao) {
        this.depreciationBatchDao = depreciationBatchDao;
    }
}

