/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.util;

import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public final class MaintainableWorkflowUtils {
    private MaintainableWorkflowUtils() {
    }

    public static boolean isDocumentSavedOrEnroute(String documentNumber) {
        boolean isSaveOrEnroute = false;
        WorkflowDocument workflowDocument = MaintainableWorkflowUtils.getWorkflowDocument(documentNumber);
        if (workflowDocument != null) {
            isSaveOrEnroute = workflowDocument.isSaved() || workflowDocument.isEnroute();
        }
        return isSaveOrEnroute;
    }

    private static WorkflowDocument getWorkflowDocument(String documentNumber) {
        WorkflowDocument workflowDocument;
        try {
            String principalId = ObjectUtils.isNull((Object)GlobalVariables.getUserSession()) ? KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName("kfs").getPrincipalId() : GlobalVariables.getUserSession().getPerson().getPrincipalId();
            workflowDocument = WorkflowDocumentFactory.loadDocument((String)principalId, (String)documentNumber);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error to retrieve workflow document: " + documentNumber, ex);
        }
        return workflowDocument;
    }
}

