/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.util.distribution;

import java.util.HashMap;
import java.util.Map;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentAssetDetail;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentDetail;
import org.kuali.kfs.module.cam.document.AssetPaymentDocument;
import org.kuali.kfs.module.cam.util.distribution.AssetDistribution;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class AssetDistributionEvenly
extends AssetDistribution {
    private Map<String, Map<AssetPaymentAssetDetail, KualiDecimal>> distributionResult;

    public AssetDistributionEvenly(AssetPaymentDocument doc) {
        super(doc);
    }

    private void precalculate() {
        this.distributionResult = new HashMap<String, Map<AssetPaymentAssetDetail, KualiDecimal>>();
        int size = this.doc.getAssetPaymentAssetDetail().size();
        KualiDecimal assetDetailSize = new KualiDecimal(size);
        if (assetDetailSize.isNonZero()) {
            for (AssetPaymentDetail sourceLine : this.getAssetPaymentDetailLines()) {
                KualiDecimal total = sourceLine.getAmount();
                KualiDecimal distributionAmount = (KualiDecimal)total.divide((AbstractKualiDecimal)assetDetailSize);
                HashMap<AssetPaymentAssetDetail, KualiDecimal> assetDetailMap = new HashMap<AssetPaymentAssetDetail, KualiDecimal>();
                for (int i = 0; i < size; ++i) {
                    AssetPaymentAssetDetail assetDetail = this.doc.getAssetPaymentAssetDetail().get(i);
                    if (i < size - 1) {
                        assetDetailMap.put(assetDetail, distributionAmount);
                        total = (KualiDecimal)total.subtract((AbstractKualiDecimal)distributionAmount);
                        continue;
                    }
                    assetDetailMap.put(assetDetail, total);
                }
                this.distributionResult.put(sourceLine.getAssetPaymentDetailKey(), assetDetailMap);
            }
        }
    }

    @Override
    public Map<String, Map<AssetPaymentAssetDetail, KualiDecimal>> getAssetPaymentDistributions() {
        this.precalculate();
        return this.distributionResult;
    }
}

