/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2020 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.batch.service.impl;

import net.sf.jasperreports.engine.JRParameter;
import org.kuali.kfs.module.cam.batch.ExtractProcessLog;
import org.kuali.kfs.module.cam.batch.service.BatchExtractReportService;
import org.kuali.kfs.sys.KFSConstants.ReportGeneration;
import org.kuali.kfs.sys.report.ReportInfo;
import org.kuali.kfs.sys.service.ReportGenerationService;
import org.kuali.rice.core.api.datetime.DateTimeService;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class BatchExtractReportServiceImpl implements BatchExtractReportService {

    protected ReportGenerationService reportGenerationService;
    protected ReportInfo cabBatchStatusReportInfo;
    protected ReportInfo cabBatchMismatchReportInfo;

    protected DateTimeService dateTimeService;

    public File generateStatusReportPDF(ExtractProcessLog extractProcessLog) {
        String reportFileName = cabBatchStatusReportInfo.getReportFileName();
        String reportDirectory = cabBatchStatusReportInfo.getReportsDirectory();
        String reportTemplateClassPath = cabBatchStatusReportInfo.getReportTemplateClassPath();
        String reportTemplateName = cabBatchStatusReportInfo.getReportTemplateName();
        ResourceBundle resourceBundle = cabBatchStatusReportInfo.getResourceBundle();
        String subReportTemplateClassPath = cabBatchStatusReportInfo.getSubReportTemplateClassPath();
        Map<String, String> subReports = cabBatchStatusReportInfo.getSubReports();
        Map<String, Object> reportData = new HashMap<>();
        reportData.put(JRParameter.REPORT_RESOURCE_BUNDLE, resourceBundle);
        reportData.put(ReportGeneration.PARAMETER_NAME_SUBREPORT_DIR, subReportTemplateClassPath);
        reportData.put(ReportGeneration.PARAMETER_NAME_SUBREPORT_TEMPLATE_NAME, subReports);
        String template = reportTemplateClassPath + reportTemplateName;
        String fullReportFileName = reportGenerationService.buildFullFileName(dateTimeService.getCurrentDate(),
                reportDirectory, reportFileName, "");
        List<ExtractProcessLog> dataSource = new ArrayList<>();
        dataSource.add(extractProcessLog);
        reportGenerationService.generateReportToPdfFile(reportData, dataSource, template, fullReportFileName);
        return new File(fullReportFileName + ".pdf");
    }

    public File generateMismatchReportPDF(ExtractProcessLog extractProcessLog) {
        String reportFileName = cabBatchMismatchReportInfo.getReportFileName();
        String reportDirectory = cabBatchMismatchReportInfo.getReportsDirectory();
        String reportTemplateClassPath = cabBatchMismatchReportInfo.getReportTemplateClassPath();
        String reportTemplateName = cabBatchMismatchReportInfo.getReportTemplateName();
        ResourceBundle resourceBundle = cabBatchMismatchReportInfo.getResourceBundle();
        String subReportTemplateClassPath = cabBatchMismatchReportInfo.getSubReportTemplateClassPath();
        Map<String, String> subReports = cabBatchMismatchReportInfo.getSubReports();
        Map<String, Object> reportData = new HashMap<>();
        reportData.put(JRParameter.REPORT_RESOURCE_BUNDLE, resourceBundle);
        reportData.put(ReportGeneration.PARAMETER_NAME_SUBREPORT_DIR, subReportTemplateClassPath);
        reportData.put(ReportGeneration.PARAMETER_NAME_SUBREPORT_TEMPLATE_NAME, subReports);
        String template = reportTemplateClassPath + reportTemplateName;
        String fullReportFileName = reportGenerationService.buildFullFileName(dateTimeService.getCurrentDate(),
                reportDirectory, reportFileName, "");
        List<ExtractProcessLog> dataSource = new ArrayList<>();
        dataSource.add(extractProcessLog);
        reportGenerationService.generateReportToPdfFile(reportData, dataSource, template, fullReportFileName);
        return new File(fullReportFileName + ".pdf");
    }

    public ReportGenerationService getReportGenerationService() {
        return reportGenerationService;
    }

    public void setReportGenerationService(ReportGenerationService reportGenerationService) {
        this.reportGenerationService = reportGenerationService;
    }

    public ReportInfo getCabBatchStatusReportInfo() {
        return cabBatchStatusReportInfo;
    }

    public void setCabBatchStatusReportInfo(ReportInfo cabBatchStatusReportInfo) {
        this.cabBatchStatusReportInfo = cabBatchStatusReportInfo;
    }

    public DateTimeService getDateTimeService() {
        return dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public ReportInfo getCabBatchMismatchReportInfo() {
        return cabBatchMismatchReportInfo;
    }

    public void setCabBatchMismatchReportInfo(ReportInfo cabBatchMismatchReportInfo) {
        this.cabBatchMismatchReportInfo = cabBatchMismatchReportInfo;
    }
}
