/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2020 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.businessobject;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.businessobject.ObjectCodeCurrent;
import org.kuali.kfs.coa.businessobject.ProjectCode;
import org.kuali.kfs.coa.businessobject.SubAccount;
import org.kuali.kfs.coa.businessobject.SubObjectCode;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.module.cam.document.service.AssetGlobalService;
import org.kuali.kfs.sys.businessobject.OriginationCode;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.doctype.bo.DocumentTypeEBO;

import java.sql.Date;

public class AssetPayment extends PersistableBusinessObjectBase {

    private Long capitalAssetNumber;
    private Integer paymentSequenceNumber;
    private String chartOfAccountsCode;
    private String accountNumber;
    private String subAccountNumber;
    private String financialObjectCode;
    private String financialSubObjectCode;
    private String financialSystemOriginationCode;
    private String financialDocumentTypeCode;
    private String documentNumber;
    private Integer financialDocumentPostingYear;
    private String financialDocumentPostingPeriodCode;
    private Date financialDocumentPostingDate;
    private String projectCode;
    private String organizationReferenceId;
    private KualiDecimal accountChargeAmount;
    private String purchaseOrderNumber;
    private String requisitionNumber;
    private KualiDecimal primaryDepreciationBaseAmount;
    private KualiDecimal accumulatedPrimaryDepreciationAmount;
    private KualiDecimal previousYearPrimaryDepreciationAmount;
    private KualiDecimal period1Depreciation1Amount;
    private KualiDecimal period2Depreciation1Amount;
    private KualiDecimal period3Depreciation1Amount;
    private KualiDecimal period4Depreciation1Amount;
    private KualiDecimal period5Depreciation1Amount;
    private KualiDecimal period6Depreciation1Amount;
    private KualiDecimal period7Depreciation1Amount;
    private KualiDecimal period8Depreciation1Amount;
    private KualiDecimal period9Depreciation1Amount;
    private KualiDecimal period10Depreciation1Amount;
    private KualiDecimal period11Depreciation1Amount;
    private KualiDecimal period12Depreciation1Amount;
    private Integer accumulatedRoundingErrorInMillicents = 0;
    private String transferPaymentCode;

    private Asset asset;
    private Chart chartOfAccounts;
    private SubAccount subAccount;
    private ObjectCode financialObject;
    private ObjectCodeCurrent objectCodeCurrent;
    private Account account;
    private SubObjectCode financialSubObject;
    private ProjectCode project;
    private AccountingPeriod financialDocumentPostingPeriod;
    private DocumentTypeEBO financialSystemDocumentTypeCode;
    private DocumentHeader documentHeader;
    private OriginationCode financialSystemOrigination;
    private SystemOptions option;

    // Non-persisted attributes:
    private KualiDecimal yearToDate;

    public AssetPayment() {
    }

    /**
     * Constructs an AssetPayment
     *
     * @param assetPayment
     * @param withAmounts indicates whether amount fields should be copied from the assetPayment object
     */
    public AssetPayment(AssetPayment assetPayment, boolean withAmounts) {
        setCapitalAssetNumber(assetPayment.getCapitalAssetNumber());
        setPaymentSequenceNumber(assetPayment.getPaymentSequenceNumber());
        setChartOfAccountsCode(assetPayment.getChartOfAccountsCode());
        setAccountNumber(assetPayment.getAccountNumber());
        setSubAccountNumber(assetPayment.getSubAccountNumber());
        setFinancialObjectCode(assetPayment.getFinancialObjectCode());
        setFinancialSubObjectCode(assetPayment.getFinancialSubObjectCode());
        setFinancialSystemOriginationCode(assetPayment.getFinancialSystemOriginationCode());
        setFinancialDocumentTypeCode(assetPayment.getFinancialDocumentTypeCode());
        setDocumentNumber(assetPayment.getDocumentNumber());
        setFinancialDocumentPostingYear(assetPayment.getFinancialDocumentPostingYear());
        setFinancialDocumentPostingPeriodCode(assetPayment.getFinancialDocumentPostingPeriodCode());
        setFinancialDocumentPostingDate(assetPayment.getFinancialDocumentPostingDate());
        setProjectCode(assetPayment.getProjectCode());
        setOrganizationReferenceId(assetPayment.getOrganizationReferenceId());
        setPurchaseOrderNumber(assetPayment.getPurchaseOrderNumber());
        setRequisitionNumber(assetPayment.getRequisitionNumber());
        setTransferPaymentCode(assetPayment.getTransferPaymentCode());

        if (withAmounts) {
            setAccountChargeAmount(assetPayment.getAccountChargeAmount());
            setPrimaryDepreciationBaseAmount(assetPayment.getPrimaryDepreciationBaseAmount());
            setAccumulatedPrimaryDepreciationAmount(assetPayment.getAccumulatedPrimaryDepreciationAmount());
            setPreviousYearPrimaryDepreciationAmount(assetPayment.getPreviousYearPrimaryDepreciationAmount());
            setPeriod1Depreciation1Amount(assetPayment.getPeriod1Depreciation1Amount());
            setPeriod2Depreciation1Amount(assetPayment.getPeriod2Depreciation1Amount());
            setPeriod3Depreciation1Amount(assetPayment.getPeriod3Depreciation1Amount());
            setPeriod4Depreciation1Amount(assetPayment.getPeriod4Depreciation1Amount());
            setPeriod5Depreciation1Amount(assetPayment.getPeriod5Depreciation1Amount());
            setPeriod6Depreciation1Amount(assetPayment.getPeriod6Depreciation1Amount());
            setPeriod7Depreciation1Amount(assetPayment.getPeriod7Depreciation1Amount());
            setPeriod8Depreciation1Amount(assetPayment.getPeriod8Depreciation1Amount());
            setPeriod9Depreciation1Amount(assetPayment.getPeriod9Depreciation1Amount());
            setPeriod10Depreciation1Amount(assetPayment.getPeriod10Depreciation1Amount());
            setPeriod11Depreciation1Amount(assetPayment.getPeriod11Depreciation1Amount());
            setPeriod12Depreciation1Amount(assetPayment.getPeriod12Depreciation1Amount());
        }
    }

    /**
     * Constructs a AssetPayment for use with Asset Payment
     *
     * @param assetPaymentDetail
     */
    public AssetPayment(AssetPaymentDetail assetPaymentDetail) {
        setChartOfAccountsCode(assetPaymentDetail.getChartOfAccountsCode());
        setAccountNumber(assetPaymentDetail.getAccountNumber());
        setSubAccountNumber(assetPaymentDetail.getSubAccountNumber());
        setFinancialObjectCode(assetPaymentDetail.getFinancialObjectCode());
        setFinancialSubObjectCode(assetPaymentDetail.getFinancialSubObjectCode());
        setFinancialSystemOriginationCode(assetPaymentDetail.getExpenditureFinancialSystemOriginationCode());
        setFinancialDocumentTypeCode(assetPaymentDetail.getExpenditureFinancialDocumentTypeCode());
        setDocumentNumber(assetPaymentDetail.getExpenditureFinancialDocumentNumber());
        setFinancialDocumentPostingYear(assetPaymentDetail.getPostingYear());
        setFinancialDocumentPostingPeriodCode(assetPaymentDetail.getPostingPeriodCode());
        setFinancialDocumentPostingDate(assetPaymentDetail.getExpenditureFinancialDocumentPostedDate());
        setProjectCode(assetPaymentDetail.getProjectCode());
        setOrganizationReferenceId(assetPaymentDetail.getOrganizationReferenceId());
        setPurchaseOrderNumber(assetPaymentDetail.getPurchaseOrderNumber());
        setRequisitionNumber(assetPaymentDetail.getRequisitionNumber());
    }

    /**
     * Constructs a AssetPayment for use with Asset Separate
     *
     * @param assetPaymentDetail
     * @param acquisitionTypeCode
     */
    public AssetPayment(AssetPaymentDetail assetPaymentDetail, String acquisitionTypeCode) {
        this(assetPaymentDetail);

        AssetGlobalService assetGlobalService = SpringContext.getBean(AssetGlobalService.class);
        if (assetGlobalService.getNewAcquisitionTypeCode().equals(acquisitionTypeCode)) {
            setFinancialDocumentPostingDate(assetPaymentDetail.getExpenditureFinancialDocumentPostedDate());
            setFinancialDocumentPostingYear(assetPaymentDetail.getPostingYear());
            setFinancialDocumentPostingPeriodCode(assetPaymentDetail.getPostingPeriodCode());
        } else {
            UniversityDateService universityDateService = SpringContext.getBean(UniversityDateService.class);

            setFinancialDocumentPostingDate(universityDateService.getCurrentUniversityDate().getUniversityDate());
            setFinancialDocumentPostingYear(universityDateService.getCurrentUniversityDate().getUniversityFiscalYear());
            setFinancialDocumentPostingPeriodCode(universityDateService.getCurrentUniversityDate()
                    .getUniversityFiscalAccountingPeriod());
        }
    }

    public Long getCapitalAssetNumber() {
        return capitalAssetNumber;
    }

    public void setCapitalAssetNumber(Long capitalAssetNumber) {
        this.capitalAssetNumber = capitalAssetNumber;
    }

    public Integer getPaymentSequenceNumber() {
        return paymentSequenceNumber;
    }

    public void setPaymentSequenceNumber(Integer paymentSequenceNumber) {
        this.paymentSequenceNumber = paymentSequenceNumber;
    }

    public String getChartOfAccountsCode() {
        return chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getAccountNumber() {
        return accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getSubAccountNumber() {
        return subAccountNumber;
    }

    public void setSubAccountNumber(String subAccountNumber) {
        this.subAccountNumber = subAccountNumber;
    }

    public String getFinancialObjectCode() {
        return financialObjectCode;
    }

    public void setFinancialObjectCode(String financialObjectCode) {
        this.financialObjectCode = financialObjectCode;
    }

    public String getFinancialSubObjectCode() {
        return financialSubObjectCode;
    }

    public void setFinancialSubObjectCode(String financialSubObjectCode) {
        this.financialSubObjectCode = financialSubObjectCode;
    }

    public String getFinancialSystemOriginationCode() {
        return financialSystemOriginationCode;
    }

    public void setFinancialSystemOriginationCode(String financialSystemOriginationCode) {
        this.financialSystemOriginationCode = financialSystemOriginationCode;
    }

    public String getFinancialDocumentTypeCode() {
        return financialDocumentTypeCode;
    }

    public void setFinancialDocumentTypeCode(String financialDocumentTypeCode) {
        this.financialDocumentTypeCode = financialDocumentTypeCode;
    }

    public String getDocumentNumber() {
        return documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public Integer getFinancialDocumentPostingYear() {
        return financialDocumentPostingYear;
    }

    public void setFinancialDocumentPostingYear(Integer financialDocumentPostingYear) {
        this.financialDocumentPostingYear = financialDocumentPostingYear;
    }

    public String getFinancialDocumentPostingPeriodCode() {
        return financialDocumentPostingPeriodCode;
    }

    public void setFinancialDocumentPostingPeriodCode(String financialDocumentPostingPeriodCode) {
        this.financialDocumentPostingPeriodCode = financialDocumentPostingPeriodCode;
    }

    public Date getFinancialDocumentPostingDate() {
        return financialDocumentPostingDate;
    }

    public void setFinancialDocumentPostingDate(Date financialDocumentPostingDate) {
        this.financialDocumentPostingDate = financialDocumentPostingDate;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getOrganizationReferenceId() {
        return organizationReferenceId;
    }

    public void setOrganizationReferenceId(String organizationReferenceId) {
        this.organizationReferenceId = organizationReferenceId;
    }

    public KualiDecimal getAccountChargeAmount() {
        return accountChargeAmount;
    }

    public void setAccountChargeAmount(KualiDecimal accountChargeAmount) {
        this.accountChargeAmount = accountChargeAmount;
    }

    public String getPurchaseOrderNumber() {
        return purchaseOrderNumber;
    }

    public void setPurchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
    }

    public String getRequisitionNumber() {
        return requisitionNumber;
    }

    public void setRequisitionNumber(String requisitionNumber) {
        this.requisitionNumber = requisitionNumber;
    }

    public KualiDecimal getPrimaryDepreciationBaseAmount() {
        return primaryDepreciationBaseAmount;
    }

    public void setPrimaryDepreciationBaseAmount(KualiDecimal primaryDepreciationBaseAmount) {
        this.primaryDepreciationBaseAmount = primaryDepreciationBaseAmount;
    }

    public KualiDecimal getAccumulatedPrimaryDepreciationAmount() {
        return accumulatedPrimaryDepreciationAmount;
    }

    public void setAccumulatedPrimaryDepreciationAmount(KualiDecimal accumulatedPrimaryDepreciationAmount) {
        this.accumulatedPrimaryDepreciationAmount = accumulatedPrimaryDepreciationAmount;
    }

    public KualiDecimal getPreviousYearPrimaryDepreciationAmount() {
        return previousYearPrimaryDepreciationAmount;
    }

    public void setPreviousYearPrimaryDepreciationAmount(KualiDecimal previousYearPrimaryDepreciationAmount) {
        this.previousYearPrimaryDepreciationAmount = previousYearPrimaryDepreciationAmount;
    }

    public KualiDecimal getPeriod1Depreciation1Amount() {
        return period1Depreciation1Amount;
    }

    public void setPeriod1Depreciation1Amount(KualiDecimal period1Depreciation1Amount) {
        this.period1Depreciation1Amount = period1Depreciation1Amount;
    }

    public KualiDecimal getPeriod2Depreciation1Amount() {
        return period2Depreciation1Amount;
    }

    public void setPeriod2Depreciation1Amount(KualiDecimal period2Depreciation1Amount) {
        this.period2Depreciation1Amount = period2Depreciation1Amount;
    }

    public KualiDecimal getPeriod3Depreciation1Amount() {
        return period3Depreciation1Amount;
    }

    public void setPeriod3Depreciation1Amount(KualiDecimal period3Depreciation1Amount) {
        this.period3Depreciation1Amount = period3Depreciation1Amount;
    }

    public KualiDecimal getPeriod4Depreciation1Amount() {
        return period4Depreciation1Amount;
    }

    public void setPeriod4Depreciation1Amount(KualiDecimal period4Depreciation1Amount) {
        this.period4Depreciation1Amount = period4Depreciation1Amount;
    }

    public KualiDecimal getPeriod5Depreciation1Amount() {
        return period5Depreciation1Amount;
    }

    public void setPeriod5Depreciation1Amount(KualiDecimal period5Depreciation1Amount) {
        this.period5Depreciation1Amount = period5Depreciation1Amount;
    }

    public KualiDecimal getPeriod6Depreciation1Amount() {
        return period6Depreciation1Amount;
    }

    public void setPeriod6Depreciation1Amount(KualiDecimal period6Depreciation1Amount) {
        this.period6Depreciation1Amount = period6Depreciation1Amount;
    }

    public KualiDecimal getPeriod7Depreciation1Amount() {
        return period7Depreciation1Amount;
    }

    public void setPeriod7Depreciation1Amount(KualiDecimal period7Depreciation1Amount) {
        this.period7Depreciation1Amount = period7Depreciation1Amount;
    }

    public KualiDecimal getPeriod8Depreciation1Amount() {
        return period8Depreciation1Amount;
    }

    public void setPeriod8Depreciation1Amount(KualiDecimal period8Depreciation1Amount) {
        this.period8Depreciation1Amount = period8Depreciation1Amount;
    }

    public KualiDecimal getPeriod9Depreciation1Amount() {
        return period9Depreciation1Amount;
    }

    public void setPeriod9Depreciation1Amount(KualiDecimal period9Depreciation1Amount) {
        this.period9Depreciation1Amount = period9Depreciation1Amount;
    }

    public KualiDecimal getPeriod10Depreciation1Amount() {
        return period10Depreciation1Amount;
    }

    public void setPeriod10Depreciation1Amount(KualiDecimal period10Depreciation1Amount) {
        this.period10Depreciation1Amount = period10Depreciation1Amount;
    }

    public KualiDecimal getPeriod11Depreciation1Amount() {
        return period11Depreciation1Amount;
    }

    public void setPeriod11Depreciation1Amount(KualiDecimal period11Depreciation1Amount) {
        this.period11Depreciation1Amount = period11Depreciation1Amount;
    }

    public KualiDecimal getPeriod12Depreciation1Amount() {
        return period12Depreciation1Amount;
    }

    public void setPeriod12Depreciation1Amount(KualiDecimal period12Depreciation1Amount) {
        this.period12Depreciation1Amount = period12Depreciation1Amount;
    }

    public Integer getAccumulatedRoundingErrorInMillicents() {
        return accumulatedRoundingErrorInMillicents;
    }

    public void setAccumulatedRoundingErrorInMillicents(Integer accumulatedRoundingErrorInMillicents) {
        this.accumulatedRoundingErrorInMillicents = accumulatedRoundingErrorInMillicents;
    }

    public String getTransferPaymentCode() {
        return transferPaymentCode;
    }

    public void setTransferPaymentCode(String transferPaymentCode) {
        this.transferPaymentCode = transferPaymentCode;
    }

    public Asset getAsset() {
        return asset;
    }

    @Deprecated
    public void setAsset(Asset asset) {
        this.asset = asset;
    }

    public Chart getChartOfAccounts() {
        return chartOfAccounts;
    }

    @Deprecated
    public void setChartOfAccounts(Chart chartOfAccounts) {
        this.chartOfAccounts = chartOfAccounts;
    }

    public SubAccount getSubAccount() {
        return subAccount;
    }

    @Deprecated
    public void setSubAccount(SubAccount subAccount) {
        this.subAccount = subAccount;
    }

    public ObjectCode getFinancialObject() {
        return financialObject;
    }

    @Deprecated
    public void setFinancialObject(ObjectCode financialObject) {
        this.financialObject = financialObject;
    }

    public Account getAccount() {
        return account;
    }

    @Deprecated
    public void setAccount(Account account) {
        this.account = account;
    }

    public SubObjectCode getFinancialSubObject() {
        return financialSubObject;
    }

    @Deprecated
    public void setFinancialSubObject(SubObjectCode financialSubObject) {
        this.financialSubObject = financialSubObject;
    }

    public ProjectCode getProject() {
        return project;
    }

    @Deprecated
    public void setProject(ProjectCode project) {
        this.project = project;
    }

    public DocumentHeader getDocumentHeader() {
        return documentHeader;
    }

    @Deprecated
    public void setDocumentHeader(DocumentHeader documentHeader) {
        this.documentHeader = documentHeader;
    }

    public DocumentTypeEBO getFinancialSystemDocumentTypeCode() {
        if (financialSystemDocumentTypeCode == null || !StringUtils.equals(financialSystemDocumentTypeCode.getName(),
                financialDocumentTypeCode)) {
            financialSystemDocumentTypeCode = null;
            if (StringUtils.isNotBlank(financialDocumentTypeCode)) {
                DocumentType docType = KewApiServiceLocator.getDocumentTypeService()
                        .getDocumentTypeByName(financialDocumentTypeCode);
                if (docType != null) {
                    financialSystemDocumentTypeCode = org.kuali.rice.kew.doctype.bo.DocumentType.from(docType);
                }
            }
        }
        return financialSystemDocumentTypeCode;
    }

    public AccountingPeriod getFinancialDocumentPostingPeriod() {
        return financialDocumentPostingPeriod;
    }

    @Deprecated
    public void setFinancialDocumentPostingPeriod(AccountingPeriod financialDocumentPostingPeriod) {
        this.financialDocumentPostingPeriod = financialDocumentPostingPeriod;
    }

    public OriginationCode getFinancialSystemOrigination() {
        return financialSystemOrigination;
    }

    @Deprecated
    public void setFinancialSystemOrigination(OriginationCode financialSystemOrigination) {
        this.financialSystemOrigination = financialSystemOrigination;
    }

    public SystemOptions getOption() {
        return option;
    }

    @Deprecated
    public void setOption(SystemOptions option) {
        this.option = option;
    }

    public KualiDecimal getYearToDate() {
        KualiDecimal yearToDate = KualiDecimal.ZERO;
        yearToDate = addAmount(yearToDate, getPeriod1Depreciation1Amount());
        yearToDate = addAmount(yearToDate, getPeriod2Depreciation1Amount());
        yearToDate = addAmount(yearToDate, getPeriod3Depreciation1Amount());
        yearToDate = addAmount(yearToDate, getPeriod4Depreciation1Amount());
        yearToDate = addAmount(yearToDate, getPeriod5Depreciation1Amount());
        yearToDate = addAmount(yearToDate, getPeriod6Depreciation1Amount());
        yearToDate = addAmount(yearToDate, getPeriod7Depreciation1Amount());
        yearToDate = addAmount(yearToDate, getPeriod8Depreciation1Amount());
        yearToDate = addAmount(yearToDate, getPeriod9Depreciation1Amount());
        yearToDate = addAmount(yearToDate, getPeriod10Depreciation1Amount());
        yearToDate = addAmount(yearToDate, getPeriod11Depreciation1Amount());
        yearToDate = addAmount(yearToDate, getPeriod12Depreciation1Amount());
        return yearToDate;
    }

    protected KualiDecimal addAmount(KualiDecimal amount, KualiDecimal addend) {
        if (addend != null) {
            return amount.add(addend);
        }
        return amount;
    }

    public void setYearToDate(KualiDecimal yearToDate) {
        this.yearToDate = yearToDate;
    }

    /**
     * @return the most recent fiscal period with depreciation.
     */
    public int getLastDepreciationPeriod() {
        if (nonZero(getPeriod12Depreciation1Amount())) {
            return 12;
        }
        if (nonZero(getPeriod11Depreciation1Amount())) {
            return 11;
        }
        if (nonZero(getPeriod10Depreciation1Amount())) {
            return 10;
        }
        if (nonZero(getPeriod9Depreciation1Amount())) {
            return 9;
        }
        if (nonZero(getPeriod8Depreciation1Amount())) {
            return 8;
        }
        if (nonZero(getPeriod7Depreciation1Amount())) {
            return 7;
        }
        if (nonZero(getPeriod6Depreciation1Amount())) {
            return 6;
        }
        if (nonZero(getPeriod5Depreciation1Amount())) {
            return 5;
        }
        if (nonZero(getPeriod4Depreciation1Amount())) {
            return 4;
        }
        if (nonZero(getPeriod3Depreciation1Amount())) {
            return 3;
        }
        if (nonZero(getPeriod2Depreciation1Amount())) {
            return 2;
        }
        if (nonZero(getPeriod1Depreciation1Amount())) {
            return 1;
        }
        return 0;
    }

    private boolean nonZero(KualiDecimal testAmount) {
        return testAmount != null && !KualiDecimal.ZERO.equals(testAmount);
    }

    public ObjectCodeCurrent getObjectCodeCurrent() {
        return objectCodeCurrent;
    }

    public void setObjectCodeCurrent(ObjectCodeCurrent objectCodeCurrent) {
        this.objectCodeCurrent = objectCodeCurrent;
    }
}
