/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2020 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.businessobject;

import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.core.api.util.type.KualiDecimal;

import java.sql.Date;

public class AssetRepairHistory extends PersistableBusinessObjectBase implements MutableInactivatable {

    private Long capitalAssetNumber;
    private Date incidentDate;
    private String problemDescription;
    private String repairContactName;
    private String repairNoteText;
    private Date estimatedRepairDate;
    private Date repairDate;
    private KualiDecimal repairAmount;
    private String repairSolutionDescription;
    private boolean active;

    private Asset asset;

    public AssetRepairHistory() {

    }

    public Long getCapitalAssetNumber() {
        return capitalAssetNumber;
    }

    public void setCapitalAssetNumber(Long capitalAssetNumber) {
        this.capitalAssetNumber = capitalAssetNumber;
    }

    public Date getIncidentDate() {
        return incidentDate;
    }

    public void setIncidentDate(Date incidentDate) {
        this.incidentDate = incidentDate;
    }

    public String getProblemDescription() {
        return problemDescription;
    }

    public void setProblemDescription(String problemDescription) {
        this.problemDescription = problemDescription;
    }

    public String getRepairContactName() {
        return repairContactName;
    }

    public void setRepairContactName(String repairContactName) {
        this.repairContactName = repairContactName;
    }

    public String getRepairNoteText() {
        return repairNoteText;
    }

    public void setRepairNoteText(String repairNoteText) {
        this.repairNoteText = repairNoteText;
    }

    public Date getEstimatedRepairDate() {
        return estimatedRepairDate;
    }

    public void setEstimatedRepairDate(Date estimatedRepairDate) {
        this.estimatedRepairDate = estimatedRepairDate;
    }

    public Date getRepairDate() {
        return repairDate;
    }

    public void setRepairDate(Date repairDate) {
        this.repairDate = repairDate;
    }

    public KualiDecimal getRepairAmount() {
        return repairAmount;
    }

    public void setRepairAmount(KualiDecimal repairAmount) {
        this.repairAmount = repairAmount;
    }

    public String getRepairSolutionDescription() {
        return repairSolutionDescription;
    }

    public void setRepairSolutionDescription(String repairSolutionDescription) {
        this.repairSolutionDescription = repairSolutionDescription;
    }

    public Asset getAsset() {
        return asset;
    }

    public void setAsset(Asset asset) {
        this.asset = asset;
    }

    @Override
    public boolean isActive() {
        return active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

}
