/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2020 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.businessobject;

import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;

public class AssetRetirementReason extends PersistableBusinessObjectBase implements MutableInactivatable {

    private String retirementReasonCode;
    private String retirementReasonName;
    private boolean active;
    private boolean retirementReasonRestrictionIndicator;

    public AssetRetirementReason() {

    }

    public String getRetirementReasonCode() {
        return retirementReasonCode;
    }

    public void setRetirementReasonCode(String retirementReasonCode) {
        this.retirementReasonCode = retirementReasonCode;
    }

    public String getRetirementReasonName() {
        return retirementReasonName;
    }

    public void setRetirementReasonName(String retirementReasonName) {
        this.retirementReasonName = retirementReasonName;
    }

    public boolean isActive() {
        return active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isRetirementReasonRestrictionIndicator() {
        return retirementReasonRestrictionIndicator;
    }

    public void setRetirementReasonRestrictionIndicator(boolean retirementReasonRestrictionIndicator) {
        this.retirementReasonRestrictionIndicator = retirementReasonRestrictionIndicator;
    }

}
