/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2020 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.service.impl;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.module.cam.dataaccess.PurchasingAccountsPayableReportDao;
import org.kuali.kfs.module.cam.service.PurchasingAccountsPayableReportService;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

@Transactional
public class PurchasingAccountsPayableReportServiceImpl implements PurchasingAccountsPayableReportService {
    private static final Logger LOG = LogManager.getLogger(PurchasingAccountsPayableReportServiceImpl.class);
    protected PurchasingAccountsPayableReportDao purApReportDao;

    /**
     * @see PurchasingAccountsPayableReportService#findGeneralLedgers(Map)
     */
    public Iterator findGeneralLedgers(Map<String, String> fieldValues) {
        LOG.debug("findGeneralLedgers() started");

        return purApReportDao.findGeneralLedgers(fieldValues);
    }

    /**
     * @see PurchasingAccountsPayableReportService#findPurchasingAccountsPayableDocuments(Map)
     */
    public Collection findPurchasingAccountsPayableDocuments(Map<String, String> fieldValues) {
        LOG.debug("findPurchasingAccountsPayableDocuments() started");

        return purApReportDao.findPurchasingAccountsPayableDocuments(fieldValues);
    }

    public PurchasingAccountsPayableReportDao getPurApReportDao() {
        return purApReportDao;
    }

    public void setPurApReportDao(PurchasingAccountsPayableReportDao purchasingAccountsPayableReportDao) {
        this.purApReportDao = purchasingAccountsPayableReportDao;
    }

}
