/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.module.cam.businessobject.PurApAccountLineGroup;
import org.kuali.kfs.module.purap.businessobject.CreditMemoAccountRevision;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestAccountRevision;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLineBase;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.mockito.Mockito;

@Execution(value=ExecutionMode.SAME_THREAD)
public class PurApAccountLineGroupTest {
    @Test
    public void testCombineEntry_PREQ() {
        PurApAccountLineGroup group = this.createAccountLineGroup(new KualiDecimal(100), PaymentRequestAccountRevision.class);
        PurApAccountingLineBase first = this.createEntry(new KualiDecimal(200), PaymentRequestAccountRevision.class);
        Assert.assertEquals((Object)group, (Object)((Object)new PurApAccountLineGroupTestable(first, "1001", null)));
        group.combineEntry(first);
        Assert.assertEquals((Object)new KualiDecimal(300), (Object)group.getAmount());
        PurApAccountingLineBase second = this.createEntry(new KualiDecimal(-100), PaymentRequestAccountRevision.class);
        Assert.assertEquals((Object)group, (Object)((Object)new PurApAccountLineGroupTestable(second, "1001", null)));
        group.combineEntry(second);
        Assert.assertEquals((Object)new KualiDecimal(200), (Object)group.getAmount());
        PurApAccountingLineBase third = this.createEntry(new KualiDecimal(-200), PaymentRequestAccountRevision.class);
        Assert.assertEquals((Object)group, (Object)((Object)new PurApAccountLineGroupTestable(third, "1001", null)));
        group.combineEntry(third);
        Assert.assertEquals((Object)new KualiDecimal(0), (Object)group.getAmount());
        List sourceEntries = group.getSourceEntries();
        Assert.assertEquals((long)4L, (long)sourceEntries.size());
        KualiDecimal totalAmount = KualiDecimal.ZERO;
        for (PurApAccountingLineBase entry : sourceEntries) {
            totalAmount = (KualiDecimal)totalAmount.add((AbstractKualiDecimal)entry.getAmount());
        }
        Assert.assertEquals((Object)group.getAmount(), (Object)totalAmount);
    }

    @Test
    public void testCombineEntry_CM() {
        PurApAccountLineGroup group = this.createAccountLineGroup(new KualiDecimal(100), CreditMemoAccountRevision.class);
        PurApAccountingLineBase first = this.createEntry(new KualiDecimal(200), CreditMemoAccountRevision.class);
        Assert.assertEquals((Object)group, (Object)((Object)new PurApAccountLineGroupTestable(first, "1001", null)));
        group.combineEntry(first);
        Assert.assertEquals((Object)new KualiDecimal(-300), (Object)group.getAmount());
        PurApAccountingLineBase second = this.createEntry(new KualiDecimal(-100), CreditMemoAccountRevision.class);
        Assert.assertEquals((Object)group, (Object)((Object)new PurApAccountLineGroupTestable(second, "1001", null)));
        group.combineEntry(second);
        Assert.assertEquals((Object)new KualiDecimal(-200), (Object)group.getAmount());
        PurApAccountingLineBase third = this.createEntry(new KualiDecimal(-200), CreditMemoAccountRevision.class);
        Assert.assertEquals((Object)group, (Object)((Object)new PurApAccountLineGroupTestable(third, "1001", null)));
        group.combineEntry(third);
        Assert.assertEquals((Object)new KualiDecimal(0), (Object)group.getAmount());
        List sourceEntries = group.getSourceEntries();
        Assert.assertEquals((long)4L, (long)sourceEntries.size());
        KualiDecimal totalAmount = KualiDecimal.ZERO;
        for (PurApAccountingLineBase entry : sourceEntries) {
            totalAmount = (KualiDecimal)totalAmount.add((AbstractKualiDecimal)entry.getAmount());
        }
        Assert.assertEquals((Object)group.getAmount(), (Object)totalAmount);
    }

    private PurApAccountLineGroup createAccountLineGroup(KualiDecimal amount, Class<? extends PurApAccountingLineBase> clazz) {
        PurApAccountingLineBase entry = this.createEntry(amount, clazz);
        return new PurApAccountLineGroupTestable(entry, "1001", null);
    }

    private PurApAccountingLineBase createEntry(KualiDecimal amount, Class<? extends PurApAccountingLineBase> clazz) {
        PurApAccountingLineBase entryMock = (PurApAccountingLineBase)Mockito.mock(clazz);
        Mockito.when((Object)entryMock.getPostingYear()).thenReturn((Object)2008);
        Mockito.when((Object)entryMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)entryMock.getAccountNumber()).thenReturn((Object)"BL002323");
        Mockito.when((Object)entryMock.getSubAccountNumber()).thenReturn((Object)"--");
        Mockito.when((Object)entryMock.getFinancialObjectCode()).thenReturn((Object)"7000");
        Mockito.when((Object)entryMock.getFinancialSubObjectCode()).thenReturn(null);
        Mockito.when((Object)entryMock.getPostingPeriodCode()).thenReturn((Object)"01");
        Mockito.when((Object)entryMock.getDocumentNumber()).thenReturn((Object)"1001");
        Mockito.when((Object)entryMock.getAmount()).thenReturn((Object)amount);
        return entryMock;
    }

    public static class PurApAccountLineGroupTestable
    extends PurApAccountLineGroup {
        public PurApAccountLineGroupTestable(PurApAccountingLineBase entry, String docNum, String refDocNum) {
            this.setDocumentNumber(docNum);
            this.setReferenceFinancialDocumentNumber(refDocNum);
            this.setUniversityFiscalYear(entry.getPostingYear());
            this.setUniversityFiscalPeriodCode(entry.getPostingPeriodCode());
            this.setChartOfAccountsCode(entry.getChartOfAccountsCode());
            this.setAccountNumber(entry.getAccountNumber());
            this.setSubAccountNumber(entry.getSubAccountNumber());
            this.setFinancialObjectCode(entry.getFinancialObjectCode());
            this.setFinancialSubObjectCode(entry.getFinancialSubObjectCode());
            this.getSourceEntries().add(entry);
            if (CreditMemoAccountRevision.class.isAssignableFrom(entry.getClass())) {
                this.setAmount((KualiDecimal)entry.getAmount().negated());
            } else {
                this.setAmount(entry.getAmount());
            }
        }
    }
}

