/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.batch.service;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.kuali.kfs.coreservice.api.parameter.Parameter;
import org.kuali.kfs.coreservice.api.parameter.ParameterContract;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.purap.CapitalAssetSystem;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.document.service.impl.PurApInfoServiceImpl;
import org.kuali.kfs.module.cam.fixture.CreditMemoAccountFixture;
import org.kuali.kfs.module.cam.fixture.CreditMemoAccountRevisionFixture;
import org.kuali.kfs.module.cam.fixture.CreditMemoDocumentFixture;
import org.kuali.kfs.module.cam.fixture.CreditMemoItemFixture;
import org.kuali.kfs.module.cam.fixture.EntryFixture;
import org.kuali.kfs.module.cam.fixture.FinancialSystemDocumentHeaderFixture;
import org.kuali.kfs.module.cam.fixture.PaymentRequestAccountFixture;
import org.kuali.kfs.module.cam.fixture.PaymentRequestAccountRevisionFixture;
import org.kuali.kfs.module.cam.fixture.PaymentRequestDocumentFixture;
import org.kuali.kfs.module.cam.fixture.PaymentRequestItemFixture;
import org.kuali.kfs.module.cam.fixture.PurchaseOrderAccountFixture;
import org.kuali.kfs.module.cam.fixture.PurchaseOrderCapitalAssetItemFixture;
import org.kuali.kfs.module.cam.fixture.PurchaseOrderCapitalAssetLocationFixture;
import org.kuali.kfs.module.cam.fixture.PurchaseOrderCapitalAssetSystemFixture;
import org.kuali.kfs.module.cam.fixture.PurchaseOrderDocumentFixture;
import org.kuali.kfs.module.cam.fixture.PurchaseOrderItemFixture;
import org.kuali.kfs.module.cam.fixture.RequisitionAccountFixture;
import org.kuali.kfs.module.cam.fixture.RequisitionDocumentFixture;
import org.kuali.kfs.module.cam.fixture.RequisitionItemFixture;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocument;
import org.kuali.kfs.sys.document.service.FinancialSystemDocumentService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteria;

public abstract class BatchIntegTestBase
extends KualiIntegTestBase {
    protected DateTimeService dateTimeService;

    protected void setUp() throws Exception {
        super.setUp();
        this.dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
        this.updateLastExtractTime();
        this.prepareTestDataRecords();
    }

    protected void updateLastExtractTime() {
        this.updateLastCabExtractTime();
        this.updateLastPreTagExtractTime();
    }

    protected void updateLastCabExtractTime() {
        Parameter lastExtractTime = this.findCabExtractTimeParam();
        if (ObjectUtils.isNotNull((Object)lastExtractTime)) {
            SimpleDateFormat fmt = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss", Locale.US);
            Parameter.Builder updatedParm = Parameter.Builder.create((ParameterContract)lastExtractTime);
            updatedParm.setValue(fmt.format(DateUtils.addDays((Date)this.dateTimeService.getCurrentDate(), (int)-1)));
            ((ParameterService)SpringContext.getBean(ParameterService.class)).updateParameter(updatedParm.build());
        } else {
            BatchIntegTestBase.fail((String)"Could not find the parameter LAST_EXTRACT_TIME");
        }
    }

    protected Parameter findCabExtractTimeParam() {
        return ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameter("KFS-CAM", "Batch", "LAST_EXTRACT_TIME");
    }

    protected void updateLastPreTagExtractTime() {
        Parameter lastExtractTime = this.findPretagExtractDateParam();
        if (lastExtractTime != null) {
            SimpleDateFormat fmt = new SimpleDateFormat("MM/dd/yyyy", Locale.US);
            Parameter.Builder updatedParm = Parameter.Builder.create((ParameterContract)lastExtractTime);
            updatedParm.setValue(fmt.format(DateUtils.addDays((Date)this.dateTimeService.getCurrentDate(), (int)-1)));
            ((ParameterService)SpringContext.getBean(ParameterService.class)).updateParameter(updatedParm.build());
        } else {
            BatchIntegTestBase.fail((String)"Could not find the parameter LAST_EXTRACT_TIME");
        }
    }

    protected Parameter findPretagExtractDateParam() {
        return ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameter("KFS-CAM", "PreAssetTaggingStep", "LAST_EXTRACT_DATE");
    }

    protected void prepareTestDataRecords() {
        FinancialSystemDocumentHeaderFixture.setUpData();
        RequisitionDocumentFixture.setUpData();
        RequisitionItemFixture.setUpData();
        RequisitionAccountFixture.setUpData();
        PurchaseOrderDocumentFixture.setUpData();
        PurchaseOrderItemFixture.setUpData();
        PurchaseOrderAccountFixture.setUpData();
        PurchaseOrderCapitalAssetSystemFixture.setUpData();
        PurchaseOrderCapitalAssetItemFixture.setUpData();
        PurchaseOrderCapitalAssetLocationFixture.setUpData();
        PaymentRequestDocumentFixture.setUpData();
        PaymentRequestItemFixture.setUpData();
        PaymentRequestAccountFixture.setUpData();
        PaymentRequestAccountRevisionFixture.setUpData();
        CreditMemoDocumentFixture.setUpData();
        CreditMemoItemFixture.setUpData();
        CreditMemoAccountFixture.setUpData();
        CreditMemoAccountRevisionFixture.setUpData();
        EntryFixture.setUpData();
    }

    protected class BatchTestBasePurApInfoService
    extends PurApInfoServiceImpl {
        protected BatchTestBasePurApInfoService() {
        }

        protected CapitalAssetSystem getCapitalAssetSystemForIndividual(Integer poId, PurApItem purApItem) {
            if (purApItem.getItemIdentifier() == 211) {
                return PurchaseOrderCapitalAssetSystemFixture.REC1.newRecord();
            }
            if (purApItem.getItemIdentifier() == 212) {
                return PurchaseOrderCapitalAssetSystemFixture.REC2.newRecord();
            }
            if (purApItem.getItemIdentifier() == 221) {
                return PurchaseOrderCapitalAssetSystemFixture.REC3.newRecord();
            }
            if (purApItem.getItemIdentifier() == 222) {
                return PurchaseOrderCapitalAssetSystemFixture.REC4.newRecord();
            }
            return null;
        }
    }

    protected class BatchTestBaseFinancialSystemDocumentService
    implements FinancialSystemDocumentService {
        protected BatchTestBaseFinancialSystemDocumentService() {
        }

        public <T extends Document> Collection<T> findByDocumentHeaderStatusCode(Class<T> clazz, String statusCode) {
            return null;
        }

        public <T extends Document> Collection<T> findByWorkflowStatusCode(Class<T> clazz, DocumentStatus docStatus) {
            return null;
        }

        public Collection<FinancialSystemDocumentHeader> findByWorkflowStatusCode(DocumentStatus docStatus) {
            return null;
        }

        public <T extends Document> Collection<T> findByApplicationDocumentStatus(Class<T> clazz, String applicationDocumentStatus) {
            if (clazz == PurchaseOrderDocument.class && StringUtils.equals((CharSequence)applicationDocumentStatus, (CharSequence)"Open")) {
                ArrayList<PurchaseOrderDocument> purchaseOrderDocuments = new ArrayList<PurchaseOrderDocument>();
                purchaseOrderDocuments.add(PurchaseOrderDocumentFixture.REC1.newRecord());
                purchaseOrderDocuments.add(PurchaseOrderDocumentFixture.REC2.newRecord());
                purchaseOrderDocuments.add(PurchaseOrderDocumentFixture.REC3.newRecord());
                return purchaseOrderDocuments;
            }
            return null;
        }

        public Collection<FinancialSystemDocumentHeader> findByApplicationDocumentStatus(String applicationDocumentStatus) {
            return null;
        }

        public void prepareToCopy(FinancialSystemDocumentHeader oldDocumentHeader, FinancialSystemTransactionalDocument document) {
        }

        public FinancialSystemDocumentHeader findByDocumentNumber(String documentNumber) {
            return null;
        }

        public Set<String> getPendingDocumentStatuses() {
            return null;
        }

        public Set<String> getSuccessfulDocumentStatuses() {
            return null;
        }

        public Set<String> getUnsuccessfulDocumentStatuses() {
            return null;
        }

        public DocumentHeader getCorrectingDocumentHeader(String documentId) {
            return null;
        }

        public int getFetchMoreIterationLimit() {
            return 0;
        }

        public int getMaxResultCap(DocumentSearchCriteria criteria) {
            return 0;
        }

        public Collection<FinancialSystemDocumentHeader> findDocumentsByArguments(DocumentStatus docStatus, List<String> excludeWorkflowDocumentTypeNames, Timestamp lessOrEqualCreateDate) {
            return null;
        }
    }
}

