/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.runner.RunWith;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.service.DocumentHeaderService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.module.cam.batch.AssetDepreciationStep;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.document.AssetPaymentDocument;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.context.SpringContext;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.reflect.Whitebox;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={SpringContext.class, KRADServiceLocatorWeb.class})
@PowerMockIgnore(value={"javax.management.*"})
@Execution(value=ExecutionMode.SAME_THREAD)
public class AssetPaymentDocumentTest {
    public static final String ACCOUNT_NUMBER = "898989";
    public static final String ORG_OWNER_ACCOUNT_NUMBER = "696969";
    public static final String ORG_PLANT_ACCOUNT_NUMBER = "797979";
    public static final String CAMPS_PLANT_ACCOUNT_NUMBER = "494949";
    public static final String COA_CD = "BL";
    public static final String OBJECT_SUB_TYPE_1 = "CM";
    public static final String OBJECT_SUB_TYPE_2 = "BD";
    @Mock
    ParameterService parameterService;
    @Mock
    AssetPayment assetPayment;
    @Mock
    Asset asset;
    @Mock
    Account account;
    @Mock
    Account orgOwnerAccount;
    @Mock
    Organization organization;
    AssetPaymentDocument assetPaymentDocument;
    GeneralLedgerPendingEntry entry;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.setupMockObjects();
        this.setupServices();
        PowerMockito.mockStatic(KRADServiceLocatorWeb.class, (Class[])new Class[0]);
        DocumentHeaderService docHeaderSvcMock = (DocumentHeaderService)Mockito.mock(DocumentHeaderService.class);
        Mockito.when((Object)KRADServiceLocatorWeb.getDocumentHeaderService()).thenReturn((Object)docHeaderSvcMock);
        Class<FinancialSystemDocumentHeader> clazz = FinancialSystemDocumentHeader.class;
        Mockito.when((Object)docHeaderSvcMock.getDocumentHeaderBaseClass()).thenReturn(clazz);
        this.assetPaymentDocument = new AssetPaymentDocument();
        PowerMockito.mockStatic(SpringContext.class, (Class[])new Class[0]);
        Mockito.when((Object)((ParameterService)SpringContext.getBean(ParameterService.class))).thenReturn((Object)this.parameterService);
        Whitebox.setInternalState((Object)this.assetPaymentDocument, (String)"apipAssetPaymentHelper", (Object)this.assetPayment);
        this.entry = new GeneralLedgerPendingEntry();
    }

    private void setupMockObjects() {
        Mockito.when((Object)this.organization.getOrganizationPlantAccountNumber()).thenReturn((Object)ORG_PLANT_ACCOUNT_NUMBER);
        Mockito.when((Object)this.organization.getCampusPlantAccountNumber()).thenReturn((Object)CAMPS_PLANT_ACCOUNT_NUMBER);
        Mockito.when((Object)this.organization.getOrganizationPlantChartCode()).thenReturn((Object)COA_CD);
        Mockito.when((Object)this.organization.getCampusPlantChartCode()).thenReturn((Object)COA_CD);
        Mockito.when((Object)this.account.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        Mockito.when((Object)this.account.getOrganization()).thenReturn((Object)this.organization);
        Mockito.when((Object)this.orgOwnerAccount.getAccountNumber()).thenReturn((Object)ORG_OWNER_ACCOUNT_NUMBER);
        Mockito.when((Object)this.assetPayment.getAccount()).thenReturn((Object)this.account);
        Mockito.when((Object)this.assetPayment.getAsset()).thenReturn((Object)this.asset);
        Mockito.when((Object)this.asset.getOrganizationOwnerAccount()).thenReturn((Object)this.orgOwnerAccount);
        Mockito.when((Object)this.assetPayment.getAsset()).thenReturn((Object)this.asset);
    }

    private void setupServices() {
        Mockito.when((Object)this.parameterService.parameterExists(AssetDepreciationStep.class, "DEPRECIATION_ORGANIZATION_PLANT_FUND_OBJECT_SUB_TYPE")).thenReturn((Object)true);
        Mockito.when((Object)this.parameterService.parameterExists(AssetDepreciationStep.class, "DEPRECIATION_CAMPUS_PLANT_FUND_OBJECT_SUB_TYPE")).thenReturn((Object)true);
        Mockito.when((Object)this.parameterService.getParameterValuesAsString(AssetDepreciationStep.class, "DEPRECIATION_ORGANIZATION_PLANT_FUND_OBJECT_SUB_TYPE")).thenReturn(Arrays.asList("C1;C2;CF;CM;ES;NA;UC;UF".split(";")));
        Mockito.when((Object)this.parameterService.getParameterValuesAsString(AssetDepreciationStep.class, "DEPRECIATION_CAMPUS_PLANT_FUND_OBJECT_SUB_TYPE")).thenReturn(Arrays.asList("BD;BF;BI;BR;BX;IF;LE;LF;LI;LR;IA;IC;IO".split(";")));
    }

    @Test
    public void determinePlantFund() {
        this.assetPaymentDocument.determinePlantFund(OBJECT_SUB_TYPE_1, this.entry);
        Assert.assertEquals((String)"The account number should be 797979 depending on the sub type CM.", (Object)ORG_PLANT_ACCOUNT_NUMBER, (Object)this.entry.getAccountNumber());
        this.assetPaymentDocument.determinePlantFund(OBJECT_SUB_TYPE_2, this.entry);
        Assert.assertEquals((String)"The account number should be 494949 depending on the sub type BD.", (Object)CAMPS_PLANT_ACCOUNT_NUMBER, (Object)this.entry.getAccountNumber());
    }
}

