/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.cam.CapitalAssetManagementModuleService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.RequisitionItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.service.impl.RequisitionServiceImpl;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.service.PostalCodeValidationService;
import org.kuali.kfs.vnd.businessobject.VendorDetail;
import org.kuali.kfs.vnd.document.service.VendorService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class CapitalAssetInvalidAPOTest {
    private RequisitionServiceImpl cut;
    @Mock
    private CapitalAssetManagementModuleService capitalAssetManagementModuleSvcMock;
    @Mock
    private DocumentService documentSvcMock;
    @Mock
    private ParameterService parameterSvcMock;
    @Mock
    private PostalCodeValidationService postalCodeValidationSvcMock;
    @Mock
    private PurapService purapSvcMock;
    @Mock
    private VendorService vendorSvcMock;
    @Mock
    private PurApAccountingLine capitalAccountingLine;
    @Mock
    private PurApAccountingLine nonCapitalAccountingLine;
    @Mock
    private RequisitionDocument requisitionDocMock;
    @Mock
    private RequisitionItem itemMock;

    @BeforeEach
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.setupRequisitionDocumentMock();
        this.setupItemMock();
        this.setupLineMock(this.capitalAccountingLine, this.itemMock, "7001");
        this.setupLineMock(this.nonCapitalAccountingLine, this.itemMock, "5000");
        Mockito.when((Object)this.parameterSvcMock.getParameterValueAsString(PurchaseOrderDocument.class, "ITEMS_REQUIRE_COMMODITY_CODE_IND")).thenReturn((Object)"N");
        Mockito.when((Object)this.postalCodeValidationSvcMock.validateAddress("US", "NY", "14886", "", "")).thenReturn((Object)true);
        Mockito.when((Object)this.purapSvcMock.getApoLimit(Integer.valueOf(0), "UA", "PUR")).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)this.vendorSvcMock.getVendorDetail(Integer.valueOf(1002), Integer.valueOf(0))).thenReturn((Object)new VendorDetail());
        this.cut = new RequisitionServiceImpl();
        this.cut.setCapitalAssetManagementModuleService(this.capitalAssetManagementModuleSvcMock);
        this.cut.setDocumentService(this.documentSvcMock);
        this.cut.setParameterService(this.parameterSvcMock);
        this.cut.setPostalCodeValidationService(this.postalCodeValidationSvcMock);
        this.cut.setPurapService(this.purapSvcMock);
        this.cut.setVendorService(this.vendorSvcMock);
    }

    private void setupRequisitionDocumentMock() {
        Mockito.when((Object)this.requisitionDocMock.getVendorHeaderGeneratedIdentifier()).thenReturn((Object)1002);
        Mockito.when((Object)this.requisitionDocMock.getVendorDetailAssignedIdentifier()).thenReturn((Object)0);
        Mockito.when((Object)this.requisitionDocMock.getVendorName()).thenReturn((Object)"ABC Cleaning Services");
        Mockito.when((Object)this.requisitionDocMock.getVendorLine1Address()).thenReturn((Object)"123456 BROAD ST");
        Mockito.when((Object)this.requisitionDocMock.getVendorCityName()).thenReturn((Object)"TRUMANSBURG");
        Mockito.when((Object)this.requisitionDocMock.getVendorStateCode()).thenReturn((Object)"NY");
        Mockito.when((Object)this.requisitionDocMock.getVendorPostalCode()).thenReturn((Object)"14886");
        Mockito.when((Object)this.requisitionDocMock.getVendorCountryCode()).thenReturn((Object)"US");
        Mockito.when((Object)this.requisitionDocMock.getChartOfAccountsCode()).thenReturn((Object)"UA");
        Mockito.when((Object)this.requisitionDocMock.getOrganizationCode()).thenReturn((Object)"PUR");
        Mockito.when((Object)this.requisitionDocMock.getItems()).thenReturn(Collections.singletonList(this.itemMock));
        Mockito.when((Object)this.requisitionDocMock.getAccountDistributionMethod()).thenReturn((Object)"S");
        Mockito.when((Object)this.requisitionDocMock.getTotalDollarAmount()).thenReturn((Object)new KualiDecimal(995.0));
    }

    private void setupItemMock() {
        Mockito.when((Object)this.itemMock.getItemUnitPrice()).thenReturn((Object)new BigDecimal(1.99));
        Mockito.when((Object)this.itemMock.getItemTypeCode()).thenReturn((Object)"ITEM");
        ItemType itemType = new ItemType();
        itemType.setItemTypeCode("ITEM");
        Mockito.when((Object)this.itemMock.getItemType()).thenReturn((Object)itemType);
        Mockito.when((Object)this.itemMock.getExtendedPrice()).thenReturn((Object)new KualiDecimal(995.0));
        Mockito.when((Object)this.itemMock.getItemQuantity()).thenReturn((Object)new KualiDecimal(500));
        ArrayList<PurApAccountingLine> accountingLineMocks = new ArrayList<PurApAccountingLine>();
        accountingLineMocks.add(this.capitalAccountingLine);
        accountingLineMocks.add(this.nonCapitalAccountingLine);
        Mockito.when((Object)this.itemMock.getSourceAccountingLines()).thenReturn(accountingLineMocks);
    }

    private void setupLineMock(PurApAccountingLine lineMock, RequisitionItem itemMock, String objectCode) {
        Mockito.when((Object)lineMock.getAccountLinePercent()).thenReturn((Object)new BigDecimal("50"));
        Mockito.when((Object)lineMock.getFinancialObjectCode()).thenReturn((Object)objectCode);
        Mockito.when((Object)lineMock.getPurapItem()).thenReturn((Object)itemMock);
        KualiDecimal amount = new KualiDecimal(itemMock.getItemUnitPrice().multiply(itemMock.getItemQuantity().bigDecimalValue()).divide(new BigDecimal(2), RoundingMode.HALF_UP));
        Mockito.when((Object)lineMock.getAmount()).thenReturn((Object)amount);
    }

    @Test
    public void isAutomaticPurchaseOrderAllowed_APO_Allowed() {
        Assertions.assertTrue((boolean)this.cut.isAutomaticPurchaseOrderAllowed(this.requisitionDocMock));
        ((DocumentService)Mockito.verify((Object)this.documentSvcMock, (VerificationMode)Mockito.never())).createNoteFromDocument((Document)ArgumentMatchers.eq((Object)this.requisitionDocMock), ArgumentMatchers.anyString());
    }

    @Test
    public void isAutomaticPurchaseOrderAllowed_ContainsCapitalAssetObjectLevel_APO_NotAllowed() {
        Mockito.when((Object)this.capitalAssetManagementModuleSvcMock.doesAccountingLineFailAutomaticPurchaseOrderRules((AccountingLine)this.capitalAccountingLine)).thenReturn((Object)true);
        Assertions.assertFalse((boolean)this.cut.isAutomaticPurchaseOrderAllowed(this.requisitionDocMock));
        ((DocumentService)Mockito.verify((Object)this.documentSvcMock)).createNoteFromDocument((Document)this.requisitionDocMock, "ORDER ROUTED TO PURCHASING FOR PROCESSING: Requisition contains accounting line with capital object level");
    }

    @Test
    public void isAutomaticPurchaseOrderAllowed_ContainsCapitalAssetItem_APO_NotAllowed() {
        Mockito.when((Object)this.capitalAssetManagementModuleSvcMock.doesDocumentFailAutomaticPurchaseOrderRules((AccountingDocument)this.requisitionDocMock)).thenReturn((Object)true);
        Assertions.assertFalse((boolean)this.cut.isAutomaticPurchaseOrderAllowed(this.requisitionDocMock));
        ((DocumentService)Mockito.verify((Object)this.documentSvcMock)).createNoteFromDocument((Document)this.requisitionDocMock, "ORDER ROUTED TO PURCHASING FOR PROCESSING: Requisition contains capital asset items.");
    }
}

