/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.dataaccess.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.document.dataaccess.AssetDepreciationUtilDao;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.util.TransactionalServiceUtils;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class AssetDepreciationUtilDaoOjb
extends PlatformAwareDaoBaseOjb
implements AssetDepreciationUtilDao {
    @Override
    public String getMaxDocumentNumber() {
        Object[] data;
        ReportQueryByCriteria query = QueryFactory.newReportQuery(FinancialSystemDocumentHeader.class, (Criteria)new Criteria());
        query.setAttributes(new String[]{"max(documentNumber)"});
        Iterator iterator = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        String maxDocumentNumber = "";
        if (iterator.hasNext() && (data = (Object[])TransactionalServiceUtils.retrieveFirstAndExhaustIterator((Iterator)iterator))[0] != null) {
            maxDocumentNumber = (String)data[0];
        }
        return maxDocumentNumber;
    }

    @Override
    public Collection<AssetPayment> getAssetPayments(List<Asset> assets) {
        ArrayList<Long> capitalAssetNumbers = new ArrayList<Long>();
        for (Asset asset : assets) {
            capitalAssetNumbers.add(asset.getCapitalAssetNumber());
        }
        Criteria criteria = new Criteria();
        criteria.addIn("capitalAssetNumber", capitalAssetNumbers);
        QueryByCriteria q = QueryFactory.newQuery(AssetPayment.class, (Criteria)criteria);
        q.addOrderByAscending("capitalAssetNumber");
        q.addOrderByAscending("paymentSequenceNumber");
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)q);
    }

    @Override
    public void deleteAssetPayment(List<Asset> assets) {
        Criteria criteria = new Criteria();
        QueryByCriteria q = QueryFactory.newQuery(AssetPayment.class, (Criteria)criteria);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)q);
    }

    @Override
    public void deleteAssets(List<Asset> assets) {
        ArrayList<Long> capitalAssetNumbers = new ArrayList<Long>();
        for (Asset asset : assets) {
            capitalAssetNumbers.add(asset.getCapitalAssetNumber());
        }
        Criteria criteria = new Criteria();
        criteria.addIn("capitalAssetNumber", capitalAssetNumbers);
        QueryByCriteria q = QueryFactory.newQuery(Asset.class, (Criteria)criteria);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)q);
    }

    @Override
    public void deleteGLPEs() {
        QueryByCriteria q = QueryFactory.newQuery(GeneralLedgerPendingEntry.class, (Criteria)new Criteria());
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)q);
    }
}

