/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.fixture;

import java.io.IOException;
import java.util.Properties;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.sys.TestDataPreparator;

public enum PaymentSummaryFixture {
    ASSET(1),
    PAYMENT1(1),
    PAYMENT2(2),
    PAYMENT3(3),
    PAYMENT4(4);

    private int testDataPos;
    private static Properties properties;

    private PaymentSummaryFixture(int dataPos) {
        this.testDataPos = dataPos;
    }

    public Asset newAsset() {
        String propertyKey = "asset.testData" + this.testDataPos;
        String deliminator = properties.getProperty("deliminator");
        String fieldNames = properties.getProperty("asset.fieldNames");
        return (Asset)TestDataPreparator.buildTestDataObject(Asset.class, (Properties)properties, (String)propertyKey, (String)fieldNames, (String)deliminator);
    }

    public AssetPayment newAssetPayment() {
        String propertyKey = "assetPayment.testData" + this.testDataPos;
        String deliminator = properties.getProperty("deliminator");
        String fieldNames = properties.getProperty("assetPayment.fieldNames");
        AssetPayment assetPayment = (AssetPayment)TestDataPreparator.buildTestDataObject(AssetPayment.class, (Properties)properties, (String)propertyKey, (String)fieldNames, (String)deliminator);
        assetPayment.setChartOfAccountsCode("BL");
        assetPayment.setFinancialObjectCode("7305");
        return assetPayment;
    }

    static {
        String propertiesFileName = "org/kuali/kfs/module/cam/document/service/payment_summary_service.properties";
        properties = new Properties();
        try {
            properties.load(PaymentSummaryFixture.class.getClassLoader().getResourceAsStream(propertiesFileName));
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }
}

