/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.batch.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.gl.businessobject.Entry;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.cam.batch.service.ReconciliationService;
import org.kuali.kfs.module.cam.businessobject.AccountLineGroup;
import org.kuali.kfs.module.cam.businessobject.GlAccountLineGroup;
import org.kuali.kfs.module.cam.businessobject.PurApAccountLineGroup;
import org.kuali.kfs.module.cam.dataaccess.ReconciliationDao;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLineBase;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ReconciliationServiceImpl
implements ReconciliationService {
    private static final Logger LOG = LogManager.getLogger(ReconciliationServiceImpl.class);
    protected BusinessObjectService businessObjectService;
    protected ReconciliationDao reconciliationDao;
    protected List<Entry> ignoredEntries = new ArrayList<Entry>();
    protected List<Entry> duplicateEntries = new ArrayList<Entry>();
    protected Collection<GlAccountLineGroup> matchedGroups = new HashSet<GlAccountLineGroup>();
    protected Collection<GlAccountLineGroup> misMatchedGroups = new HashSet<GlAccountLineGroup>();
    protected HashMap<GlAccountLineGroup, GlAccountLineGroup> glEntryGroupMap = new HashMap();
    protected HashMap<PurApAccountLineGroup, PurApAccountLineGroup> purapAcctGroupMap = new HashMap();

    @Override
    public void reconcile(Collection<Entry> glEntries, Collection<PurApAccountingLineBase> purapAcctEntries) {
        LOG.debug("Reconcile started");
        this.groupGLEntries(glEntries);
        this.groupPurapAccountEntries(purapAcctEntries);
        this.reconcileGroups(this.glEntryGroupMap.values());
        if (!this.misMatchedGroups.isEmpty()) {
            LOG.info("Checking for continuation account");
            this.checkGroupByContinuationAccount();
            this.reconcileGroups(this.misMatchedGroups);
        }
        LOG.debug("Reconcile finished");
    }

    protected void checkGroupByContinuationAccount() {
        ArrayList<PurApAccountLineGroup> purapGroups = new ArrayList<PurApAccountLineGroup>(this.purapAcctGroupMap.keySet());
        for (PurApAccountLineGroup purapAcctLineGroup : purapGroups) {
            if (this.matchedGroups.contains(purapAcctLineGroup)) continue;
            Account account = this.findAccount(purapAcctLineGroup);
            String continuationAcctNum = account.getContinuationAccountNumber();
            if (!account.isExpired() || continuationAcctNum == null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Continuation account found for " + account.getAccountNumber() + " is " + account.getContinuationAccountNumber());
            }
            this.purapAcctGroupMap.remove(purapAcctLineGroup);
            purapAcctLineGroup.setAccountNumber(continuationAcctNum);
            this.purapAcctGroupMap.put(purapAcctLineGroup, purapAcctLineGroup);
        }
    }

    protected Account findAccount(AccountLineGroup acctLineGroup) {
        HashMap<String, String> keys = new HashMap<String, String>();
        keys.put("chartOfAccountsCode", acctLineGroup.getChartOfAccountsCode());
        keys.put("accountNumber", acctLineGroup.getAccountNumber());
        return (Account)this.businessObjectService.findByPrimaryKey(Account.class, keys);
    }

    protected void reconcileGroups(Collection<GlAccountLineGroup> glKeySet) {
        for (GlAccountLineGroup glAccountLineGroup : glKeySet) {
            PurApAccountLineGroup purapAccountLineGroup = this.purapAcctGroupMap.get(glAccountLineGroup);
            KualiDecimal glAmt = this.glEntryGroupMap.get(glAccountLineGroup).getAmount();
            if (purapAccountLineGroup == null || !glAmt.equals((Object)purapAccountLineGroup.getAmount())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("GL account line " + glAccountLineGroup.toString() + " did not find a matching purchasing account line group");
                }
                this.misMatchedGroups.add(glAccountLineGroup);
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("GL account line " + glAccountLineGroup.toString() + " found a matching Purchasing account line group ");
            }
            glAccountLineGroup.setMatchedPurApAcctLines(purapAccountLineGroup.getSourceEntries());
            this.matchedGroups.add(glAccountLineGroup);
            this.misMatchedGroups.remove(glAccountLineGroup);
        }
    }

    protected void groupGLEntries(Collection<Entry> glEntries) {
        for (Entry glEntry : glEntries) {
            if (glEntry.getTransactionLedgerEntryAmount() == null || glEntry.getTransactionLedgerEntryAmount().isZero()) {
                this.ignoredEntries.add(glEntry);
                continue;
            }
            if (this.isDuplicateEntry(glEntry)) {
                this.duplicateEntries.add(glEntry);
                continue;
            }
            GlAccountLineGroup accountLineGroup = new GlAccountLineGroup(glEntry);
            GlAccountLineGroup targetAccountLineGroup = this.glEntryGroupMap.get(accountLineGroup);
            if (targetAccountLineGroup == null) {
                this.glEntryGroupMap.put(accountLineGroup, accountLineGroup);
                continue;
            }
            targetAccountLineGroup.combineEntry(glEntry);
        }
    }

    protected void groupPurapAccountEntries(Collection<PurApAccountingLineBase> purapAcctEntries) {
        for (PurApAccountingLineBase entry : purapAcctEntries) {
            if (entry.getAmount() == null || entry.getAmount().isZero()) continue;
            PurApAccountLineGroup accountLineGroup = new PurApAccountLineGroup(entry);
            PurApAccountLineGroup targetAccountLineGroup = this.purapAcctGroupMap.get(accountLineGroup);
            if (targetAccountLineGroup == null) {
                this.purapAcctGroupMap.put(accountLineGroup, accountLineGroup);
                continue;
            }
            targetAccountLineGroup.combineEntry(entry);
        }
    }

    @Override
    public boolean isDuplicateEntry(Entry glEntry) {
        return this.reconciliationDao.isDuplicateEntry(glEntry);
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setReconciliationDao(ReconciliationDao reconDao) {
        this.reconciliationDao = reconDao;
    }

    @Override
    public List<Entry> getIgnoredEntries() {
        return this.ignoredEntries;
    }

    public void setIgnoredEntries(List<Entry> ignoredEntries) {
        this.ignoredEntries = ignoredEntries;
    }

    @Override
    public List<Entry> getDuplicateEntries() {
        return this.duplicateEntries;
    }

    public void setDuplicateEntries(List<Entry> duplicateEntries) {
        this.duplicateEntries = duplicateEntries;
    }

    @Override
    public Collection<GlAccountLineGroup> getMatchedGroups() {
        return this.matchedGroups;
    }

    @Override
    public Collection<GlAccountLineGroup> getMisMatchedGroups() {
        return this.misMatchedGroups;
    }
}

