/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.PropertyUtils;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetGlobalDetail;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.util.KualiDecimalUtils;
import org.kuali.kfs.module.cam.util.ObjectValueUtils;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class AssetSeparatePaymentDistributor {
    private Asset sourceAsset;
    private AssetGlobal assetGlobal;
    private List<Asset> newAssets;
    private List<AssetPayment> sourcePayments;
    private List<AssetPayment> separatedPayments = new ArrayList<AssetPayment>();
    private List<AssetPayment> offsetPayments = new ArrayList<AssetPayment>();
    private List<AssetPayment> remainingPayments = new ArrayList<AssetPayment>();
    private HashMap<Long, KualiDecimal> totalByAsset = new HashMap();
    private HashMap<Integer, List<AssetPayment>> paymentSplitMap = new HashMap();
    private double[] assetAllocateRatios;
    private double separateRatio;
    private double retainRatio;
    private Integer maxPaymentSeqNo;
    private static PropertyDescriptor[] assetPaymentProperties = PropertyUtils.getPropertyDescriptors(AssetPayment.class);

    public AssetSeparatePaymentDistributor(Asset sourceAsset, List<AssetPayment> sourcePayments, Integer maxPaymentSeqNo, AssetGlobal assetGlobal, List<Asset> newAssets) {
        this.sourceAsset = sourceAsset;
        this.sourcePayments = sourcePayments;
        this.maxPaymentSeqNo = maxPaymentSeqNo;
        this.assetGlobal = assetGlobal;
        this.newAssets = newAssets;
    }

    public void distribute() {
        KualiDecimal totalSourceAmount = this.assetGlobal.getTotalCostAmount();
        KualiDecimal totalSeparateAmount = this.assetGlobal.getSeparateSourceTotalAmount();
        KualiDecimal remainingAmount = (KualiDecimal)totalSourceAmount.subtract((AbstractKualiDecimal)totalSeparateAmount);
        this.separateRatio = totalSeparateAmount.doubleValue() / totalSourceAmount.doubleValue();
        this.retainRatio = remainingAmount.doubleValue() / totalSourceAmount.doubleValue();
        List<AssetGlobalDetail> assetGlobalDetails = this.assetGlobal.getAssetGlobalDetails();
        int size = assetGlobalDetails.size();
        this.assetAllocateRatios = new double[size];
        for (int i = 0; i < size; ++i) {
            AssetGlobalDetail assetGlobalDetail = assetGlobalDetails.get(i);
            Long capitalAssetNumber = assetGlobalDetail.getCapitalAssetNumber();
            this.totalByAsset.put(capitalAssetNumber, KualiDecimal.ZERO);
            this.assetAllocateRatios[i] = assetGlobalDetail.getSeparateSourceAmount().doubleValue() / totalSeparateAmount.doubleValue();
        }
        this.prepareSourcePaymentsForSplit();
        this.allocatePaymentAmountsByRatio();
        this.roundPaymentAmounts();
        this.roundAccountChargeAmount();
        this.createOffsetPayments();
    }

    private void prepareSourcePaymentsForSplit() {
        for (AssetPayment assetPayment : this.sourcePayments) {
            if (assetPayment.getAccountChargeAmount() == null || !assetPayment.getAccountChargeAmount().isNonZero()) continue;
            AssetPayment separatePayment = new AssetPayment();
            ObjectValueUtils.copySimpleProperties((Object)assetPayment, (Object)separatePayment);
            this.separatedPayments.add(separatePayment);
            AssetPayment remainingPayment = new AssetPayment();
            ObjectValueUtils.copySimpleProperties((Object)assetPayment, (Object)remainingPayment);
            this.remainingPayments.add(remainingPayment);
            this.applyRatioToPaymentAmounts(assetPayment, new AssetPayment[]{separatePayment, remainingPayment}, new double[]{this.separateRatio, this.retainRatio});
        }
    }

    private void createOffsetPayments() {
        for (AssetPayment separatePayment : this.separatedPayments) {
            AssetPayment offsetPayment = new AssetPayment();
            ObjectValueUtils.copySimpleProperties((Object)separatePayment, (Object)offsetPayment);
            try {
                this.negatePaymentAmounts(offsetPayment);
            }
            catch (Exception e) {
                throw new RuntimeException();
            }
            offsetPayment.setDocumentNumber(this.assetGlobal.getDocumentNumber());
            offsetPayment.setFinancialDocumentTypeCode("ASEP");
            offsetPayment.setVersionNumber(null);
            offsetPayment.setObjectId(null);
            this.maxPaymentSeqNo = this.maxPaymentSeqNo + 1;
            offsetPayment.setPaymentSequenceNumber(this.maxPaymentSeqNo);
            this.offsetPayments.add(offsetPayment);
        }
        this.sourceAsset.getAssetPayments().addAll(this.offsetPayments);
    }

    private void allocatePaymentAmountsByRatio() {
        int index = 0;
        for (AssetPayment source : this.separatedPayments) {
            int j;
            AssetPayment[] targets = new AssetPayment[this.assetAllocateRatios.length];
            for (j = 0; j < this.assetAllocateRatios.length; ++j) {
                AssetPayment newPayment = new AssetPayment();
                ObjectValueUtils.copySimpleProperties((Object)source, (Object)newPayment);
                Asset currentAsset = this.newAssets.get(j);
                Long capitalAssetNumber = currentAsset.getCapitalAssetNumber();
                newPayment.setCapitalAssetNumber(capitalAssetNumber);
                newPayment.setDocumentNumber(this.assetGlobal.getDocumentNumber());
                newPayment.setFinancialDocumentTypeCode("ASEP");
                targets[j] = newPayment;
                newPayment.setVersionNumber(null);
                newPayment.setObjectId(null);
                currentAsset.getAssetPayments().add(index, newPayment);
            }
            this.applyRatioToPaymentAmounts(source, targets, this.assetAllocateRatios);
            this.paymentSplitMap.put(source.getPaymentSequenceNumber(), Arrays.asList(targets));
            for (j = 0; j < targets.length; ++j) {
                Asset currentAsset = this.newAssets.get(j);
                Long capitalAssetNumber = currentAsset.getCapitalAssetNumber();
                this.totalByAsset.put(capitalAssetNumber, (KualiDecimal)this.totalByAsset.get(capitalAssetNumber).add((AbstractKualiDecimal)targets[j].getAccountChargeAmount()));
            }
            ++index;
        }
    }

    private void roundPaymentAmounts() {
        for (AssetPayment separatedPayment : this.separatedPayments) {
            this.applyBalanceToPaymentAmounts(separatedPayment, this.paymentSplitMap.get(separatedPayment.getPaymentSequenceNumber()));
        }
    }

    private void roundAccountChargeAmount() {
        for (int j = 0; j < this.newAssets.size(); ++j) {
            Asset currentAsset = this.newAssets.get(j);
            AssetGlobalDetail detail = this.assetGlobal.getAssetGlobalDetails().get(j);
            AssetPayment lastPayment = currentAsset.getAssetPayments().get(currentAsset.getAssetPayments().size() - 1);
            KualiDecimal totalForAsset = this.totalByAsset.get(currentAsset.getCapitalAssetNumber());
            KualiDecimal diff = (KualiDecimal)detail.getSeparateSourceAmount().subtract((AbstractKualiDecimal)totalForAsset);
            lastPayment.setAccountChargeAmount((KualiDecimal)lastPayment.getAccountChargeAmount().add((AbstractKualiDecimal)diff));
            currentAsset.setTotalCostAmount((KualiDecimal)totalForAsset.add((AbstractKualiDecimal)diff));
            AssetPayment lastSource = this.separatedPayments.get(this.separatedPayments.size() - 1);
            lastSource.setAccountChargeAmount((KualiDecimal)lastSource.getAccountChargeAmount().add((AbstractKualiDecimal)diff));
            if (lastPayment.getPrimaryDepreciationBaseAmount() == null || !lastPayment.getPrimaryDepreciationBaseAmount().isNonZero()) continue;
            lastPayment.setPrimaryDepreciationBaseAmount(lastPayment.getAccountChargeAmount());
            lastSource.setPrimaryDepreciationBaseAmount(lastSource.getAccountChargeAmount());
        }
    }

    private void applyRatioToPaymentAmounts(AssetPayment source, AssetPayment[] targets, double[] ratios) {
        try {
            for (PropertyDescriptor propertyDescriptor : assetPaymentProperties) {
                KualiDecimal amount;
                Method readMethod = propertyDescriptor.getReadMethod();
                if (readMethod == null || propertyDescriptor.getPropertyType() == null || !KualiDecimal.class.isAssignableFrom(propertyDescriptor.getPropertyType()) || (amount = (KualiDecimal)readMethod.invoke((Object)source, new Object[0])) == null || !amount.isNonZero()) continue;
                KualiDecimal[] ratioAmounts = KualiDecimalUtils.allocateByRatio(amount, ratios);
                Method writeMethod = propertyDescriptor.getWriteMethod();
                if (writeMethod == null) continue;
                for (int i = 0; i < ratioAmounts.length; ++i) {
                    writeMethod.invoke((Object)targets[i], ratioAmounts[i]);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void applyBalanceToPaymentAmounts(AssetPayment source, List<AssetPayment> consumedList) {
        try {
            for (PropertyDescriptor propertyDescriptor : assetPaymentProperties) {
                KualiDecimal amount;
                Method readMethod = propertyDescriptor.getReadMethod();
                if (readMethod == null || propertyDescriptor.getPropertyType() == null || !KualiDecimal.class.isAssignableFrom(propertyDescriptor.getPropertyType()) || (amount = (KualiDecimal)readMethod.invoke((Object)source, new Object[0])) == null || !amount.isNonZero()) continue;
                Method writeMethod = propertyDescriptor.getWriteMethod();
                KualiDecimal consumedAmount = KualiDecimal.ZERO;
                KualiDecimal currAmt = KualiDecimal.ZERO;
                if (writeMethod != null) {
                    for (AssetPayment aConsumedList : consumedList) {
                        currAmt = (KualiDecimal)readMethod.invoke((Object)aConsumedList, new Object[0]);
                        consumedAmount = (KualiDecimal)consumedAmount.add((AbstractKualiDecimal)(currAmt != null ? currAmt : KualiDecimal.ZERO));
                    }
                }
                if (consumedAmount.equals((Object)amount)) continue;
                AssetPayment lastPayment = consumedList.get(consumedList.size() - 1);
                writeMethod.invoke((Object)lastPayment, currAmt.add((AbstractKualiDecimal)((KualiDecimal)amount.subtract((AbstractKualiDecimal)consumedAmount))));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void negatePaymentAmounts(AssetPayment assetPayment) {
        try {
            for (PropertyDescriptor propertyDescriptor : assetPaymentProperties) {
                Method readMethod = propertyDescriptor.getReadMethod();
                if (readMethod == null || propertyDescriptor.getPropertyType() == null || !KualiDecimal.class.isAssignableFrom(propertyDescriptor.getPropertyType())) continue;
                KualiDecimal amount = (KualiDecimal)readMethod.invoke((Object)assetPayment, new Object[0]);
                Method writeMethod = propertyDescriptor.getWriteMethod();
                if (writeMethod == null || amount == null) continue;
                writeMethod.invoke((Object)assetPayment, amount.negated());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void computeAccumulatedDepreciationAmount() {
        KualiDecimal previousYearAmount;
        for (Asset asset : this.newAssets) {
            List<AssetPayment> assetPayments = asset.getAssetPayments();
            for (AssetPayment currPayment : assetPayments) {
                previousYearAmount = currPayment.getPreviousYearPrimaryDepreciationAmount();
                previousYearAmount = previousYearAmount == null ? KualiDecimal.ZERO : previousYearAmount;
                KualiDecimal computedAmount = (KualiDecimal)previousYearAmount.add((AbstractKualiDecimal)AssetSeparatePaymentDistributor.sumPeriodicDepreciationAmounts(currPayment));
                if (!computedAmount.isNonZero()) continue;
                currPayment.setAccumulatedPrimaryDepreciationAmount(computedAmount);
            }
        }
        for (AssetPayment currPayment : this.offsetPayments) {
            previousYearAmount = currPayment.getPreviousYearPrimaryDepreciationAmount();
            previousYearAmount = previousYearAmount == null ? KualiDecimal.ZERO : previousYearAmount;
            KualiDecimal computedAmount = (KualiDecimal)previousYearAmount.add((AbstractKualiDecimal)AssetSeparatePaymentDistributor.sumPeriodicDepreciationAmounts(currPayment));
            if (!computedAmount.isNonZero()) continue;
            currPayment.setAccumulatedPrimaryDepreciationAmount(computedAmount);
        }
    }

    public static KualiDecimal sumPeriodicDepreciationAmounts(AssetPayment currPayment) {
        KualiDecimal ytdAmount = KualiDecimal.ZERO;
        try {
            for (PropertyDescriptor propertyDescriptor : assetPaymentProperties) {
                KualiDecimal amount;
                Method readMethod = propertyDescriptor.getReadMethod();
                if (readMethod == null || !Pattern.matches("getperiod\\d.*depreciation\\damount", readMethod.getName().toLowerCase(Locale.US)) || propertyDescriptor.getPropertyType() == null || !KualiDecimal.class.isAssignableFrom(propertyDescriptor.getPropertyType()) || (amount = (KualiDecimal)readMethod.invoke((Object)currPayment, new Object[0])) == null) continue;
                ytdAmount = (KualiDecimal)ytdAmount.add((AbstractKualiDecimal)amount);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ytdAmount;
    }

    public List<AssetPayment> getRemainingPayments() {
        return this.remainingPayments;
    }

    public void setRemainingPayments(List<AssetPayment> remainingPayments) {
        this.remainingPayments = remainingPayments;
    }

    public List<AssetPayment> getOffsetPayments() {
        return this.offsetPayments;
    }

    public void setOffsetPayments(List<AssetPayment> offsetPayments) {
        this.offsetPayments = offsetPayments;
    }

    public List<AssetPayment> getSeparatedPayments() {
        return this.separatedPayments;
    }

    public void setSeparatedPayments(List<AssetPayment> separatedPayments) {
        this.separatedPayments = separatedPayments;
    }

    public AssetGlobal getAssetGlobal() {
        return this.assetGlobal;
    }

    public void setAssetGlobal(AssetGlobal assetGlobal) {
        this.assetGlobal = assetGlobal;
    }

    public List<Asset> getNewAssets() {
        return this.newAssets;
    }

    public void setNewAssets(List<Asset> newAssets) {
        this.newAssets = newAssets;
    }

    public double[] getAssetAllocateRatios() {
        return this.assetAllocateRatios;
    }

    public void setAssetAllocateRatios(double[] assetAllocateRatios) {
        this.assetAllocateRatios = assetAllocateRatios;
    }

    public double getSeparateRatio() {
        return this.separateRatio;
    }

    public void setSeparateRatio(double separateRatio) {
        this.separateRatio = separateRatio;
    }

    public double getRetainRatio() {
        return this.retainRatio;
    }

    public void setRetainRatio(double retainRatio) {
        this.retainRatio = retainRatio;
    }

    public List<AssetPayment> getSourcePayments() {
        return this.sourcePayments;
    }

    public void setSourcePayments(List<AssetPayment> sourcePayments) {
        this.sourcePayments = sourcePayments;
    }
}

