/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.util.distribution;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentAssetDetail;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentDetail;
import org.kuali.kfs.module.cam.document.AssetPaymentDocument;
import org.kuali.kfs.module.cam.util.distribution.AssetDistribution;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class AssetDistributionPercent
extends AssetDistribution {
    private Map<String, Map<AssetPaymentAssetDetail, KualiDecimal>> distributionResult;

    public AssetDistributionPercent(AssetPaymentDocument doc) {
        super(doc);
    }

    @Override
    public Map<String, Map<AssetPaymentAssetDetail, KualiDecimal>> getAssetPaymentDistributions() {
        this.distributionResult = new HashMap<String, Map<AssetPaymentAssetDetail, KualiDecimal>>();
        for (AssetPaymentDetail line : this.getAssetPaymentDetailLines()) {
            KualiDecimal lineAmount;
            KualiDecimal remainingAmount = lineAmount = line.getAmount();
            HashMap<AssetPaymentAssetDetail, KualiDecimal> apadMap = new HashMap<AssetPaymentAssetDetail, KualiDecimal>();
            int size = this.doc.getAssetPaymentAssetDetail().size();
            for (int i = 0; i < size; ++i) {
                AssetPaymentAssetDetail apad = this.doc.getAssetPaymentAssetDetail().get(i);
                if (i < size - 1) {
                    BigDecimal allocationPercentage = apad.getAllocatedUserValuePct();
                    BigDecimal amount = BigDecimal.ZERO;
                    if (lineAmount.isNonZero()) {
                        amount = allocationPercentage.divide(new BigDecimal(100)).multiply(lineAmount.bigDecimalValue());
                    }
                    apadMap.put(apad, new KualiDecimal(amount));
                    remainingAmount = (KualiDecimal)remainingAmount.subtract((AbstractKualiDecimal)new KualiDecimal(amount));
                    continue;
                }
                apadMap.put(apad, remainingAmount);
            }
            this.distributionResult.put(line.getAssetPaymentDetailKey(), apadMap);
        }
        return this.distributionResult;
    }

    private KualiDecimal getTotalLineAmount() {
        KualiDecimal result = KualiDecimal.ZERO;
        for (AssetPaymentDetail sourceLine : this.getAssetPaymentDetailLines()) {
            result = (KualiDecimal)result.add((AbstractKualiDecimal)sourceLine.getAmount());
        }
        return result;
    }

    public Map<AssetPaymentAssetDetail, KualiDecimal> getTotalAssetAllocations() {
        HashMap<AssetPaymentAssetDetail, KualiDecimal> assetTotalAllocationMap = new HashMap<AssetPaymentAssetDetail, KualiDecimal>();
        for (AssetPaymentAssetDetail apad : this.doc.getAssetPaymentAssetDetail()) {
            assetTotalAllocationMap.put(apad, apad.getAllocatedAmount());
        }
        return assetTotalAllocationMap;
    }
}

