/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.batch;

import java.sql.Timestamp;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.module.cam.batch.ExtractProcessLog;
import org.kuali.kfs.module.cam.batch.service.BatchExtractReportService;
import org.kuali.kfs.module.cam.batch.service.BatchExtractService;
import org.kuali.kfs.sys.batch.AbstractStep;
import org.kuali.rice.core.api.datetime.DateTimeService;

public class ExtractStep
extends AbstractStep {
    private static final Logger LOG = LogManager.getLogger(ExtractStep.class);
    private BatchExtractService batchExtractService;
    private DateTimeService dateTimeService;
    private BatchExtractReportService batchExtractReportService;

    public boolean execute(String jobName, Date jobRunDate) throws InterruptedException {
        ExtractProcessLog processLog = new ExtractProcessLog();
        try {
            Timestamp startTs = this.dateTimeService.getCurrentTimestamp();
            if (LOG.isDebugEnabled()) {
                LOG.debug("CAB extract started at " + startTs);
            }
            processLog.setStartTime(startTs);
            this.batchExtractService.performExtract(processLog);
            processLog.setFinishTime(this.dateTimeService.getCurrentTimestamp());
        }
        catch (Throwable e) {
            processLog.setSuccess(false);
            processLog.setErrorMessage("Unexpected error occurred while performing CAB Extract. " + e.toString());
            LOG.error("Unexpected error occurred while performing CAB Extract.", e);
            throw new RuntimeException(e);
        }
        finally {
            this.batchExtractReportService.generateStatusReportPDF(processLog);
            if (processLog.getMismatchedGLEntries() != null && !processLog.getMismatchedGLEntries().isEmpty()) {
                this.batchExtractReportService.generateMismatchReportPDF(processLog);
            }
            LOG.info("Batch status report is generated successfully.");
        }
        return true;
    }

    public void setBatchExtractService(BatchExtractService batchExtractService) {
        this.batchExtractService = batchExtractService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setBatchExtractReportService(BatchExtractReportService batchExtractReportService) {
        this.batchExtractReportService = batchExtractReportService;
    }
}

