/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.businessobject;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsAgency;
import org.kuali.kfs.krad.bo.GlobalBusinessObject;
import org.kuali.kfs.krad.bo.GlobalBusinessObjectDetail;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetAcquisitionType;
import org.kuali.kfs.module.cam.businessobject.AssetCondition;
import org.kuali.kfs.module.cam.businessobject.AssetGlobalDetail;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentDetail;
import org.kuali.kfs.module.cam.businessobject.AssetStatus;
import org.kuali.kfs.module.cam.businessobject.AssetType;
import org.kuali.kfs.module.cam.document.service.AssetGlobalService;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;

public class AssetGlobal
extends PersistableBusinessObjectBase
implements GlobalBusinessObject {
    private String documentNumber;
    private String acquisitionTypeCode;
    private String capitalAssetDescription;
    private String inventoryStatusCode;
    private String conditionCode;
    private String capitalAssetTypeCode;
    private String manufacturerName;
    private String manufacturerModelNumber;
    private KualiDecimal totalCostAmount;
    private String landCountyName;
    private Integer landAcreageSize;
    private String landParcelNumber;
    private String vendorName;
    private String organizationText;
    private Date createDate;
    private Date capitalAssetInServiceDate;
    private Date capitalAssetDepreciationDate;
    private String representativeUniversalIdentifier;
    private String organizationOwnerChartOfAccountsCode;
    private String organizationOwnerAccountNumber;
    private String agencyNumber;
    private Integer financialDocumentNextLineNumber;
    private Asset separateSourceCapitalAsset;
    private Integer separateSourcePaymentSequenceNumber;
    private boolean capitalAssetBuilderOriginIndicator;
    protected String financialDocumentPostingPeriodCode;
    protected Integer financialDocumentPostingYear;
    protected String universityFiscalPeriodName;
    private AccountingPeriod accountingPeriod;
    private Date lastInventoryDate;
    private ContractsAndGrantsAgency agency;
    private Person assetRepresentative;
    private AssetType capitalAssetType;
    private AssetCondition assetCondition;
    private AssetStatus inventoryStatus;
    private List<AssetGlobalDetail> assetGlobalDetails = new ArrayList<AssetGlobalDetail>();
    private List<AssetGlobalDetail> assetSharedDetails = new ArrayList<AssetGlobalDetail>();
    private List<AssetPaymentDetail> assetPaymentDetails = new ArrayList<AssetPaymentDetail>();
    private AssetAcquisitionType acquisitionType;
    private Chart organizationOwnerChartOfAccounts;
    private Account organizationOwnerAccount;
    private String financialDocumentTypeCode;
    private Long separateSourceCapitalAssetNumber;
    private String calculateEqualSourceAmountsButton;
    private KualiDecimal separateSourceRemainingAmount;
    private KualiDecimal separateSourceTotalAmount;
    private String calculateSeparateSourceRemainingAmountButton;
    private List<GeneralLedgerPendingEntry> generalLedgerPendingEntries = new ArrayList<GeneralLedgerPendingEntry>();
    private FinancialSystemDocumentHeader documentHeader;
    private KualiDecimal totalAssetPaymentAmount;
    private KualiDecimal minAssetTotalAmount;
    private KualiDecimal maxAssetTotalAmount;
    protected static transient AccountingPeriodService accountingPeriodService;

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public String getAcquisitionTypeCode() {
        return this.acquisitionTypeCode;
    }

    public void setAcquisitionTypeCode(String acquisitionTypeCode) {
        this.acquisitionTypeCode = acquisitionTypeCode;
    }

    public String getCapitalAssetDescription() {
        return this.capitalAssetDescription;
    }

    public void setCapitalAssetDescription(String capitalAssetDescription) {
        this.capitalAssetDescription = capitalAssetDescription;
    }

    public String getInventoryStatusCode() {
        return this.inventoryStatusCode;
    }

    public void setInventoryStatusCode(String inventoryStatusCode) {
        this.inventoryStatusCode = inventoryStatusCode;
    }

    public String getConditionCode() {
        return this.conditionCode;
    }

    public void setConditionCode(String conditionCode) {
        this.conditionCode = conditionCode;
    }

    public String getCapitalAssetTypeCode() {
        return this.capitalAssetTypeCode;
    }

    public void setCapitalAssetTypeCode(String capitalAssetTypeCode) {
        this.capitalAssetTypeCode = capitalAssetTypeCode;
    }

    public String getManufacturerName() {
        return this.manufacturerName;
    }

    public void setManufacturerName(String manufacturerName) {
        this.manufacturerName = manufacturerName;
    }

    public String getManufacturerModelNumber() {
        return this.manufacturerModelNumber;
    }

    public void setManufacturerModelNumber(String manufacturerModelNumber) {
        this.manufacturerModelNumber = manufacturerModelNumber;
    }

    public KualiDecimal getTotalCostAmount() {
        return this.totalCostAmount;
    }

    public void setTotalCostAmount(KualiDecimal totalCostAmount) {
        this.totalCostAmount = totalCostAmount;
    }

    public String getLandCountyName() {
        return this.landCountyName;
    }

    public void setLandCountyName(String landCountyName) {
        this.landCountyName = landCountyName;
    }

    public Integer getLandAcreageSize() {
        return this.landAcreageSize;
    }

    public void setLandAcreageSize(Integer landAcreageSize) {
        this.landAcreageSize = landAcreageSize;
    }

    public String getLandParcelNumber() {
        return this.landParcelNumber;
    }

    public void setLandParcelNumber(String landParcelNumber) {
        this.landParcelNumber = landParcelNumber;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    public String getOrganizationText() {
        return this.organizationText;
    }

    public void setOrganizationText(String organizationText) {
        this.organizationText = organizationText;
    }

    public Date getCreateDate() {
        if (this.createDate != null) {
            return this.createDate;
        }
        return ((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDate();
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getCapitalAssetInServiceDate() {
        return this.capitalAssetInServiceDate;
    }

    public void setCapitalAssetInServiceDate(Date capitalAssetInServiceDate) {
        this.capitalAssetInServiceDate = capitalAssetInServiceDate;
    }

    public Date getCapitalAssetDepreciationDate() {
        return this.capitalAssetDepreciationDate;
    }

    public void setCapitalAssetDepreciationDate(Date capitalAssetDepreciationDate) {
        this.capitalAssetDepreciationDate = capitalAssetDepreciationDate;
    }

    public String getAgencyNumber() {
        return this.agencyNumber;
    }

    public void setAgencyNumber(String agencyNumber) {
        this.agencyNumber = agencyNumber;
    }

    public String getOrganizationOwnerAccountNumber() {
        return this.organizationOwnerAccountNumber;
    }

    public void setOrganizationOwnerAccountNumber(String organizationOwnerAccountNumber) {
        this.organizationOwnerAccountNumber = organizationOwnerAccountNumber;
    }

    public String getOrganizationOwnerChartOfAccountsCode() {
        return this.organizationOwnerChartOfAccountsCode;
    }

    public void setOrganizationOwnerChartOfAccountsCode(String organizationOwnerChartOfAccountsCode) {
        this.organizationOwnerChartOfAccountsCode = organizationOwnerChartOfAccountsCode;
    }

    public String getRepresentativeUniversalIdentifier() {
        return this.representativeUniversalIdentifier;
    }

    public void setRepresentativeUniversalIdentifier(String representativeUniversalIdentifier) {
        this.representativeUniversalIdentifier = representativeUniversalIdentifier;
    }

    public AssetCondition getAssetCondition() {
        return this.assetCondition;
    }

    public void setAssetCondition(AssetCondition assetCondition) {
        this.assetCondition = assetCondition;
    }

    public AssetType getCapitalAssetType() {
        return this.capitalAssetType;
    }

    public void setCapitalAssetType(AssetType capitalAssetType) {
        this.capitalAssetType = capitalAssetType;
    }

    public AssetStatus getInventoryStatus() {
        return this.inventoryStatus;
    }

    public void setInventoryStatus(AssetStatus inventoryStatus) {
        this.inventoryStatus = inventoryStatus;
    }

    public Account getOrganizationOwnerAccount() {
        return this.organizationOwnerAccount;
    }

    public void setOrganizationOwnerAccount(Account organizationOwnerAccount) {
        this.organizationOwnerAccount = organizationOwnerAccount;
    }

    public Chart getOrganizationOwnerChartOfAccounts() {
        return this.organizationOwnerChartOfAccounts;
    }

    public void setOrganizationOwnerChartOfAccounts(Chart organizationOwnerChartOfAccounts) {
        this.organizationOwnerChartOfAccounts = organizationOwnerChartOfAccounts;
    }

    public List<AssetGlobalDetail> getAssetGlobalDetails() {
        return this.assetGlobalDetails;
    }

    public void setAssetGlobalDetails(List<AssetGlobalDetail> assetGlobalDetails) {
        this.assetGlobalDetails = assetGlobalDetails;
    }

    public List<AssetPaymentDetail> getAssetPaymentDetails() {
        return this.assetPaymentDetails;
    }

    public void setAssetPaymentDetails(List<AssetPaymentDetail> assetPaymentDetails) {
        this.assetPaymentDetails = assetPaymentDetails;
    }

    public List<PersistableBusinessObject> generateDeactivationsToPersist() {
        return null;
    }

    public List<PersistableBusinessObject> generateGlobalChangesToPersist() {
        AssetGlobalService assetGlobalService = (AssetGlobalService)SpringContext.getBean(AssetGlobalService.class);
        List<PersistableBusinessObject> persistables = assetGlobalService.isAssetSeparate(this) ? assetGlobalService.getSeparateAssets(this) : assetGlobalService.getCreateNewAssets(this);
        return persistables;
    }

    public boolean isPersistable() {
        Account organizationOwnerAccount;
        this.refreshReferenceObject("organizationOwnerAccount");
        AssetGlobalService assetGlobalService = (AssetGlobalService)SpringContext.getBean(AssetGlobalService.class);
        if (!assetGlobalService.isAssetSeparate(this) && (ObjectUtils.isNull((Object)(organizationOwnerAccount = this.getOrganizationOwnerAccount())) || !organizationOwnerAccount.isActive() || organizationOwnerAccount.isExpired())) {
            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath("document.newMaintainableObject.organizationOwnerAccountNumber", "error.asset.org.owner.account.invalid", new String[0]);
            return false;
        }
        return true;
    }

    public List<? extends GlobalBusinessObjectDetail> getAllDetailObjects() {
        return this.getAssetGlobalDetails();
    }

    public Date getLastInventoryDate() {
        return this.lastInventoryDate;
    }

    public void setLastInventoryDate(Date lastInventoryDate) {
        this.lastInventoryDate = lastInventoryDate;
    }

    public String getFinancialDocumentPostingPeriodCode() {
        return this.financialDocumentPostingPeriodCode;
    }

    public void setFinancialDocumentPostingPeriodCode(String financialDocumentPostingPeriodCode) {
        this.financialDocumentPostingPeriodCode = financialDocumentPostingPeriodCode;
    }

    public Integer getFinancialDocumentPostingYear() {
        return this.financialDocumentPostingYear;
    }

    public void setFinancialDocumentPostingYear(Integer financialDocumentPostingYear) {
        this.financialDocumentPostingYear = financialDocumentPostingYear;
    }

    public Integer getFinancialDocumentNextLineNumber() {
        return this.financialDocumentNextLineNumber;
    }

    public void setFinancialDocumentNextLineNumber(Integer financialDocumentNextLineNumber) {
        this.financialDocumentNextLineNumber = financialDocumentNextLineNumber;
    }

    public Integer incrementFinancialDocumentLineNumber() {
        if (this.financialDocumentNextLineNumber == null) {
            this.financialDocumentNextLineNumber = 0;
        }
        this.financialDocumentNextLineNumber = this.financialDocumentNextLineNumber + 1;
        return this.financialDocumentNextLineNumber;
    }

    public List<AssetGlobalDetail> getAssetSharedDetails() {
        return this.assetSharedDetails;
    }

    public void setAssetSharedDetails(List<AssetGlobalDetail> assetSharedDetails) {
        this.assetSharedDetails = assetSharedDetails;
    }

    public AssetAcquisitionType getAcquisitionType() {
        return this.acquisitionType;
    }

    public void setAcquisitionType(AssetAcquisitionType acquisitionType) {
        this.acquisitionType = acquisitionType;
    }

    public String getFinancialDocumentTypeCode() {
        return this.financialDocumentTypeCode;
    }

    public void setFinancialDocumentTypeCode(String financialDocumentTypeCode) {
        this.financialDocumentTypeCode = financialDocumentTypeCode;
    }

    public Person getAssetRepresentative() {
        this.assetRepresentative = ((PersonService)SpringContext.getBean(PersonService.class)).updatePersonIfNecessary(this.representativeUniversalIdentifier, this.assetRepresentative);
        return this.assetRepresentative;
    }

    public void setAssetRepresentative(Person assetRepresentative) {
        this.assetRepresentative = assetRepresentative;
    }

    public ContractsAndGrantsAgency getAgency() {
        this.agency = (ContractsAndGrantsAgency)((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(ContractsAndGrantsAgency.class).retrieveExternalizableBusinessObjectIfNecessary((BusinessObject)this, (ExternalizableBusinessObject)this.agency, "agency");
        return this.agency;
    }

    public void setAgency(ContractsAndGrantsAgency agency) {
        this.agency = agency;
    }

    public List<GeneralLedgerPendingEntry> getGeneralLedgerPendingEntries() {
        return this.generalLedgerPendingEntries;
    }

    public void setGeneralLedgerPendingEntries(List<GeneralLedgerPendingEntry> generalLedgerPendingEntries) {
        this.generalLedgerPendingEntries = generalLedgerPendingEntries;
    }

    public Asset getSeparateSourceCapitalAsset() {
        return this.separateSourceCapitalAsset;
    }

    public void setSeparateSourceCapitalAsset(Asset separateSourceCapitalAsset) {
        this.separateSourceCapitalAsset = separateSourceCapitalAsset;
    }

    public Long getSeparateSourceCapitalAssetNumber() {
        return this.separateSourceCapitalAssetNumber;
    }

    public void setSeparateSourceCapitalAssetNumber(Long separateSourceCapitalAssetNumber) {
        this.separateSourceCapitalAssetNumber = separateSourceCapitalAssetNumber;
    }

    public Integer getSeparateSourcePaymentSequenceNumber() {
        return this.separateSourcePaymentSequenceNumber;
    }

    public void setSeparateSourcePaymentSequenceNumber(Integer separateSourcePaymentSequenceNumber) {
        this.separateSourcePaymentSequenceNumber = separateSourcePaymentSequenceNumber;
    }

    public FinancialSystemDocumentHeader getDocumentHeader() {
        return this.documentHeader;
    }

    public void setDocumentHeader(FinancialSystemDocumentHeader documentHeader) {
        this.documentHeader = documentHeader;
    }

    public Date getSeparateDocumentHeaderFinalDate() {
        if (this.documentNumber == null || !((AssetGlobalService)SpringContext.getBean(AssetGlobalService.class)).isAssetSeparate(this)) {
            return null;
        }
        String userId = GlobalVariables.getUserSession().getPrincipalId();
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.loadDocument((String)userId, (String)this.getDocumentNumber());
        if (ObjectUtils.isNotNull((Object)workflowDocument.getDateApproved())) {
            return this.getSqlDate(workflowDocument.getDateApproved().toCalendar(Locale.getDefault()));
        }
        return null;
    }

    protected Date getSqlDate(Calendar cal) {
        if (ObjectUtils.isNull((Object)cal)) {
            return null;
        }
        Date sqlDueDate = null;
        try {
            sqlDueDate = ((DateTimeService)SpringContext.getBean(DateTimeService.class)).convertToSqlDate(new Timestamp(cal.getTime().getTime()));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return sqlDueDate;
    }

    public boolean isCapitalAssetBuilderOriginIndicator() {
        return this.capitalAssetBuilderOriginIndicator;
    }

    public void setCapitalAssetBuilderOriginIndicator(boolean capitalAssetBuilderOriginIndicator) {
        this.capitalAssetBuilderOriginIndicator = capitalAssetBuilderOriginIndicator;
    }

    public String getCalculateEqualSourceAmountsButton() {
        return this.calculateEqualSourceAmountsButton;
    }

    public void setCalculateEqualSourceAmountsButton(String calculateEqualSourceAmountsButton) {
        this.calculateEqualSourceAmountsButton = calculateEqualSourceAmountsButton;
    }

    public String getCalculateSeparateSourceRemainingAmountButton() {
        return this.calculateSeparateSourceRemainingAmountButton;
    }

    public void setCalculateSeparateSourceRemainingAmountButton(String calculateSeparateSourceRemainingAmountButton) {
        this.calculateSeparateSourceRemainingAmountButton = calculateSeparateSourceRemainingAmountButton;
    }

    public KualiDecimal getSeparateSourceRemainingAmount() {
        if (this.separateSourceRemainingAmount == null && this.getTotalCostAmount() != null) {
            return (KualiDecimal)this.getTotalCostAmount().subtract((AbstractKualiDecimal)this.getSeparateSourceTotalAmount());
        }
        return this.separateSourceRemainingAmount;
    }

    public void setSeparateSourceRemainingAmount(KualiDecimal separateSourceRemainingAmount) {
        this.separateSourceRemainingAmount = separateSourceRemainingAmount;
    }

    public List<Collection<PersistableBusinessObject>> buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(new ArrayList<AssetGlobalDetail>(this.getAssetGlobalDetails()));
        managedLists.add(new ArrayList<AssetPaymentDetail>(this.getAssetPaymentDetails()));
        return managedLists;
    }

    public KualiDecimal getTotalAssetPaymentAmount() {
        KualiDecimal totalAmount = KualiDecimal.ZERO;
        List<AssetPaymentDetail> assetPaymentList = this.getAssetPaymentDetails();
        if (assetPaymentList != null && !assetPaymentList.isEmpty()) {
            for (AssetPaymentDetail assetPaymentDetail : assetPaymentList) {
                totalAmount = (KualiDecimal)totalAmount.add((AbstractKualiDecimal)assetPaymentDetail.getAmount());
            }
        }
        return totalAmount;
    }

    public void setTotalAssetPaymentAmount(KualiDecimal totalAssetPaymentAmount) {
        this.totalAssetPaymentAmount = totalAssetPaymentAmount;
    }

    public KualiDecimal getSeparateSourceTotalAmount() {
        if (this.separateSourceTotalAmount == null) {
            this.separateSourceTotalAmount = KualiDecimal.ZERO;
            for (AssetGlobalDetail detail : this.assetGlobalDetails) {
                KualiDecimal separateSourceAmount = detail.getSeparateSourceAmount();
                if (separateSourceAmount == null) continue;
                this.separateSourceTotalAmount = (KualiDecimal)this.separateSourceTotalAmount.add((AbstractKualiDecimal)separateSourceAmount);
            }
        }
        return this.separateSourceTotalAmount;
    }

    public void setSeparateSourceTotalAmount(KualiDecimal separateSourceTotalAmount) {
        this.separateSourceTotalAmount = separateSourceTotalAmount;
    }

    public KualiDecimal getMinAssetTotalAmount() {
        return this.minAssetTotalAmount;
    }

    public void setMinAssetTotalAmount(KualiDecimal minAssetTotalAmount) {
        this.minAssetTotalAmount = minAssetTotalAmount;
    }

    public KualiDecimal getMaxAssetTotalAmount() {
        return this.maxAssetTotalAmount;
    }

    public void setMaxAssetTotalAmount(KualiDecimal maxAssetTotalAmount) {
        this.maxAssetTotalAmount = maxAssetTotalAmount;
    }

    public static AccountingPeriodService getAccountingPeriodService() {
        if (accountingPeriodService == null) {
            accountingPeriodService = (AccountingPeriodService)SpringContext.getBean(AccountingPeriodService.class);
        }
        return accountingPeriodService;
    }

    public void setAccountingPeriod(AccountingPeriod accountingPeriod) {
        this.accountingPeriod = accountingPeriod;
    }

    public AccountingPeriod getAccountingPeriod() {
        return this.accountingPeriod;
    }

    public String getUniversityFiscalPeriodName() {
        if (StringUtils.isNotBlank((CharSequence)this.universityFiscalPeriodName)) {
            this.setFinancialDocumentPostingPeriodCode(StringUtils.left((String)this.universityFiscalPeriodName, (int)2));
            this.setFinancialDocumentPostingYear(new Integer(StringUtils.right((String)this.universityFiscalPeriodName, (int)4)));
        }
        if (StringUtils.isBlank((CharSequence)this.universityFiscalPeriodName) && this.financialDocumentPostingPeriodCode != null && this.financialDocumentPostingYear != null) {
            this.universityFiscalPeriodName = this.financialDocumentPostingPeriodCode + this.financialDocumentPostingYear;
        }
        return this.universityFiscalPeriodName;
    }

    public void setUniversityFiscalPeriodName(String universityFiscalPeriodName) {
        if (StringUtils.isBlank((CharSequence)universityFiscalPeriodName) && this.financialDocumentPostingPeriodCode != null && this.financialDocumentPostingYear != null) {
            universityFiscalPeriodName = this.financialDocumentPostingPeriodCode + this.financialDocumentPostingYear;
        }
        String THIRTEEN = "13";
        if (StringUtils.isNotBlank((CharSequence)universityFiscalPeriodName) && StringUtils.left((String)universityFiscalPeriodName, (int)2).equals(THIRTEEN)) {
            String period = StringUtils.left((String)universityFiscalPeriodName, (int)2);
            Integer year = new Integer(StringUtils.right((String)universityFiscalPeriodName, (int)4));
            AccountingPeriod accountingPeriod = AssetGlobal.getAccountingPeriodService().getByPeriod(period, year);
            this.setAccountingPeriod(accountingPeriod);
        }
        this.universityFiscalPeriodName = universityFiscalPeriodName;
    }

    public String getAccountingPeriodCompositeString() {
        if (this.financialDocumentPostingPeriodCode == null || this.financialDocumentPostingYear == null) {
            return "";
        }
        return this.financialDocumentPostingPeriodCode + this.financialDocumentPostingYear;
    }

    public void setAccountingPeriodCompositeString(String accountingPeriodString) {
        String THIRTEEN = "13";
        if (StringUtils.isNotBlank((CharSequence)accountingPeriodString) && StringUtils.left((String)accountingPeriodString, (int)2).equals(THIRTEEN)) {
            String period = StringUtils.left((String)accountingPeriodString, (int)2);
            Integer year = new Integer(StringUtils.right((String)accountingPeriodString, (int)4));
            AccountingPeriod accountingPeriod = AssetGlobal.getAccountingPeriodService().getByPeriod(period, year);
            this.setAccountingPeriod(accountingPeriod);
        }
    }
}

