/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.dataaccess.impl;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.module.cam.batch.AssetDepreciationStep;
import org.kuali.kfs.module.cam.batch.AssetPaymentInfo;
import org.kuali.kfs.module.cam.document.dataaccess.DepreciationBatchDao;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.dataaccess.UniversityDateDao;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.framework.persistence.jdbc.dao.PlatformAwareDaoBaseJdbc;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.PreparedStatementSetter;

public class DepreciationBatchDaoJdbc
extends PlatformAwareDaoBaseJdbc
implements DepreciationBatchDao {
    private static final Logger LOG = LogManager.getLogger(DepreciationBatchDaoJdbc.class);
    private AccountingPeriodService accountingPeriodService;
    protected UniversityDateDao universityDateDao;
    protected ParameterService parameterService;

    @Override
    public void resetPeriodValuesWhenFirstFiscalPeriod(Integer fiscalMonth) throws Exception {
        LOG.debug("resetPeriodValuesWhenFirstFiscalPeriod() started");
        if (fiscalMonth == 1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("DEPRECIATION BATCH - Starting resetPeriodValuesWhenFirstFiscalPeriod");
            }
            this.getJdbcTemplate().update("UPDATE CM_AST_PAYMENT_T SET AST_PRVYRDEPR1_AMT = (COALESCE(AST_PRD1_DEPR1_AMT, 0) + COALESCE(AST_PRD2_DEPR1_AMT, 0) + COALESCE(AST_PRD3_DEPR1_AMT, 0) + COALESCE(AST_PRD4_DEPR1_AMT, 0) + COALESCE(AST_PRD5_DEPR1_AMT, 0) + COALESCE(AST_PRD6_DEPR1_AMT, 0) + COALESCE(AST_PRD7_DEPR1_AMT, 0) + COALESCE(AST_PRD8_DEPR1_AMT, 0) + COALESCE(AST_PRD9_DEPR1_AMT, 0) + COALESCE(AST_PRD10DEPR1_AMT, 0) + COALESCE(AST_PRD11DEPR1_AMT, 0) + COALESCE(AST_PRD12DEPR1_AMT, 0))");
            LOG.info("DEPRECIATION BATCH - Fiscal month = 1. Therefore, initializing each month with zeros.");
            this.getJdbcTemplate().update("UPDATE CM_AST_PAYMENT_T SET AST_PRD1_DEPR1_AMT =0.0,  AST_PRD2_DEPR1_AMT =0.0,  AST_PRD3_DEPR1_AMT =0.0,  AST_PRD4_DEPR1_AMT =0.0,  AST_PRD5_DEPR1_AMT =0.0,  AST_PRD6_DEPR1_AMT =0.0,  AST_PRD7_DEPR1_AMT =0.0,  AST_PRD8_DEPR1_AMT =0.0,  AST_PRD9_DEPR1_AMT =0.0,  AST_PRD10DEPR1_AMT =0.0,  AST_PRD11DEPR1_AMT =0.0,  AST_PRD12DEPR1_AMT=0.0");
            if (LOG.isDebugEnabled()) {
                LOG.debug("DEPRECIATION BATCH - Finished resetPeriodValuesWhenFirstFiscalPeriod");
            }
        }
    }

    @Override
    public void updateAssetPayments(final List<AssetPaymentInfo> assetPayments, Integer fiscalMonth) {
        LOG.debug("updateAssetPayments() started");
        LOG.info("DEPRECIATION BATCH - Batch updating [" + assetPayments.size() + "] payments");
        this.getJdbcTemplate().batchUpdate("UPDATE CM_AST_PAYMENT_T SET AST_ACUM_DEPR1_AMT=? , AST_PRD" + fiscalMonth + (fiscalMonth < 10 ? "_" : "") + "DEPR1_AMT = ?, ACCUM_RNDNG_ERR_MILLICENTS = ? WHERE CPTLAST_NBR = ? AND AST_PMT_SEQ_NBR = ? ", new BatchPreparedStatementSetter(){

            public int getBatchSize() {
                return assetPayments.size();
            }

            public void setValues(PreparedStatement pstmt, int index) throws SQLException {
                pstmt.setBigDecimal(1, ((AssetPaymentInfo)assetPayments.get(index)).getAccumulatedPrimaryDepreciationAmount().bigDecimalValue());
                pstmt.setBigDecimal(2, ((AssetPaymentInfo)assetPayments.get(index)).getTransactionAmount().bigDecimalValue());
                pstmt.setInt(3, ((AssetPaymentInfo)assetPayments.get(index)).getAccumulatedRoundingErrorInMillicents());
                pstmt.setLong(4, ((AssetPaymentInfo)assetPayments.get(index)).getCapitalAssetNumber());
                pstmt.setInt(5, ((AssetPaymentInfo)assetPayments.get(index)).getPaymentSequenceNumber());
            }
        });
    }

    @Override
    public void savePendingGLEntries(final List<GeneralLedgerPendingEntry> glPendingEntries) {
        LOG.debug("savePendingGLEntries() started");
        LOG.info("DEPRECIATION BATCH - Batch update of [" + glPendingEntries.size() + "] glpes");
        this.getJdbcTemplate().batchUpdate("INSERT INTO GL_PENDING_ENTRY_T  (FS_ORIGIN_CD,FDOC_NBR,TRN_ENTR_SEQ_NBR,OBJ_ID,VER_NBR,FIN_COA_CD,ACCOUNT_NBR,SUB_ACCT_NBR,FIN_OBJECT_CD,FIN_SUB_OBJ_CD,FIN_BALANCE_TYP_CD,FIN_OBJ_TYP_CD,UNIV_FISCAL_YR,UNIV_FISCAL_PRD_CD,TRN_LDGR_ENTR_DESC,TRN_LDGR_ENTR_AMT,TRN_DEBIT_CRDT_CD,TRANSACTION_DT,FDOC_TYP_CD,ORG_DOC_NBR,PROJECT_CD,ORG_REFERENCE_ID,FDOC_REF_TYP_CD,FS_REF_ORIGIN_CD,FDOC_REF_NBR,FDOC_REVERSAL_DT,TRN_ENCUM_UPDT_CD,FDOC_APPROVED_CD,ACCT_SF_FINOBJ_CD,TRNENTR_PROCESS_TM) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", new BatchPreparedStatementSetter(){

            public int getBatchSize() {
                return glPendingEntries.size();
            }

            public void setValues(PreparedStatement pstmt, int index) throws SQLException {
                GeneralLedgerPendingEntry generalLedgerPendingEntry = (GeneralLedgerPendingEntry)glPendingEntries.get(index);
                pstmt.setObject(1, generalLedgerPendingEntry.getFinancialSystemOriginationCode());
                pstmt.setObject(2, generalLedgerPendingEntry.getDocumentNumber());
                pstmt.setObject(3, generalLedgerPendingEntry.getTransactionLedgerEntrySequenceNumber());
                pstmt.setObject(4, UUID.randomUUID().toString());
                pstmt.setObject(5, generalLedgerPendingEntry.getVersionNumber());
                pstmt.setObject(6, generalLedgerPendingEntry.getChartOfAccountsCode());
                pstmt.setObject(7, generalLedgerPendingEntry.getAccountNumber());
                pstmt.setObject(8, generalLedgerPendingEntry.getSubAccountNumber());
                pstmt.setObject(9, generalLedgerPendingEntry.getFinancialObjectCode());
                pstmt.setObject(10, generalLedgerPendingEntry.getFinancialSubObjectCode());
                pstmt.setObject(11, generalLedgerPendingEntry.getFinancialBalanceTypeCode());
                pstmt.setObject(12, generalLedgerPendingEntry.getFinancialObjectTypeCode());
                pstmt.setObject(13, generalLedgerPendingEntry.getUniversityFiscalYear());
                pstmt.setObject(14, generalLedgerPendingEntry.getUniversityFiscalPeriodCode());
                pstmt.setObject(15, generalLedgerPendingEntry.getTransactionLedgerEntryDescription());
                pstmt.setObject(16, generalLedgerPendingEntry.getTransactionLedgerEntryAmount().bigDecimalValue());
                pstmt.setObject(17, generalLedgerPendingEntry.getTransactionDebitCreditCode());
                pstmt.setObject(18, generalLedgerPendingEntry.getTransactionDate());
                pstmt.setObject(19, generalLedgerPendingEntry.getFinancialDocumentTypeCode());
                pstmt.setObject(20, generalLedgerPendingEntry.getOrganizationDocumentNumber());
                pstmt.setObject(21, generalLedgerPendingEntry.getProjectCode());
                pstmt.setObject(22, generalLedgerPendingEntry.getOrganizationReferenceId());
                pstmt.setObject(23, generalLedgerPendingEntry.getReferenceFinancialDocumentTypeCode());
                pstmt.setObject(24, generalLedgerPendingEntry.getReferenceFinancialSystemOriginationCode());
                pstmt.setObject(25, generalLedgerPendingEntry.getReferenceFinancialDocumentNumber());
                pstmt.setObject(26, generalLedgerPendingEntry.getFinancialDocumentReversalDate());
                pstmt.setObject(27, generalLedgerPendingEntry.getTransactionEncumbranceUpdateCode());
                pstmt.setObject(28, generalLedgerPendingEntry.getFinancialDocumentApprovedCode());
                pstmt.setObject(29, generalLedgerPendingEntry.getAcctSufficientFundsFinObjCd());
                pstmt.setObject(30, generalLedgerPendingEntry.getTransactionEntryProcessedTs());
            }
        });
    }

    @Override
    public Collection<AssetPaymentInfo> getListOfDepreciableAssetPaymentInfo(Integer fiscalYear, Integer fiscalMonth, Calendar depreciationDate) {
        LOG.debug("getListOfDepreciableAssetPaymentInfo() started");
        LOG.info("DEPRECIATION BATCH - Starting to get the list of depreciable asset payment list.");
        ArrayList<AssetPaymentInfo> assetPaymentDetails = new ArrayList<AssetPaymentInfo>();
        ArrayList<String> depreciationMethodList = new ArrayList<String>();
        Collection notAcceptedAssetStatus = this.parameterService.getParameterValuesAsString(AssetDepreciationStep.class, "NON_DEPRECIABLE_NON_CAPITAL_ASSET_STATUS_CODES");
        depreciationMethodList.add("SV");
        depreciationMethodList.add("SL");
        Collection<String> federallyOwnedObjectSubTypes = this.getFederallyOwnedObjectSubTypes();
        Object sql = "SELECT A0.CPTLAST_NBR,A0.AST_PMT_SEQ_NBR,A1.CPTL_AST_DEPR_DT,A1.AST_DEPR_MTHD1_CD,A1.CPTLAST_SALVAG_AMT,";
        sql = (String)sql + "A2.CPTLAST_DEPRLF_LMT,A5.ORG_PLNT_COA_CD,A5.ORG_PLNT_ACCT_NBR,A5.CMP_PLNT_COA_CD,A5.CMP_PLNT_ACCT_NBR,A3.FIN_OBJ_TYP_CD, ";
        sql = (String)sql + "A3.FIN_OBJ_SUB_TYP_CD, A0.AST_DEPR1_BASE_AMT,A0.FIN_OBJECT_CD, A0.AST_ACUM_DEPR1_AMT,A0.SUB_ACCT_NBR,A0.FIN_SUB_OBJ_CD,A0.PROJECT_CD, A0.FIN_COA_CD, A0.ACCUM_RNDNG_ERR_MILLICENTS";
        sql = (String)sql + this.buildCriteria(fiscalYear, fiscalMonth, depreciationMethodList, notAcceptedAssetStatus, federallyOwnedObjectSubTypes, false, true);
        sql = (String)sql + "ORDER BY A0.CPTLAST_NBR, A0.FS_ORIGIN_CD, A0.ACCOUNT_NBR, A0.SUB_ACCT_NBR, A0.FIN_OBJECT_CD, A0.FIN_SUB_OBJ_CD, A3.FIN_OBJ_TYP_CD, A0.PROJECT_CD";
        this.getJdbcTemplate().query((String)sql, this.preparedStatementSetter(depreciationDate), rs -> {
            int counter = 0;
            while (rs != null && rs.next()) {
                if (++counter % 10000 == 0) {
                    LOG.info("Reading result row at " + new java.util.Date() + " -  " + counter);
                }
                AssetPaymentInfo assetPaymentInfo = new AssetPaymentInfo();
                assetPaymentInfo.setCapitalAssetNumber(rs.getLong(1));
                assetPaymentInfo.setPaymentSequenceNumber(rs.getInt(2));
                assetPaymentInfo.setDepreciationDate(rs.getDate(3));
                String deprMethod = rs.getString(4);
                assetPaymentInfo.setPrimaryDepreciationMethodCode(deprMethod == null ? "SL" : deprMethod);
                BigDecimal salvage = rs.getBigDecimal(5);
                assetPaymentInfo.setSalvageAmount(salvage == null ? KualiDecimal.ZERO : new KualiDecimal(salvage));
                assetPaymentInfo.setDepreciableLifeLimit(rs.getInt(6));
                assetPaymentInfo.setOrganizationPlantChartCode(rs.getString(7));
                assetPaymentInfo.setOrganizationPlantAccountNumber(rs.getString(8));
                assetPaymentInfo.setCampusPlantChartCode(rs.getString(9));
                assetPaymentInfo.setCampusPlantAccountNumber(rs.getString(10));
                assetPaymentInfo.setFinancialObjectTypeCode(rs.getString(11));
                assetPaymentInfo.setFinancialObjectSubTypeCode(rs.getString(12));
                BigDecimal primaryDeprAmt = rs.getBigDecimal(13);
                assetPaymentInfo.setPrimaryDepreciationBaseAmount(primaryDeprAmt == null ? KualiDecimal.ZERO : new KualiDecimal(primaryDeprAmt));
                assetPaymentInfo.setFinancialObjectCode(rs.getString(14));
                BigDecimal accumDeprAmt = rs.getBigDecimal(15);
                assetPaymentInfo.setAccumulatedPrimaryDepreciationAmount(accumDeprAmt == null ? KualiDecimal.ZERO : new KualiDecimal(accumDeprAmt));
                assetPaymentInfo.setSubAccountNumber(rs.getString(16));
                assetPaymentInfo.setFinancialSubObjectCode(rs.getString(17));
                assetPaymentInfo.setProjectCode(rs.getString(18));
                assetPaymentInfo.setChartOfAccountsCode(rs.getString(19));
                assetPaymentInfo.setAccumulatedRoundingErrorInMillicents(rs.getInt(20));
                assetPaymentDetails.add(assetPaymentInfo);
            }
            return assetPaymentDetails;
        });
        LOG.info("DEPRECIATION BATCH - Finished getting list of [" + assetPaymentDetails.size() + "] depreciable asset payment list.");
        return assetPaymentDetails;
    }

    protected PreparedStatementSetter preparedStatementSetter(Calendar depreciationDate) {
        return pstmt -> {
            Calendar DateOf1900 = Calendar.getInstance();
            DateOf1900.set(1900, 0, 1);
            pstmt.setDate(1, new Date(depreciationDate.getTimeInMillis()));
            pstmt.setDate(2, new Date(DateOf1900.getTimeInMillis()));
        };
    }

    protected String buildCriteria(Integer fiscalYear, Integer fiscalMonth, Collection<String> depreciationMethodList, Collection<String> notAcceptedAssetStatus, Collection<String> federallyOwnedObjectSubTypes, boolean includeFederal, boolean includePending) {
        Object sql = "  FROM CM_AST_PAYMENT_T A0 INNER JOIN CM_CPTLAST_T A1 ON A0.CPTLAST_NBR=A1.CPTLAST_NBR INNER JOIN ";
        sql = (String)sql + "CM_ASSET_TYPE_T A2 ON A1.CPTLAST_TYP_CD=A2.CPTLAST_TYP_CD INNER JOIN CA_OBJECT_CODE_T A3 ON " + fiscalYear + "=A3.UNIV_FISCAL_YR ";
        sql = (String)sql + "AND A0.FIN_COA_CD=A3.FIN_COA_CD AND A0.FIN_OBJECT_CD=A3.FIN_OBJECT_CD INNER JOIN CA_ACCOUNT_T A4 ON A0.FIN_COA_CD=A4.FIN_COA_CD ";
        sql = (String)sql + "AND A0.ACCOUNT_NBR=A4.ACCOUNT_NBR INNER JOIN CA_ORG_T A5 ON A4.FIN_COA_CD=A5.FIN_COA_CD AND A4.ORG_CD=A5.ORG_CD ";
        sql = (String)sql + "WHERE  (A0.AST_TRNFR_PMT_CD ";
        sql = (String)sql + "IN ('N','') OR  A0.AST_TRNFR_PMT_CD IS NULL ) AND ( A1.AST_DEPR_MTHD1_CD IS NULL OR A1.AST_DEPR_MTHD1_CD IN (" + this.buildINValues(depreciationMethodList) + ") ) ";
        sql = (String)sql + "AND (A1.CPTL_AST_DEPR_DT IS NOT NULL AND A1.CPTL_AST_DEPR_DT <= ? AND A1.CPTL_AST_DEPR_DT <> ?) AND  ";
        sql = (String)sql + "(A1.AST_RETIR_FSCL_YR IS NULL OR A1.AST_RETIR_PRD_CD IS NULL OR A1.AST_RETIR_FSCL_YR > " + fiscalYear + " OR (A1.AST_RETIR_FSCL_YR = " + fiscalYear + " AND A1.AST_RETIR_PRD_CD > " + fiscalMonth + ")) ";
        Object fiscalPeriodColumn = "AST_PRD";
        if (fiscalMonth >= 1 && fiscalMonth <= 9) {
            fiscalPeriodColumn = (String)fiscalPeriodColumn + fiscalMonth + "_DEPR1_AMT";
        } else if (fiscalMonth >= 10 && fiscalMonth <= 12) {
            fiscalPeriodColumn = (String)fiscalPeriodColumn + fiscalMonth + "DEPR1_AMT";
        } else {
            throw new IllegalArgumentException("Fiscal month " + fiscalMonth + " must be between 1 and 12.");
        }
        sql = (String)sql + "AND (" + (String)fiscalPeriodColumn + " = 0 OR " + (String)fiscalPeriodColumn + " IS NULL) ";
        sql = (String)sql + "AND A1.AST_INVN_STAT_CD NOT IN (" + this.buildINValues(notAcceptedAssetStatus) + ")AND A2.CPTLAST_DEPRLF_LMT > 0 ";
        sql = includeFederal ? (String)sql + "AND A3.FIN_OBJ_SUB_TYP_CD IN (" + this.buildINValues(federallyOwnedObjectSubTypes) + ")" : (String)sql + "AND A3.FIN_OBJ_SUB_TYP_CD NOT IN (" + this.buildINValues(federallyOwnedObjectSubTypes) + ")";
        if (!includePending) {
            sql = (String)sql + " AND NOT EXISTS (SELECT 1 FROM CM_AST_TRNFR_DOC_T TRFR, FS_DOC_HEADER_T HDR WHERE HDR.FDOC_NBR = TRFR.FDOC_NBR AND ";
            sql = (String)sql + " HDR.FDOC_STATUS_CD = 'R' AND TRFR.CPTLAST_NBR = A0.CPTLAST_NBR) ";
            sql = (String)sql + " AND NOT EXISTS (SELECT 1 FROM CM_AST_RETIRE_DTL_T DTL, FS_DOC_HEADER_T HDR WHERE HDR.FDOC_NBR = DTL.FDOC_NBR ";
            sql = (String)sql + " AND HDR.FDOC_STATUS_CD = 'R' AND DTL.CPTLAST_NBR = A0.CPTLAST_NBR) ";
        }
        return sql;
    }

    @Override
    public Integer getFullyDepreciatedAssetCount() {
        LOG.debug("getFullyDepreciatedAssetCount() started");
        return (Integer)this.getJdbcTemplate().queryForObject("SELECT COUNT(1) FROM CM_CPTLAST_T AST, (SELECT CPTLAST_NBR, (SUM(AST_DEPR1_BASE_AMT - AST_ACUM_DEPR1_AMT) - (SELECT 0.0+CPTLAST_SALVAG_AMT FROM CM_CPTLAST_T X WHERE X.CPTLAST_NBR = Y.CPTLAST_NBR)) BAL FROM CM_AST_PAYMENT_T Y WHERE AST_DEPR1_BASE_AMT IS NOT NULL AND AST_DEPR1_BASE_AMT <> 0.0 AND AST_ACUM_DEPR1_AMT IS NOT NULL AND AST_ACUM_DEPR1_AMT <> 0.0 AND (AST_TRNFR_PMT_CD = 'N' OR AST_TRNFR_PMT_CD = '' OR AST_TRNFR_PMT_CD IS NULL) GROUP BY CPTLAST_NBR) PMT WHERE PMT.BAL = 0.0 AND AST.CPTLAST_NBR = PMT.CPTLAST_NBR", Integer.class);
    }

    @Override
    public Object[] getAssetAndPaymentCount(Integer fiscalYear, Integer fiscalMonth, Calendar depreciationDate, boolean includePending) {
        LOG.debug("getAssetAndPaymentCount() started");
        Object[] data = new Object[2];
        ArrayList<String> depreciationMethodList = new ArrayList<String>();
        Collection notAcceptedAssetStatus = this.parameterService.getParameterValuesAsString(AssetDepreciationStep.class, "NON_DEPRECIABLE_NON_CAPITAL_ASSET_STATUS_CODES");
        depreciationMethodList.add("SV");
        depreciationMethodList.add("SL");
        Collection<String> federallyOwnedObjectSubTypes = this.getFederallyOwnedObjectSubTypes();
        String sql = "SELECT COUNT(DISTINCT A0.CPTLAST_NBR), COUNT(1) " + this.buildCriteria(fiscalYear, fiscalMonth, depreciationMethodList, notAcceptedAssetStatus, federallyOwnedObjectSubTypes, false, includePending);
        this.getJdbcTemplate().query(sql, this.preparedStatementSetter(depreciationDate), rs -> {
            if (rs != null && rs.next()) {
                data[0] = rs.getInt(1);
                data[1] = rs.getInt(2);
            }
            return data;
        });
        return data;
    }

    @Override
    public Object[] getFederallyOwnedAssetAndPaymentCount(Integer fiscalYear, Integer fiscalMonth, Calendar depreciationDate) {
        LOG.debug("getFederallyOwnedAssetAndPaymentCount() started");
        Object[] data = new Object[2];
        ArrayList<String> depreciationMethodList = new ArrayList<String>();
        Collection notAcceptedAssetStatus = this.parameterService.getParameterValuesAsString(AssetDepreciationStep.class, "NON_DEPRECIABLE_NON_CAPITAL_ASSET_STATUS_CODES");
        depreciationMethodList.add("SV");
        depreciationMethodList.add("SL");
        Collection<String> federallyOwnedObjectSubTypes = this.getFederallyOwnedObjectSubTypes();
        String sql = "SELECT COUNT(DISTINCT A0.CPTLAST_NBR), COUNT(1) " + this.buildCriteria(fiscalYear, fiscalMonth, depreciationMethodList, notAcceptedAssetStatus, federallyOwnedObjectSubTypes, true, true);
        this.getJdbcTemplate().query(sql, this.preparedStatementSetter(depreciationDate), rs -> {
            if (rs != null && rs.next()) {
                data[0] = rs.getInt(1);
                data[1] = rs.getInt(2);
            }
            return data;
        });
        return data;
    }

    @Override
    public Map<Long, KualiDecimal> getPrimaryDepreciationBaseAmountForSV() {
        LOG.debug("getPrimaryDepreciationBaseAmountForSV() started");
        HashMap<Long, KualiDecimal> amountMap = new HashMap<Long, KualiDecimal>();
        this.getJdbcTemplate().query("SELECT PMT.CPTLAST_NBR, SUM(PMT.AST_DEPR1_BASE_AMT) FROM CM_CPTLAST_T AST, CM_AST_PAYMENT_T PMT WHERE AST.CPTLAST_NBR = PMT.CPTLAST_NBR AND AST.AST_DEPR_MTHD1_CD = 'SV' GROUP BY PMT.CPTLAST_NBR", rs -> {
            while (rs != null && rs.next()) {
                amountMap.put(rs.getLong(1), new KualiDecimal(rs.getBigDecimal(2)));
            }
            return amountMap;
        });
        return amountMap;
    }

    @Override
    public Integer getTransferDocLockedAssetCount() {
        LOG.debug("getTransferDocLockedAssetCount() started");
        return (Integer)this.getJdbcTemplate().queryForObject("select count(1) from CM_AST_TRNFR_DOC_T t inner join FS_DOC_HEADER_T h on t.fdoc_nbr = h.fdoc_nbr where h.fdoc_status_cd ='R'", Integer.class);
    }

    @Override
    public Set<Long> getTransferDocPendingAssets() {
        LOG.debug("getTransferDocPendingAssets() started");
        HashSet<Long> assets = new HashSet<Long>();
        this.getJdbcTemplate().query("select t.cptlast_nbr from CM_AST_TRNFR_DOC_T t inner join FS_DOC_HEADER_T h on t.fdoc_nbr = h.fdoc_nbr where h.fdoc_status_cd = 'R'", rs -> {
            while (rs != null && rs.next()) {
                assets.add(rs.getLong(1));
            }
            return assets;
        });
        return assets;
    }

    @Override
    public Integer getRetireDocLockedAssetCount() {
        LOG.debug("getRetireDocLockedAssetCount() started");
        return (Integer)this.getJdbcTemplate().queryForObject("select count(1) from CM_AST_RETIRE_DTL_T t inner join FS_DOC_HEADER_T h on t.fdoc_nbr = h.fdoc_nbr where h.fdoc_status_cd  ='R'", Integer.class);
    }

    @Override
    public Set<Long> getLockedAssets() {
        LOG.debug("getLockedAssets() started");
        HashSet<Long> assets = new HashSet<Long>();
        this.getJdbcTemplate().query("select t.cptlast_nbr from CM_AST_RETIRE_DTL_T t inner join FS_DOC_HEADER_T h on t.fdoc_nbr = h.fdoc_nbr where h.fdoc_status_cd = 'R' union select t.cptlast_nbr from CM_AST_TRNFR_DOC_T t inner join FS_DOC_HEADER_T h on t.fdoc_nbr = h.fdoc_nbr where h.fdoc_status_cd = 'R'", rs -> {
            assets.add(rs.getLong(1));
            return assets;
        });
        return assets;
    }

    protected String buildINValues(Collection<String> list) {
        if (list.isEmpty()) {
            return "''";
        }
        Object returnValue = "";
        for (String string : list) {
            returnValue = (String)returnValue + "'" + string + "',";
        }
        return ((String)returnValue).substring(0, ((String)returnValue).lastIndexOf(44));
    }

    protected Collection<String> getFederallyOwnedObjectSubTypes() {
        return this.parameterService.parameterExists(AssetDepreciationStep.class, "NON_DEPRECIABLE_FEDERALLY_OWNED_OBJECT_SUB_TYPES") != false ? this.parameterService.getParameterValuesAsString(AssetDepreciationStep.class, "NON_DEPRECIABLE_FEDERALLY_OWNED_OBJECT_SUB_TYPES") : new ArrayList<String>();
    }

    @Override
    public List<Map<String, Object>> getAssetsByDepreciationConvention(Date lastFiscalYearDate, List<String> movableEquipmentObjectSubTypes, String depreciationConventionCd) {
        LOG.debug("getAssetsByDepreciationConvention() started");
        String sql = "SELECT A0.CPTLAST_NBR FROM CM_CPTLAST_T A0, CM_AST_DEPR_CNVNTN_T A1, CM_ASSET_TYPE_T A2 WHERE A0.CPTLAST_CRT_DT > ? AND A0.FIN_OBJ_SUB_TYP_CD IN (" + this.buildINValues(movableEquipmentObjectSubTypes) + ") AND A0.FIN_OBJ_SUB_TYP_CD = A1.FIN_OBJ_SUB_TYPE_CD AND A1.CPTL_AST_DEPR_CNVNTN_CD = ? AND A2.CPTLAST_TYP_CD=A0.CPTLAST_TYP_CD AND A0.CPTLAST_TYP_CD IS NOT NULL AND A2.CPTLAST_DEPRLF_LMT IS NOT NULL AND A2.CPTLAST_DEPRLF_LMT != 0";
        return this.getJdbcTemplate().queryForList(sql, new Object[]{lastFiscalYearDate, depreciationConventionCd});
    }

    @Override
    public void updateAssetInServiceAndDepreciationDate(List<String> selectedAssets, Date inServiceDate, Date depreciationDate) {
        LOG.debug("updateAssetInServiceAndDepreciationDate() started");
        AccountingPeriod acctPeriod = this.accountingPeriodService.getByDate(inServiceDate);
        this.getJdbcTemplate().update("UPDATE CM_CPTLAST_T SET CPTL_AST_IN_SRVC_DT=?, CPTL_AST_DEPR_DT=?, FDOC_POST_PRD_CD=? , FDOC_POST_YR=? WHERE CPTLAST_NBR IN (" + this.buildINValues(selectedAssets) + ")", ps -> {
            ps.setDate(1, inServiceDate);
            ps.setDate(2, depreciationDate);
            ps.setString(3, acctPeriod.getUniversityFiscalPeriodCode());
            ps.setInt(4, acctPeriod.getUniversityFiscalYear());
        });
    }

    public void setAccountingPeriodService(AccountingPeriodService accountingPeriodService) {
        this.accountingPeriodService = accountingPeriodService;
    }

    public void setUniversityDateDao(UniversityDateDao universityDateDao) {
        this.universityDateDao = universityDateDao;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

