/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service.impl;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.businessobject.OffsetDefinition;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.coa.service.OffsetDefinitionService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.batch.AssetDepreciationStep;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetAcquisitionType;
import org.kuali.kfs.module.cam.businessobject.AssetGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetGlobalDetail;
import org.kuali.kfs.module.cam.businessobject.AssetGlpeSourceDetail;
import org.kuali.kfs.module.cam.businessobject.AssetLocation;
import org.kuali.kfs.module.cam.businessobject.AssetObjectCode;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentDetail;
import org.kuali.kfs.module.cam.document.gl.CamsGeneralLedgerPendingEntrySourceBase;
import org.kuali.kfs.module.cam.document.service.AssetGlobalService;
import org.kuali.kfs.module.cam.document.service.AssetObjectCodeService;
import org.kuali.kfs.module.cam.document.service.AssetPaymentService;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.module.cam.document.service.PaymentSummaryService;
import org.kuali.kfs.module.cam.util.AssetSeparatePaymentDistributor;
import org.kuali.kfs.module.cam.util.KualiDecimalUtils;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class AssetGlobalServiceImpl
implements AssetGlobalService {
    protected ParameterService parameterService;
    protected AssetService assetService;
    protected UniversityDateService universityDateService;
    protected AssetObjectCodeService assetObjectCodeService;
    protected BusinessObjectService businessObjectService;
    protected AssetPaymentService assetPaymentService;
    protected PaymentSummaryService paymentSummaryService;
    protected DateTimeService dateTimeService;
    protected ObjectCodeService objectCodeService;
    protected OffsetDefinitionService offsetDefinitionService;
    private static final Logger LOG = LogManager.getLogger(AssetGlobalServiceImpl.class);

    protected AssetGlpeSourceDetail createAssetGlpePostable(AssetGlobal document, AssetPaymentDetail assetPaymentDetail, AmountCategory amountCategory) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Start - createAssetGlpePostable (" + document.getDocumentNumber() + "-" + assetPaymentDetail.getAccountNumber() + ")");
        }
        AssetGlpeSourceDetail postable = new AssetGlpeSourceDetail();
        assetPaymentDetail.refreshReferenceObject("account");
        postable.setAccount(assetPaymentDetail.getAccount());
        postable.setAmount(assetPaymentDetail.getAmount());
        postable.setAccountNumber(assetPaymentDetail.getAccountNumber());
        postable.setBalanceTypeCode("AC");
        postable.setChartOfAccountsCode(assetPaymentDetail.getChartOfAccountsCode());
        postable.setDocumentNumber(document.getDocumentNumber());
        postable.setFinancialSubObjectCode(assetPaymentDetail.getFinancialSubObjectCode());
        postable.setPostingYear(this.universityDateService.getCurrentUniversityDate().getUniversityFiscalYear());
        postable.setProjectCode(assetPaymentDetail.getProjectCode());
        postable.setSubAccountNumber(assetPaymentDetail.getSubAccountNumber());
        postable.setOrganizationReferenceId(assetPaymentDetail.getOrganizationReferenceId());
        assetPaymentDetail.refreshReferenceObject("objectCode");
        ObjectCode objectCode = this.objectCodeService.getByPrimaryIdForCurrentYear(assetPaymentDetail.getChartOfAccountsCode(), assetPaymentDetail.getFinancialObjectCode());
        AssetObjectCode assetObjectCode = this.assetObjectCodeService.findAssetObjectCode(assetPaymentDetail.getChartOfAccountsCode(), objectCode.getFinancialObjectSubTypeCode());
        OffsetDefinition offsetDefinition = this.offsetDefinitionService.getByPrimaryId(this.universityDateService.getCurrentFiscalYear(), assetPaymentDetail.getChartOfAccountsCode(), "AT", "AC");
        document.refreshReferenceObject("acquisitionType");
        amountCategory.setParams(postable, assetPaymentDetail, assetObjectCode, offsetDefinition, document.getAcquisitionType());
        if (LOG.isDebugEnabled()) {
            LOG.debug("End - createAssetGlpePostable(" + document.getDocumentNumber() + "-" + assetPaymentDetail.getAccountNumber() + "-)");
        }
        return postable;
    }

    @Override
    public void createGLPostables(AssetGlobal assetGlobal, CamsGeneralLedgerPendingEntrySourceBase assetGlobalGlPoster) {
        List<AssetPaymentDetail> assetPaymentDetails = assetGlobal.getAssetPaymentDetails();
        for (AssetPaymentDetail assetPaymentDetail : assetPaymentDetails) {
            KualiDecimal accountChargeAmount;
            if (!this.isPaymentFinancialObjectActive(assetPaymentDetail) || (accountChargeAmount = assetPaymentDetail.getAmount()) == null || accountChargeAmount.isZero()) continue;
            assetGlobalGlPoster.getGeneralLedgerPendingEntrySourceDetails().add(this.createAssetGlpePostable(assetGlobal, assetPaymentDetail, AmountCategory.PAYMENT));
            assetGlobalGlPoster.getGeneralLedgerPendingEntrySourceDetails().add(this.createAssetGlpePostable(assetGlobal, assetPaymentDetail, AmountCategory.PAYMENT_OFFSET));
        }
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setAssetObjectCodeService(AssetObjectCodeService assetObjectCodeService) {
        this.assetObjectCodeService = assetObjectCodeService;
    }

    public void setAssetPaymentService(AssetPaymentService assetPaymentService) {
        this.assetPaymentService = assetPaymentService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    @Override
    public KualiDecimal totalPaymentByAsset(AssetGlobal assetGlobal, boolean lastEntry) {
        KualiDecimal assetTotalAmount = KualiDecimal.ZERO;
        List<AssetPaymentDetail> assetPaymentDetails = assetGlobal.getAssetPaymentDetails();
        int numberOfTotalAsset = assetGlobal.getAssetGlobalDetails().size();
        if (numberOfTotalAsset > 0) {
            for (AssetPaymentDetail assetPaymentDetail : assetPaymentDetails) {
                KualiDecimal assetPaymentUnitCost = (KualiDecimal)assetPaymentDetail.getAmount().divide((AbstractKualiDecimal)new KualiDecimal(numberOfTotalAsset));
                if (lastEntry) {
                    assetPaymentUnitCost = (KualiDecimal)assetPaymentDetail.getAmount().subtract((AbstractKualiDecimal)((KualiDecimal)assetPaymentUnitCost.multiply((AbstractKualiDecimal)new KualiDecimal(numberOfTotalAsset - 1))));
                }
                assetTotalAmount = (KualiDecimal)assetTotalAmount.add((AbstractKualiDecimal)assetPaymentUnitCost);
            }
        }
        return assetTotalAmount;
    }

    @Override
    public boolean existsInGroup(String groupName, String memberName) {
        if (StringUtils.isBlank((CharSequence)groupName) || StringUtils.isBlank((CharSequence)memberName)) {
            return false;
        }
        return Arrays.asList(groupName.split(";")).contains(memberName);
    }

    protected boolean isPaymentFinancialObjectActive(AssetPaymentDetail assetPayment) {
        ObjectCode financialObjectCode = this.objectCodeService.getByPrimaryIdForCurrentYear(assetPayment.getChartOfAccountsCode(), assetPayment.getFinancialObjectCode());
        if (financialObjectCode != null) {
            return financialObjectCode.isActive();
        }
        return false;
    }

    public void setAssetService(AssetService assetService) {
        this.assetService = assetService;
    }

    @Override
    public boolean isAssetSeparate(AssetGlobal assetGlobal) {
        return ObjectUtils.isNotNull((Object)assetGlobal.getFinancialDocumentTypeCode()) && assetGlobal.getFinancialDocumentTypeCode().equals("ASEP");
    }

    @Override
    public boolean isAssetSeparateByPayment(AssetGlobal assetGlobal) {
        return this.isAssetSeparate(assetGlobal) && ObjectUtils.isNotNull((Object)assetGlobal.getSeparateSourcePaymentSequenceNumber());
    }

    @Override
    public KualiDecimal getUniqueAssetsTotalAmount(AssetGlobal assetGlobal) {
        KualiDecimal totalAmount = KualiDecimal.ZERO;
        for (AssetGlobalDetail assetSharedDetail : assetGlobal.getAssetSharedDetails()) {
            for (AssetGlobalDetail assetGlobalUniqueDetail : assetSharedDetail.getAssetGlobalUniqueDetails()) {
                KualiDecimal separateSourceAmount = assetGlobalUniqueDetail.getSeparateSourceAmount();
                if (separateSourceAmount == null) continue;
                totalAmount = (KualiDecimal)totalAmount.add((AbstractKualiDecimal)separateSourceAmount);
            }
        }
        return totalAmount;
    }

    @Override
    public List<PersistableBusinessObject> getCreateNewAssets(AssetGlobal assetGlobal) {
        ArrayList<PersistableBusinessObject> persistables = new ArrayList<PersistableBusinessObject>();
        Iterator<AssetGlobalDetail> assetGlobalDetailsIterator = assetGlobal.getAssetGlobalDetails().iterator();
        int assetGlobalDetailsIndex = 0;
        while (assetGlobalDetailsIterator.hasNext()) {
            AssetGlobalDetail assetGlobalDetail = assetGlobalDetailsIterator.next();
            Asset asset = this.setupAsset(assetGlobal, assetGlobalDetail, false);
            KualiDecimal paymentsAccountChargeAmount = new KualiDecimal(0);
            for (AssetPaymentDetail assetPaymentDetail : assetGlobal.getAssetPaymentDetails()) {
                AssetPayment assetPayment = this.setupCreateNewAssetPayment(assetGlobalDetail.getCapitalAssetNumber(), assetGlobal.getAcquisitionTypeCode(), assetGlobal.getAssetGlobalDetails().size(), assetGlobalDetailsIndex, assetPaymentDetail);
                paymentsAccountChargeAmount = (KualiDecimal)paymentsAccountChargeAmount.add((AbstractKualiDecimal)assetPayment.getAccountChargeAmount());
                asset.getAssetPayments().add(assetPayment);
            }
            asset.setTotalCostAmount(paymentsAccountChargeAmount);
            persistables.add((PersistableBusinessObject)asset);
            ++assetGlobalDetailsIndex;
        }
        return persistables;
    }

    @Override
    public List<PersistableBusinessObject> getSeparateAssets(AssetGlobal assetGlobal) {
        Asset separateSourceCapitalAsset = assetGlobal.getSeparateSourceCapitalAsset();
        ArrayList<AssetPayment> sourcePayments = new ArrayList<AssetPayment>();
        for (AssetPayment assetPayment : separateSourceCapitalAsset.getAssetPayments()) {
            if (!this.isAssetSeparateByPayment(assetGlobal)) {
                sourcePayments.add(assetPayment);
                continue;
            }
            if (!assetPayment.getPaymentSequenceNumber().equals(assetGlobal.getSeparateSourcePaymentSequenceNumber())) continue;
            sourcePayments.add(assetPayment);
            break;
        }
        ArrayList<Asset> newAssets = new ArrayList<Asset>();
        for (AssetGlobalDetail assetGlobalDetail : assetGlobal.getAssetGlobalDetails()) {
            newAssets.add(this.setupAsset(assetGlobal, assetGlobalDetail, true));
        }
        KualiDecimal kualiDecimal = assetGlobal.getSeparateSourceCapitalAsset().getTotalCostAmount();
        if (kualiDecimal.isZero()) {
            separateSourceCapitalAsset.setSalvageAmount(KualiDecimal.ZERO);
            separateSourceCapitalAsset.setReplacementAmount(KualiDecimal.ZERO);
            separateSourceCapitalAsset.setFabricationEstimatedTotalAmount(KualiDecimal.ZERO);
        } else {
            double separateRatio = 1.0 - assetGlobal.getSeparateSourceTotalAmount().doubleValue() / kualiDecimal.doubleValue();
            separateSourceCapitalAsset.setSalvageAmount(KualiDecimalUtils.safeMultiply(assetGlobal.getSeparateSourceCapitalAsset().getSalvageAmount(), separateRatio));
            separateSourceCapitalAsset.setReplacementAmount(KualiDecimalUtils.safeMultiply(assetGlobal.getSeparateSourceCapitalAsset().getReplacementAmount(), separateRatio));
            separateSourceCapitalAsset.setFabricationEstimatedTotalAmount(KualiDecimalUtils.safeMultiply(assetGlobal.getSeparateSourceCapitalAsset().getFabricationEstimatedTotalAmount(), separateRatio));
        }
        Integer maxSequenceNumber = this.assetPaymentService.getMaxSequenceNumber(separateSourceCapitalAsset.getCapitalAssetNumber());
        AssetSeparatePaymentDistributor distributor = new AssetSeparatePaymentDistributor(separateSourceCapitalAsset, sourcePayments, maxSequenceNumber, assetGlobal, newAssets);
        distributor.distribute();
        separateSourceCapitalAsset.setTotalCostAmount(this.paymentSummaryService.calculatePaymentTotalCost(separateSourceCapitalAsset));
        ArrayList<PersistableBusinessObject> persistables = new ArrayList<PersistableBusinessObject>();
        persistables.add((PersistableBusinessObject)separateSourceCapitalAsset);
        persistables.addAll(newAssets);
        return persistables;
    }

    protected Asset setupAsset(AssetGlobal assetGlobal, AssetGlobalDetail assetGlobalDetail, boolean separate) {
        boolean offCampus;
        Asset asset = new Asset(assetGlobal, assetGlobalDetail, separate);
        if (!assetGlobal.getAssetPaymentDetails().isEmpty() && ObjectUtils.isNotNull((Object)assetGlobal.getAssetPaymentDetails().get(0).getObjectCode())) {
            AssetPaymentDetail assetPaymentDetail = assetGlobal.getAssetPaymentDetails().get(0);
            ObjectCode objectCode = this.objectCodeService.getByPrimaryIdForCurrentYear(assetPaymentDetail.getChartOfAccountsCode(), assetPaymentDetail.getFinancialObjectCode());
            asset.setFinancialObjectSubTypeCode(objectCode.getFinancialObjectSubTypeCode());
        }
        boolean bl = offCampus = StringUtils.isNotBlank((CharSequence)assetGlobalDetail.getOffCampusName()) || StringUtils.isNotBlank((CharSequence)assetGlobalDetail.getOffCampusAddress()) || StringUtils.isNotBlank((CharSequence)assetGlobalDetail.getOffCampusCityName()) || StringUtils.isNotBlank((CharSequence)assetGlobalDetail.getOffCampusStateCode()) || StringUtils.isNotBlank((CharSequence)assetGlobalDetail.getOffCampusZipCode()) || StringUtils.isNotBlank((CharSequence)assetGlobalDetail.getOffCampusCountryCode());
        if (offCampus) {
            this.setupAssetLocationOffCampus(assetGlobalDetail, asset);
        }
        if (separate) {
            KualiDecimal divisor = assetGlobal.getSeparateSourceCapitalAsset().getTotalCostAmount();
            if (divisor.isZero()) {
                asset.setSalvageAmount(KualiDecimal.ZERO);
                asset.setReplacementAmount(KualiDecimal.ZERO);
                asset.setFabricationEstimatedTotalAmount(KualiDecimal.ZERO);
            } else {
                double separateRatio = assetGlobalDetail.getSeparateSourceAmount().doubleValue() / divisor.doubleValue();
                asset.setSalvageAmount(KualiDecimalUtils.safeMultiply(assetGlobal.getSeparateSourceCapitalAsset().getSalvageAmount(), separateRatio));
                asset.setReplacementAmount(KualiDecimalUtils.safeMultiply(assetGlobal.getSeparateSourceCapitalAsset().getReplacementAmount(), separateRatio));
                asset.setFabricationEstimatedTotalAmount(KualiDecimalUtils.safeMultiply(assetGlobal.getSeparateSourceCapitalAsset().getFabricationEstimatedTotalAmount(), separateRatio));
            }
            Date lastInventoryDate = assetGlobal.getLastInventoryDate();
            if (lastInventoryDate != null) {
                asset.setLastInventoryDate(new Timestamp(lastInventoryDate.getTime()));
            }
        }
        return asset;
    }

    protected void setupAssetLocationOffCampus(AssetGlobalDetail assetGlobalDetail, Asset asset) {
        AssetLocation offCampusAssetLocation = new AssetLocation();
        offCampusAssetLocation.setCapitalAssetNumber(asset.getCapitalAssetNumber());
        offCampusAssetLocation.setAssetLocationTypeCode("O");
        asset.getAssetLocations().add(offCampusAssetLocation);
        offCampusAssetLocation.setAssetLocationContactName(assetGlobalDetail.getOffCampusName());
        offCampusAssetLocation.setAssetLocationContactIdentifier(assetGlobalDetail.getRepresentativeUniversalIdentifier());
        offCampusAssetLocation.setAssetLocationInstitutionName(assetGlobalDetail.getAssetRepresentative().getPrimaryDepartmentCode());
        offCampusAssetLocation.setAssetLocationStreetAddress(assetGlobalDetail.getOffCampusAddress());
        offCampusAssetLocation.setAssetLocationCityName(assetGlobalDetail.getOffCampusCityName());
        offCampusAssetLocation.setAssetLocationStateCode(assetGlobalDetail.getOffCampusStateCode());
        offCampusAssetLocation.setAssetLocationCountryCode(assetGlobalDetail.getOffCampusCountryCode());
        offCampusAssetLocation.setAssetLocationZipCode(assetGlobalDetail.getOffCampusZipCode());
        offCampusAssetLocation.setAssetLocationPhoneNumber(null);
    }

    protected AssetPayment setupCreateNewAssetPayment(Long capitalAssetNumber, String acquisitionTypeCode, int assetGlobalDetailsSize, int assetGlobalDetailsIndex, AssetPaymentDetail assetPaymentDetail) {
        boolean isDepreciablePayment;
        AssetPayment assetPayment = new AssetPayment(assetPaymentDetail, acquisitionTypeCode);
        assetPayment.setCapitalAssetNumber(capitalAssetNumber);
        assetPayment.setPaymentSequenceNumber(assetPaymentDetail.getSequenceNumber());
        assetPayment.setTransferPaymentCode("N");
        KualiDecimal[] amountBuckets = KualiDecimalUtils.allocateByQuantity(assetPaymentDetail.getAmount(), assetGlobalDetailsSize);
        assetPayment.setAccountChargeAmount(amountBuckets[assetGlobalDetailsIndex]);
        ObjectCode objectCode = this.objectCodeService.getByPrimaryIdForCurrentYear(assetPayment.getChartOfAccountsCode(), assetPayment.getFinancialObjectCode());
        boolean bl = isDepreciablePayment = ObjectUtils.isNotNull((Object)assetPaymentDetail.getObjectCode()) && !Arrays.asList(this.parameterService.getParameterValueAsString(AssetDepreciationStep.class, "NON_DEPRECIABLE_FEDERALLY_OWNED_OBJECT_SUB_TYPES").split(";")).contains(objectCode.getFinancialObjectSubTypeCode());
        if (isDepreciablePayment) {
            assetPayment.setPrimaryDepreciationBaseAmount(amountBuckets[assetGlobalDetailsIndex]);
        } else {
            assetPayment.setPrimaryDepreciationBaseAmount(KualiDecimal.ZERO);
        }
        return assetPayment;
    }

    public void setPaymentSummaryService(PaymentSummaryService paymentSummaryService) {
        this.paymentSummaryService = paymentSummaryService;
    }

    @Override
    public String getNewAcquisitionTypeCode() {
        return this.parameterService.getParameterValueAsString(AssetGlobal.class, "NEW_ACQUISITION_CODE");
    }

    @Override
    public String getCapitalObjectAcquisitionCodeGroup() {
        return this.parameterService.getParameterValueAsString(AssetGlobal.class, "CAPITAL_OBJECT_ACQUISITION_CODES");
    }

    @Override
    public String getNonNewAcquisitionCodeGroup() {
        return this.parameterService.getParameterValueAsString(AssetGlobal.class, "NON_NEW_ACQUISITION_CODES");
    }

    @Override
    public String getFiscalYearEndDayAndMonth() {
        String yearEndDateAndMonth = this.parameterService.getParameterValueAsString(KfsParameterConstants.CAPITAL_ASSETS_ALL.class, "FISCAL_YEAR_END_MONTH_AND_DAY");
        return yearEndDateAndMonth.substring(0, 2).concat("/").concat(yearEndDateAndMonth.substring(2, 4));
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setObjectCodeService(ObjectCodeService objectCodeService) {
        this.objectCodeService = objectCodeService;
    }

    public void setOffsetDefinitionService(OffsetDefinitionService offsetDefinitionService) {
        this.offsetDefinitionService = offsetDefinitionService;
    }

    protected static enum AmountCategory {
        PAYMENT{

            @Override
            void setParams(AssetGlpeSourceDetail postable, AssetPaymentDetail assetPaymentDetail, AssetObjectCode assetObjectCode, OffsetDefinition offsetDefinition, AssetAcquisitionType acquisitionType) {
                postable.setPayment(true);
                postable.setFinancialDocumentLineDescription("Payment");
                postable.setFinancialObjectCode(assetPaymentDetail.getFinancialObjectCode());
                postable.setObjectCode(assetPaymentDetail.getObjectCode());
            }
        }
        ,
        PAYMENT_OFFSET{

            @Override
            void setParams(AssetGlpeSourceDetail postable, AssetPaymentDetail assetPaymentDetail, AssetObjectCode assetObjectCode, OffsetDefinition offsetDefinition, AssetAcquisitionType acquisitionType) {
                postable.setPaymentOffset(true);
                postable.setFinancialDocumentLineDescription("Payment Offset");
                postable.setFinancialObjectCode(acquisitionType.getIncomeAssetObjectCode());
                postable.setObjectCode(((ObjectCodeService)SpringContext.getBean(ObjectCodeService.class)).getByPrimaryId(assetPaymentDetail.getPostingYear(), assetPaymentDetail.getChartOfAccountsCode(), acquisitionType.getIncomeAssetObjectCode()));
            }
        };


        abstract void setParams(AssetGlpeSourceDetail var1, AssetPaymentDetail var2, AssetObjectCode var3, OffsetDefinition var4, AssetAcquisitionType var5);
    }
}

