/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service.impl;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.datadictionary.legacy.BusinessObjectDictionaryService;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.datadictionary.legacy.DocumentDictionaryService;
import org.kuali.kfs.kns.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.krad.datadictionary.DataDictionaryEntry;
import org.kuali.kfs.krad.document.DocumentBase;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetLocation;
import org.kuali.kfs.module.cam.businessobject.AssetType;
import org.kuali.kfs.module.cam.document.service.AssetLocationService;
import org.kuali.kfs.sys.businessobject.State;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.LocationService;
import org.kuali.rice.krad.bo.BusinessObject;

public class AssetLocationServiceImpl
implements AssetLocationService {
    private BusinessObjectDictionaryService businessObjectDictionaryService;
    private BusinessObjectService businessObjectService;
    private DataDictionaryService DataDictionaryService;
    private DocumentDictionaryService documentDictionaryService;

    @Override
    public void setOffCampusLocation(Asset asset) {
        List<AssetLocation> assetLocations = asset.getAssetLocations();
        AssetLocation offCampusLocation = null;
        for (AssetLocation location : assetLocations) {
            if (!"O".equalsIgnoreCase(location.getAssetLocationTypeCode())) continue;
            offCampusLocation = new AssetLocation(location);
            break;
        }
        if (ObjectUtils.isNull(offCampusLocation)) {
            offCampusLocation = new AssetLocation(asset.getCapitalAssetNumber());
            offCampusLocation.setAssetLocationTypeCode("O");
        }
        asset.setOffCampusLocation(offCampusLocation);
    }

    @Override
    public void updateOffCampusLocation(Asset asset) {
        AssetLocation offLocation = asset.getOffCampusLocation();
        boolean isOffCampusEmpty = this.isOffCampusLocationEmpty(offLocation);
        AssetLocation removableOffCampusLocation = null;
        for (AssetLocation location : asset.getAssetLocations()) {
            if (!"O".equalsIgnoreCase(location.getAssetLocationTypeCode())) continue;
            if (isOffCampusEmpty) {
                removableOffCampusLocation = location;
                continue;
            }
            location.setAssetLocationCityName(offLocation.getAssetLocationCityName());
            location.setAssetLocationContactIdentifier(offLocation.getAssetLocationContactIdentifier());
            location.setAssetLocationContactName(offLocation.getAssetLocationContactName());
            location.setAssetLocationCountryCode(offLocation.getAssetLocationCountryCode());
            location.setAssetLocationInstitutionName(offLocation.getAssetLocationInstitutionName());
            location.setAssetLocationPhoneNumber(offLocation.getAssetLocationPhoneNumber());
            location.setAssetLocationStateCode(offLocation.getAssetLocationStateCode());
            location.setAssetLocationStreetAddress(offLocation.getAssetLocationStreetAddress());
            location.setAssetLocationZipCode(offLocation.getAssetLocationZipCode());
            return;
        }
        if (removableOffCampusLocation != null) {
            asset.getAssetLocations().remove((Object)removableOffCampusLocation);
        } else if (!isOffCampusEmpty) {
            asset.getAssetLocations().add(offLocation);
        }
    }

    @Override
    public boolean isOffCampusLocationExists(AssetLocation offCampusLocation) {
        if (ObjectUtils.isNotNull((Object)((Object)offCampusLocation))) {
            return "O".equalsIgnoreCase(offCampusLocation.getAssetLocationTypeCode());
        }
        return false;
    }

    @Override
    public boolean isOffCampusLocationEmpty(AssetLocation offCampusLocation) {
        if (ObjectUtils.isNotNull((Object)((Object)offCampusLocation))) {
            return StringUtils.isBlank((CharSequence)offCampusLocation.getAssetLocationCityName()) && StringUtils.isBlank((CharSequence)offCampusLocation.getAssetLocationContactIdentifier()) && StringUtils.isBlank((CharSequence)offCampusLocation.getAssetLocationContactName()) && StringUtils.isBlank((CharSequence)offCampusLocation.getAssetLocationCountryCode()) && StringUtils.isBlank((CharSequence)offCampusLocation.getAssetLocationInstitutionName()) && StringUtils.isBlank((CharSequence)offCampusLocation.getAssetLocationPhoneNumber()) && StringUtils.isBlank((CharSequence)offCampusLocation.getAssetLocationStateCode()) && StringUtils.isBlank((CharSequence)offCampusLocation.getAssetLocationStreetAddress()) && StringUtils.isBlank((CharSequence)offCampusLocation.getAssetLocationZipCode());
        }
        return true;
    }

    @Override
    public boolean validateLocation(Map<AssetLocationService.LocationField, String> fieldMap, BusinessObject businessObject, boolean isCapital, AssetType assetType) {
        boolean valid;
        boolean offCampus;
        BusinessObjectEntry ddEntry;
        String campusCode = this.readPropertyValue(businessObject, fieldMap, AssetLocationService.LocationField.CAMPUS_CODE);
        String buildingCode = this.readPropertyValue(businessObject, fieldMap, AssetLocationService.LocationField.BUILDING_CODE);
        String roomNumber = this.readPropertyValue(businessObject, fieldMap, AssetLocationService.LocationField.ROOM_NUMBER);
        String subRoomNumber = this.readPropertyValue(businessObject, fieldMap, AssetLocationService.LocationField.SUB_ROOM_NUMBER);
        String contactName = this.readPropertyValue(businessObject, fieldMap, AssetLocationService.LocationField.CONTACT_NAME);
        String streetAddress = this.readPropertyValue(businessObject, fieldMap, AssetLocationService.LocationField.STREET_ADDRESS);
        String cityName = this.readPropertyValue(businessObject, fieldMap, AssetLocationService.LocationField.CITY_NAME);
        String stateCode = this.readPropertyValue(businessObject, fieldMap, AssetLocationService.LocationField.STATE_CODE);
        String zipCode = this.readPropertyValue(businessObject, fieldMap, AssetLocationService.LocationField.ZIP_CODE);
        String countryCode = this.readPropertyValue(businessObject, fieldMap, AssetLocationService.LocationField.COUNTRY_CODE);
        DataDictionaryService ddService = this.getDataDictionaryService();
        if (DocumentBase.class.isAssignableFrom(businessObject.getClass())) {
            String docTypeName = ddService.getDocumentTypeNameByClass(businessObject.getClass());
            ddEntry = this.documentDictionaryService.getDocumentEntry(docTypeName);
        } else {
            ddEntry = this.businessObjectDictionaryService.getBusinessObjectEntry(businessObject.getClass().getName());
        }
        boolean onCampus = StringUtils.isNotBlank((CharSequence)buildingCode) || StringUtils.isNotBlank((CharSequence)roomNumber) || StringUtils.isNotBlank((CharSequence)subRoomNumber);
        boolean bl = offCampus = StringUtils.isNotBlank((CharSequence)contactName) || StringUtils.isNotBlank((CharSequence)streetAddress) || StringUtils.isNotBlank((CharSequence)cityName) || StringUtils.isNotBlank((CharSequence)stateCode) || StringUtils.isNotBlank((CharSequence)zipCode) || StringUtils.isNotBlank((CharSequence)countryCode);
        if (onCampus && offCampus) {
            this.putError(fieldMap, AssetLocationService.LocationField.BUILDING_CODE, "error.location.choose.right", new String[0]);
            valid = false;
        } else {
            valid = isCapital ? this.validateCapitalAssetLocation(assetType, fieldMap, campusCode, buildingCode, roomNumber, subRoomNumber, contactName, streetAddress, cityName, stateCode, zipCode, countryCode, onCampus, offCampus, (DataDictionaryEntry)ddEntry) : this.validateNonCapitalAssetLocation(fieldMap, contactName, streetAddress, cityName, stateCode, zipCode, countryCode, onCampus, offCampus);
        }
        return valid;
    }

    protected boolean validateCapitalAssetLocation(AssetType assetType, Map<AssetLocationService.LocationField, String> fieldMap, String campusCode, String buildingCode, String roomNumber, String subRoomNumber, String contactName, String streetAddress, String cityName, String stateCode, String zipCode, String countryCode, boolean onCampus, boolean offCampus, DataDictionaryEntry businessObjectEntry) {
        boolean valid = true;
        if (ObjectUtils.isNull((Object)((Object)assetType))) {
            GlobalVariables.getMessageMap().putErrorForSectionId("Location Information", "error.choose.asset.type.validate.location", new String[0]);
            valid = false;
        } else if (assetType.isRequiredBuildingIndicator() && offCampus) {
            String label;
            if (StringUtils.isNotBlank((CharSequence)contactName)) {
                label = businessObjectEntry.getAttributeDefinition(fieldMap.get((Object)AssetLocationService.LocationField.CONTACT_NAME)).getLabel();
                this.putError(fieldMap, AssetLocationService.LocationField.CONTACT_NAME, "error.location.not.permitted.asset.type", label, assetType.getCapitalAssetTypeDescription());
                valid = false;
            }
            if (StringUtils.isNotBlank((CharSequence)streetAddress)) {
                label = businessObjectEntry.getAttributeDefinition(fieldMap.get((Object)AssetLocationService.LocationField.STREET_ADDRESS)).getLabel();
                this.putError(fieldMap, AssetLocationService.LocationField.STREET_ADDRESS, "error.location.not.permitted.asset.type", label, assetType.getCapitalAssetTypeDescription());
                valid = false;
            }
            if (StringUtils.isNotBlank((CharSequence)cityName)) {
                label = businessObjectEntry.getAttributeDefinition(fieldMap.get((Object)AssetLocationService.LocationField.CITY_NAME)).getLabel();
                this.putError(fieldMap, AssetLocationService.LocationField.CITY_NAME, "error.location.not.permitted.asset.type", label, assetType.getCapitalAssetTypeDescription());
                valid = false;
            }
            if (StringUtils.isNotBlank((CharSequence)stateCode)) {
                label = businessObjectEntry.getAttributeDefinition(fieldMap.get((Object)AssetLocationService.LocationField.STATE_CODE)).getLabel();
                this.putError(fieldMap, AssetLocationService.LocationField.STATE_CODE, "error.location.not.permitted.asset.type", label, assetType.getCapitalAssetTypeDescription());
                valid = false;
            }
            if (StringUtils.isNotBlank((CharSequence)zipCode)) {
                label = businessObjectEntry.getAttributeDefinition(fieldMap.get((Object)AssetLocationService.LocationField.ZIP_CODE)).getLabel();
                this.putError(fieldMap, AssetLocationService.LocationField.ZIP_CODE, "error.location.not.permitted.asset.type", label, assetType.getCapitalAssetTypeDescription());
                valid = false;
            }
            if (StringUtils.isNotBlank((CharSequence)countryCode)) {
                label = businessObjectEntry.getAttributeDefinition(fieldMap.get((Object)AssetLocationService.LocationField.COUNTRY_CODE)).getLabel();
                this.putError(fieldMap, AssetLocationService.LocationField.COUNTRY_CODE, "error.location.not.permitted.asset.type", label, assetType.getCapitalAssetTypeDescription());
                valid = false;
            }
        } else if (!assetType.isMovingIndicator() && !assetType.isRequiredBuildingIndicator() && onCampus) {
            String label;
            if (StringUtils.isNotBlank((CharSequence)buildingCode)) {
                label = businessObjectEntry.getAttributeDefinition(fieldMap.get((Object)AssetLocationService.LocationField.BUILDING_CODE)).getLabel();
                this.putError(fieldMap, AssetLocationService.LocationField.BUILDING_CODE, "error.location.not.permitted.asset.type", label, assetType.getCapitalAssetTypeDescription());
                valid = false;
            }
            if (StringUtils.isNotBlank((CharSequence)roomNumber)) {
                label = businessObjectEntry.getAttributeDefinition(fieldMap.get((Object)AssetLocationService.LocationField.ROOM_NUMBER)).getLabel();
                this.putError(fieldMap, AssetLocationService.LocationField.ROOM_NUMBER, "error.location.not.permitted.asset.type", label, assetType.getCapitalAssetTypeDescription());
                valid = false;
            }
            if (StringUtils.isNotBlank((CharSequence)subRoomNumber)) {
                label = businessObjectEntry.getAttributeDefinition(fieldMap.get((Object)AssetLocationService.LocationField.SUB_ROOM_NUMBER)).getLabel();
                this.putError(fieldMap, AssetLocationService.LocationField.SUB_ROOM_NUMBER, "error.location.not.permitted.asset.type", label, assetType.getCapitalAssetTypeDescription());
                valid = false;
            }
        } else if (onCampus) {
            valid = this.validateOnCampusLocation(fieldMap, assetType, campusCode, buildingCode, roomNumber, subRoomNumber);
        } else if (offCampus) {
            valid = this.validateOffCampusLocation(fieldMap, contactName, streetAddress, cityName, stateCode, zipCode, countryCode);
        } else if (assetType.isMovingIndicator() || assetType.isRequiredBuildingIndicator()) {
            this.putError(fieldMap, AssetLocationService.LocationField.BUILDING_CODE, "error.location.info.required", new String[0]);
            valid = false;
        }
        return valid;
    }

    protected boolean validateNonCapitalAssetLocation(Map<AssetLocationService.LocationField, String> fieldMap, String contactName, String streetAddress, String cityName, String stateCode, String zipCode, String countryCode, boolean onCampus, boolean offCampus) {
        boolean valid = true;
        if (offCampus) {
            valid = this.validateOffCampusLocation(fieldMap, contactName, streetAddress, cityName, stateCode, zipCode, countryCode);
        }
        return valid;
    }

    protected void putError(Map<AssetLocationService.LocationField, String> fieldMap, AssetLocationService.LocationField field, String errorKey, String ... errorParameters) {
        GlobalVariables.getMessageMap().putError(fieldMap.get((Object)field), errorKey, errorParameters);
    }

    protected boolean validateOnCampusLocation(Map<AssetLocationService.LocationField, String> fieldMap, AssetType assetType, String campusCode, String buildingCode, String buildingRoomNumber, String subRoomNumber) {
        boolean valid = true;
        if (assetType.isMovingIndicator()) {
            if (StringUtils.isBlank((CharSequence)buildingCode)) {
                this.putError(fieldMap, AssetLocationService.LocationField.BUILDING_CODE, "error.on.campus.building.value.required", assetType.getCapitalAssetTypeDescription());
                valid = false;
            }
            if (StringUtils.isBlank((CharSequence)buildingRoomNumber)) {
                this.putError(fieldMap, AssetLocationService.LocationField.ROOM_NUMBER, "error.on.campus.room.number.required", assetType.getCapitalAssetTypeDescription());
                valid = false;
            }
        }
        if (assetType.isRequiredBuildingIndicator()) {
            if (StringUtils.isBlank((CharSequence)buildingCode)) {
                this.putError(fieldMap, AssetLocationService.LocationField.BUILDING_CODE, "error.on.campus.building.value.required", assetType.getCapitalAssetTypeDescription());
                valid = false;
            }
            if (StringUtils.isNotBlank((CharSequence)buildingRoomNumber)) {
                this.putError(fieldMap, AssetLocationService.LocationField.ROOM_NUMBER, "error.on.campus.room.number.not.permitted", assetType.getCapitalAssetTypeDescription());
                valid = false;
            }
            if (StringUtils.isNotBlank((CharSequence)subRoomNumber)) {
                this.putError(fieldMap, AssetLocationService.LocationField.SUB_ROOM_NUMBER, "error.on.campus.sub.room.number.not.permitted", assetType.getCapitalAssetTypeDescription());
                valid = false;
            }
        }
        return valid;
    }

    protected boolean validateOffCampusLocation(Map<AssetLocationService.LocationField, String> fieldMap, String contactName, String streetAddress, String cityName, String stateCode, String zipCode, String countryCode) {
        boolean valid = true;
        boolean isCountryUS = false;
        if (this.isBlank(fieldMap, AssetLocationService.LocationField.COUNTRY_CODE, countryCode)) {
            this.putError(fieldMap, AssetLocationService.LocationField.COUNTRY_CODE, "error.off.campus.country.required", new String[0]);
            valid = false;
        } else {
            isCountryUS = countryCode.equals("US");
        }
        if (this.isBlank(fieldMap, AssetLocationService.LocationField.CONTACT_NAME, contactName)) {
            this.putError(fieldMap, AssetLocationService.LocationField.CONTACT_NAME, "error.off.campus.contactName.required", new String[0]);
            valid = false;
        }
        if (this.isBlank(fieldMap, AssetLocationService.LocationField.STREET_ADDRESS, streetAddress)) {
            this.putError(fieldMap, AssetLocationService.LocationField.STREET_ADDRESS, "error.off.campus.address.required", new String[0]);
            valid = false;
        }
        if (this.isBlank(fieldMap, AssetLocationService.LocationField.CITY_NAME, cityName)) {
            this.putError(fieldMap, AssetLocationService.LocationField.CITY_NAME, "error.off.campus.city.required", new String[0]);
            valid = false;
        }
        if (isCountryUS) {
            State locationState;
            if (this.isBlank(fieldMap, AssetLocationService.LocationField.STATE_CODE, stateCode)) {
                this.putError(fieldMap, AssetLocationService.LocationField.STATE_CODE, "error.off.campus.state.required", new String[0]);
                valid = false;
            }
            if (this.isBlank(fieldMap, AssetLocationService.LocationField.ZIP_CODE, zipCode)) {
                this.putError(fieldMap, AssetLocationService.LocationField.ZIP_CODE, "error.off.campus.zip.required", new String[0]);
                valid = false;
            }
            if (!this.isBlank(fieldMap, AssetLocationService.LocationField.STATE_CODE, stateCode) && ObjectUtils.isNull((Object)(locationState = this.getLocationService().getState(countryCode, stateCode)))) {
                this.putError(fieldMap, AssetLocationService.LocationField.STATE_CODE, "error.invalid.state.code", stateCode);
                valid = false;
            }
        }
        return valid;
    }

    protected boolean isBlank(Map<AssetLocationService.LocationField, String> fieldMap, AssetLocationService.LocationField field, String countryCode) {
        return fieldMap.get((Object)field) != null && StringUtils.isBlank((CharSequence)countryCode);
    }

    protected String readPropertyValue(BusinessObject currObject, Map<AssetLocationService.LocationField, String> fieldMap, AssetLocationService.LocationField field) {
        String stringValue = null;
        try {
            String propertyName = fieldMap.get((Object)field);
            if (propertyName != null) {
                stringValue = (String)ObjectUtils.getNestedValue((Object)currObject, (String)propertyName);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return stringValue;
    }

    public void setBusinessObjectDictionaryService(BusinessObjectDictionaryService businessObjectDictionaryService) {
        this.businessObjectDictionaryService = businessObjectDictionaryService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.DataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.DataDictionaryService = dataDictionaryService;
    }

    public void setDocumentDictionaryService(DocumentDictionaryService documentDictionaryService) {
        this.documentDictionaryService = documentDictionaryService;
    }

    LocationService getLocationService() {
        return (LocationService)SpringContext.getBean(LocationService.class, (String)"locationService-fin");
    }
}

