/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetRetirementGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetRetirementGlobalDetail;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.module.cam.document.service.RetirementInfoService;

public class RetirementInfoServiceImpl
implements RetirementInfoService {
    private ParameterService parameterService;
    private AssetService assetService;

    @Override
    public void setRetirementInfo(Asset asset) {
        if (!this.assetService.isAssetRetired(asset)) {
            return;
        }
        List<AssetRetirementGlobalDetail> retirementHistory = asset.getAssetRetirementHistory();
        ArrayList<AssetRetirementGlobalDetail> sortableList = new ArrayList<AssetRetirementGlobalDetail>();
        for (AssetRetirementGlobalDetail assetRetirementGlobalDetail : retirementHistory) {
            AssetRetirementGlobal assetRetirementGlobal = assetRetirementGlobalDetail.getAssetRetirementGlobal();
            if (assetRetirementGlobal == null || !this.isDocumentApproved(assetRetirementGlobal)) continue;
            sortableList.add(assetRetirementGlobalDetail);
        }
        Comparator comparator = (o1, o2) -> o2.getAssetRetirementGlobal().getRetirementDate().compareTo(o1.getAssetRetirementGlobal().getRetirementDate());
        sortableList.sort(comparator);
        if (!sortableList.isEmpty()) {
            asset.setRetirementInfo((AssetRetirementGlobalDetail)((Object)sortableList.get(0)));
        }
    }

    protected boolean isDocumentApproved(AssetRetirementGlobal assetRetirementDoc) {
        assetRetirementDoc.refreshReferenceObject("documentHeader");
        return assetRetirementDoc.getDocumentHeader() != null && "A".equals(assetRetirementDoc.getDocumentHeader().getFinancialDocumentStatusCode());
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public AssetService getAssetService() {
        return this.assetService;
    }

    public void setAssetService(AssetService assetService) {
        this.assetService = assetService;
    }

    @Override
    public void setMergeHistory(Asset asset) {
        List<AssetRetirementGlobal> retirementGlobals = asset.getRetirementGlobals();
        ArrayList<AssetRetirementGlobalDetail> mergeHistory = new ArrayList<AssetRetirementGlobalDetail>();
        for (AssetRetirementGlobal retirementGlobal : retirementGlobals) {
            if (!"M".equalsIgnoreCase(retirementGlobal.getRetirementReasonCode())) continue;
            List<AssetRetirementGlobalDetail> retirementDetails = retirementGlobal.getAssetRetirementGlobalDetails();
            mergeHistory.addAll(retirementDetails);
        }
        if (!mergeHistory.isEmpty()) {
            asset.setMergeHistory(mergeHistory);
        }
    }
}

