/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.batch;

import java.util.Collection;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.module.cam.batch.service.BatchExtractService;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.sys.batch.AbstractStep;
import org.kuali.rice.core.api.datetime.DateTimeService;

public class PreAssetTaggingStep
extends AbstractStep {
    private static final Logger LOG = LogManager.getLogger();
    private BatchExtractService batchExtractService;
    private DateTimeService dateTimeService;

    public boolean execute(String jobName, Date jobRunDate) throws InterruptedException {
        try {
            Collection<PurchaseOrderAccount> preTaggablePOAccounts;
            java.sql.Date currentSqlDate = this.dateTimeService.getCurrentSqlDate();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Pre Asset Tagging extract started at " + this.dateTimeService.getCurrentTimestamp());
            }
            if ((preTaggablePOAccounts = this.batchExtractService.findPreTaggablePOAccounts()) != null && !preTaggablePOAccounts.isEmpty()) {
                this.batchExtractService.savePreTagLines(preTaggablePOAccounts);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Pre Asset Tagging extract finished at " + this.dateTimeService.getCurrentTimestamp());
            }
            this.batchExtractService.updateLastExtractDate(currentSqlDate);
        }
        catch (Throwable e) {
            LOG.error("Unexpected error occurred during Pre Asset Tagging extract", e);
            throw new RuntimeException(e);
        }
        return true;
    }

    public BatchExtractService getBatchExtractService() {
        return this.batchExtractService;
    }

    public void setBatchExtractService(BatchExtractService batchExtractService) {
        this.batchExtractService = batchExtractService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }
}

