/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.batch.service.impl;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.gl.service.impl.StringHelper;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.workflow.service.WorkflowDocumentService;
import org.kuali.kfs.module.cam.batch.AssetDepreciationStep;
import org.kuali.kfs.module.cam.batch.AssetPaymentInfo;
import org.kuali.kfs.module.cam.batch.service.AssetDepreciationService;
import org.kuali.kfs.module.cam.batch.service.ReportService;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetDepreciationTransaction;
import org.kuali.kfs.module.cam.businessobject.AssetObjectCode;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.document.dataaccess.DepreciableAssetsDao;
import org.kuali.kfs.module.cam.document.dataaccess.DepreciationBatchDao;
import org.kuali.kfs.module.cam.document.service.AssetDateService;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.sys.batch.service.SchedulerService;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.UniversityDate;
import org.kuali.kfs.sys.mail.BodyMailMessage;
import org.kuali.kfs.sys.mail.MailMessage;
import org.kuali.kfs.sys.service.EmailService;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class AssetDepreciationServiceImpl
implements AssetDepreciationService {
    private static final Logger LOG = LogManager.getLogger();
    protected ParameterService parameterService;
    protected AssetService assetService;
    protected ReportService reportService;
    protected DateTimeService dateTimeService;
    protected DepreciableAssetsDao depreciableAssetsDao;
    protected ConfigurationService kualiConfigurationService;
    protected GeneralLedgerPendingEntryService generalLedgerPendingEntryService;
    protected BusinessObjectService businessObjectService;
    protected UniversityDateService universityDateService;
    protected OptionsService optionsService;
    protected DataDictionaryService dataDictionaryService;
    protected DepreciationBatchDao depreciationBatchDao;
    protected String cronExpression;
    protected EmailService emailService;
    protected ObjectCodeService objectCodeService;
    protected WorkflowDocumentService workflowDocumentService;
    private AssetDateService assetDateService;
    private SchedulerService schedulerService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runDepreciation() {
        String depreciationDateParameter;
        ArrayList<String[]> reportLog;
        Object errorMsg;
        block17: {
            LOG.debug("runDepreciation() started");
            Integer fiscalYear = -1;
            Integer fiscalMonth = -1;
            errorMsg = "";
            ArrayList<String> documentNos = new ArrayList<String>();
            reportLog = new ArrayList<String[]>();
            Collection<AssetObjectCode> assetObjectCodes = new ArrayList<AssetObjectCode>();
            boolean hasErrors = false;
            Calendar depreciationDate = this.dateTimeService.getCurrentCalendar();
            depreciationDateParameter = null;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
            boolean executeJob = false;
            String errorMessage = this.kualiConfigurationService.getPropertyValueAsString("error.batch.depreciation.alreadyRan");
            try {
                executeJob = this.runAssetDepreciation();
                if (executeJob) {
                    LOG.info("*******DEPRECIATION BATCH -  HAS BEGUN *******");
                    if (this.parameterService.parameterExists(AssetDepreciationStep.class, "DEPRECIATION_DATE").booleanValue()) {
                        depreciationDateParameter = this.parameterService.getParameterValueAsString(AssetDepreciationStep.class, "DEPRECIATION_DATE");
                    }
                    if (StringUtils.isBlank(depreciationDateParameter)) {
                        depreciationDateParameter = dateFormat.format(this.dateTimeService.getCurrentDate());
                    }
                    if (!StringUtils.isBlank(depreciationDateParameter)) {
                        try {
                            depreciationDate.setTime(dateFormat.parse(depreciationDateParameter.trim()));
                        }
                        catch (ParseException e) {
                            throw new IllegalArgumentException(this.kualiConfigurationService.getPropertyValueAsString("error.batch.depreciation.invalidDepreciationDateFormat"));
                        }
                    }
                    LOG.info("DEPRECIATION BATCH - Depreciation run date: " + depreciationDateParameter);
                    UniversityDate universityDate = (UniversityDate)this.businessObjectService.findBySinglePrimaryKey(UniversityDate.class, (Object)new java.util.Date(depreciationDate.getTimeInMillis()));
                    if (universityDate == null) {
                        throw new IllegalStateException(this.kualiConfigurationService.getPropertyValueAsString("error.gl.UniversityDateNotFound"));
                    }
                    fiscalYear = universityDate.getUniversityFiscalYear();
                    fiscalMonth = new Integer(universityDate.getUniversityFiscalAccountingPeriod());
                    assetObjectCodes = this.getAssetObjectCodes(fiscalYear);
                    LOG.info("DEPRECIATION BATCH - Fiscal Year = " + fiscalYear + " & Fiscal Period=" + fiscalMonth);
                    int fiscalStartMonth = Integer.parseInt(this.optionsService.getCurrentYearOptions().getUniversityFiscalYearStartMo());
                    reportLog.addAll(this.depreciableAssetsDao.generateStatistics(true, null, fiscalYear, fiscalMonth, depreciationDate, this.dateTimeService.toDateString(depreciationDate.getTime()), assetObjectCodes, fiscalStartMonth, errorMessage));
                    this.updateAssetsDatesForLastFiscalPeriod(fiscalMonth, fiscalYear);
                    LOG.info("DEPRECIATION BATCH - Getting list of asset payments eligible for depreciation.");
                    Collection<AssetPaymentInfo> depreciableAssetsCollection = this.depreciationBatchDao.getListOfDepreciableAssetPaymentInfo(fiscalYear, fiscalMonth, depreciationDate);
                    if (depreciableAssetsCollection != null && !depreciableAssetsCollection.isEmpty()) {
                        SortedMap<String, AssetDepreciationTransaction> depreciationTransactions = this.calculateDepreciation(fiscalYear, fiscalMonth, depreciableAssetsCollection, depreciationDate, assetObjectCodes);
                        this.processGeneralLedgerPendingEntry(fiscalYear, fiscalMonth, documentNos, depreciationTransactions);
                    } else {
                        throw new IllegalStateException(this.kualiConfigurationService.getPropertyValueAsString("error.batch.depreciation.assetsNotFound"));
                    }
                }
                if (hasErrors || !executeJob) break block17;
            }
            catch (Exception e) {
                block18: {
                    try {
                        LOG.error("Error occurred");
                        LOG.error("DEPRECIATION BATCH - **************************************************************************");
                        LOG.error("DEPRECIATION BATCH - AN ERROR HAS OCCURRED! - ERROR: " + e.getMessage(), (Throwable)e);
                        LOG.error("DEPRECIATION BATCH - **************************************************************************");
                        hasErrors = true;
                        errorMsg = "Depreciation process ran unsuccessfully.\nReason:" + e.getMessage();
                        if (hasErrors || !executeJob) break block18;
                    }
                    catch (Throwable throwable) {
                        if (!hasErrors && executeJob) {
                            int fiscalStartMonth = Integer.parseInt(this.optionsService.getCurrentYearOptions().getUniversityFiscalYearStartMo());
                            reportLog.addAll(this.depreciableAssetsDao.generateStatistics(false, documentNos, fiscalYear, fiscalMonth, depreciationDate, this.dateTimeService.toDateString(depreciationDate.getTime()), assetObjectCodes, fiscalStartMonth, errorMessage));
                        }
                        if (!reportLog.isEmpty() || !((String)errorMsg).trim().equals("")) {
                            this.reportService.generateDepreciationReport(reportLog, (String)errorMsg, depreciationDateParameter);
                        }
                        LOG.debug("*******DEPRECIATION BATCH -  HAS ENDED *******");
                        throw throwable;
                    }
                    int fiscalStartMonth = Integer.parseInt(this.optionsService.getCurrentYearOptions().getUniversityFiscalYearStartMo());
                    reportLog.addAll(this.depreciableAssetsDao.generateStatistics(false, documentNos, fiscalYear, fiscalMonth, depreciationDate, this.dateTimeService.toDateString(depreciationDate.getTime()), assetObjectCodes, fiscalStartMonth, errorMessage));
                }
                if (!reportLog.isEmpty() || !((String)errorMsg).trim().equals("")) {
                    this.reportService.generateDepreciationReport(reportLog, (String)errorMsg, depreciationDateParameter);
                }
                LOG.debug("*******DEPRECIATION BATCH -  HAS ENDED *******");
            }
            int fiscalStartMonth = Integer.parseInt(this.optionsService.getCurrentYearOptions().getUniversityFiscalYearStartMo());
            reportLog.addAll(this.depreciableAssetsDao.generateStatistics(false, documentNos, fiscalYear, fiscalMonth, depreciationDate, this.dateTimeService.toDateString(depreciationDate.getTime()), assetObjectCodes, fiscalStartMonth, errorMessage));
        }
        if (!reportLog.isEmpty() || !((String)errorMsg).trim().equals("")) {
            this.reportService.generateDepreciationReport(reportLog, (String)errorMsg, depreciationDateParameter);
        }
        LOG.debug("*******DEPRECIATION BATCH -  HAS ENDED *******");
    }

    @Override
    public Collection<AssetObjectCode> getAssetObjectCodes(Integer fiscalYear) {
        LOG.debug("DepreciableAssetsDAoOjb.getAssetObjectCodes() -  started");
        LOG.info("DEPRECIATION BATCH - Getting asset object codes.");
        HashMap<String, Constable> fields = new HashMap<String, Constable>();
        fields.put("universityFiscalYear", fiscalYear);
        fields.put("active", Boolean.TRUE);
        Collection assetObjectCodesCollection = this.businessObjectService.findMatching(AssetObjectCode.class, fields);
        LOG.info("DEPRECIATION BATCH - Finished getting asset object codes - which are:" + assetObjectCodesCollection.toString());
        LOG.debug("DepreciableAssetsDAoOjb.getAssetObjectCodes() -  ended");
        return assetObjectCodesCollection;
    }

    @Override
    public boolean resetPeriodValuesWhenFirstFiscalPeriod() {
        LOG.debug("resetPeriodValuesWhenFirstFiscalPeriod() started");
        try {
            this.depreciationBatchDao.resetPeriodValuesWhenFirstFiscalPeriod(1);
            return true;
        }
        catch (Exception e) {
            LOG.error("resetPeriodValuesWhenFirstFiscalPeriod() Exception", (Throwable)e);
            return false;
        }
    }

    protected boolean runAssetDepreciation() throws ParseException {
        java.util.Date endDate;
        boolean executeJob = false;
        ArrayList<String> errorMessages = new ArrayList<String>();
        java.util.Date currentDate = DateUtils.truncate((java.util.Date)this.dateTimeService.getCurrentDate(), (int)5);
        java.util.Date beginDate = this.getBlankOutBeginDate();
        if (this.hasBlankOutPeriodStarted(beginDate, endDate = this.getBlankOutEndDate())) {
            String blankOutPeriodrunDate = this.parameterService.getParameterValueAsString(AssetDepreciationStep.class, "BLANK_OUT_PERIOD_RUN_DATE");
            if (!StringHelper.isNullOrEmpty((String)blankOutPeriodrunDate)) {
                java.util.Date runDate = this.convertToDate(blankOutPeriodrunDate);
                if (runDate.compareTo(beginDate) >= 0 && runDate.compareTo(endDate) <= 0) {
                    if (currentDate.equals(runDate)) {
                        executeJob = true;
                    } else {
                        LOG.info("Today is not BLANK_OUT_PERIOD_RUN_DATE. executeJob not set to true");
                    }
                } else {
                    String blankOutBegin = this.parameterService.getParameterValueAsString(AssetDepreciationStep.class, "BLANK_OUT_PERIOD_BEGIN");
                    String blankOutEnd = this.parameterService.getParameterValueAsString(AssetDepreciationStep.class, "BLANK_OUT_PERIOD_END");
                    String message = "BLANK_OUT_PERIOD_RUN_DATE: " + blankOutPeriodrunDate + " is not in the blank out period range.Blank out period range is [ " + blankOutBegin + "-" + blankOutEnd + " ] .";
                    errorMessages.add(message);
                    LOG.info(message);
                }
            } else {
                String message = "Parameter BLANK_OUT_PERIOD_RUN_DATE (component: Asset Depreciation Step) is not set Please set the date correctly to run the job.";
                errorMessages.add(message);
                LOG.info(message);
            }
        } else if (this.schedulerService.cronConditionMet(this.cronExpression)) {
            executeJob = true;
        } else {
            LOG.info("Cron condition not met. executeJob not set to true");
        }
        if (!executeJob && !errorMessages.isEmpty()) {
            this.sendWarningMail(errorMessages);
        }
        return executeJob;
    }

    protected boolean hasBlankOutPeriodStarted(java.util.Date beginDate, java.util.Date endDate) {
        java.util.Date currentDate = DateUtils.truncate((java.util.Date)this.dateTimeService.getCurrentDate(), (int)5);
        if (ObjectUtils.isNotNull((Object)beginDate) && ObjectUtils.isNotNull((Object)endDate)) {
            return currentDate.compareTo(beginDate) >= 0 && currentDate.compareTo(endDate) <= 0;
        }
        return false;
    }

    private java.util.Date getBlankOutEndDate() throws ParseException {
        String endDate = this.parameterService.getParameterValueAsString(AssetDepreciationStep.class, "BLANK_OUT_PERIOD_END");
        if (!StringHelper.isNullOrEmpty((String)endDate)) {
            int endDay = new Integer(StringUtils.substringAfterLast((String)endDate, (String)"/"));
            int endMonth = new Integer(StringUtils.substringBeforeLast((String)endDate, (String)"/")) - 1;
            Calendar blankOutEndcalendar = Calendar.getInstance();
            blankOutEndcalendar.set(blankOutEndcalendar.get(1), endMonth, endDay);
            return this.convertToDate(this.dateTimeService.toString(blankOutEndcalendar.getTime(), "MM/dd/yyyy"));
        }
        return null;
    }

    private java.util.Date getBlankOutBeginDate() throws ParseException {
        String beginDate = this.parameterService.getParameterValueAsString(AssetDepreciationStep.class, "BLANK_OUT_PERIOD_BEGIN");
        if (!StringHelper.isNullOrEmpty((String)beginDate)) {
            int beginDay = new Integer(StringUtils.substringAfterLast((String)beginDate, (String)"/"));
            int beginMonth = new Integer(StringUtils.substringBeforeLast((String)beginDate, (String)"/")) - 1;
            Calendar blankOutBegincalendar = Calendar.getInstance();
            blankOutBegincalendar.set(blankOutBegincalendar.get(1), beginMonth, beginDay);
            return this.convertToDate(this.dateTimeService.toString(blankOutBegincalendar.getTime(), "MM/dd/yyyy"));
        }
        return null;
    }

    private java.util.Date convertToDate(String date) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy", Locale.US);
        dateFormat.setLenient(false);
        return dateFormat.parse(date);
    }

    protected SortedMap<String, AssetDepreciationTransaction> calculateDepreciation(Integer fiscalYear, Integer fiscalMonth, Collection<AssetPaymentInfo> depreciableAssetsCollection, Calendar depreciationDate, Collection<AssetObjectCode> assetObjectCodes) {
        LOG.debug("calculateDepreciation() - start");
        ArrayList organizationPlantFundObjectSubType = new ArrayList();
        ArrayList campusPlantFundObjectSubType = new ArrayList();
        int depreciationPeriod = 1;
        TreeMap<String, AssetDepreciationTransaction> depreciationTransactionSummary = new TreeMap<String, AssetDepreciationTransaction>();
        Calendar assetDepreciationDate = Calendar.getInstance();
        try {
            String depreciationPeriodString;
            LOG.debug("DEPRECIATION BATCH - Getting the parameters for the plant fund object sub types.");
            if (this.parameterService.parameterExists(AssetDepreciationStep.class, "DEPRECIATION_ORGANIZATION_PLANT_FUND_OBJECT_SUB_TYPE").booleanValue()) {
                organizationPlantFundObjectSubType = new ArrayList(this.parameterService.getParameterValuesAsString(AssetDepreciationStep.class, "DEPRECIATION_ORGANIZATION_PLANT_FUND_OBJECT_SUB_TYPE"));
            }
            if (this.parameterService.parameterExists(AssetDepreciationStep.class, "DEPRECIATION_CAMPUS_PLANT_FUND_OBJECT_SUB_TYPE").booleanValue()) {
                campusPlantFundObjectSubType = new ArrayList(this.parameterService.getParameterValuesAsString(AssetDepreciationStep.class, "DEPRECIATION_CAMPUS_PLANT_FUND_OBJECT_SUB_TYPE"));
            }
            if (this.parameterService.parameterExists(AssetDepreciationStep.class, "DEPRECIATION_PERIOD").booleanValue() && !StringUtils.isBlank((CharSequence)(depreciationPeriodString = this.parameterService.getParameterValueAsString(AssetDepreciationStep.class, "DEPRECIATION_PERIOD")))) {
                depreciationPeriod = Integer.parseInt(depreciationPeriodString);
            }
            if (fiscalMonth % depreciationPeriod != 0) {
                throw new IllegalStateException(this.kualiConfigurationService.getPropertyValueAsString("error.batch.depreciation.fiscalMonthNotValid"));
            }
            LOG.debug("getBaseAmountOfAssets(Collection<AssetPayment> depreciableAssetsCollection) - Started.");
            LOG.debug("DEPRECIATION BATCH - Calculating the base amount for each asset.");
            Map<Long, KualiDecimal> salvageValueAssetDeprAmounts = this.depreciationBatchDao.getPrimaryDepreciationBaseAmountForSV();
            Map<String, AssetObjectCode> assetObjectCodeMap = this.buildChartObjectToCapitalizationObjectMap(assetObjectCodes);
            HashMap<String, ObjectCode> capitalizationObjectCodes = new HashMap<String, ObjectCode>();
            int depreciationStartMonth = depreciationDate.get(2) - depreciationPeriod + 1;
            int depreciationEndMonth = depreciationStartMonth + depreciationPeriod;
            LOG.debug("DEPRECIATION BATCH - Reading collection with eligible asset payment details.");
            int counter = 0;
            ArrayList<AssetPaymentInfo> saveList = new ArrayList<AssetPaymentInfo>();
            for (AssetPaymentInfo assetPaymentInfo : depreciableAssetsCollection) {
                BigDecimal transactionAmountPrecise;
                KualiDecimal transactionAmount;
                KualiDecimal priorAccumulatedAmount;
                KualiDecimal primaryDepreciationBaseAmount;
                AssetObjectCode assetObjectCode = assetObjectCodeMap.get(assetPaymentInfo.getChartOfAccountsCode() + "-" + assetPaymentInfo.getFinancialObjectCode());
                if (assetObjectCode == null) {
                    LOG.error("DEPRECIATION BATCH - Asset object code not found for " + fiscalYear + "-" + assetPaymentInfo.getChartOfAccountsCode() + "-" + assetPaymentInfo.getFinancialObjectCode());
                    LOG.error("DEPRECIATION BATCH - Asset payment is not included in depreciation " + assetPaymentInfo.getCapitalAssetNumber() + " - " + assetPaymentInfo.getPaymentSequenceNumber());
                    continue;
                }
                ObjectCode accumulatedDepreciationFinancialObject = this.getDepreciationObjectCode(fiscalYear, capitalizationObjectCodes, assetPaymentInfo, assetObjectCode.getAccumulatedDepreciationFinancialObjectCode());
                ObjectCode depreciationExpenseFinancialObject = this.getDepreciationObjectCode(fiscalYear, capitalizationObjectCodes, assetPaymentInfo, assetObjectCode.getDepreciationExpenseFinancialObjectCode());
                if (ObjectUtils.isNull((Object)accumulatedDepreciationFinancialObject)) {
                    LOG.error("DEPRECIATION BATCH - Accumulated Depreciation Financial Object Code not found for " + fiscalYear + "-" + assetPaymentInfo.getChartOfAccountsCode() + "-" + assetObjectCode.getAccumulatedDepreciationFinancialObjectCode());
                    LOG.error("DEPRECIATION BATCH - Asset payment is not included in depreciation " + assetPaymentInfo.getCapitalAssetNumber() + " - " + assetPaymentInfo.getPaymentSequenceNumber());
                    continue;
                }
                if (ObjectUtils.isNull((Object)depreciationExpenseFinancialObject)) {
                    LOG.error("DEPRECIATION BATCH - Depreciation Expense Financial Object Code not found for " + fiscalYear + "-" + assetPaymentInfo.getChartOfAccountsCode() + "-" + assetObjectCode.getDepreciationExpenseFinancialObjectCode());
                    LOG.error("DEPRECIATION BATCH - Asset payment is not included in depreciation " + assetPaymentInfo.getCapitalAssetNumber() + " - " + assetPaymentInfo.getPaymentSequenceNumber());
                    continue;
                }
                Long assetNumber = assetPaymentInfo.getCapitalAssetNumber();
                assetDepreciationDate.setTime(assetPaymentInfo.getDepreciationDate());
                KualiDecimal deprAmountSum = salvageValueAssetDeprAmounts.get(assetNumber);
                double assetLifeInMonths = assetPaymentInfo.getDepreciableLifeLimit() * 12;
                double ageAtPeriodStart = depreciationStartMonth - assetDepreciationDate.get(2) + (depreciationDate.get(1) - assetDepreciationDate.get(1)) * 12;
                double ageAtPeriodEnd = depreciationEndMonth - assetDepreciationDate.get(2) + (depreciationDate.get(1) - assetDepreciationDate.get(1)) * 12;
                if (ageAtPeriodStart < 0.0) {
                    ageAtPeriodStart = 0.0;
                }
                if ((primaryDepreciationBaseAmount = assetPaymentInfo.getPrimaryDepreciationBaseAmount()) == null) {
                    primaryDepreciationBaseAmount = KualiDecimal.ZERO;
                    assetPaymentInfo.setPrimaryDepreciationBaseAmount(KualiDecimal.ZERO);
                }
                if ((priorAccumulatedAmount = assetPaymentInfo.getAccumulatedPrimaryDepreciationAmount()) == null) {
                    priorAccumulatedAmount = KualiDecimal.ZERO;
                    assetPaymentInfo.setAccumulatedPrimaryDepreciationAmount(KualiDecimal.ZERO);
                }
                KualiDecimal remainingAmount = (KualiDecimal)primaryDepreciationBaseAmount.subtract((AbstractKualiDecimal)priorAccumulatedAmount);
                if ("SV".equals(assetPaymentInfo.getPrimaryDepreciationMethodCode()) && deprAmountSum != null && deprAmountSum.isNonZero()) {
                    remainingAmount = (KualiDecimal)remainingAmount.subtract((AbstractKualiDecimal)((KualiDecimal)((KualiDecimal)primaryDepreciationBaseAmount.divide((AbstractKualiDecimal)deprAmountSum)).multiply((AbstractKualiDecimal)assetPaymentInfo.getSalvageAmount())));
                }
                BigDecimal remainingAmountPrecise = remainingAmount.bigDecimalValue().setScale(5);
                if ((double)depreciationPeriod >= assetLifeInMonths - ageAtPeriodStart) {
                    transactionAmount = remainingAmount;
                    transactionAmountPrecise = transactionAmount.bigDecimalValue();
                } else if (this.needToCatchUp(assetPaymentInfo, depreciationDate)) {
                    transactionAmount = (KualiDecimal)((KualiDecimal)remainingAmount.multiply((AbstractKualiDecimal)new KualiDecimal(ageAtPeriodEnd))).divide((AbstractKualiDecimal)new KualiDecimal(assetLifeInMonths));
                    transactionAmountPrecise = remainingAmountPrecise.multiply(new BigDecimal(ageAtPeriodEnd)).divide(new BigDecimal(assetLifeInMonths), RoundingMode.HALF_UP);
                } else {
                    transactionAmount = (KualiDecimal)((KualiDecimal)remainingAmount.multiply((AbstractKualiDecimal)new KualiDecimal(depreciationPeriod))).divide((AbstractKualiDecimal)new KualiDecimal(assetLifeInMonths - ageAtPeriodStart));
                    transactionAmountPrecise = remainingAmountPrecise.multiply(new BigDecimal(depreciationPeriod)).divide(new BigDecimal(assetLifeInMonths - ageAtPeriodStart), RoundingMode.HALF_UP);
                }
                BigDecimal currentRoundingError = transactionAmount.bigDecimalValue().subtract(transactionAmountPrecise);
                Integer currentRoundingErrorMillicents = currentRoundingError.multiply(new BigDecimal(Math.pow(10.0, transactionAmountPrecise.scale()))).intValue();
                int accumulatedRoundingErrorMillicents = currentRoundingErrorMillicents + assetPaymentInfo.getAccumulatedRoundingErrorInMillicents();
                if (accumulatedRoundingErrorMillicents >= 500) {
                    transactionAmount = (KualiDecimal)transactionAmount.subtract((AbstractKualiDecimal)new KualiDecimal(0.01));
                    accumulatedRoundingErrorMillicents -= 1000;
                } else if (accumulatedRoundingErrorMillicents <= -500) {
                    transactionAmount = (KualiDecimal)transactionAmount.add((AbstractKualiDecimal)new KualiDecimal(0.01));
                    accumulatedRoundingErrorMillicents += 1000;
                }
                KualiDecimal accumulatedDepreciationAmount = (KualiDecimal)priorAccumulatedAmount.add((AbstractKualiDecimal)transactionAmount);
                String transactionType = "D";
                if (transactionAmount.isNegative()) {
                    transactionType = "C";
                }
                String plantAccount = "";
                String plantCOA = "";
                if (organizationPlantFundObjectSubType.contains(assetPaymentInfo.getFinancialObjectSubTypeCode())) {
                    plantAccount = assetPaymentInfo.getOrganizationPlantAccountNumber();
                    plantCOA = assetPaymentInfo.getOrganizationPlantChartCode();
                } else if (campusPlantFundObjectSubType.contains(assetPaymentInfo.getFinancialObjectSubTypeCode())) {
                    plantAccount = assetPaymentInfo.getCampusPlantAccountNumber();
                    plantCOA = assetPaymentInfo.getCampusPlantChartCode();
                }
                if (StringUtils.isBlank((CharSequence)plantCOA) || StringUtils.isBlank((CharSequence)plantAccount)) {
                    LOG.error("DEPRECIATION BATCH - Plant COA is " + plantCOA + " and plant account is " + plantAccount + " for Financial Object SubType Code = " + assetPaymentInfo.getFinancialObjectSubTypeCode() + " so Asset payment is not included in depreciation " + assetPaymentInfo.getCapitalAssetNumber() + " - " + assetPaymentInfo.getPaymentSequenceNumber());
                    continue;
                }
                LOG.debug("Asset#: " + assetNumber + " - Payment sequence#:" + assetPaymentInfo.getPaymentSequenceNumber() + " - Asset Depreciation date:" + assetDepreciationDate + " - Life:" + assetLifeInMonths + " - Depreciation base amt:" + primaryDepreciationBaseAmount + " - Accumulated depreciation:" + priorAccumulatedAmount + " - Month Elapsed:" + ageAtPeriodStart + " - Calculated accum depreciation:" + accumulatedDepreciationAmount + " - Depreciation amount:" + transactionAmount.toString() + " - Depreciation Method:" + assetPaymentInfo.getPrimaryDepreciationMethodCode());
                assetPaymentInfo.setAccumulatedPrimaryDepreciationAmount(accumulatedDepreciationAmount);
                assetPaymentInfo.setTransactionAmount(transactionAmount);
                assetPaymentInfo.setAccumulatedRoundingErrorInMillicents(accumulatedRoundingErrorMillicents);
                saveList.add(assetPaymentInfo);
                if (++counter % 1000 == 0) {
                    this.depreciationBatchDao.updateAssetPayments(saveList, fiscalMonth);
                    saveList.clear();
                }
                if (!transactionAmount.isNonZero()) continue;
                this.populateDepreciationTransaction(assetPaymentInfo, transactionType, plantCOA, plantAccount, depreciationExpenseFinancialObject, depreciationTransactionSummary);
                transactionType = transactionType.equals("D") ? "C" : "D";
                this.populateDepreciationTransaction(assetPaymentInfo, transactionType, plantCOA, plantAccount, accumulatedDepreciationFinancialObject, depreciationTransactionSummary);
            }
            this.depreciationBatchDao.updateAssetPayments(saveList, fiscalMonth);
            saveList.clear();
            return depreciationTransactionSummary;
        }
        catch (Exception e) {
            LOG.error("Error occurred", (Throwable)e);
            throw new IllegalStateException(this.kualiConfigurationService.getPropertyValueAsString("error.batch.depreciation.calculationError") + " :" + e.getMessage());
        }
    }

    private boolean needToCatchUp(AssetPaymentInfo assetPaymentInfo, Calendar depreciationDate) {
        return this.isFirstDepreciationForAssetPayment(assetPaymentInfo) && this.paymentInFirstYearOfAsset(assetPaymentInfo) && this.depreciationDateInCurrentFiscalYear(depreciationDate);
    }

    private boolean isFirstDepreciationForAssetPayment(AssetPaymentInfo assetPaymentInfo) {
        HashMap<String, Number> primaryKeys = new HashMap<String, Number>();
        primaryKeys.put("capitalAssetNumber", assetPaymentInfo.getCapitalAssetNumber());
        primaryKeys.put("paymentSequenceNumber", assetPaymentInfo.getPaymentSequenceNumber());
        AssetPayment assetPayment = (AssetPayment)this.businessObjectService.findByPrimaryKey(AssetPayment.class, primaryKeys);
        return assetPayment == null || assetPayment.getAccumulatedPrimaryDepreciationAmount() == null || assetPayment.getAccumulatedPrimaryDepreciationAmount().isZero();
    }

    private boolean paymentInFirstYearOfAsset(AssetPaymentInfo assetPaymentInfo) {
        Integer assetPaymentFiscalYear = this.universityDateService.getFiscalYear((java.util.Date)assetPaymentInfo.getDepreciationDate());
        Integer currentFiscalYear = this.universityDateService.getCurrentFiscalYear();
        return Objects.equals(assetPaymentFiscalYear, currentFiscalYear);
    }

    private boolean depreciationDateInCurrentFiscalYear(Calendar depreciationDate) {
        Integer depreciationFiscalYear = this.universityDateService.getFiscalYear(depreciationDate.getTime());
        Integer currentFiscalYear = this.universityDateService.getCurrentFiscalYear();
        return Objects.equals(depreciationFiscalYear, currentFiscalYear);
    }

    protected void populateDepreciationTransaction(AssetPaymentInfo assetPayment, String transactionType, String plantCOA, String plantAccount, ObjectCode deprObjectCode, SortedMap<String, AssetDepreciationTransaction> depreciationTransactionSummary) {
        LOG.debug("populateDepreciationTransaction(AssetDepreciationTransaction depreciationTransaction, AssetPayment assetPayment, String transactionType, KualiDecimal transactionAmount, String plantCOA, String plantAccount, String accumulatedDepreciationFinancialObjectCode, String depreciationExpenseFinancialObjectCode, ObjectCode financialObject, SortedMap<String, AssetDepreciationTransaction> depreciationTransactionSummary) -  started");
        LOG.debug("DEPRECIATION BATCH - populateDepreciationTransaction(): populating AssetDepreciationTransaction pojo - Asset#:" + assetPayment.getCapitalAssetNumber());
        AssetDepreciationTransaction depreciationTransaction = new AssetDepreciationTransaction();
        depreciationTransaction.setCapitalAssetNumber(assetPayment.getCapitalAssetNumber());
        depreciationTransaction.setChartOfAccountsCode(plantCOA);
        depreciationTransaction.setAccountNumber(plantAccount);
        depreciationTransaction.setSubAccountNumber(assetPayment.getSubAccountNumber());
        depreciationTransaction.setFinancialObjectCode(deprObjectCode.getFinancialObjectCode());
        depreciationTransaction.setFinancialSubObjectCode(assetPayment.getFinancialSubObjectCode());
        depreciationTransaction.setFinancialObjectTypeCode(deprObjectCode.getFinancialObjectTypeCode());
        depreciationTransaction.setTransactionType(transactionType);
        depreciationTransaction.setProjectCode(assetPayment.getProjectCode());
        depreciationTransaction.setTransactionAmount(assetPayment.getTransactionAmount());
        depreciationTransaction.setTransactionLedgerEntryDescription("Batch Depreciation Asset " + assetPayment.getCapitalAssetNumber());
        String sKey = depreciationTransaction.getKey();
        if (depreciationTransactionSummary.containsKey(sKey)) {
            depreciationTransaction = (AssetDepreciationTransaction)((Object)depreciationTransactionSummary.get(sKey));
            depreciationTransaction.setTransactionAmount((KualiDecimal)depreciationTransaction.getTransactionAmount().add((AbstractKualiDecimal)assetPayment.getTransactionAmount()));
        } else {
            depreciationTransactionSummary.put(sKey, depreciationTransaction);
        }
        LOG.debug("populateDepreciationTransaction(AssetDepreciationTransaction depreciationTransaction, AssetPayment assetPayment, String transactionType, KualiDecimal transactionAmount, String plantCOA, String plantAccount, String accumulatedDepreciationFinancialObjectCode, String depreciationExpenseFinancialObjectCode, ObjectCode financialObject, SortedMap<String, AssetDepreciationTransaction> depreciationTransactionSummary) -  ended");
    }

    protected void processGeneralLedgerPendingEntry(Integer fiscalYear, Integer fiscalMonth, List<String> documentNos, SortedMap<String, AssetDepreciationTransaction> trans) {
        LOG.debug("populateExplicitGeneralLedgerPendingEntry(AccountingDocument, AccountingLine, GeneralLedgerPendingEntrySequenceHelper, GeneralLedgerPendingEntry) - start");
        try {
            String documentNumber = this.createNewDepreciationDocument(documentNos);
            String financialSystemDocumentTypeCodeCode = "DEPR";
            LOG.debug("DEPRECIATION BATCH - Depreciation Document Type Code: " + financialSystemDocumentTypeCodeCode);
            Timestamp transactionTimestamp = new Timestamp(this.dateTimeService.getCurrentDate().getTime());
            GeneralLedgerPendingEntrySequenceHelper sequenceHelper = new GeneralLedgerPendingEntrySequenceHelper();
            ArrayList<GeneralLedgerPendingEntry> saveList = new ArrayList<GeneralLedgerPendingEntry>();
            int counter = 0;
            for (AssetDepreciationTransaction t : trans.values()) {
                if (!t.getTransactionAmount().isNonZero()) continue;
                ++counter;
                LOG.debug("DEPRECIATION BATCH - Creating GLPE entries for asset:" + t.getCapitalAssetNumber());
                GeneralLedgerPendingEntry explicitEntry = new GeneralLedgerPendingEntry();
                explicitEntry.setFinancialSystemOriginationCode("01");
                explicitEntry.setDocumentNumber(documentNumber);
                explicitEntry.setTransactionLedgerEntrySequenceNumber(Integer.valueOf(sequenceHelper.getSequenceCounter()));
                sequenceHelper.increment();
                explicitEntry.setChartOfAccountsCode(t.getChartOfAccountsCode());
                explicitEntry.setAccountNumber(t.getAccountNumber());
                explicitEntry.setSubAccountNumber(null);
                explicitEntry.setFinancialObjectCode(t.getFinancialObjectCode());
                explicitEntry.setFinancialSubObjectCode(null);
                explicitEntry.setFinancialBalanceTypeCode("AC");
                explicitEntry.setFinancialObjectTypeCode(t.getFinancialObjectTypeCode());
                explicitEntry.setUniversityFiscalYear(fiscalYear);
                explicitEntry.setUniversityFiscalPeriodCode(StringUtils.leftPad((String)fiscalMonth.toString().trim(), (int)2, (String)"0"));
                explicitEntry.setTransactionLedgerEntryDescription(t.getTransactionLedgerEntryDescription());
                explicitEntry.setTransactionLedgerEntryAmount((KualiDecimal)t.getTransactionAmount().abs());
                explicitEntry.setTransactionDebitCreditCode(t.getTransactionType());
                explicitEntry.setTransactionDate(new Date(transactionTimestamp.getTime()));
                explicitEntry.setFinancialDocumentTypeCode(financialSystemDocumentTypeCodeCode);
                explicitEntry.setFinancialDocumentApprovedCode("A");
                explicitEntry.setVersionNumber(Long.valueOf(1L));
                explicitEntry.setTransactionEntryProcessedTs(new Timestamp(transactionTimestamp.getTime()));
                saveList.add(explicitEntry);
                if (counter % 1000 == 0) {
                    this.depreciationBatchDao.savePendingGLEntries(saveList);
                    saveList.clear();
                }
                if (sequenceHelper.getSequenceCounter() != 99999) continue;
                documentNumber = this.createNewDepreciationDocument(documentNos);
                sequenceHelper = new GeneralLedgerPendingEntrySequenceHelper();
            }
            this.depreciationBatchDao.savePendingGLEntries(saveList);
            saveList.clear();
        }
        catch (Exception e) {
            LOG.error("Error occurred", (Throwable)e);
            throw new IllegalStateException(this.kualiConfigurationService.getPropertyValueAsString("error.batch.depreciation.glpeUpdateError") + " :" + e.getMessage());
        }
        LOG.debug("populateExplicitGeneralLedgerPendingEntry(AccountingDocument, AccountingLine, GeneralLedgerPendingEntrySequenceHelper, GeneralLedgerPendingEntry) - end");
    }

    protected String createNewDepreciationDocument(List<String> documentNos) throws WorkflowException {
        WorkflowDocument workflowDocument = this.workflowDocumentService.createWorkflowDocument("DEPR", this.getPerson());
        LOG.debug("DEPRECIATION BATCH - Creating document header entry.");
        FinancialSystemDocumentHeader documentHeader = new FinancialSystemDocumentHeader();
        documentHeader.setWorkflowDocument(workflowDocument);
        documentHeader.setDocumentNumber(workflowDocument.getDocumentId());
        documentHeader.setFinancialDocumentStatusCode("A");
        documentHeader.setExplanation("Batch Depreciation Entry");
        documentHeader.setDocumentDescription("Batch Depreciation Entry");
        documentHeader.setFinancialDocumentTotalAmount(KualiDecimal.ZERO);
        LOG.debug("DEPRECIATION BATCH - Saving document header entry.");
        this.businessObjectService.save((PersistableBusinessObject)documentHeader);
        LOG.debug("DEPRECIATION BATCH - Document Header entry was saved successfully.");
        String documentNumber = documentHeader.getDocumentNumber();
        documentNos.add(documentNumber);
        LOG.debug("DEPRECIATION BATCH - Document Number Created: " + documentNumber);
        return documentNumber;
    }

    Person getPerson() {
        return GlobalVariables.getUserSession().getPerson();
    }

    protected ObjectCode getDepreciationObjectCode(Integer fiscalYear, Map<String, ObjectCode> capObjectCodesCache, AssetPaymentInfo assetPaymentInfo, String capitalizationFinancialObjectCode) {
        String key = assetPaymentInfo.getChartOfAccountsCode() + "-" + capitalizationFinancialObjectCode;
        ObjectCode deprObjCode = capObjectCodesCache.get(key);
        if (deprObjCode == null && ObjectUtils.isNotNull((Object)(deprObjCode = this.objectCodeService.getByPrimaryId(fiscalYear, assetPaymentInfo.getChartOfAccountsCode(), capitalizationFinancialObjectCode)))) {
            capObjectCodesCache.put(key, deprObjCode);
        }
        return deprObjCode;
    }

    protected Map<String, AssetObjectCode> buildChartObjectToCapitalizationObjectMap(Collection<AssetObjectCode> assetObjectCodes) {
        HashMap<String, AssetObjectCode> assetObjectCodeMap = new HashMap<String, AssetObjectCode>();
        for (AssetObjectCode assetObjectCode : assetObjectCodes) {
            List<ObjectCode> objectCodes = assetObjectCode.getObjectCode();
            for (ObjectCode objectCode : objectCodes) {
                String key = objectCode.getChartOfAccountsCode() + "-" + objectCode.getFinancialObjectCode();
                if (assetObjectCodeMap.containsKey(key)) continue;
                assetObjectCodeMap.put(key, assetObjectCode);
            }
        }
        return assetObjectCodeMap;
    }

    private void sendWarningMail(List<String> errorMessages) {
        LOG.debug("sendWarningMail() started");
        BodyMailMessage message = new BodyMailMessage();
        message.setFromAddress(this.emailService.getDefaultFromAddress());
        String subject = "Asset Depreciation Job status";
        message.setSubject(subject);
        Collection toAddresses = this.parameterService.getParameterValuesAsString(AssetDepreciationStep.class, "BLANK_OUT_NOTIFICATION_EMAIL_ADDRESSES");
        toAddresses.forEach(arg_0 -> ((BodyMailMessage)message).addToAddress(arg_0));
        StringBuffer sb = new StringBuffer();
        sb.append("Unable to run Depreciation process.Reason:\n");
        for (String msg : errorMessages) {
            sb.append(msg).append("\n");
        }
        sb.append("Please set the dates correctly to run the job.");
        message.setMessage(sb.toString());
        this.emailService.sendMessage((MailMessage)message, false);
    }

    protected void updateAssetsDatesForLastFiscalPeriod(Integer fiscalMonth, Integer fiscalYear) {
        if (fiscalMonth == 12) {
            LOG.info("DEPRECIATION BATCH - Starting updateAssetsCreatedInLastFiscalPeriod()");
            java.util.Date lastDateOfFiscalYear = this.universityDateService.getLastDateOfFiscalYear(fiscalYear);
            if (lastDateOfFiscalYear == null) {
                throw new IllegalStateException(this.kualiConfigurationService.getPropertyValueAsString("error.gl.UniversityDateNotFound"));
            }
            Date lastFiscalYearDate = new Date(lastDateOfFiscalYear.getTime());
            ArrayList<String> movableEquipmentObjectSubTypes = new ArrayList<String>();
            if (this.parameterService.parameterExists(Asset.class, "MOVABLE_EQUIPMENT_OBJECT_SUB_TYPES").booleanValue()) {
                movableEquipmentObjectSubTypes.addAll(this.parameterService.getParameterValuesAsString(Asset.class, "MOVABLE_EQUIPMENT_OBJECT_SUB_TYPES"));
            }
            if (!movableEquipmentObjectSubTypes.isEmpty()) {
                this.updateAssetDatesPerConvention(lastFiscalYearDate, movableEquipmentObjectSubTypes, "CD");
                this.updateAssetDatesPerConvention(lastFiscalYearDate, movableEquipmentObjectSubTypes, "FY");
                this.updateAssetDatesPerConvention(lastFiscalYearDate, movableEquipmentObjectSubTypes, "HY");
            }
            LOG.info("DEPRECIATION BATCH - Finished updateAssetsCreatedInLastFiscalPeriod()");
        }
    }

    protected void updateAssetDatesPerConvention(Date lastFiscalYearDate, List<String> movableEquipmentObjectSubTypes, String depreciationConventionCd) {
        List<Map<String, Object>> selectedAssets = this.depreciationBatchDao.getAssetsByDepreciationConvention(lastFiscalYearDate, movableEquipmentObjectSubTypes, depreciationConventionCd);
        if (selectedAssets != null && !selectedAssets.isEmpty()) {
            ArrayList<String> assetNumbers = new ArrayList<String>();
            for (Map<String, Object> assetMap : selectedAssets) {
                assetNumbers.add(assetMap.get("CPTLAST_NBR").toString());
            }
            Date depreciationDate = this.assetDateService.computeDepreciationDateForPeriod13(depreciationConventionCd, lastFiscalYearDate);
            this.depreciationBatchDao.updateAssetInServiceAndDepreciationDate(assetNumbers, lastFiscalYearDate, depreciationDate);
            LOG.info("DEPRECIATION BATCH - Finished updateAssetInServiceAndDepreciationDate() for Depreciation convention " + depreciationConventionCd + " for " + assetNumbers.size() + " assets : " + ((Object)assetNumbers).toString());
        }
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setDepreciableAssetsDao(DepreciableAssetsDao depreciableAssetsDao) {
        this.depreciableAssetsDao = depreciableAssetsDao;
    }

    public void setCamsReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public void setConfigurationService(ConfigurationService kcs) {
        this.kualiConfigurationService = kcs;
    }

    public void setGeneralLedgerPendingEntryService(GeneralLedgerPendingEntryService generalLedgerPendingEntryService) {
        this.generalLedgerPendingEntryService = generalLedgerPendingEntryService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    @Override
    public void setDepreciationBatchDao(DepreciationBatchDao depreciationBatchDao) {
        this.depreciationBatchDao = depreciationBatchDao;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public void setOptionsService(OptionsService optionsService) {
        this.optionsService = optionsService;
    }

    public void setAssetDateService(AssetDateService assetDateService) {
        this.assetDateService = assetDateService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public void setAssetService(AssetService assetService) {
        this.assetService = assetService;
    }

    public void setObjectCodeService(ObjectCodeService objectCodeService) {
        this.objectCodeService = objectCodeService;
    }

    public void setWorkflowDocumentService(WorkflowDocumentService workflowDocumentService) {
        this.workflowDocumentService = workflowDocumentService;
    }

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }
}

