/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.batch.service.impl;

import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coreservice.api.parameter.Parameter;
import org.kuali.kfs.coreservice.api.parameter.ParameterContract;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.gl.businessobject.Entry;
import org.kuali.kfs.integration.cam.CapitalAssetManagementModuleService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.batch.ExtractProcessLog;
import org.kuali.kfs.module.cam.batch.PreAssetTaggingStep;
import org.kuali.kfs.module.cam.batch.dataaccess.ExtractDao;
import org.kuali.kfs.module.cam.batch.dataaccess.PurchasingAccountsPayableItemAssetDao;
import org.kuali.kfs.module.cam.batch.service.BatchExtractService;
import org.kuali.kfs.module.cam.batch.service.ReconciliationService;
import org.kuali.kfs.module.cam.businessobject.AssetGlobal;
import org.kuali.kfs.module.cam.businessobject.BatchParameters;
import org.kuali.kfs.module.cam.businessobject.GeneralLedgerEntry;
import org.kuali.kfs.module.cam.businessobject.GlAccountLineGroup;
import org.kuali.kfs.module.cam.businessobject.Pretag;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableActionHistory;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableItemAsset;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableLineAssetAccount;
import org.kuali.kfs.module.cam.document.service.PurApInfoService;
import org.kuali.kfs.module.cam.document.service.PurApLineService;
import org.kuali.kfs.module.purap.businessobject.CreditMemoAccountRevision;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestAccountRevision;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLineBase;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.service.FinancialSystemDocumentService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.springframework.transaction.annotation.Transactional;

public class BatchExtractServiceImpl
implements BatchExtractService {
    private static final Logger LOG = LogManager.getLogger();
    protected BusinessObjectService businessObjectService;
    protected ExtractDao extractDao;
    protected DateTimeService dateTimeService;
    protected ParameterService parameterService;
    protected PurApLineService purApLineService;
    protected PurApInfoService purApInfoService;
    protected PurchasingAccountsPayableItemAssetDao purchasingAccountsPayableItemAssetDao;
    protected FinancialSystemDocumentService financialSystemDocumentService;
    protected CapitalAssetManagementModuleService capitalAssetManagementModuleService;

    @Override
    @Transactional
    public void performExtract(ExtractProcessLog processLog) {
        Collection<Entry> elgibleGLEntries = this.findElgibleGLEntries(processLog);
        if (elgibleGLEntries != null && !elgibleGLEntries.isEmpty()) {
            ArrayList<Entry> fpLines = new ArrayList<Entry>();
            ArrayList<Entry> purapLines = new ArrayList<Entry>();
            this.separatePOLines(fpLines, purapLines, elgibleGLEntries);
            this.saveFPLines(fpLines, processLog);
            HashSet<PurchasingAccountsPayableDocument> purApDocuments = this.savePOLines(purapLines, processLog);
            this.allocateAdditionalCharges(purApDocuments);
            processLog.setTotalGlCount(elgibleGLEntries.size());
            processLog.setNonPurApGlCount(fpLines.size());
            processLog.setPurApGlCount(purapLines.size());
            this.updateLastExtractTime(processLog.getStartTime());
            if (LOG.isDebugEnabled()) {
                LOG.debug("CAB batch finished at " + this.dateTimeService.getCurrentTimestamp());
            }
            processLog.setFinishTime(this.dateTimeService.getCurrentTimestamp());
            processLog.setSuccess(true);
        } else {
            LOG.warn("****** No records processed during CAB Extract *******");
            processLog.setSuccess(false);
            processLog.setErrorMessage("No GL records were found for CAB processing.");
        }
    }

    @Override
    public void allocateAdditionalCharges(HashSet<PurchasingAccountsPayableDocument> purApDocuments) {
        ArrayList<PurchasingAccountsPayableActionHistory> actionsTakenHistory = new ArrayList<PurchasingAccountsPayableActionHistory>();
        ArrayList<PurchasingAccountsPayableDocument> candidateDocs = new ArrayList<PurchasingAccountsPayableDocument>();
        ArrayList<PurchasingAccountsPayableItemAsset> initialItems = new ArrayList<PurchasingAccountsPayableItemAsset>();
        for (PurchasingAccountsPayableDocument purApDoc : purApDocuments) {
            boolean documentUpdated = false;
            HashMap<String, String> primaryKeys = new HashMap<String, String>();
            primaryKeys.put("documentNumber", purApDoc.getDocumentNumber());
            PurchasingAccountsPayableDocument cabPurapDoc = (PurchasingAccountsPayableDocument)this.businessObjectService.findByPrimaryKey(PurchasingAccountsPayableDocument.class, primaryKeys);
            candidateDocs.add(cabPurapDoc);
            initialItems.addAll(cabPurapDoc.getPurchasingAccountsPayableItemAssets());
            for (PurchasingAccountsPayableItemAsset initialItem : initialItems) {
                this.purApInfoService.setAccountsPayableItemsFromPurAp(initialItem, cabPurapDoc.getDocumentTypeCode());
            }
            for (PurchasingAccountsPayableItemAsset allocateSourceLine : initialItems) {
                List<PurchasingAccountsPayableItemAsset> allocateTargetLines;
                if (!allocateSourceLine.isAdditionalChargeNonTradeInIndicator() || !allocateSourceLine.isActive() || (allocateTargetLines = this.purApLineService.getAllocateTargetLines(allocateSourceLine, candidateDocs)) == null || allocateTargetLines.isEmpty()) continue;
                this.setupObjectRelationship(candidateDocs);
                this.purApLineService.processAllocate(allocateSourceLine, allocateTargetLines, actionsTakenHistory, candidateDocs, true);
                documentUpdated = true;
            }
            if (documentUpdated) {
                this.businessObjectService.save((PersistableBusinessObject)cabPurapDoc);
            }
            candidateDocs.clear();
            initialItems.clear();
        }
    }

    protected void setupObjectRelationship(List<PurchasingAccountsPayableDocument> purApDocs) {
        for (PurchasingAccountsPayableDocument purApDoc : purApDocs) {
            for (PurchasingAccountsPayableItemAsset item : purApDoc.getPurchasingAccountsPayableItemAssets()) {
                item.setPurchasingAccountsPayableDocument(purApDoc);
                for (PurchasingAccountsPayableLineAssetAccount account : item.getPurchasingAccountsPayableLineAssetAccounts()) {
                    account.setPurchasingAccountsPayableItemAsset(item);
                }
            }
        }
    }

    protected BatchParameters createCabBatchParameters() {
        BatchParameters parameters = new BatchParameters();
        parameters.setLastRunTime(this.getCabLastRunTimestamp());
        parameters.setIncludedFinancialBalanceTypeCodes(this.parameterService.getParameterValuesAsString(KfsParameterConstants.CAPITAL_ASSETS_BATCH.class, "BALANCE_TYPES"));
        parameters.setIncludedFinancialObjectSubTypeCodes(this.parameterService.getParameterValuesAsString(KfsParameterConstants.CAPITAL_ASSETS_BATCH.class, "OBJECT_SUB_TYPES"));
        parameters.setExcludedChartCodes(this.parameterService.getParameterValuesAsString(KfsParameterConstants.CAPITAL_ASSETS_BATCH.class, "CHARTS"));
        parameters.setExcludedDocTypeCodes(this.parameterService.getParameterValuesAsString(KfsParameterConstants.CAPITAL_ASSETS_BATCH.class, "DOCUMENT_TYPES"));
        parameters.setExcludedFiscalPeriods(this.parameterService.getParameterValuesAsString(KfsParameterConstants.CAPITAL_ASSETS_BATCH.class, "FISCAL_PERIODS"));
        parameters.setExcludedSubFundCodes(this.parameterService.getParameterValuesAsString(KfsParameterConstants.CAPITAL_ASSETS_BATCH.class, "SUB_FUND_GROUPS"));
        return parameters;
    }

    protected BatchParameters createPreTagBatchParameters() {
        BatchParameters parameters = new BatchParameters();
        parameters.setLastRunDate(this.getPreTagLastRunDate());
        parameters.setIncludedFinancialObjectSubTypeCodes(this.parameterService.getParameterValuesAsString(PreAssetTaggingStep.class, "OBJECT_SUB_TYPES"));
        parameters.setExcludedChartCodes(this.parameterService.getParameterValuesAsString(KfsParameterConstants.CAPITAL_ASSETS_BATCH.class, "CHARTS"));
        parameters.setExcludedSubFundCodes(this.parameterService.getParameterValuesAsString(KfsParameterConstants.CAPITAL_ASSETS_BATCH.class, "SUB_FUND_GROUPS"));
        parameters.setCapitalizationLimitAmount(new BigDecimal(this.parameterService.getParameterValueAsString(AssetGlobal.class, "CAPITALIZATION_LIMIT_AMOUNT")));
        return parameters;
    }

    protected VendorCreditMemoDocument findCreditMemoDocument(Entry entry) {
        VendorCreditMemoDocument creditMemoDocument = null;
        LinkedHashMap<String, String> keys = new LinkedHashMap<String, String>();
        keys.put("documentNumber", entry.getDocumentNumber());
        Collection matchingCms = this.businessObjectService.findMatching(VendorCreditMemoDocument.class, keys);
        if (matchingCms != null && matchingCms.size() == 1) {
            creditMemoDocument = (VendorCreditMemoDocument)matchingCms.iterator().next();
        }
        return creditMemoDocument;
    }

    @Override
    public Collection<Entry> findElgibleGLEntries(ExtractProcessLog processLog) {
        BatchParameters parameters = this.createCabBatchParameters();
        processLog.setLastExtractTime(parameters.getLastRunTime());
        return this.extractDao.findMatchingGLEntries(parameters);
    }

    @Override
    public Collection<PurchaseOrderAccount> findPreTaggablePOAccounts() {
        BatchParameters parameters = this.createPreTagBatchParameters();
        return this.extractDao.findPreTaggablePOAccounts(parameters, this.getDocumentsNumbersAwaitingPurchaseOrderOpenStatus());
    }

    protected PaymentRequestDocument findPaymentRequestDocument(Entry entry) {
        PaymentRequestDocument paymentRequestDocument = null;
        LinkedHashMap<String, String> keys = new LinkedHashMap<String, String>();
        keys.put("documentNumber", entry.getDocumentNumber());
        Collection matchingPreqs = this.businessObjectService.findMatching(PaymentRequestDocument.class, keys);
        if (matchingPreqs != null && matchingPreqs.size() == 1) {
            paymentRequestDocument = (PaymentRequestDocument)matchingPreqs.iterator().next();
        }
        return paymentRequestDocument;
    }

    protected Timestamp getCabLastRunTimestamp() {
        Timestamp lastRunTime;
        String lastRunTS = this.parameterService.getParameterValueAsString(KfsParameterConstants.CAPITAL_ASSETS_BATCH.class, "LAST_EXTRACT_TIME");
        java.util.Date yesterday = DateUtils.addDays((java.util.Date)this.dateTimeService.getCurrentDate(), (int)-1);
        try {
            lastRunTime = lastRunTS == null ? new Timestamp(yesterday.getTime()) : new Timestamp(DateUtils.parseDate((String)lastRunTS, (String[])new String[]{"MM/dd/yyyy HH:mm:ss"}).getTime());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return lastRunTime;
    }

    protected Date getPreTagLastRunDate() {
        Date lastRunDt;
        String lastRunTS = this.parameterService.getParameterValueAsString(PreAssetTaggingStep.class, "LAST_EXTRACT_DATE");
        java.util.Date yesterday = DateUtils.addDays((java.util.Date)this.dateTimeService.getCurrentDate(), (int)-1);
        try {
            lastRunDt = lastRunTS == null ? new Date(yesterday.getTime()) : new Date(DateUtils.parseDate((String)lastRunTS, (String[])new String[]{"MM/dd/yyyy"}).getTime());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return lastRunDt;
    }

    @Override
    @Transactional
    public void saveFPLines(List<Entry> fpLines, ExtractProcessLog processLog) {
        for (Entry fpLine : fpLines) {
            if (fpLine.getTransactionLedgerEntryAmount() == null || fpLine.getTransactionLedgerEntryAmount().isZero()) {
                processLog.addIgnoredGLEntry(fpLine);
                continue;
            }
            if (this.getReconciliationService().isDuplicateEntry(fpLine)) {
                processLog.addDuplicateGLEntry(fpLine);
                continue;
            }
            GeneralLedgerEntry glEntry = new GeneralLedgerEntry(fpLine);
            this.businessObjectService.save((PersistableBusinessObject)glEntry);
        }
    }

    @Override
    @Transactional
    public HashSet<PurchasingAccountsPayableDocument> savePOLines(List<Entry> poLines, ExtractProcessLog processLog) {
        HashSet<PurchasingAccountsPayableDocument> purApDocuments = new HashSet<PurchasingAccountsPayableDocument>();
        Collection<PurApAccountingLineBase> purapAcctLines = this.findPurapAccountRevisions();
        ReconciliationService reconciliationService = this.getReconciliationService();
        reconciliationService.reconcile(poLines, purapAcctLines);
        Collection<GlAccountLineGroup> matchedGroups = reconciliationService.getMatchedGroups();
        HashMap<CallSite, PurchasingAccountsPayableItemAsset> assetItems = new HashMap<CallSite, PurchasingAccountsPayableItemAsset>();
        HashMap<CallSite, PurchasingAccountsPayableLineAssetAccount> assetAcctLines = new HashMap<CallSite, PurchasingAccountsPayableLineAssetAccount>();
        HashMap<String, Object> assetLockMap = new HashMap<String, Object>();
        HashMap<Integer, PurchaseOrderDocument> poDocMap = new HashMap<Integer, PurchaseOrderDocument>();
        HashMap<String, PurchasingAccountsPayableDocument> papdMap = new HashMap<String, PurchasingAccountsPayableDocument>();
        for (GlAccountLineGroup group : matchedGroups) {
            boolean nonZero;
            Entry entry = group.getTargetEntry();
            GeneralLedgerEntry generalLedgerEntry = new GeneralLedgerEntry(entry);
            GeneralLedgerEntry debitEntry = null;
            GeneralLedgerEntry creditEntry = null;
            KualiDecimal transactionLedgerEntryAmount = generalLedgerEntry.getTransactionLedgerEntryAmount();
            List<PurApAccountingLineBase> matchedPurApAcctLines = group.getMatchedPurApAcctLines();
            boolean hasPositiveAndNegative = this.hasPositiveAndNegative(matchedPurApAcctLines);
            boolean bl = nonZero = ObjectUtils.isNotNull((Object)transactionLedgerEntryAmount) && transactionLedgerEntryAmount.isNonZero();
            if (nonZero && !hasPositiveAndNegative) {
                this.businessObjectService.save((PersistableBusinessObject)generalLedgerEntry);
            } else {
                debitEntry = this.createPositiveGlEntry(entry);
                this.businessObjectService.save((PersistableBusinessObject)debitEntry);
                creditEntry = this.createNegativeGlEntry(entry);
                this.businessObjectService.save((PersistableBusinessObject)creditEntry);
            }
            boolean newApDoc = false;
            PurchasingAccountsPayableDocument cabPurapDoc = (PurchasingAccountsPayableDocument)((Object)papdMap.get(entry.getDocumentNumber()));
            if (ObjectUtils.isNull((Object)((Object)cabPurapDoc))) {
                cabPurapDoc = this.findPurchasingAccountsPayableDocument(entry);
            }
            if (ObjectUtils.isNull((Object)((Object)cabPurapDoc))) {
                cabPurapDoc = this.createPurchasingAccountsPayableDocument(entry);
                newApDoc = true;
            }
            if (cabPurapDoc != null) {
                KualiDecimal amount;
                papdMap.put(entry.getDocumentNumber(), cabPurapDoc);
                boolean isPREQ = "PREQ".equals(entry.getFinancialDocumentTypeCode());
                boolean hasRevisionWithMixedLines = isPREQ && this.hasRevisionWithMixedLines(matchedPurApAcctLines);
                for (PurApAccountingLineBase purApAccountingLine : matchedPurApAcctLines) {
                    boolean newAssetItem = false;
                    PurApItem purapItem = purApAccountingLine.getPurapItem();
                    String itemAssetKey = cabPurapDoc.getDocumentNumber() + "-" + purapItem.getItemIdentifier();
                    PurchasingAccountsPayableItemAsset itemAsset = (PurchasingAccountsPayableItemAsset)assetItems.get(itemAssetKey);
                    if (ObjectUtils.isNull((Object)itemAsset)) {
                        itemAsset = this.findMatchingPurapAssetItem(cabPurapDoc, purapItem);
                    }
                    if (ObjectUtils.isNull((Object)itemAsset)) {
                        itemAsset = this.createPurchasingAccountsPayableItemAsset(cabPurapDoc, purapItem);
                        cabPurapDoc.getPurchasingAccountsPayableItemAssets().add(itemAsset);
                        newAssetItem = true;
                    }
                    assetItems.put((CallSite)((Object)itemAssetKey), itemAsset);
                    String acctLineKey = cabPurapDoc.getDocumentNumber() + "-" + itemAsset.getAccountsPayableLineItemIdentifier() + "-" + itemAsset.getCapitalAssetBuilderLineNumber() + "-" + generalLedgerEntry.getGeneralLedgerAccountIdentifier();
                    PurchasingAccountsPayableLineAssetAccount assetAccount = (PurchasingAccountsPayableLineAssetAccount)((Object)assetAcctLines.get(acctLineKey));
                    if (ObjectUtils.isNull((Object)((Object)assetAccount)) && nonZero && !hasPositiveAndNegative) {
                        assetAccount = this.createPurchasingAccountsPayableLineAssetAccount(generalLedgerEntry, cabPurapDoc, purApAccountingLine, itemAsset);
                        assetAcctLines.put((CallSite)((Object)acctLineKey), assetAccount);
                        itemAsset.getPurchasingAccountsPayableLineAssetAccounts().add(assetAccount);
                    } else if (!nonZero || hasPositiveAndNegative) {
                        KualiDecimal purapAmount = purApAccountingLine.getAmount();
                        boolean isPositive = purapAmount.isPositive();
                        boolean usuallyNegative = this.isItemTypeUsuallyOfNegativeAmount(purapItem.getItemTypeCode());
                        boolean isDebitEntry = hasRevisionWithMixedLines ? (usuallyNegative ? !isPositive : isPositive) : (isPREQ ? isPositive : !isPositive);
                        GeneralLedgerEntry currentEntry = isDebitEntry ? debitEntry : creditEntry;
                        KualiDecimal oldAmount = currentEntry.getTransactionLedgerEntryAmount();
                        oldAmount = isDebitEntry ? oldAmount : (KualiDecimal)oldAmount.negated();
                        KualiDecimal newAmount = (KualiDecimal)oldAmount.add((AbstractKualiDecimal)purapAmount);
                        newAmount = isDebitEntry ? newAmount : (KualiDecimal)newAmount.negated();
                        currentEntry.setTransactionLedgerEntryAmount(newAmount);
                        assetAccount = this.createPurchasingAccountsPayableLineAssetAccount(currentEntry, cabPurapDoc, purApAccountingLine, itemAsset);
                        itemAsset.getPurchasingAccountsPayableLineAssetAccounts().add(assetAccount);
                    } else if (ObjectUtils.isNotNull((Object)((Object)assetAccount))) {
                        assetAccount.setItemAccountTotalAmount((KualiDecimal)assetAccount.getItemAccountTotalAmount().add((AbstractKualiDecimal)purApAccountingLine.getAmount()));
                    }
                    if (!newAssetItem) {
                        this.businessObjectService.save((PersistableBusinessObject)itemAsset);
                    }
                    this.businessObjectService.save((PersistableBusinessObject)cabPurapDoc);
                    this.addAssetLocks(assetLockMap, cabPurapDoc, purapItem, itemAsset.getAccountsPayableLineItemIdentifier(), poDocMap);
                }
                if (debitEntry != null) {
                    amount = debitEntry.getTransactionLedgerEntryAmount();
                    if (amount.isNegative()) {
                        debitEntry.setTransactionDebitCreditCode("C");
                        debitEntry.setTransactionLedgerEntryAmount((KualiDecimal)amount.negated());
                    }
                    this.businessObjectService.save((PersistableBusinessObject)debitEntry);
                }
                if (creditEntry != null) {
                    amount = creditEntry.getTransactionLedgerEntryAmount();
                    if (amount.isNegative()) {
                        creditEntry.setTransactionDebitCreditCode("D");
                        creditEntry.setTransactionLedgerEntryAmount((KualiDecimal)amount.negated());
                    }
                    this.businessObjectService.save((PersistableBusinessObject)creditEntry);
                }
                if (!newApDoc) continue;
                purApDocuments.add(cabPurapDoc);
                continue;
            }
            LOG.error("Could not create a valid PurchasingAccountsPayableDocument object for document number " + entry.getDocumentNumber());
        }
        this.updateProcessLog(processLog, reconciliationService);
        return purApDocuments;
    }

    private boolean isItemTypeUsuallyOfNegativeAmount(String itemTypeCode) {
        return "TRDI".equals(itemTypeCode) || "ORDS".equals(itemTypeCode) || "MISC".equals(itemTypeCode);
    }

    private boolean hasRevisionWithMixedLines(List<PurApAccountingLineBase> matchedPurApAcctLines) {
        boolean hasItemsUsuallyNegative = false;
        boolean hasOthers = false;
        boolean hasRevision = false;
        HashSet<Integer> itemIdentifiers = new HashSet<Integer>();
        for (PurApAccountingLineBase purApAccountingLine : matchedPurApAcctLines) {
            PurApItem purapItem = purApAccountingLine.getPurapItem();
            if (this.isItemTypeUsuallyOfNegativeAmount(purapItem.getItemTypeCode())) {
                hasItemsUsuallyNegative = true;
            } else {
                hasOthers = true;
            }
            if (itemIdentifiers.contains(purApAccountingLine.getItemIdentifier())) {
                hasRevision = true;
            } else {
                itemIdentifiers.add(purApAccountingLine.getItemIdentifier());
            }
            if (!hasRevision || !hasItemsUsuallyNegative || !hasOthers) continue;
            return true;
        }
        return false;
    }

    private boolean hasPositiveAndNegative(List<PurApAccountingLineBase> matchedPurApAcctLines) {
        boolean hasPositive = false;
        boolean hasNegative = false;
        for (PurApAccountingLineBase line : matchedPurApAcctLines) {
            hasPositive = hasPositive || line.getAmount().isPositive();
            boolean bl = hasNegative = hasNegative || line.getAmount().isNegative();
            if (!hasPositive || !hasNegative) continue;
            return true;
        }
        return false;
    }

    protected void addAssetLocks(HashMap<String, Object> assetLockMap, PurchasingAccountsPayableDocument cabPurapDoc, PurApItem purapItem, Integer accountsPaymentItemId, HashMap<Integer, PurchaseOrderDocument> poDocMap) {
        PurchaseOrderDocument purApdocument;
        if (poDocMap.containsKey(cabPurapDoc.getPurchaseOrderIdentifier())) {
            purApdocument = poDocMap.get(cabPurapDoc.getPurchaseOrderIdentifier());
        } else {
            purApdocument = this.purApInfoService.getCurrentDocumentForPurchaseOrderIdentifier(cabPurapDoc.getPurchaseOrderIdentifier());
            poDocMap.put(cabPurapDoc.getPurchaseOrderIdentifier(), purApdocument);
        }
        Object assetLockKey = cabPurapDoc.getDocumentNumber();
        String lockingInformation = null;
        if ("IND".equalsIgnoreCase(purApdocument.getCapitalAssetSystemTypeCode())) {
            lockingInformation = accountsPaymentItemId.toString();
            assetLockKey = cabPurapDoc.getDocumentNumber() + "-" + lockingInformation;
        }
        if (!assetLockMap.containsKey(assetLockKey) && !this.capitalAssetManagementModuleService.isAssetLockedByCurrentDocument(cabPurapDoc.getDocumentNumber(), lockingInformation)) {
            List capitalAssetNumbers = this.getAssetNumbersForLocking(purApdocument, purapItem);
            if (capitalAssetNumbers != null && !capitalAssetNumbers.isEmpty()) {
                boolean lockingResult = this.capitalAssetManagementModuleService.storeAssetLocks(capitalAssetNumbers, cabPurapDoc.getDocumentNumber(), cabPurapDoc.getDocumentTypeCode(), lockingInformation);
                assetLockMap.put((String)assetLockKey, lockingResult);
            } else {
                assetLockMap.put((String)assetLockKey, false);
            }
        }
    }

    protected List getAssetNumbersForLocking(PurchaseOrderDocument purApdocument, PurApItem purapItem) {
        if (!"MOD".equalsIgnoreCase(purApdocument.getCapitalAssetSystemStateCode())) {
            return null;
        }
        return this.purApInfoService.retrieveValidAssetNumberForLocking(purApdocument.getPurapDocumentIdentifier(), purApdocument.getCapitalAssetSystemTypeCode(), purapItem);
    }

    protected GeneralLedgerEntry createPositiveGlEntry(Entry entry) {
        GeneralLedgerEntry copyEntry = new GeneralLedgerEntry(entry);
        copyEntry.setTransactionDebitCreditCode("D");
        copyEntry.setTransactionLedgerEntryAmount(KualiDecimal.ZERO);
        return copyEntry;
    }

    protected GeneralLedgerEntry createNegativeGlEntry(Entry entry) {
        GeneralLedgerEntry copyEntry = new GeneralLedgerEntry(entry);
        copyEntry.setTransactionDebitCreditCode("C");
        copyEntry.setTransactionLedgerEntryAmount(KualiDecimal.ZERO);
        return copyEntry;
    }

    @Override
    public Collection<PurApAccountingLineBase> findPurapAccountRevisions() {
        ArrayList<PurApAccountingLineBase> purapAcctLines = new ArrayList<PurApAccountingLineBase>();
        Collection<CreditMemoAccountRevision> cmAccountHistory = this.extractDao.findCreditMemoAccountRevisions(this.createCabBatchParameters());
        Collection<PaymentRequestAccountRevision> preqAccountHistory = this.extractDao.findPaymentRequestAccountRevisions(this.createCabBatchParameters());
        if (cmAccountHistory != null) {
            purapAcctLines.addAll(cmAccountHistory);
        }
        if (preqAccountHistory != null) {
            purapAcctLines.addAll(preqAccountHistory);
        }
        return purapAcctLines;
    }

    protected PurchasingAccountsPayableLineAssetAccount createPurchasingAccountsPayableLineAssetAccount(GeneralLedgerEntry generalLedgerEntry, PurchasingAccountsPayableDocument cabPurapDoc, PurApAccountingLineBase purApAccountingLine, PurchasingAccountsPayableItemAsset itemAsset) {
        PurchasingAccountsPayableLineAssetAccount assetAccount = new PurchasingAccountsPayableLineAssetAccount();
        assetAccount.setDocumentNumber(cabPurapDoc.getDocumentNumber());
        assetAccount.setAccountsPayableLineItemIdentifier(itemAsset.getAccountsPayableLineItemIdentifier());
        assetAccount.setCapitalAssetBuilderLineNumber(itemAsset.getCapitalAssetBuilderLineNumber());
        assetAccount.setGeneralLedgerAccountIdentifier(generalLedgerEntry.getGeneralLedgerAccountIdentifier());
        if ("CM".equals(generalLedgerEntry.getFinancialDocumentTypeCode())) {
            assetAccount.setItemAccountTotalAmount((KualiDecimal)purApAccountingLine.getAmount().negated());
        } else {
            assetAccount.setItemAccountTotalAmount(purApAccountingLine.getAmount());
        }
        assetAccount.setActivityStatusCode("N");
        assetAccount.setVersionNumber(0L);
        return assetAccount;
    }

    protected void updateProcessLog(ExtractProcessLog processLog, ReconciliationService reconciliationService) {
        processLog.addIgnoredGLEntries(reconciliationService.getIgnoredEntries());
        processLog.addDuplicateGLEntries(reconciliationService.getDuplicateEntries());
        Collection<GlAccountLineGroup> misMatchedGroups = reconciliationService.getMisMatchedGroups();
        for (GlAccountLineGroup glAccountLineGroup : misMatchedGroups) {
            processLog.addMismatchedGLEntries(glAccountLineGroup.getSourceEntries());
        }
    }

    protected PurchasingAccountsPayableDocument findPurchasingAccountsPayableDocument(Entry entry) {
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("documentNumber", entry.getDocumentNumber());
        return (PurchasingAccountsPayableDocument)this.businessObjectService.findByPrimaryKey(PurchasingAccountsPayableDocument.class, primaryKeys);
    }

    protected PurchasingAccountsPayableItemAsset createPurchasingAccountsPayableItemAsset(PurchasingAccountsPayableDocument cabPurapDoc, PurApItem apItem) {
        PurApItem poItem;
        PurchaseOrderDocument poDoc;
        PurchasingAccountsPayableItemAsset itemAsset = new PurchasingAccountsPayableItemAsset();
        itemAsset.setDocumentNumber(cabPurapDoc.getDocumentNumber());
        itemAsset.setAccountsPayableLineItemIdentifier(apItem.getItemIdentifier());
        itemAsset.setCapitalAssetBuilderLineNumber(this.purchasingAccountsPayableItemAssetDao.findMaxCabLineNumber(cabPurapDoc.getDocumentNumber(), apItem.getItemIdentifier()) + 1);
        if (ObjectUtils.isNotNull((Object)((Object)cabPurapDoc)) && ObjectUtils.isNotNull((Object)apItem.getItemType()) && apItem.getItemType().isLineItemIndicator() && ObjectUtils.isNotNull((Object)(poDoc = this.purApInfoService.getCurrentDocumentForPurchaseOrderIdentifier(cabPurapDoc.getPurchaseOrderIdentifier()))) && ObjectUtils.isNotNull((Object)(poItem = poDoc.getItemByLineNumber(apItem.getItemLineNumber().intValue())))) {
            itemAsset.setAccountsPayableLineItemDescription(poItem.getItemDescription());
        }
        itemAsset.setAccountsPayableItemQuantity(apItem.getItemQuantity() == null ? new KualiDecimal(1) : apItem.getItemQuantity());
        itemAsset.setActivityStatusCode("N");
        itemAsset.setVersionNumber(0L);
        return itemAsset;
    }

    protected PurchasingAccountsPayableDocument createPurchasingAccountsPayableDocument(Entry entry) {
        PaymentRequestDocument apDoc = null;
        PurchasingAccountsPayableDocument cabPurapDoc = null;
        if ("PREQ".equals(entry.getFinancialDocumentTypeCode())) {
            apDoc = this.findPaymentRequestDocument(entry);
        } else if ("CM".equals(entry.getFinancialDocumentTypeCode())) {
            apDoc = this.findCreditMemoDocument(entry);
        }
        if (apDoc == null) {
            LOG.error("A valid Purchasing Document (PREQ or CM) could not be found for this document number " + entry.getDocumentNumber());
        } else {
            cabPurapDoc = new PurchasingAccountsPayableDocument();
            cabPurapDoc.setDocumentNumber(entry.getDocumentNumber());
            cabPurapDoc.setPurapDocumentIdentifier(apDoc.getPurapDocumentIdentifier());
            cabPurapDoc.setPurchaseOrderIdentifier(apDoc.getPurchaseOrderIdentifier());
            cabPurapDoc.setDocumentTypeCode(entry.getFinancialDocumentTypeCode());
            cabPurapDoc.setActivityStatusCode("N");
            cabPurapDoc.setVersionNumber(0L);
        }
        return cabPurapDoc;
    }

    protected PurchasingAccountsPayableItemAsset findMatchingPurapAssetItem(PurchasingAccountsPayableDocument cabPurapDoc, PurApItem apItem) {
        if (ObjectUtils.isNotNull((Object)((Object)cabPurapDoc))) {
            for (PurchasingAccountsPayableItemAsset assetItem : cabPurapDoc.getPurchasingAccountsPayableItemAssets()) {
                if (assetItem.getAccountsPayableLineItemIdentifier() == null || !assetItem.getAccountsPayableLineItemIdentifier().equals(apItem.getItemIdentifier()) || !ObjectUtils.isNotNull((Object)assetItem) || !"N".equalsIgnoreCase(assetItem.getActivityStatusCode())) continue;
                return assetItem;
            }
        } else {
            LOG.error("expecting the CAB AP document not null");
        }
        return null;
    }

    @Override
    public void separatePOLines(List<Entry> fpLines, List<Entry> purapLines, Collection<Entry> eligibleGLEntries) {
        for (Entry entry : eligibleGLEntries) {
            if ("PREQ".equals(entry.getFinancialDocumentTypeCode())) {
                purapLines.add(entry);
                continue;
            }
            if (!"CM".equals(entry.getFinancialDocumentTypeCode())) {
                fpLines.add(entry);
                continue;
            }
            if (!"CM".equals(entry.getFinancialDocumentTypeCode())) continue;
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("documentNumber", entry.getDocumentNumber());
            Collection matchingCreditMemos = this.businessObjectService.findMatching(VendorCreditMemoDocument.class, fieldValues);
            for (VendorCreditMemoDocument creditMemoDocument : matchingCreditMemos) {
                if (creditMemoDocument.getPurchaseOrderIdentifier() == null) {
                    fpLines.add(entry);
                    continue;
                }
                purapLines.add(entry);
            }
        }
    }

    @Override
    public void updateLastExtractTime(Timestamp time) {
        Parameter parameter = this.parameterService.getParameter("KFS-CAM", "Batch", "LAST_EXTRACT_TIME");
        if (parameter != null) {
            SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss", Locale.US);
            Parameter.Builder updatedParameter = Parameter.Builder.create((ParameterContract)parameter);
            updatedParameter.setValue(format.format(time));
            this.parameterService.updateParameter(updatedParameter.build());
        }
    }

    @Override
    @Transactional
    public void savePreTagLines(Collection<PurchaseOrderAccount> preTaggablePOAccounts) {
        HashSet<CallSite> savedLines = new HashSet<CallSite>();
        for (PurchaseOrderAccount purchaseOrderAccount : preTaggablePOAccounts) {
            purchaseOrderAccount.refresh();
            PurchaseOrderItem purapItem = (PurchaseOrderItem)purchaseOrderAccount.getPurapItem();
            PurchaseOrderDocument purchaseOrder = purapItem.getPurchaseOrder();
            if (!ObjectUtils.isNotNull((Object)purchaseOrder)) continue;
            Integer poId = purchaseOrder.getPurapDocumentIdentifier();
            Integer itemLineNumber = purapItem.getItemLineNumber();
            if (poId == null || itemLineNumber == null) continue;
            HashMap<String, Integer> primaryKeys = new HashMap<String, Integer>();
            primaryKeys.put("purchaseOrderNumber", poId);
            primaryKeys.put("itemLineNumber", itemLineNumber);
            Pretag pretag = (Pretag)this.businessObjectService.findByPrimaryKey(Pretag.class, primaryKeys);
            if (!ObjectUtils.isNull((Object)((Object)pretag)) || !savedLines.add((CallSite)((Object)(poId + "-" + itemLineNumber)))) continue;
            pretag = new Pretag();
            pretag.setPurchaseOrderNumber(poId.toString());
            pretag.setItemLineNumber(itemLineNumber);
            KualiDecimal quantity = purapItem.getItemQuantity();
            pretag.setQuantityInvoiced(quantity != null ? quantity : new KualiDecimal(1));
            pretag.setVendorName(purchaseOrder.getVendorName());
            pretag.setAssetTopsDescription(purapItem.getItemDescription());
            pretag.setPretagCreateDate(new Date(purchaseOrder.getPurchaseOrderInitialOpenTimestamp().getTime()));
            pretag.setChartOfAccountsCode(purchaseOrder.getChartOfAccountsCode());
            pretag.setOrganizationCode(purchaseOrder.getOrganizationCode());
            pretag.setActive(true);
            this.businessObjectService.save((PersistableBusinessObject)pretag);
        }
    }

    protected List<String> getDocumentsNumbersAwaitingPurchaseOrderOpenStatus() {
        List poDocuments;
        ArrayList<String> poDocumentNumbers = new ArrayList<String>();
        try {
            poDocuments = (List)this.financialSystemDocumentService.findByApplicationDocumentStatus(PurchaseOrderDocument.class, "Open");
        }
        catch (WorkflowException we) {
            throw new RuntimeException(we);
        }
        for (PurchaseOrderDocument poDocument : poDocuments) {
            poDocumentNumbers.add(poDocument.getDocumentNumber());
        }
        return poDocumentNumbers;
    }

    @Override
    public void updateLastExtractDate(Date dt) {
        Parameter parameter = this.parameterService.getParameter("KFS-CAM", "PreAssetTaggingStep", "LAST_EXTRACT_DATE");
        if (parameter != null) {
            SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy", Locale.US);
            Parameter.Builder updatedParameter = Parameter.Builder.create((ParameterContract)parameter);
            updatedParameter.setValue(format.format(dt));
            this.parameterService.updateParameter(updatedParameter.build());
        }
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setExtractDao(ExtractDao extractDao) {
        this.extractDao = extractDao;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setPurchasingAccountsPayableItemAssetDao(PurchasingAccountsPayableItemAssetDao purchasingAccountsPayableItemAssetDao) {
        this.purchasingAccountsPayableItemAssetDao = purchasingAccountsPayableItemAssetDao;
    }

    public void setPurApLineService(PurApLineService purApLineService) {
        this.purApLineService = purApLineService;
    }

    public void setPurApInfoService(PurApInfoService purApInfoService) {
        this.purApInfoService = purApInfoService;
    }

    private ReconciliationService getReconciliationService() {
        return (ReconciliationService)SpringContext.getBean(ReconciliationService.class);
    }

    public void setFinancialSystemDocumentService(FinancialSystemDocumentService financialSystemDocumentService) {
        this.financialSystemDocumentService = financialSystemDocumentService;
    }

    public void setCapitalAssetManagementModuleService(CapitalAssetManagementModuleService capitalAssetManagementModuleService) {
        this.capitalAssetManagementModuleService = capitalAssetManagementModuleService;
    }
}

