/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.businessobject.lookup;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.kuali.kfs.datadictionary.legacy.DocumentDictionaryService;
import org.kuali.kfs.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.kfs.kns.lookup.CollectionIncomplete;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.kfs.kns.lookup.LookupUtils;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.krad.document.DocumentAuthorizer;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.businessobject.AssetAcquisitionType;
import org.kuali.kfs.module.cam.businessobject.AssetGlobal;
import org.kuali.kfs.module.cam.document.service.AssetGlobalService;
import org.kuali.rice.krad.bo.BusinessObject;

public class AssetAcquisitionTypeLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    protected boolean initializingAssetGlobal = true;
    private AssetGlobalService assetGlobalService;
    private DocumentDictionaryService documentDictionaryService;

    public HtmlData getReturnUrl(BusinessObject businessObject, LookupForm lookupForm, List returnKeys, BusinessObjectRestrictions businessObjectRestrictions) {
        DocumentAuthorizer documentAuthorizer;
        boolean isAuthorized;
        AssetAcquisitionType assetAcquisitionType = (AssetAcquisitionType)businessObject;
        if (this.initializingAssetGlobal && !assetAcquisitionType.isActive()) {
            return this.getEmptyAnchorHtmlData();
        }
        if (this.assetGlobalService.getNewAcquisitionTypeCode().equalsIgnoreCase(assetAcquisitionType.getAcquisitionTypeCode()) && !(isAuthorized = (documentAuthorizer = this.documentDictionaryService.getDocumentAuthorizer("AA")).isAuthorized((Object)businessObject, "KFS-CAM", "Use Acquisition Type \"New\"", GlobalVariables.getUserSession().getPerson().getPrincipalId()))) {
            return this.getEmptyAnchorHtmlData();
        }
        Map<String, String> parameters = this.generateUrlParameters(businessObject, lookupForm, returnKeys);
        return this.getReturnAnchorHtmlData(businessObject, parameters, lookupForm, returnKeys, businessObjectRestrictions);
    }

    protected Map<String, String> generateUrlParameters(BusinessObject businessObject, LookupForm lookupForm, List returnKeys) {
        AssetAcquisitionType assetAcquisitionType = (AssetAcquisitionType)businessObject;
        Map parameters = this.getParameters(businessObject, lookupForm.getFieldConversions(), lookupForm.getLookupableImplServiceName(), returnKeys);
        parameters.put("methodToCall", "newWithExisting");
        parameters.put("businessObjectClassName", AssetGlobal.class.getName());
        parameters.put("overrideKeys", "acquisitionTypeCode");
        parameters.put("refreshCaller", "acquisitionTypeCode::" + assetAcquisitionType.getAcquisitionTypeCode());
        this.setBackLocation("maintenance.do");
        return parameters;
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        List searchResults = super.getSearchResults(fieldValues);
        if (searchResults == null || searchResults.isEmpty() || !this.initializingAssetGlobal) {
            return searchResults;
        }
        Integer searchResultsLimit = LookupUtils.getSearchResultsLimit(AssetAcquisitionType.class);
        ArrayList<AssetAcquisitionType> newList = new ArrayList<AssetAcquisitionType>();
        for (BusinessObject businessObject : searchResults) {
            AssetAcquisitionType acquisition = (AssetAcquisitionType)businessObject;
            if (!ObjectUtils.isNotNull((Object)((Object)acquisition)) || "C".equalsIgnoreCase(acquisition.getAcquisitionTypeCode()) || "P".equalsIgnoreCase(acquisition.getAcquisitionTypeCode())) continue;
            newList.add(acquisition);
        }
        long matchingResultsCount = newList.size();
        if (matchingResultsCount <= (long)searchResultsLimit.intValue()) {
            matchingResultsCount = 0L;
        }
        return new CollectionIncomplete(newList, Long.valueOf(matchingResultsCount));
    }

    public void setFieldConversions(Map fieldConversions) {
        super.setFieldConversions(fieldConversions);
        if (fieldConversions == null || fieldConversions.size() == 0) {
            this.initializingAssetGlobal = false;
        }
    }

    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        if (!this.initializingAssetGlobal) {
            return super.getCustomActionUrls(businessObject, pkNames);
        }
        return super.getEmptyActionUrls();
    }

    public void setAssetGlobalService(AssetGlobalService assetGlobalService) {
        this.assetGlobalService = assetGlobalService;
    }

    public void setDocumentDictionaryService(DocumentDictionaryService documentDictionaryService) {
        this.documentDictionaryService = documentDictionaryService;
    }
}

