/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.coa.service.OrganizationService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.datadictionary.legacy.DocumentDictionaryService;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.document.authorization.MaintenanceDocumentAuthorizer;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetGlpeSourceDetail;
import org.kuali.kfs.module.cam.businessobject.AssetObjectCode;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.businessobject.AssetRetirementGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetRetirementGlobalDetail;
import org.kuali.kfs.module.cam.document.gl.CamsGeneralLedgerPendingEntrySourceBase;
import org.kuali.kfs.module.cam.document.service.AssetObjectCodeService;
import org.kuali.kfs.module.cam.document.service.AssetPaymentService;
import org.kuali.kfs.module.cam.document.service.AssetRetirementService;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.module.cam.util.ObjectValueUtils;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.bo.BusinessObject;

public class AssetRetirementServiceImpl
implements AssetRetirementService {
    protected UniversityDateService universityDateService;
    protected AssetObjectCodeService assetObjectCodeService;
    protected BusinessObjectService businessObjectService;
    protected AssetPaymentService assetPaymentService;
    protected ParameterService parameterService;
    protected AssetService assetService;
    protected OrganizationService organizationService;
    protected ObjectCodeService objectCodeService;

    public ObjectCodeService getObjectCodeService() {
        return this.objectCodeService;
    }

    public void setObjectCodeService(ObjectCodeService serv) {
        this.objectCodeService = serv;
    }

    public OrganizationService getOrganizationService() {
        return this.organizationService;
    }

    public void setOrganizationService(OrganizationService serv) {
        this.organizationService = serv;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public AssetService getAssetService() {
        return this.assetService;
    }

    public void setAssetService(AssetService assetService) {
        this.assetService = assetService;
    }

    public UniversityDateService getUniversityDateService() {
        return this.universityDateService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    public AssetObjectCodeService getAssetObjectCodeService() {
        return this.assetObjectCodeService;
    }

    public void setAssetObjectCodeService(AssetObjectCodeService assetObjectCodeService) {
        this.assetObjectCodeService = assetObjectCodeService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public AssetPaymentService getAssetPaymentService() {
        return this.assetPaymentService;
    }

    public void setAssetPaymentService(AssetPaymentService assetPaymentService) {
        this.assetPaymentService = assetPaymentService;
    }

    @Override
    public boolean isAssetRetiredByAuction(AssetRetirementGlobal assetRetirementGlobal) {
        return "A".equalsIgnoreCase(assetRetirementGlobal.getRetirementReasonCode());
    }

    @Override
    public boolean isAssetRetiredBySold(AssetRetirementGlobal assetRetirementGlobal) {
        return "1".equalsIgnoreCase(assetRetirementGlobal.getRetirementReasonCode());
    }

    @Override
    public boolean isAssetRetiredByExternalTransferOrGift(AssetRetirementGlobal assetRetirementGlobal) {
        return "9".equalsIgnoreCase(assetRetirementGlobal.getRetirementReasonCode()) || "6".equalsIgnoreCase(assetRetirementGlobal.getRetirementReasonCode());
    }

    @Override
    public boolean isAssetRetiredByMerged(AssetRetirementGlobal assetRetirementGlobal) {
        return "M".equalsIgnoreCase(assetRetirementGlobal.getRetirementReasonCode());
    }

    @Override
    public boolean isAssetRetiredByTheft(AssetRetirementGlobal assetRetirementGlobal) {
        return "7".equalsIgnoreCase(assetRetirementGlobal.getRetirementReasonCode());
    }

    @Override
    public String getAssetRetirementReasonName(AssetRetirementGlobal assetRetirementGlobal) {
        return assetRetirementGlobal.getRetirementReason() == null ? "" : assetRetirementGlobal.getRetirementReason().getRetirementReasonName();
    }

    @Override
    public void generateOffsetPaymentsForEachSource(Asset sourceAsset, List<PersistableBusinessObject> persistables, String currentDocumentNumber) {
        ArrayList<AssetPayment> offsetPayments = new ArrayList<AssetPayment>();
        Integer maxSequenceNo = this.assetPaymentService.getMaxSequenceNumber(sourceAsset.getCapitalAssetNumber());
        try {
            for (AssetPayment sourcePayment : sourceAsset.getAssetPayments()) {
                AssetPayment offsetPayment = new AssetPayment();
                ObjectValueUtils.copySimpleProperties((Object)sourcePayment, (Object)offsetPayment);
                offsetPayment.setFinancialDocumentTypeCode("AMRG");
                offsetPayment.setDocumentNumber(currentDocumentNumber);
                maxSequenceNo = maxSequenceNo + 1;
                offsetPayment.setPaymentSequenceNumber(maxSequenceNo);
                this.assetPaymentService.adjustPaymentAmounts(offsetPayment, true, false);
                offsetPayments.add(offsetPayment);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error occurred while creating offset payment in retirement", e);
        }
        persistables.addAll(offsetPayments);
    }

    @Override
    public Integer generateNewPaymentForTarget(Asset targetAsset, Asset sourceAsset, List<PersistableBusinessObject> persistables, Integer maxSequenceNo, String currentDocumentNumber) {
        ArrayList<AssetPayment> newPayments = new ArrayList<AssetPayment>();
        try {
            for (AssetPayment sourcePayment : sourceAsset.getAssetPayments()) {
                AssetPayment newPayment = new AssetPayment();
                ObjectValueUtils.copySimpleProperties((Object)sourcePayment, (Object)newPayment);
                newPayment.setCapitalAssetNumber(targetAsset.getCapitalAssetNumber());
                newPayment.setFinancialDocumentTypeCode("AMRG");
                maxSequenceNo = maxSequenceNo + 1;
                newPayment.setPaymentSequenceNumber(maxSequenceNo);
                newPayment.setDocumentNumber(currentDocumentNumber);
                this.assetPaymentService.adjustPaymentAmounts(newPayment, false, false);
                newPayments.add(newPayment);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error occurred while creating new payment in retirement", e);
        }
        persistables.addAll(newPayments);
        return maxSequenceNo;
    }

    @Override
    public boolean isRetirementReasonCodeInGroup(String reasonCodeGroup, String reasonCode) {
        if (StringUtils.isBlank((CharSequence)reasonCodeGroup) || StringUtils.isBlank((CharSequence)reasonCode)) {
            return false;
        }
        return Arrays.asList(reasonCodeGroup.split(";")).contains(reasonCode);
    }

    @Override
    public boolean isAllowedRetireMultipleAssets(MaintenanceDocument maintenanceDocument) {
        MaintenanceDocumentAuthorizer documentAuthorizer = (MaintenanceDocumentAuthorizer)((DocumentDictionaryService)SpringContext.getBean(DocumentDictionaryService.class)).getDocumentAuthorizer((Document)maintenanceDocument);
        return documentAuthorizer.isAuthorized((BusinessObject)maintenanceDocument, "KFS-CAM", "Retire Multiple", GlobalVariables.getUserSession().getPerson().getPrincipalId());
    }

    @Override
    public void createGLPostables(AssetRetirementGlobal assetRetirementGlobal, CamsGeneralLedgerPendingEntrySourceBase assetRetirementGlPoster) {
        List<AssetRetirementGlobalDetail> assetRetirementGlobalDetails = assetRetirementGlobal.getAssetRetirementGlobalDetails();
        for (AssetRetirementGlobalDetail assetRetirementGlobalDetail : assetRetirementGlobalDetails) {
            Asset asset = assetRetirementGlobalDetail.getAsset();
            for (AssetPayment assetPayment : asset.getAssetPayments()) {
                if (this.getAssetPaymentService().isPaymentFederalOwned(assetPayment) || "Y".equals(assetPayment.getTransferPaymentCode())) continue;
                List<GeneralLedgerPendingEntrySourceDetail> postables = this.generateGlPostablesForOnePayment(assetRetirementGlobal.getDocumentNumber(), assetRetirementGlPoster, asset, assetPayment);
                assetRetirementGlPoster.getPostables().addAll(postables);
            }
        }
    }

    protected List<GeneralLedgerPendingEntrySourceDetail> generateGlPostablesForOnePayment(String documentNumber, CamsGeneralLedgerPendingEntrySourceBase assetRetirementGlPoster, Asset asset, AssetPayment assetPayment) {
        ArrayList<GeneralLedgerPendingEntrySourceDetail> postables = new ArrayList<GeneralLedgerPendingEntrySourceDetail>();
        Account plantAccount = this.getPlantFundAccount(assetPayment);
        if (ObjectUtils.isNotNull((Object)plantAccount)) {
            if (this.assetPaymentService.isPaymentEligibleForCapitalizationGLPosting(assetPayment)) {
                this.createNewPostable(AmountCategory.CAPITALIZATION, asset, assetPayment, documentNumber, plantAccount, postables);
            }
            if (this.assetPaymentService.isPaymentEligibleForAccumDeprGLPosting(assetPayment)) {
                this.createNewPostable(AmountCategory.ACCUMMULATE_DEPRECIATION, asset, assetPayment, documentNumber, plantAccount, postables);
            }
            if (this.assetPaymentService.isPaymentEligibleForOffsetGLPosting(assetPayment)) {
                this.createNewPostable(AmountCategory.OFFSET_AMOUNT, asset, assetPayment, documentNumber, plantAccount, postables);
            }
        }
        return postables;
    }

    protected void createNewPostable(AmountCategory category, Asset asset, AssetPayment assetPayment, String documentNumber, Account plantAccount, List<GeneralLedgerPendingEntrySourceDetail> postables) {
        AssetGlpeSourceDetail postable = new AssetGlpeSourceDetail();
        AssetObjectCode assetObjectCode = this.getAssetObjectCode(asset, assetPayment);
        category.setParams(postable, assetPayment, assetObjectCode);
        postable.setDocumentNumber(documentNumber);
        postable.setAccount(plantAccount);
        postable.setAccountNumber(plantAccount.getAccountNumber());
        postable.setBalanceTypeCode("AC");
        postable.setChartOfAccountsCode(plantAccount.getChartOfAccountsCode());
        postable.setPostingYear(this.universityDateService.getCurrentFiscalYear());
        postable.setProjectCode(assetPayment.getProjectCode());
        postable.setOrganizationReferenceId(assetPayment.getOrganizationReferenceId());
        postables.add(postable);
    }

    protected AssetObjectCode getAssetObjectCode(Asset asset, AssetPayment assetPayment) {
        ObjectCodeService objectCodeService = this.getObjectCodeService();
        ObjectCode objectCode = objectCodeService.getByPrimaryIdForLatestValidYear(assetPayment.getChartOfAccountsCode(), assetPayment.getFinancialObjectCode());
        return this.assetObjectCodeService.findAssetObjectCode(asset.getOrganizationOwnerChartOfAccountsCode(), objectCode.getFinancialObjectSubTypeCode());
    }

    @Override
    public ObjectCode getOffsetFinancialObject(String chartOfAccountsCode) {
        UniversityDateService universityDateService = (UniversityDateService)SpringContext.getBean(UniversityDateService.class);
        ParameterService parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
        String gainDispositionObjectCode = parameterService.getParameterValueAsString(AssetRetirementGlobal.class, "DEFAULT_GAIN_LOSS_DISPOSITION_OBJECT_CODE");
        HashMap<String, Object> pkMap = new HashMap<String, Object>();
        pkMap.put("universityFiscalYear", universityDateService.getCurrentFiscalYear());
        pkMap.put("chartOfAccountsCode", chartOfAccountsCode);
        pkMap.put("financialObjectCode", gainDispositionObjectCode);
        return (ObjectCode)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(ObjectCode.class, pkMap);
    }

    protected Account getPlantFundAccount(AssetPayment payment) {
        Account plantFundAccount = null;
        payment.refreshReferenceObject("financialObject");
        String finObjectCode = payment.getFinancialObjectCode();
        if (StringUtils.isNotEmpty((CharSequence)finObjectCode)) {
            ObjectCodeService obj = this.getObjectCodeService();
            ObjectCode objectCode = obj.getByPrimaryIdForLatestValidYear(payment.getChartOfAccountsCode(), finObjectCode);
            String financialObjectSubTypeCode = objectCode.getFinancialObjectSubTypeCode();
            String coaCode = payment.getChartOfAccountsCode();
            Account tempAcct = payment.getAccount();
            String orgCode = tempAcct.getOrganizationCode();
            Organization org = this.getOrganizationService().getByPrimaryId(coaCode, orgCode);
            plantFundAccount = this.assetService.isAssetMovableCheckByPayment(financialObjectSubTypeCode) ? org.getOrganizationPlantAccount() : org.getCampusPlantAccount();
        }
        return plantFundAccount;
    }

    @Override
    public String generateCalculatedTotal(String salePrice, String handlingFeeAmount, String preventiveMaintenanceAmount) {
        KualiDecimal testAmount;
        KualiDecimal calculatedTotal = KualiDecimal.ZERO;
        if (!salePrice.isEmpty()) {
            testAmount = this.toKualiDecimal(salePrice);
            if (testAmount.isZero()) {
                return "Please enter Sale Price in 1,234,567.00 Format";
            }
            calculatedTotal = (KualiDecimal)calculatedTotal.add((AbstractKualiDecimal)testAmount);
        }
        if (!handlingFeeAmount.isEmpty()) {
            testAmount = this.toKualiDecimal(handlingFeeAmount);
            if (testAmount.isZero()) {
                return "Please enter Handling Fee Amount in 1,234,567.00 Format";
            }
            calculatedTotal = (KualiDecimal)calculatedTotal.add((AbstractKualiDecimal)testAmount);
        }
        if (!preventiveMaintenanceAmount.isEmpty()) {
            testAmount = this.toKualiDecimal(preventiveMaintenanceAmount);
            if (testAmount.isZero()) {
                return "Please enter Preventive Maintenance Amount in 1,234,567.00 Format";
            }
            calculatedTotal = (KualiDecimal)calculatedTotal.add((AbstractKualiDecimal)testAmount);
        }
        return calculatedTotal.toString();
    }

    protected KualiDecimal toKualiDecimal(String amount) {
        KualiDecimal newAmount;
        try {
            newAmount = new KualiDecimal(Double.parseDouble(amount));
        }
        catch (NumberFormatException e) {
            return KualiDecimal.ZERO;
        }
        return newAmount;
    }

    protected static enum AmountCategory {
        CAPITALIZATION{

            @Override
            void setParams(AssetGlpeSourceDetail postable, AssetPayment assetPayment, AssetObjectCode assetObjectCode) {
                postable.setCapitalization(true);
                ParameterService parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
                String lineDescription = parameterService.getParameterValueAsString(AssetRetirementGlobal.class, "CAPITALIZATION_LINE_DESCRIPTION");
                postable.setFinancialDocumentLineDescription(lineDescription);
                postable.setAmount(assetPayment.getAccountChargeAmount());
                postable.setFinancialObjectCode(assetObjectCode.getCapitalizationFinancialObjectCode());
                postable.setObjectCode(assetObjectCode.getCapitalizationFinancialObject());
            }
        }
        ,
        ACCUMMULATE_DEPRECIATION{

            @Override
            void setParams(AssetGlpeSourceDetail postable, AssetPayment assetPayment, AssetObjectCode assetObjectCode) {
                postable.setAccumulatedDepreciation(true);
                ParameterService parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
                String lineDescription = parameterService.getParameterValueAsString(AssetRetirementGlobal.class, "ACCUMULATED_DEPRECIATION_LINE_DESCRIPTION");
                postable.setFinancialDocumentLineDescription(lineDescription);
                postable.setAmount(assetPayment.getAccumulatedPrimaryDepreciationAmount());
                postable.setFinancialObjectCode(assetObjectCode.getAccumulatedDepreciationFinancialObjectCode());
                postable.setObjectCode(assetObjectCode.getAccumulatedDepreciationFinancialObject());
            }
        }
        ,
        OFFSET_AMOUNT{

            @Override
            void setParams(AssetGlpeSourceDetail postable, AssetPayment assetPayment, AssetObjectCode assetObjectCode) {
                postable.setCapitalizationOffset(true);
                ParameterService parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
                String lineDescription = parameterService.getParameterValueAsString(AssetRetirementGlobal.class, "OFFSET_AMOUNT_LINE_DESCRIPTION");
                postable.setFinancialDocumentLineDescription(lineDescription);
                KualiDecimal accumulatedDepreciationAmount = assetPayment.getAccumulatedPrimaryDepreciationAmount() == null ? new KualiDecimal(0) : assetPayment.getAccumulatedPrimaryDepreciationAmount();
                postable.setAmount((KualiDecimal)assetPayment.getAccountChargeAmount().subtract((AbstractKualiDecimal)accumulatedDepreciationAmount));
                postable.setFinancialObjectCode(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString(AssetRetirementGlobal.class, "DEFAULT_GAIN_LOSS_DISPOSITION_OBJECT_CODE").trim());
                HashMap<String, Object> pkMap = new HashMap<String, Object>();
                UniversityDateService universityDateService = (UniversityDateService)SpringContext.getBean(UniversityDateService.class);
                String gainDispositionObjectCode = parameterService.getParameterValueAsString(AssetRetirementGlobal.class, "DEFAULT_GAIN_LOSS_DISPOSITION_OBJECT_CODE");
                pkMap.put("universityFiscalYear", universityDateService.getCurrentFiscalYear());
                pkMap.put("chartOfAccountsCode", assetPayment.getAsset().getOrganizationOwnerChartOfAccountsCode());
                pkMap.put("financialObjectCode", gainDispositionObjectCode);
                ObjectCode offsetFinancialObject = (ObjectCode)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(ObjectCode.class, pkMap);
                postable.setObjectCode(offsetFinancialObject);
            }
        };


        abstract void setParams(AssetGlpeSourceDetail var1, AssetPayment var2, AssetObjectCode var3);
    }
}

