/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.CamsPropertyConstants;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetGlobalDetail;
import org.kuali.kfs.module.cam.businessobject.AssetLocation;
import org.kuali.kfs.module.cam.businessobject.AssetLocationGlobalDetail;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.businessobject.AssetType;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.module.cam.document.service.PaymentSummaryService;
import org.kuali.kfs.sys.businessobject.UniversityDate;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.kew.api.WorkflowDocument;

public class AssetServiceImpl
implements AssetService {
    private static final Logger LOG = LogManager.getLogger();
    protected BusinessObjectService businessObjectService;
    protected ObjectCodeService objectCodeService;
    protected ParameterService parameterService;
    protected PaymentSummaryService paymentSummaryService;
    private UniversityDateService universityDateService;

    @Override
    public boolean isAssetMovableCheckByAsset(Asset asset) {
        asset.refreshReferenceObject("capitalAssetType");
        return asset.getCapitalAssetType().isMovingIndicator();
    }

    @Override
    public boolean isAssetDepreciationStarted(Asset asset) {
        if (ObjectUtils.isNotNull((Object)asset.getAccumulatedDepreciation()) && asset.getAccumulatedDepreciation().isPositive()) {
            return true;
        }
        for (AssetPayment assetPayment : asset.getAssetPayments()) {
            if (!ObjectUtils.isNotNull((Object)assetPayment.getAccumulatedPrimaryDepreciationAmount()) || !assetPayment.getAccumulatedPrimaryDepreciationAmount().isPositive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCapitalAsset(Asset asset) {
        return this.parameterService.getParameterValuesAsString(Asset.class, "CAPITAL_ASSET_STATUS_CODES").contains(asset.getInventoryStatusCode());
    }

    @Override
    public boolean isAssetRetired(Asset asset) {
        return this.parameterService.getParameterValuesAsString(Asset.class, "RETIRED_STATUS_CODES").contains(asset.getInventoryStatusCode());
    }

    @Override
    public boolean isInServiceDateChanged(Asset oldAsset, Asset newAsset) {
        return !(!ObjectUtils.isNull((Object)oldAsset.getCapitalAssetInServiceDate()) ? oldAsset.getCapitalAssetInServiceDate().equals(newAsset.getCapitalAssetInServiceDate()) : ObjectUtils.isNull((Object)newAsset.getCapitalAssetInServiceDate()));
    }

    @Override
    public boolean isAssetFabrication(MaintenanceDocument maintenanceDocument) {
        return maintenanceDocument.getNewMaintainableObject().getBusinessObject() instanceof Asset && maintenanceDocument.isNew();
    }

    @Override
    public boolean isAssetLoaned(Asset asset) {
        return ObjectUtils.isNotNull((Object)asset.getExpectedReturnDate()) && ObjectUtils.isNull((Object)asset.getLoanReturnDate());
    }

    @Override
    public boolean isAssetTaggedInPriorFiscalYear(Asset asset) {
        return StringUtils.isNotBlank((CharSequence)asset.getCampusTagNumber()) && ObjectUtils.isNotNull((Object)asset.getFinancialDocumentPostingYear()) && !this.universityDateService.getCurrentFiscalYear().equals(asset.getFinancialDocumentPostingYear());
    }

    @Override
    public boolean isTagNumberCheckExclude(Asset asset) {
        String status = asset.getInventoryStatusCode();
        return StringUtils.equalsIgnoreCase((CharSequence)status, (CharSequence)"R") || StringUtils.equalsIgnoreCase((CharSequence)status, (CharSequence)"O") || StringUtils.equalsIgnoreCase((CharSequence)asset.getCampusTagNumber(), (CharSequence)"N");
    }

    @Override
    public boolean isOffCampusLocationEntered(Asset asset) {
        AssetLocation offCampus = asset.getOffCampusLocation();
        return StringUtils.isNotBlank((CharSequence)offCampus.getAssetLocationContactName()) || StringUtils.isNotBlank((CharSequence)offCampus.getAssetLocationStreetAddress()) || StringUtils.isNotBlank((CharSequence)offCampus.getAssetLocationCityName()) || StringUtils.isNotBlank((CharSequence)offCampus.getAssetLocationStateCode()) || StringUtils.isNotBlank((CharSequence)offCampus.getAssetLocationZipCode()) || StringUtils.isNotBlank((CharSequence)offCampus.getAssetLocationCountryCode());
    }

    @Override
    public boolean isFinancialObjectSubTypeCodeChanged(Asset oldAsset, Asset newAsset) {
        return !StringUtils.equalsIgnoreCase((CharSequence)oldAsset.getFinancialObjectSubTypeCode(), (CharSequence)newAsset.getFinancialObjectSubTypeCode());
    }

    @Override
    public boolean isAssetTypeCodeChanged(Asset oldAsset, Asset newAsset) {
        return !StringUtils.equalsIgnoreCase((CharSequence)oldAsset.getCapitalAssetTypeCode(), (CharSequence)newAsset.getCapitalAssetTypeCode());
    }

    @Override
    public boolean isAssetDepreciableLifeLimitZero(Asset asset) {
        asset.refreshReferenceObject("capitalAssetType");
        AssetType capitalAssetType = asset.getCapitalAssetType();
        if (ObjectUtils.isNotNull((Object)((Object)capitalAssetType))) {
            return Integer.valueOf(0).equals(capitalAssetType.getDepreciableLifeLimit());
        }
        return false;
    }

    @Override
    public boolean isCapitalAssetNumberDuplicate(Long capitalAssetNumber1, Long capitalAssetNumber2) {
        return capitalAssetNumber1 != null && capitalAssetNumber2 != null && capitalAssetNumber1.compareTo(capitalAssetNumber2) == 0;
    }

    @Override
    public void setAssetSummaryFields(Asset asset) {
        if (ObjectUtils.isNotNull((Object)((Object)asset))) {
            asset.setFederalContribution(this.paymentSummaryService.calculateFederalContribution(asset));
            asset.setAccumulatedDepreciation(this.paymentSummaryService.calculatePrimaryAccumulatedDepreciation(asset));
            asset.setBookValue(this.paymentSummaryService.calculatePrimaryBookValue(asset));
        }
    }

    @Override
    public boolean isAssetMovableCheckByPayment(String financialObjectSubTypeCode) {
        if (ObjectUtils.isNull((Object)financialObjectSubTypeCode)) {
            return true;
        }
        if (this.parameterService.getParameterValuesAsString(Asset.class, "MOVABLE_EQUIPMENT_OBJECT_SUB_TYPES").contains(financialObjectSubTypeCode)) {
            return true;
        }
        if (this.parameterService.getParameterValuesAsString(Asset.class, "NON_MOVABLE_EQUIPMENT_OBJECT_SUB_TYPES").contains(financialObjectSubTypeCode)) {
            return false;
        }
        throw new ValidationException("Could not determine movable or non-movable for this object sub-type code " + financialObjectSubTypeCode);
    }

    @Override
    public boolean isAssetMovableCheckByPayment(Asset asset) {
        String financialObjectSubTypeCode = this.determineFinancialObjectSubTypeCode(asset);
        return this.isAssetMovableCheckByPayment(financialObjectSubTypeCode);
    }

    @Override
    public String determineFinancialObjectSubTypeCode(Asset asset) {
        String financialObjectSubTypeCode = asset.getFinancialObjectSubTypeCode();
        if (ObjectUtils.isNotNull(asset.getAssetPayments()) && !asset.getAssetPayments().isEmpty()) {
            int size = asset.getAssetPayments().size();
            AssetPayment lastAssetPayment = asset.getAssetPayments().get(size - 1);
            lastAssetPayment.refreshReferenceObject("financialObject");
            String chartCode = lastAssetPayment.getChartOfAccountsCode();
            String finObjectCode = lastAssetPayment.getFinancialObjectCode();
            ObjectCode objectCode = this.objectCodeService.getByPrimaryIdForCurrentYear(chartCode, finObjectCode);
            if (ObjectUtils.isNotNull((Object)objectCode)) {
                financialObjectSubTypeCode = objectCode.getFinancialObjectSubTypeCode();
            } else {
                LOG.warn("Possibly out-dated object code " + finObjectCode + " for chart " + chartCode + " for current fiscal year in payments for asset " + asset.getCapitalAssetNumber());
            }
        }
        return financialObjectSubTypeCode;
    }

    @Override
    public List<Asset> findActiveAssetsMatchingTagNumber(String campusTagNumber) {
        ArrayList<Asset> activeMatches = new ArrayList<Asset>();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("campusTagNumber", campusTagNumber);
        Collection tagMatches = this.businessObjectService.findMatching(Asset.class, params);
        if (tagMatches != null && !tagMatches.isEmpty()) {
            for (Asset asset : tagMatches) {
                if (this.isAssetRetired(asset)) continue;
                activeMatches.add(asset);
            }
        }
        return activeMatches;
    }

    @Override
    public Collection<Asset> findAssetsMatchingTagNumber(String campusTagNumber) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("campusTagNumber", campusTagNumber);
        return this.businessObjectService.findMatching(Asset.class, params);
    }

    @Override
    public boolean isObjectSubTypeCompatible(List<String> financialObjectSubTypeCode) {
        if (financialObjectSubTypeCode == null || financialObjectSubTypeCode.size() <= 1) {
            return true;
        }
        ArrayList subTypes = new ArrayList(this.parameterService.getParameterValuesAsString(Asset.class, "OBJECT_SUB_TYPE_GROUPS"));
        String firstObjectSubType = financialObjectSubTypeCode.get(0);
        List<Object> validObjectSubTypes = new ArrayList<String>();
        for (String subType : subTypes) {
            if (!subType.contains(firstObjectSubType)) continue;
            validObjectSubTypes = Arrays.asList(StringUtils.split((String)subType, (String)","));
            break;
        }
        if (validObjectSubTypes.isEmpty()) {
            validObjectSubTypes.add(firstObjectSubType);
        }
        for (String subTypeCode : financialObjectSubTypeCode) {
            if (validObjectSubTypes.contains(subTypeCode)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setSeparateHistory(Asset asset) {
        HashMap<String, String> paramsAssetGlobalDetail = new HashMap<String, String>();
        paramsAssetGlobalDetail.put(CamsPropertyConstants.AssetGlobalDetail.CAPITAL_ASSET_NUMBER, asset.getCapitalAssetNumber().toString());
        Collection assetGlobalDetails = this.businessObjectService.findMatching(AssetGlobalDetail.class, paramsAssetGlobalDetail);
        if (assetGlobalDetails.size() > 1) {
            throw new IllegalStateException("Asset #" + asset.getCapitalAssetNumber().toString() + " was created from more then one asset document.");
        }
        if (assetGlobalDetails.size() == 1) {
            HashMap<String, String> paramsAssetGlobal = new HashMap<String, String>();
            paramsAssetGlobal.put("documentNumber", ((AssetGlobalDetail)((Object)assetGlobalDetails.iterator().next())).getDocumentNumber());
            AssetGlobal assetGlobal = (AssetGlobal)this.businessObjectService.findByPrimaryKey(AssetGlobal.class, paramsAssetGlobal);
            if ("A".equals(assetGlobal.getDocumentHeader().getFinancialDocumentStatusCode())) {
                asset.setSeparateHistory(assetGlobal);
            }
        }
    }

    @Override
    public List<String> getDocumentNumbersThatSeparatedThisAsset(Long capitalAssetNumber) {
        HashMap<String, String> paramsAssetGlobal = new HashMap<String, String>();
        paramsAssetGlobal.put("separateSourceCapitalAssetNumber", capitalAssetNumber.toString());
        Collection assetGlobals = this.businessObjectService.findMatching(AssetGlobal.class, paramsAssetGlobal);
        ArrayList<String> separateDocumentNumbers = new ArrayList<String>();
        for (AssetGlobal assetGlobal : assetGlobals) {
            if (!"A".equals(assetGlobal.getDocumentHeader().getFinancialDocumentStatusCode())) continue;
            separateDocumentNumbers.add(assetGlobal.getDocumentNumber());
        }
        return separateDocumentNumbers;
    }

    @Override
    public void setFiscalPeriod(Asset asset) {
        if (asset.getCreateDate() == null) {
            return;
        }
        HashMap<String, Date> primaryKeys = new HashMap<String, Date>();
        primaryKeys.put("universityDate", asset.getCreateDate());
        UniversityDate universityDate = (UniversityDate)this.businessObjectService.findByPrimaryKey(UniversityDate.class, primaryKeys);
        if (universityDate != null) {
            asset.setFinancialDocumentPostingYear(universityDate.getUniversityFiscalYear());
            asset.setFinancialDocumentPostingPeriodCode(universityDate.getUniversityFiscalAccountingPeriod());
        }
    }

    @Override
    public Set<String> getCurrentRouteLevels(WorkflowDocument workflowDocument) {
        return workflowDocument.getCurrentNodeNames();
    }

    @Override
    public boolean isDocumentEnrouting(Document document) {
        return document.getDocumentHeader().getWorkflowDocument().isEnroute();
    }

    @Override
    public boolean hasCapitalAssetLocationDetailsChanged(AssetLocationGlobalDetail assetLocationGlobalDetail) {
        boolean success = false;
        if (ObjectUtils.isNotNull((Object)assetLocationGlobalDetail.getCapitalAssetNumber())) {
            assetLocationGlobalDetail.refreshReferenceObject("asset");
            Asset asset = assetLocationGlobalDetail.getAsset();
            if (ObjectUtils.isNotNull((Object)((Object)assetLocationGlobalDetail.getAsset()))) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)asset.getCampusCode(), (CharSequence)assetLocationGlobalDetail.getCampusCode())) {
                    success = true;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)asset.getBuildingCode(), (CharSequence)assetLocationGlobalDetail.getBuildingCode())) {
                    success = true;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)asset.getBuildingRoomNumber(), (CharSequence)assetLocationGlobalDetail.getBuildingRoomNumber())) {
                    success = true;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)asset.getBuildingSubRoomNumber(), (CharSequence)assetLocationGlobalDetail.getBuildingSubRoomNumber())) {
                    success = true;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)asset.getCampusTagNumber(), (CharSequence)assetLocationGlobalDetail.getCampusTagNumber())) {
                    success = true;
                }
            }
        }
        return success;
    }

    @Override
    public boolean hasAssetLocationChanged(Asset oldAsset, Asset newAsset) {
        AssetLocation oldOffCampusLocation = oldAsset.getOffCampusLocation();
        AssetLocation newOffCampusLocation = newAsset.getOffCampusLocation();
        if (ObjectUtils.isNull((Object)((Object)oldOffCampusLocation)) || ObjectUtils.isNull((Object)((Object)newOffCampusLocation))) {
            return false;
        }
        return !StringUtils.equalsIgnoreCase((CharSequence)oldAsset.getCampusCode(), (CharSequence)newAsset.getCampusCode()) || !StringUtils.equalsIgnoreCase((CharSequence)oldAsset.getBuildingCode(), (CharSequence)newAsset.getBuildingCode()) || !StringUtils.equalsIgnoreCase((CharSequence)oldAsset.getBuildingRoomNumber(), (CharSequence)newAsset.getBuildingRoomNumber()) || !StringUtils.equalsIgnoreCase((CharSequence)oldAsset.getBuildingSubRoomNumber(), (CharSequence)newAsset.getBuildingSubRoomNumber()) || !StringUtils.equalsIgnoreCase((CharSequence)oldAsset.getCampusTagNumber(), (CharSequence)newAsset.getCampusTagNumber()) || !StringUtils.equalsIgnoreCase((CharSequence)oldOffCampusLocation.getAssetLocationContactName(), (CharSequence)newOffCampusLocation.getAssetLocationContactName()) || !StringUtils.equalsIgnoreCase((CharSequence)oldOffCampusLocation.getAssetLocationStreetAddress(), (CharSequence)newOffCampusLocation.getAssetLocationStreetAddress()) || !StringUtils.equalsIgnoreCase((CharSequence)oldOffCampusLocation.getAssetLocationCityName(), (CharSequence)newOffCampusLocation.getAssetLocationCityName()) || !StringUtils.equalsIgnoreCase((CharSequence)oldOffCampusLocation.getAssetLocationStateCode(), (CharSequence)newOffCampusLocation.getAssetLocationStateCode()) || !StringUtils.equalsIgnoreCase((CharSequence)oldOffCampusLocation.getAssetLocationZipCode(), (CharSequence)newOffCampusLocation.getAssetLocationZipCode()) || !StringUtils.equalsIgnoreCase((CharSequence)oldOffCampusLocation.getAssetLocationCountryCode(), (CharSequence)newOffCampusLocation.getAssetLocationCountryCode());
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ObjectCodeService getObjectCodeService() {
        return this.objectCodeService;
    }

    public void setObjectCodeService(ObjectCodeService objectCodeService) {
        this.objectCodeService = objectCodeService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public PaymentSummaryService getPaymentSummaryService() {
        return this.paymentSummaryService;
    }

    public void setPaymentSummaryService(PaymentSummaryService paymentSummaryService) {
        this.paymentSummaryService = paymentSummaryService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }
}

