/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.integration.cam.CapitalAssetManagementModuleService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.businessobject.GeneralLedgerEntry;
import org.kuali.kfs.module.cam.businessobject.Pretag;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableActionHistory;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableItemAsset;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableLineAssetAccount;
import org.kuali.kfs.module.cam.dataaccess.PurApLineDao;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.module.cam.document.service.PurApInfoService;
import org.kuali.kfs.module.cam.document.service.PurApLineService;
import org.kuali.kfs.module.cam.document.web.PurApLineSession;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class PurApLineServiceImpl
implements PurApLineService {
    private AssetService assetService;
    private BusinessObjectService businessObjectService;
    private CapitalAssetManagementModuleService capitalAssetManagementModuleService;
    private PurApInfoService purApInfoService;
    private PurApLineDao purApLineDao;

    @Override
    public boolean mergeLinesHasDifferentObjectSubTypes(List<PurchasingAccountsPayableItemAsset> mergeLines) {
        boolean invalid = false;
        ArrayList<String> objectSubTypeList = new ArrayList<String>();
        for (PurchasingAccountsPayableItemAsset itemAsset : mergeLines) {
            for (PurchasingAccountsPayableLineAssetAccount account : itemAsset.getPurchasingAccountsPayableLineAssetAccounts()) {
                account.getGeneralLedgerEntry().refreshReferenceObject("financialObject");
                ObjectCode objCode = account.getGeneralLedgerEntry().getFinancialObject();
                if (!ObjectUtils.isNotNull((Object)objCode) || !StringUtils.isNotEmpty((CharSequence)objCode.getFinancialObjectSubTypeCode())) continue;
                objectSubTypeList.add(objCode.getFinancialObjectSubTypeCode());
            }
        }
        if (!this.assetService.isObjectSubTypeCompatible(objectSubTypeList)) {
            invalid = true;
        }
        return invalid;
    }

    @Override
    public boolean allocateLinesHasDifferentObjectSubTypes(List<PurchasingAccountsPayableItemAsset> targetLines, PurchasingAccountsPayableItemAsset sourceLine) {
        boolean invalid = false;
        ArrayList<String> objectSubTypeList = new ArrayList<String>();
        for (PurchasingAccountsPayableItemAsset itemAsset : targetLines) {
            for (PurchasingAccountsPayableLineAssetAccount account : itemAsset.getPurchasingAccountsPayableLineAssetAccounts()) {
                account.getGeneralLedgerEntry().refreshReferenceObject("financialObject");
                ObjectCode objCode = account.getGeneralLedgerEntry().getFinancialObject();
                if (!ObjectUtils.isNotNull((Object)objCode) || !StringUtils.isNotEmpty((CharSequence)objCode.getFinancialObjectSubTypeCode())) continue;
                objectSubTypeList.add(objCode.getFinancialObjectSubTypeCode());
            }
        }
        if (ObjectUtils.isNotNull((Object)sourceLine)) {
            for (PurchasingAccountsPayableLineAssetAccount account : sourceLine.getPurchasingAccountsPayableLineAssetAccounts()) {
                account.getGeneralLedgerEntry().refreshReferenceObject("financialObject");
                ObjectCode objCode = account.getGeneralLedgerEntry().getFinancialObject();
                if (!ObjectUtils.isNotNull((Object)objCode) || !StringUtils.isNotEmpty((CharSequence)objCode.getFinancialObjectSubTypeCode())) continue;
                objectSubTypeList.add(objCode.getFinancialObjectSubTypeCode());
            }
        }
        if (!this.assetService.isObjectSubTypeCompatible(objectSubTypeList)) {
            invalid = true;
        }
        return invalid;
    }

    @Override
    public void conditionallyUpdateDocumentStatusAsProcessed(PurchasingAccountsPayableDocument selectedDoc) {
        for (PurchasingAccountsPayableItemAsset item : selectedDoc.getPurchasingAccountsPayableItemAssets()) {
            if (!item.isActive()) continue;
            return;
        }
        selectedDoc.setActivityStatusCode("P");
    }

    @Override
    public void resetSelectedValue(List<PurchasingAccountsPayableDocument> purApDocs) {
        for (PurchasingAccountsPayableDocument purApDoc : purApDocs) {
            for (PurchasingAccountsPayableItemAsset item : purApDoc.getPurchasingAccountsPayableItemAssets()) {
                item.setSelectedValue(false);
            }
        }
    }

    @Override
    public boolean processAllocate(PurchasingAccountsPayableItemAsset allocateSourceLine, List<PurchasingAccountsPayableItemAsset> allocateTargetLines, List<PurchasingAccountsPayableActionHistory> actionsTakeHistory, List<PurchasingAccountsPayableDocument> purApDocs, boolean initiateFromBatch) {
        boolean allocatedIndicator = true;
        boolean allocateAddlChrgIndicator = allocateSourceLine.isAdditionalChargeNonTradeInIndicator() | allocateSourceLine.isTradeInAllowance();
        ArrayList<PurchasingAccountsPayableLineAssetAccount> newAccountList = new ArrayList<PurchasingAccountsPayableLineAssetAccount>();
        for (PurchasingAccountsPayableLineAssetAccount sourceAccount : allocateSourceLine.getPurchasingAccountsPayableLineAssetAccounts()) {
            sourceAccount.refresh();
            List<PurchasingAccountsPayableLineAssetAccount> targetAccounts = this.getAllocateTargetAccounts(sourceAccount, allocateTargetLines, allocateAddlChrgIndicator);
            if (!targetAccounts.isEmpty()) {
                this.allocateByItemAccountAmount(sourceAccount, targetAccounts, newAccountList, actionsTakeHistory);
                continue;
            }
            allocatedIndicator = false;
            break;
        }
        if (allocatedIndicator) {
            this.postAllocateProcess(allocateSourceLine, allocateTargetLines, purApDocs, newAccountList, initiateFromBatch);
        }
        return allocatedIndicator;
    }

    protected void postAllocateProcess(PurchasingAccountsPayableItemAsset selectedLineItem, List<PurchasingAccountsPayableItemAsset> allocateTargetLines, List<PurchasingAccountsPayableDocument> purApDocs, List<PurchasingAccountsPayableLineAssetAccount> newAccountList, boolean initiateFromBatch) {
        this.addNewAccountToItemList(newAccountList);
        this.updateLineItemsCost(allocateTargetLines);
        if (ObjectUtils.isNotNull((Object)((Object)selectedLineItem.getPurchasingAccountsPayableDocument()))) {
            selectedLineItem.getPurchasingAccountsPayableDocument().getPurchasingAccountsPayableItemAssets().remove(selectedLineItem);
            this.conditionallyUpdateDocumentStatusAsProcessed(selectedLineItem.getPurchasingAccountsPayableDocument());
        }
        if (!initiateFromBatch && (selectedLineItem.isAdditionalChargeNonTradeInIndicator() || selectedLineItem.isTradeInAllowance())) {
            this.setAssetIndicator(purApDocs);
        }
        if (!initiateFromBatch) {
            for (PurchasingAccountsPayableItemAsset allocateTargetItem : allocateTargetLines) {
                this.updateItemStatusAsUserModified(allocateTargetItem);
            }
        }
    }

    protected Map<String, Set> getRemovableAssetLocks(List<PurchasingAccountsPayableItemAsset> processedItems) {
        HashMap<String, Set> removableAssetLocks = new HashMap<String, Set>();
        for (PurchasingAccountsPayableItemAsset processedItem : processedItems) {
            if (processedItem.getLockingInformation() != null && !"-1".equals(processedItem.getLockingInformation())) {
                this.addAssetLock(removableAssetLocks, processedItem);
                continue;
            }
            if (!ObjectUtils.isNotNull((Object)((Object)processedItem.getPurchasingAccountsPayableDocument()))) continue;
            List<PurchasingAccountsPayableItemAsset> remainingItems = processedItem.getPurchasingAccountsPayableDocument().getPurchasingAccountsPayableItemAssets();
            boolean fullyProcessed = true;
            for (PurchasingAccountsPayableItemAsset itemAsset : remainingItems) {
                if ("P".equalsIgnoreCase(itemAsset.getActivityStatusCode())) continue;
                fullyProcessed = false;
                break;
            }
            if (!fullyProcessed) continue;
            this.addAssetLock(removableAssetLocks, processedItem);
        }
        processedItems.clear();
        return removableAssetLocks;
    }

    protected void addAssetLock(Map<String, Set> removableAssetLocks, PurchasingAccountsPayableItemAsset processedItem) {
        if (processedItem.getLockingInformation() == null) {
            processedItem.setLockingInformation("-1");
        }
        if (removableAssetLocks.containsKey(processedItem.getDocumentNumber())) {
            Set lockingInfoList = removableAssetLocks.get(processedItem.getDocumentNumber());
            lockingInfoList.add(processedItem.getLockingInformation());
        } else {
            HashSet<String> lockingInfoList = new HashSet<String>();
            lockingInfoList.add(processedItem.getLockingInformation());
            removableAssetLocks.put(processedItem.getDocumentNumber(), lockingInfoList);
        }
    }

    protected void updateLineItemsCost(List<PurchasingAccountsPayableItemAsset> lineItems) {
        for (PurchasingAccountsPayableItemAsset item : lineItems) {
            this.setLineItemCost(item);
        }
    }

    protected void addNewAccountToItemList(List<PurchasingAccountsPayableLineAssetAccount> newAccountList) {
        for (PurchasingAccountsPayableLineAssetAccount newAccount : newAccountList) {
            PurchasingAccountsPayableItemAsset lineItem = newAccount.getPurchasingAccountsPayableItemAsset();
            if (!ObjectUtils.isNotNull((Object)lineItem) || !ObjectUtils.isNotNull(lineItem.getPurchasingAccountsPayableLineAssetAccounts())) continue;
            lineItem.getPurchasingAccountsPayableLineAssetAccounts().add(newAccount);
        }
    }

    protected void setLineItemCost(PurchasingAccountsPayableItemAsset item) {
        KualiDecimal totalCost = this.calculateItemAssetTotalCost(item);
        item.setTotalCost(totalCost);
        this.setItemAssetUnitCost(item, totalCost);
    }

    protected void allocateByItemAccountAmount(PurchasingAccountsPayableLineAssetAccount sourceAccount, List<PurchasingAccountsPayableLineAssetAccount> targetAccounts, List<PurchasingAccountsPayableLineAssetAccount> newAccountList, List<PurchasingAccountsPayableActionHistory> actionsTakeHistory) {
        KualiDecimal targetAccountsTotalAmount = KualiDecimal.ZERO;
        KualiDecimal sourceAccountTotalAmount = sourceAccount.getItemAccountTotalAmount();
        KualiDecimal amountAllocated = KualiDecimal.ZERO;
        for (PurchasingAccountsPayableLineAssetAccount targetAccount : targetAccounts) {
            targetAccountsTotalAmount = (KualiDecimal)targetAccountsTotalAmount.add((AbstractKualiDecimal)((KualiDecimal)targetAccount.getItemAccountTotalAmount().abs()));
        }
        Iterator<PurchasingAccountsPayableLineAssetAccount> iterator = targetAccounts.iterator();
        while (iterator.hasNext()) {
            KualiDecimal additionalAmount;
            PurchasingAccountsPayableLineAssetAccount targetAccount;
            targetAccount = iterator.next();
            if (iterator.hasNext()) {
                additionalAmount = (KualiDecimal)((KualiDecimal)((KualiDecimal)targetAccount.getItemAccountTotalAmount().abs()).multiply((AbstractKualiDecimal)sourceAccountTotalAmount)).divide((AbstractKualiDecimal)targetAccountsTotalAmount);
                amountAllocated = (KualiDecimal)amountAllocated.add((AbstractKualiDecimal)additionalAmount);
            } else {
                additionalAmount = (KualiDecimal)sourceAccountTotalAmount.subtract((AbstractKualiDecimal)amountAllocated);
            }
            PurchasingAccountsPayableLineAssetAccount newAccount = this.getMatchingFromAccountList(targetAccounts, sourceAccount.getGeneralLedgerAccountIdentifier(), targetAccount);
            if (newAccount != null) {
                this.updateAccountAmount(additionalAmount, newAccount);
            } else {
                newAccount = this.getMatchingFromAccountList(newAccountList, sourceAccount.getGeneralLedgerAccountIdentifier(), targetAccount);
                if (newAccount != null) {
                    this.updateAccountAmount(additionalAmount, newAccount);
                } else {
                    newAccount = new PurchasingAccountsPayableLineAssetAccount(targetAccount.getPurchasingAccountsPayableItemAsset(), sourceAccount.getGeneralLedgerAccountIdentifier());
                    newAccount.setItemAccountTotalAmount(additionalAmount);
                    newAccount.setGeneralLedgerEntry(sourceAccount.getGeneralLedgerEntry());
                    newAccountList.add(newAccount);
                }
            }
            this.addAllocateHistory(sourceAccount, actionsTakeHistory, additionalAmount, newAccount);
        }
    }

    protected void addAllocateHistory(PurchasingAccountsPayableLineAssetAccount sourceAccount, List<PurchasingAccountsPayableActionHistory> actionsTakeHistory, KualiDecimal additionalAmount, PurchasingAccountsPayableLineAssetAccount newAccount) {
        PurchasingAccountsPayableActionHistory newAction = new PurchasingAccountsPayableActionHistory(sourceAccount.getPurchasingAccountsPayableItemAsset(), newAccount.getPurchasingAccountsPayableItemAsset(), "allocate");
        newAction.setGeneralLedgerAccountIdentifier(sourceAccount.getGeneralLedgerAccountIdentifier());
        newAction.setItemAccountTotalAmount(additionalAmount);
        newAction.setAccountsPayableItemQuantity(sourceAccount.getPurchasingAccountsPayableItemAsset().getAccountsPayableItemQuantity());
        actionsTakeHistory.add(newAction);
    }

    protected PurchasingAccountsPayableLineAssetAccount getFromTargetAccountList(List<PurchasingAccountsPayableLineAssetAccount> targetAccounts, Long glIdentifier) {
        for (PurchasingAccountsPayableLineAssetAccount account : targetAccounts) {
            if (!account.getGeneralLedgerAccountIdentifier().equals(glIdentifier)) continue;
            return account;
        }
        return null;
    }

    protected void updateAccountAmount(KualiDecimal additionalAmount, PurchasingAccountsPayableLineAssetAccount targetAccount) {
        KualiDecimal baseAmount = targetAccount.getItemAccountTotalAmount();
        targetAccount.setItemAccountTotalAmount(baseAmount != null ? (KualiDecimal)baseAmount.add((AbstractKualiDecimal)additionalAmount) : additionalAmount);
    }

    protected PurchasingAccountsPayableLineAssetAccount getMatchingFromAccountList(List<PurchasingAccountsPayableLineAssetAccount> accountList, Long glIdentifier, PurchasingAccountsPayableLineAssetAccount targetAccount) {
        for (PurchasingAccountsPayableLineAssetAccount account : accountList) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)targetAccount.getDocumentNumber(), (CharSequence)account.getDocumentNumber()) || !targetAccount.getAccountsPayableLineItemIdentifier().equals(account.getAccountsPayableLineItemIdentifier()) || !targetAccount.getCapitalAssetBuilderLineNumber().equals(account.getCapitalAssetBuilderLineNumber()) || !glIdentifier.equals(account.getGeneralLedgerAccountIdentifier())) continue;
            return account;
        }
        return null;
    }

    protected List<PurchasingAccountsPayableLineAssetAccount> getAllocateTargetAccounts(PurchasingAccountsPayableLineAssetAccount sourceAccount, List<PurchasingAccountsPayableItemAsset> allocateTargetLines, boolean additionalCharge) {
        GeneralLedgerEntry sourceEntry = sourceAccount.getGeneralLedgerEntry();
        ArrayList<PurchasingAccountsPayableLineAssetAccount> matchingAccounts = new ArrayList<PurchasingAccountsPayableLineAssetAccount>();
        ArrayList<PurchasingAccountsPayableLineAssetAccount> allAccounts = new ArrayList<PurchasingAccountsPayableLineAssetAccount>();
        for (PurchasingAccountsPayableItemAsset item : allocateTargetLines) {
            for (PurchasingAccountsPayableLineAssetAccount account : item.getPurchasingAccountsPayableLineAssetAccounts()) {
                account.refreshReferenceObject("generalLedgerEntry");
                GeneralLedgerEntry candidateEntry = account.getGeneralLedgerEntry();
                if (ObjectUtils.isNotNull((Object)((Object)candidateEntry)) && additionalCharge && StringUtils.equalsIgnoreCase((CharSequence)sourceEntry.getChartOfAccountsCode(), (CharSequence)candidateEntry.getChartOfAccountsCode()) && StringUtils.equalsIgnoreCase((CharSequence)sourceEntry.getAccountNumber(), (CharSequence)candidateEntry.getAccountNumber()) && StringUtils.equalsIgnoreCase((CharSequence)sourceEntry.getFinancialObjectCode(), (CharSequence)candidateEntry.getFinancialObjectCode())) {
                    matchingAccounts.add(account);
                }
                allAccounts.add(account);
            }
        }
        return matchingAccounts.isEmpty() ? allAccounts : matchingAccounts;
    }

    @Override
    public List<PurchasingAccountsPayableItemAsset> getAllocateTargetLines(PurchasingAccountsPayableItemAsset selectedLineItem, List<PurchasingAccountsPayableDocument> purApDocs) {
        ArrayList<PurchasingAccountsPayableItemAsset> targetLineItems = new ArrayList<PurchasingAccountsPayableItemAsset>();
        for (PurchasingAccountsPayableDocument purApDoc : purApDocs) {
            for (PurchasingAccountsPayableItemAsset item : purApDoc.getPurchasingAccountsPayableItemAssets()) {
                if (!item.isActive() || item == selectedLineItem || !(selectedLineItem.isAdditionalChargeNonTradeInIndicator() && !item.isAdditionalChargeNonTradeInIndicator() && !item.isTradeInAllowance() && StringUtils.equalsIgnoreCase((CharSequence)selectedLineItem.getDocumentNumber(), (CharSequence)item.getDocumentNumber()) || selectedLineItem.isTradeInAllowance() && item.isItemAssignedToTradeInIndicator()) && !item.isSelectedValue()) continue;
                targetLineItems.add(item);
            }
        }
        return targetLineItems;
    }

    @Override
    public List<PurchasingAccountsPayableItemAsset> getSelectedMergeLines(boolean isMergeAll, List<PurchasingAccountsPayableDocument> purApDocs) {
        ArrayList<PurchasingAccountsPayableItemAsset> mergeLines = new ArrayList<PurchasingAccountsPayableItemAsset>();
        boolean excludeTradeInAllowance = false;
        if (isMergeAll && !this.isTradeInIndicatorExistInAllLines(purApDocs) && this.isTradeInAllowanceExist(purApDocs)) {
            excludeTradeInAllowance = true;
        }
        for (PurchasingAccountsPayableDocument purApDoc : purApDocs) {
            for (PurchasingAccountsPayableItemAsset item : purApDoc.getPurchasingAccountsPayableItemAssets()) {
                if ((isMergeAll || !item.isSelectedValue()) && (!isMergeAll || excludeTradeInAllowance && item.isTradeInAllowance())) continue;
                mergeLines.add(item);
                item.setPurchasingAccountsPayableDocument(purApDoc);
            }
        }
        return mergeLines;
    }

    @Override
    public boolean isTradeInAllowanceExist(List<PurchasingAccountsPayableDocument> purApDocs) {
        boolean tradeInAllowance = false;
        block0: for (PurchasingAccountsPayableDocument purApDoc : purApDocs) {
            for (PurchasingAccountsPayableItemAsset item : purApDoc.getPurchasingAccountsPayableItemAssets()) {
                if (!item.isTradeInAllowance() || !item.isActive()) continue;
                tradeInAllowance = true;
                continue block0;
            }
        }
        return tradeInAllowance;
    }

    protected boolean isTradeInIndicatorExistInAllLines(List<PurchasingAccountsPayableDocument> purApDocs) {
        boolean tradeInIndicator = false;
        block0: for (PurchasingAccountsPayableDocument purApDoc : purApDocs) {
            for (PurchasingAccountsPayableItemAsset item : purApDoc.getPurchasingAccountsPayableItemAssets()) {
                if (!item.isItemAssignedToTradeInIndicator() || !item.isActive()) continue;
                tradeInIndicator = true;
                continue block0;
            }
        }
        return tradeInIndicator;
    }

    @Override
    public boolean isTradeInIndExistInSelectedLines(List<PurchasingAccountsPayableItemAsset> itemAssets) {
        boolean tradeInIndicator = false;
        for (PurchasingAccountsPayableItemAsset item : itemAssets) {
            if (!item.isItemAssignedToTradeInIndicator()) continue;
            tradeInIndicator = true;
            break;
        }
        return tradeInIndicator;
    }

    @Override
    public boolean isAdditionalChargePending(List<PurchasingAccountsPayableItemAsset> itemAssets) {
        boolean diffDocument = false;
        PurchasingAccountsPayableItemAsset firstAsset = itemAssets.get(0);
        PurchasingAccountsPayableItemAsset lastAsset = itemAssets.get(itemAssets.size() - 1);
        if (ObjectUtils.isNotNull((Object)firstAsset) && ObjectUtils.isNotNull((Object)lastAsset) && !firstAsset.getDocumentNumber().equalsIgnoreCase(lastAsset.getDocumentNumber())) {
            diffDocument = true;
        }
        if (diffDocument) {
            for (PurchasingAccountsPayableItemAsset item : itemAssets) {
                if (!ObjectUtils.isNotNull((Object)((Object)item.getPurchasingAccountsPayableDocument()))) continue;
                for (PurchasingAccountsPayableItemAsset itemLine : item.getPurchasingAccountsPayableDocument().getPurchasingAccountsPayableItemAssets()) {
                    if (!itemLine.isAdditionalChargeNonTradeInIndicator()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isMergeAllAction(List<PurchasingAccountsPayableDocument> purApDocs) {
        for (PurchasingAccountsPayableDocument purApDoc : purApDocs) {
            for (PurchasingAccountsPayableItemAsset item : purApDoc.getPurchasingAccountsPayableItemAssets()) {
                if (item.isAdditionalChargeNonTradeInIndicator() || item.isTradeInAllowance() || item.isSelectedValue()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isAdditionalChargeExistInAllLines(List<PurchasingAccountsPayableDocument> purApDocs) {
        for (PurchasingAccountsPayableDocument purApDoc : purApDocs) {
            for (PurchasingAccountsPayableItemAsset item : purApDoc.getPurchasingAccountsPayableItemAssets()) {
                if (!item.isAdditionalChargeNonTradeInIndicator() || !item.isActive()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void processMerge(List<PurchasingAccountsPayableItemAsset> mergeLines, List<PurchasingAccountsPayableActionHistory> actionsTakeHistory, boolean isMergeAll) {
        PurchasingAccountsPayableItemAsset firstItem = mergeLines.get(0);
        List<PurchasingAccountsPayableLineAssetAccount> firstAccountList = firstItem.getPurchasingAccountsPayableLineAssetAccounts();
        for (int i = 1; i < mergeLines.size(); ++i) {
            PurchasingAccountsPayableItemAsset sourceItem = mergeLines.get(i);
            for (PurchasingAccountsPayableLineAssetAccount account : sourceItem.getPurchasingAccountsPayableLineAssetAccounts()) {
                PurchasingAccountsPayableLineAssetAccount targetAccount = this.getFromTargetAccountList(firstAccountList, account.getGeneralLedgerAccountIdentifier());
                if (targetAccount != null) {
                    this.updateAccountAmount(account.getItemAccountTotalAmount(), targetAccount);
                    continue;
                }
                account.setDocumentNumber(firstItem.getDocumentNumber());
                account.setAccountsPayableLineItemIdentifier(firstItem.getAccountsPayableLineItemIdentifier());
                account.setCapitalAssetBuilderLineNumber(firstItem.getCapitalAssetBuilderLineNumber());
                account.setPurchasingAccountsPayableItemAsset(firstItem);
                firstAccountList.add(account);
            }
        }
        this.postMergeProcess(mergeLines, actionsTakeHistory, isMergeAll);
    }

    protected void postMergeProcess(List<PurchasingAccountsPayableItemAsset> mergeLines, List<PurchasingAccountsPayableActionHistory> actionsTakeHistory, boolean isMergeAll) {
        Pretag targetPretag;
        String actionTypeCode = isMergeAll ? "merge all" : "merge";
        PurchasingAccountsPayableItemAsset targetItem = mergeLines.get(0);
        this.setLineItemCost(targetItem);
        targetItem.setItemAssignedToTradeInIndicator(false);
        for (int i = 1; i < mergeLines.size(); ++i) {
            PurchasingAccountsPayableItemAsset sourceItem = mergeLines.get(i);
            this.addMergeHistory(actionsTakeHistory, actionTypeCode, sourceItem, targetItem);
            if (!ObjectUtils.isNotNull((Object)((Object)sourceItem.getPurchasingAccountsPayableDocument()))) continue;
            sourceItem.getPurchasingAccountsPayableDocument().getPurchasingAccountsPayableItemAssets().remove(sourceItem);
            this.conditionallyUpdateDocumentStatusAsProcessed(sourceItem.getPurchasingAccountsPayableDocument());
        }
        Integer poId = targetItem.getPurchasingAccountsPayableDocument().getPurchaseOrderIdentifier();
        if (poId != null && (targetPretag = this.getTargetPretag(mergeLines, poId)) != null) {
            targetItem.setItemLineNumber(targetPretag.getItemLineNumber());
        }
        this.updateAssetIndicatorAfterMerge(mergeLines);
        this.updateItemStatusAsUserModified(targetItem);
    }

    protected void updateAssetIndicatorAfterMerge(List<PurchasingAccountsPayableItemAsset> mergeLines) {
        boolean existCreateAsset = false;
        boolean existApplyPayment = false;
        PurchasingAccountsPayableItemAsset targetItem = mergeLines.get(0);
        for (int i = 1; i < mergeLines.size(); ++i) {
            PurchasingAccountsPayableItemAsset sourceItem = mergeLines.get(i);
            existCreateAsset |= sourceItem.isCreateAssetIndicator();
            existApplyPayment |= sourceItem.isApplyPaymentIndicator();
        }
        targetItem.setCreateAssetIndicator(targetItem.isCreateAssetIndicator() | existCreateAsset);
        targetItem.setApplyPaymentIndicator(targetItem.isApplyPaymentIndicator() | existApplyPayment);
    }

    protected Pretag getTargetPretag(List<PurchasingAccountsPayableItemAsset> itemLines, Integer purchaseOrderIdentifier) {
        for (PurchasingAccountsPayableItemAsset item : itemLines) {
            Pretag newTag = this.getPreTagLineItem(purchaseOrderIdentifier, item.getItemLineNumber());
            if (!this.isPretaggingExisting(newTag)) continue;
            return newTag;
        }
        return null;
    }

    @Override
    public boolean isPretaggingExisting(Pretag newTag) {
        return ObjectUtils.isNotNull((Object)((Object)newTag)) && newTag.getPretagDetails() != null && !newTag.getPretagDetails().isEmpty();
    }

    @Override
    public boolean isMultipleTagExisting(Integer purchaseOrderIdentifier, Set<Integer> itemLineNumbers) {
        Pretag firstTag = null;
        for (Integer itemLineNumber : itemLineNumbers) {
            Pretag newTag = this.getPreTagLineItem(purchaseOrderIdentifier, itemLineNumber);
            if (!this.isPretaggingExisting(newTag)) continue;
            if (firstTag != null) {
                return true;
            }
            firstTag = newTag;
        }
        return false;
    }

    protected void addMergeHistory(List<PurchasingAccountsPayableActionHistory> actionsTakenHistory, String actionTypeCode, PurchasingAccountsPayableItemAsset sourceItem, PurchasingAccountsPayableItemAsset targetItem) {
        for (PurchasingAccountsPayableLineAssetAccount sourceAccount : sourceItem.getPurchasingAccountsPayableLineAssetAccounts()) {
            PurchasingAccountsPayableActionHistory newAction = new PurchasingAccountsPayableActionHistory(sourceItem, targetItem, actionTypeCode);
            newAction.setAccountsPayableItemQuantity(sourceItem.getAccountsPayableItemQuantity());
            newAction.setItemAccountTotalAmount(sourceAccount.getItemAccountTotalAmount());
            newAction.setGeneralLedgerAccountIdentifier(sourceAccount.getGeneralLedgerAccountIdentifier());
            actionsTakenHistory.add(newAction);
        }
    }

    @Override
    public void processPercentPayment(PurchasingAccountsPayableItemAsset itemAsset, List<PurchasingAccountsPayableActionHistory> actionsTakenHistory) {
        KualiDecimal newQty;
        KualiDecimal oldQty = itemAsset.getAccountsPayableItemQuantity();
        if (oldQty.isLessThan((AbstractKualiDecimal)(newQty = new KualiDecimal(1)))) {
            itemAsset.setAccountsPayableItemQuantity(newQty);
            this.setLineItemCost(itemAsset);
            this.addPercentPaymentHistory(actionsTakenHistory, itemAsset, oldQty);
            this.updateItemStatusAsUserModified(itemAsset);
        }
    }

    protected void updateItemStatusAsUserModified(PurchasingAccountsPayableItemAsset itemAsset) {
        itemAsset.setActivityStatusCode("M");
        for (PurchasingAccountsPayableLineAssetAccount account : itemAsset.getPurchasingAccountsPayableLineAssetAccounts()) {
            account.setActivityStatusCode("M");
        }
        itemAsset.getPurchasingAccountsPayableDocument().setActivityStatusCode("M");
    }

    protected void addPercentPaymentHistory(List<PurchasingAccountsPayableActionHistory> actionsTakenHistory, PurchasingAccountsPayableItemAsset item, KualiDecimal oldQty) {
        PurchasingAccountsPayableActionHistory newAction = new PurchasingAccountsPayableActionHistory(item, item, "percent payment");
        newAction.setAccountsPayableItemQuantity(oldQty);
        actionsTakenHistory.add(newAction);
    }

    @Override
    public void processSplit(PurchasingAccountsPayableItemAsset splitItemAsset, List<PurchasingAccountsPayableActionHistory> actionsTakeHistory) {
        PurchasingAccountsPayableDocument purApDoc = splitItemAsset.getPurchasingAccountsPayableDocument();
        this.updateItemStatusAsUserModified(splitItemAsset);
        PurchasingAccountsPayableItemAsset newItemAsset = new PurchasingAccountsPayableItemAsset(splitItemAsset);
        newItemAsset.setCapitalAssetBuilderLineNumber(this.getMaxCabLineNumber(splitItemAsset, purApDoc) + 1);
        newItemAsset.setAccountsPayableItemQuantity(splitItemAsset.getSplitQty());
        this.createAccountsForNewItemAsset(splitItemAsset, newItemAsset);
        this.setLineItemCost(newItemAsset);
        splitItemAsset.setAccountsPayableItemQuantity((KualiDecimal)splitItemAsset.getAccountsPayableItemQuantity().subtract((AbstractKualiDecimal)splitItemAsset.getSplitQty()));
        this.setLineItemCost(splitItemAsset);
        purApDoc.getPurchasingAccountsPayableItemAssets().add(newItemAsset);
        Collections.sort(purApDoc.getPurchasingAccountsPayableItemAssets());
        this.addSplitHistory(splitItemAsset, newItemAsset, actionsTakeHistory);
        splitItemAsset.setSplitQty(null);
    }

    protected int getMaxCabLineNumber(PurchasingAccountsPayableItemAsset splitItemAsset, PurchasingAccountsPayableDocument purApDoc) {
        Integer maxDBCabLineNbr = this.purApLineDao.getMaxCabLineNumber(splitItemAsset.getDocumentNumber(), splitItemAsset.getAccountsPayableLineItemIdentifier());
        int availableCabLineNbr = this.getMaxCabLineNbrForItemInForm(purApDoc, splitItemAsset);
        if (maxDBCabLineNbr > availableCabLineNbr) {
            availableCabLineNbr = maxDBCabLineNbr;
        }
        return availableCabLineNbr;
    }

    protected int getMaxCabLineNbrForItemInForm(PurchasingAccountsPayableDocument purApDoc, PurchasingAccountsPayableItemAsset currentItemAsset) {
        int maxCabLineNbr = 0;
        for (PurchasingAccountsPayableItemAsset item : purApDoc.getPurchasingAccountsPayableItemAssets()) {
            if (!item.getDocumentNumber().equalsIgnoreCase(currentItemAsset.getDocumentNumber()) || !item.getAccountsPayableLineItemIdentifier().equals(currentItemAsset.getAccountsPayableLineItemIdentifier()) || item.getCapitalAssetBuilderLineNumber() <= maxCabLineNbr) continue;
            maxCabLineNbr = item.getCapitalAssetBuilderLineNumber();
        }
        return maxCabLineNbr;
    }

    protected void addSplitHistory(PurchasingAccountsPayableItemAsset currentItemAsset, PurchasingAccountsPayableItemAsset newItemAsset, List<PurchasingAccountsPayableActionHistory> actionsTakenHistory) {
        for (PurchasingAccountsPayableLineAssetAccount account : newItemAsset.getPurchasingAccountsPayableLineAssetAccounts()) {
            PurchasingAccountsPayableActionHistory newAction = new PurchasingAccountsPayableActionHistory(currentItemAsset, newItemAsset, "split");
            newAction.setGeneralLedgerAccountIdentifier(account.getGeneralLedgerAccountIdentifier());
            newAction.setAccountsPayableItemQuantity(newItemAsset.getAccountsPayableItemQuantity());
            newAction.setItemAccountTotalAmount(account.getItemAccountTotalAmount());
            actionsTakenHistory.add(newAction);
        }
    }

    @Override
    public void processSaveBusinessObjects(List<PurchasingAccountsPayableDocument> purApDocs, PurApLineSession purApLineSession) {
        Map<String, Set> removableAssetLocks = this.getRemovableAssetLocks(purApLineSession.getProcessedItems());
        for (PurchasingAccountsPayableDocument purApDoc : purApDocs) {
            this.businessObjectService.save((PersistableBusinessObject)purApDoc);
        }
        for (String lockingDocumentNbr : removableAssetLocks.keySet()) {
            Set lockingInfoList = removableAssetLocks.get(lockingDocumentNbr);
            for (String lockingInfo : lockingInfoList) {
                if (!this.getCapitalAssetManagementModuleService().isAssetLockedByCurrentDocument(lockingDocumentNbr, lockingInfo)) continue;
                this.getCapitalAssetManagementModuleService().deleteAssetLocks(lockingDocumentNbr, lockingInfo);
            }
        }
        if (purApLineSession != null) {
            List<GeneralLedgerEntry> glUpdateList;
            List<PurchasingAccountsPayableActionHistory> historyList = purApLineSession.getActionsTakenHistory();
            if (historyList != null && !historyList.isEmpty()) {
                this.businessObjectService.save(historyList);
                historyList.clear();
            }
            if ((glUpdateList = purApLineSession.getGlEntryUpdateList()) != null && !glUpdateList.isEmpty()) {
                this.businessObjectService.save(glUpdateList);
                glUpdateList.clear();
            }
        }
    }

    protected void createAccountsForNewItemAsset(PurchasingAccountsPayableItemAsset currentItemAsset, PurchasingAccountsPayableItemAsset newItemAsset) {
        KualiDecimal currentQty = currentItemAsset.getAccountsPayableItemQuantity();
        KualiDecimal splitQty = currentItemAsset.getSplitQty();
        List<PurchasingAccountsPayableLineAssetAccount> newAccountsList = newItemAsset.getPurchasingAccountsPayableLineAssetAccounts();
        for (PurchasingAccountsPayableLineAssetAccount currentAccount : currentItemAsset.getPurchasingAccountsPayableLineAssetAccounts()) {
            PurchasingAccountsPayableLineAssetAccount newAccount = new PurchasingAccountsPayableLineAssetAccount(newItemAsset, currentAccount.getGeneralLedgerAccountIdentifier());
            newAccount.setItemAccountTotalAmount((KualiDecimal)((KualiDecimal)currentAccount.getItemAccountTotalAmount().multiply((AbstractKualiDecimal)splitQty)).divide((AbstractKualiDecimal)currentQty));
            newAccount.setGeneralLedgerEntry(currentAccount.getGeneralLedgerEntry());
            newAccountsList.add(newAccount);
            currentAccount.setItemAccountTotalAmount((KualiDecimal)currentAccount.getItemAccountTotalAmount().subtract((AbstractKualiDecimal)newAccount.getItemAccountTotalAmount()));
        }
    }

    protected void setFirstFinancialObjectCode(PurchasingAccountsPayableItemAsset item) {
        String firstFinancialObjectCode = null;
        for (PurchasingAccountsPayableLineAssetAccount account : item.getPurchasingAccountsPayableLineAssetAccounts()) {
            if (!ObjectUtils.isNotNull((Object)((Object)account.getGeneralLedgerEntry()))) continue;
            firstFinancialObjectCode = account.getGeneralLedgerEntry().getFinancialObjectCode();
            break;
        }
        item.setFirstFincialObjectCode(firstFinancialObjectCode);
    }

    @Override
    public void buildPurApItemAssetList(List<PurchasingAccountsPayableDocument> purApDocs) {
        for (PurchasingAccountsPayableDocument purApDoc : purApDocs) {
            for (PurchasingAccountsPayableItemAsset item : purApDoc.getPurchasingAccountsPayableItemAssets()) {
                this.purApInfoService.setAccountsPayableItemsFromPurAp(item, purApDoc.getDocumentTypeCode());
                this.setLineItemCost(item);
                this.setFirstFinancialObjectCode(item);
                this.updateAssetDescriptionFromPreTag(item, purApDoc);
            }
            Collections.sort(purApDoc.getPurchasingAccountsPayableItemAssets());
        }
        this.purApInfoService.setCamsTransactionFromPurAp(purApDocs);
        this.setAssetIndicator(purApDocs);
    }

    private void updateAssetDescriptionFromPreTag(PurchasingAccountsPayableItemAsset item, PurchasingAccountsPayableDocument purApDoc) {
        Pretag preTag;
        if (item.isActive() && ObjectUtils.isNotNull((Object)((Object)(preTag = this.getPreTagLineItem(purApDoc.getPurchaseOrderIdentifier(), item.getItemLineNumber())))) && StringUtils.isNotBlank((CharSequence)preTag.getAssetTopsDescription())) {
            item.setAccountsPayableLineItemDescription(preTag.getAssetTopsDescription());
        }
    }

    @Override
    public Pretag getPreTagLineItem(Integer purchaseOrderIdentifier, Integer lineItemNumber) {
        if (purchaseOrderIdentifier == null || lineItemNumber == null) {
            return null;
        }
        HashMap<String, Integer> pKeys = new HashMap<String, Integer>();
        pKeys.put("purchaseOrderNumber", purchaseOrderIdentifier);
        pKeys.put("itemLineNumber", lineItemNumber);
        return (Pretag)this.businessObjectService.findByPrimaryKey(Pretag.class, pKeys);
    }

    protected void setAssetIndicator(List<PurchasingAccountsPayableDocument> apDocs) {
        boolean existUnallocatedAdditionalTRDI = this.existUnallocatedAdditionalTRDI(apDocs);
        boolean existActiveItemTradeIn = this.existActiveItemTradeIn(apDocs);
        for (PurchasingAccountsPayableDocument apDoc : apDocs) {
            boolean existUnallocatedAdditionalNonTRDI = this.existUnallocatedAdditionalNonTRDI(apDoc);
            boolean existActiveItemLines = this.existActiveItemLines(apDoc);
            if (existUnallocatedAdditionalNonTRDI && existActiveItemLines) continue;
            for (PurchasingAccountsPayableItemAsset item : apDoc.getPurchasingAccountsPayableItemAssets()) {
                if (!item.isActive()) continue;
                if (!existUnallocatedAdditionalTRDI || !existActiveItemTradeIn) {
                    item.setCreateAssetIndicator(true);
                    item.setApplyPaymentIndicator(true);
                    continue;
                }
                if (item.isActiveAdditionalTRDI() || item.isActiveItemTradeIn()) continue;
                item.setCreateAssetIndicator(true);
                item.setApplyPaymentIndicator(true);
            }
        }
    }

    protected boolean existUnallocatedAdditionalTRDI(List<PurchasingAccountsPayableDocument> apDocs) {
        for (PurchasingAccountsPayableDocument apDoc : apDocs) {
            for (PurchasingAccountsPayableItemAsset item : apDoc.getPurchasingAccountsPayableItemAssets()) {
                if (!item.isActiveAdditionalTRDI()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean existUnallocatedAdditionalNonTRDI(PurchasingAccountsPayableDocument apDoc) {
        for (PurchasingAccountsPayableItemAsset item : apDoc.getPurchasingAccountsPayableItemAssets()) {
            if (!item.isActiveAdditionalNonTRDI()) continue;
            return true;
        }
        return false;
    }

    protected boolean existActiveItemTradeIn(List<PurchasingAccountsPayableDocument> apDocs) {
        for (PurchasingAccountsPayableDocument apDoc : apDocs) {
            for (PurchasingAccountsPayableItemAsset item : apDoc.getPurchasingAccountsPayableItemAssets()) {
                if (!item.isActiveItemTradeIn()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean existActiveItemLines(PurchasingAccountsPayableDocument apDoc) {
        for (PurchasingAccountsPayableItemAsset item : apDoc.getPurchasingAccountsPayableItemAssets()) {
            if (!item.isActiveItemLine()) continue;
            return true;
        }
        return false;
    }

    protected void setItemAssetUnitCost(PurchasingAccountsPayableItemAsset item, KualiDecimal totalCost) {
        KualiDecimal quantity = item.getAccountsPayableItemQuantity();
        if (quantity != null && quantity.isNonZero()) {
            item.setUnitCost((KualiDecimal)totalCost.divide((AbstractKualiDecimal)quantity));
        }
    }

    public KualiDecimal calculateItemAssetTotalCost(PurchasingAccountsPayableItemAsset item) {
        KualiDecimal totalCost = KualiDecimal.ZERO;
        for (PurchasingAccountsPayableLineAssetAccount account : item.getPurchasingAccountsPayableLineAssetAccounts()) {
            if (account.getItemAccountTotalAmount() == null) continue;
            totalCost = (KualiDecimal)totalCost.add((AbstractKualiDecimal)account.getItemAccountTotalAmount());
        }
        return totalCost;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public PurApLineDao getPurApLineDao() {
        return this.purApLineDao;
    }

    public void setPurApLineDao(PurApLineDao purApLineDao) {
        this.purApLineDao = purApLineDao;
    }

    public PurApInfoService getPurApInfoService() {
        return this.purApInfoService;
    }

    public void setPurApInfoService(PurApInfoService purApInfoService) {
        this.purApInfoService = purApInfoService;
    }

    public void setAssetService(AssetService assetService) {
        this.assetService = assetService;
    }

    public CapitalAssetManagementModuleService getCapitalAssetManagementModuleService() {
        return this.capitalAssetManagementModuleService;
    }

    public void setCapitalAssetManagementModuleService(CapitalAssetManagementModuleService capitalAssetManagementModuleService) {
        this.capitalAssetManagementModuleService = capitalAssetManagementModuleService;
    }
}

