/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.validation.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.datadictionary.legacy.BusinessObjectDictionaryService;
import org.kuali.kfs.datadictionary.legacy.DocumentDictionaryService;
import org.kuali.kfs.integration.cam.CapitalAssetManagementModuleService;
import org.kuali.kfs.kns.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.document.authorization.MaintenanceDocumentAuthorizer;
import org.kuali.kfs.kns.maintenance.Maintainable;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.datadictionary.ReferenceDefinition;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.CamsPropertyConstants;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetGlobalDetail;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentDetail;
import org.kuali.kfs.module.cam.businessobject.AssetType;
import org.kuali.kfs.module.cam.document.gl.AssetGlobalGeneralLedgerPendingEntrySource;
import org.kuali.kfs.module.cam.document.service.AssetAcquisitionTypeService;
import org.kuali.kfs.module.cam.document.service.AssetGlobalService;
import org.kuali.kfs.module.cam.document.service.AssetLocationService;
import org.kuali.kfs.module.cam.document.service.AssetPaymentService;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.module.cam.document.service.PaymentSummaryService;
import org.kuali.kfs.sys.businessobject.Building;
import org.kuali.kfs.sys.businessobject.Campus;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.businessobject.Room;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.GeneralLedgerPendingEntrySource;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.parameter.ParameterEvaluator;
import org.kuali.rice.core.api.parameter.ParameterEvaluatorService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.web.format.CurrencyFormatter;
import org.kuali.rice.krad.bo.BusinessObject;

public class AssetGlobalRule
extends MaintenanceDocumentRuleBase {
    private static final Logger LOG = LogManager.getLogger();
    private BusinessObjectDictionaryService businessObjectDictionaryService;
    protected static final Map<AssetLocationService.LocationField, String> LOCATION_FIELD_MAP = new HashMap<AssetLocationService.LocationField, String>();

    protected boolean checkReferenceExists(AssetGlobal assetGlobal, AssetPaymentDetail assetPaymentDetail) {
        boolean valid = true;
        if (StringUtils.isBlank((CharSequence)assetPaymentDetail.getFinancialObjectCode())) {
            valid = false;
        }
        if (assetPaymentDetail.getExpenditureFinancialDocumentPostedDate() != null) {
            valid &= this.validatePostedDate(assetPaymentDetail);
        }
        if (valid && StringUtils.isNotBlank((CharSequence)assetPaymentDetail.getFinancialObjectCode())) {
            assetPaymentDetail.refreshReferenceObject("objectCode");
            if (ObjectUtils.isNull((Object)assetPaymentDetail.getObjectCode())) {
                String label = this.getBusinessObjectDictionaryService().getBusinessObjectEntry(AssetPaymentDetail.class.getName()).getAttributeDefinition("financialObjectCode").getLabel();
                GlobalVariables.getMessageMap().putError("financialObjectCode", "error.existence", new String[]{label});
                valid = false;
            }
        }
        if (StringUtils.isBlank((CharSequence)assetGlobal.getAcquisitionTypeCode()) || ObjectUtils.isNull((Object)((Object)assetGlobal.getAcquisitionType()))) {
            this.putFieldError("acquisitionTypeCode", "error.acquisition.code.required");
            valid = false;
        }
        if (StringUtils.isBlank((CharSequence)assetGlobal.getInventoryStatusCode())) {
            this.putFieldError("inventoryStatusCode", "error.asset.inventory.status.code.required.for.payment");
            GlobalVariables.getMessageMap().putError("sequenceNumber", "error.asset.payment.validation.dependency", new String[0]);
            valid = false;
        }
        if (StringUtils.isBlank((CharSequence)assetGlobal.getCapitalAssetTypeCode())) {
            this.putFieldError("capitalAssetTypeCode", "error.valid.capital.asset.type.required");
            GlobalVariables.getMessageMap().putError("sequenceNumber", "error.asset.payment.validation.dependency", new String[0]);
            valid = false;
        }
        if (!this.getAssetGlobalService().isAssetSeparate(assetGlobal)) {
            String label;
            assetPaymentDetail.refreshReferenceObject("account");
            BusinessObjectEntry assetPaymentDetailEntry = this.getBusinessObjectDictionaryService().getBusinessObjectEntry(AssetPaymentDetail.class.getName());
            if (StringUtils.isBlank((CharSequence)assetPaymentDetail.getAccountNumber()) || this.isAccountInvalid(assetPaymentDetail.getAccount())) {
                GlobalVariables.getMessageMap().putError("accountNumber", "error.asset.payment.account.not.valid", new String[]{assetPaymentDetail.getChartOfAccountsCode(), assetPaymentDetail.getAccountNumber()});
                valid = false;
            } else if (!StringUtils.isBlank((CharSequence)assetPaymentDetail.getAccountNumber()) && !assetPaymentDetail.getAccount().isActive()) {
                label = assetPaymentDetailEntry.getAttributeDefinition("accountNumber").getLabel();
                GlobalVariables.getMessageMap().putError("accountNumber", "error.inactive", new String[]{label});
                valid = false;
            }
            assetPaymentDetail.refreshReferenceObject("subAccount");
            if (!StringUtils.isBlank((CharSequence)assetPaymentDetail.getSubAccountNumber()) && ObjectUtils.isNull((Object)assetPaymentDetail.getSubAccount())) {
                label = assetPaymentDetailEntry.getAttributeDefinition("subAccountNumber").getLabel();
                GlobalVariables.getMessageMap().putError("subAccountNumber", "error.existence", new String[]{label});
                valid = false;
            } else if (!StringUtils.isBlank((CharSequence)assetPaymentDetail.getSubAccountNumber()) && !assetPaymentDetail.getSubAccount().isActive()) {
                label = assetPaymentDetailEntry.getAttributeDefinition("subAccountNumber").getLabel();
                GlobalVariables.getMessageMap().putError("subAccountNumber", "error.inactive", new String[]{label});
                valid = false;
            }
            assetPaymentDetail.refreshReferenceObject("objectCode");
            if (!StringUtils.isBlank((CharSequence)assetPaymentDetail.getFinancialObjectCode()) && ObjectUtils.isNull((Object)assetPaymentDetail.getObjectCode())) {
                label = assetPaymentDetailEntry.getAttributeDefinition("financialObjectCode").getLabel();
                GlobalVariables.getMessageMap().putError("financialObjectCode", "error.existence", new String[]{label});
                valid = false;
            } else if (!StringUtils.isBlank((CharSequence)assetPaymentDetail.getFinancialObjectCode()) && !assetPaymentDetail.getObjectCode().isActive()) {
                label = assetPaymentDetailEntry.getAttributeDefinition("financialObjectCode").getLabel();
                GlobalVariables.getMessageMap().putError("financialObjectCode", "error.inactive", new String[]{label});
                valid = false;
            }
            assetPaymentDetail.refreshReferenceObject("subObjectCode");
            if (!StringUtils.isBlank((CharSequence)assetPaymentDetail.getFinancialSubObjectCode()) && ObjectUtils.isNull((Object)assetPaymentDetail.getSubObjectCode())) {
                label = assetPaymentDetailEntry.getAttributeDefinition("financialSubObjectCode").getLabel();
                GlobalVariables.getMessageMap().putError("financialSubObjectCode", "error.existence", new String[]{label});
                valid = false;
            } else if (!StringUtils.isBlank((CharSequence)assetPaymentDetail.getFinancialSubObjectCode()) && !assetPaymentDetail.getSubObjectCode().isActive()) {
                label = assetPaymentDetailEntry.getAttributeDefinition("financialSubObjectCode").getLabel();
                GlobalVariables.getMessageMap().putError("financialSubObjectCode", "error.inactive", new String[]{label});
                valid = false;
            }
            assetPaymentDetail.refreshReferenceObject("project");
            if (!StringUtils.isBlank((CharSequence)assetPaymentDetail.getProjectCode()) && ObjectUtils.isNull((Object)assetPaymentDetail.getProject())) {
                label = assetPaymentDetailEntry.getAttributeDefinition("projectCode").getLabel();
                GlobalVariables.getMessageMap().putError("projectCode", "error.existence", new String[]{label});
                valid = false;
            } else if (!StringUtils.isBlank((CharSequence)assetPaymentDetail.getProjectCode()) && !assetPaymentDetail.getProject().isActive()) {
                label = assetPaymentDetailEntry.getAttributeDefinition("projectCode").getLabel();
                GlobalVariables.getMessageMap().putError("projectCode", "error.inactive", new String[]{label});
                valid = false;
            }
            assetPaymentDetail.refreshReferenceObject("expenditureFinancialSystemOrigination");
            if (!StringUtils.isBlank((CharSequence)assetPaymentDetail.getExpenditureFinancialSystemOriginationCode()) && ObjectUtils.isNull((Object)assetPaymentDetail.getExpenditureFinancialSystemOrigination())) {
                label = assetPaymentDetailEntry.getAttributeDefinition("expenditureFinancialSystemOriginationCode").getLabel();
                GlobalVariables.getMessageMap().putError("expenditureFinancialSystemOriginationCode", "error.existence", new String[]{label});
                valid = false;
            } else if (!StringUtils.isBlank((CharSequence)assetPaymentDetail.getExpenditureFinancialSystemOriginationCode()) && !assetPaymentDetail.getExpenditureFinancialSystemOrigination().isActive()) {
                label = assetPaymentDetailEntry.getAttributeDefinition("expenditureFinancialSystemOriginationCode").getLabel();
                GlobalVariables.getMessageMap().putError("expenditureFinancialSystemOriginationCode", "error.inactive", new String[]{label});
                valid = false;
            }
            if (!StringUtils.isBlank((CharSequence)assetPaymentDetail.getExpenditureFinancialDocumentTypeCode()) && ObjectUtils.isNull((Object)assetPaymentDetail.getExpenditureFinancialSystemDocumentTypeCode())) {
                label = assetPaymentDetailEntry.getAttributeDefinition("expenditureFinancialDocumentTypeCode").getLabel();
                GlobalVariables.getMessageMap().putError("expenditureFinancialDocumentTypeCode", "error.existence", new String[]{label});
                return false;
            }
            if (!StringUtils.isBlank((CharSequence)assetPaymentDetail.getExpenditureFinancialDocumentTypeCode()) && !assetPaymentDetail.getExpenditureFinancialSystemDocumentTypeCode().isActive()) {
                label = assetPaymentDetailEntry.getAttributeDefinition("expenditureFinancialDocumentTypeCode").getLabel();
                GlobalVariables.getMessageMap().putError("expenditureFinancialDocumentTypeCode", "error.inactive", new String[]{label});
                valid = false;
            }
        }
        return valid;
    }

    protected boolean checkReferenceExists(AssetGlobalDetail assetGlobalDetail) {
        String label;
        HashMap<String, String> objectKeys;
        boolean valid = true;
        if (StringUtils.isNotBlank((CharSequence)assetGlobalDetail.getCampusCode())) {
            Campus campus = this.getCampus(assetGlobalDetail.getCampusCode());
            if (ObjectUtils.isNull((Object)campus)) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.AssetGlobalDetail.CAMPUS_CODE, "error.invalid.campus.code", new String[]{assetGlobalDetail.getCampusCode()});
                valid = false;
            } else if (!campus.isActive()) {
                String label2 = this.getBusinessObjectDictionaryService().getBusinessObjectEntry(Campus.class.getName()).getAttributeDefinition("campusCode").getLabel();
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.AssetGlobalDetail.CAMPUS_CODE, "error.inactive", new String[]{label2});
                valid = false;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)assetGlobalDetail.getBuildingCode())) {
            objectKeys = new HashMap<String, String>();
            objectKeys.put(CamsPropertyConstants.AssetGlobalDetail.CAMPUS_CODE, assetGlobalDetail.getCampusCode());
            objectKeys.put(CamsPropertyConstants.AssetGlobalDetail.BUILDING_CODE, assetGlobalDetail.getBuildingCode());
            Building building = (Building)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(Building.class, objectKeys);
            if (ObjectUtils.isNull((Object)building)) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.AssetGlobalDetail.BUILDING_CODE, "error.invalid.building.code", new String[]{assetGlobalDetail.getBuildingCode(), assetGlobalDetail.getCampusCode()});
                valid = false;
            } else if (!building.isActive()) {
                label = this.getBusinessObjectDictionaryService().getBusinessObjectEntry(Building.class.getName()).getAttributeDefinition("buildingCode").getLabel();
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.AssetGlobalDetail.BUILDING_CODE, "error.inactive", new String[]{label});
                valid = false;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)assetGlobalDetail.getBuildingRoomNumber())) {
            objectKeys = new HashMap();
            objectKeys.put(CamsPropertyConstants.AssetGlobalDetail.CAMPUS_CODE, assetGlobalDetail.getCampusCode());
            objectKeys.put(CamsPropertyConstants.AssetGlobalDetail.BUILDING_CODE, assetGlobalDetail.getBuildingCode());
            objectKeys.put(CamsPropertyConstants.AssetGlobalDetail.BUILDING_ROOM_NUMBER, assetGlobalDetail.getBuildingRoomNumber());
            Room room = (Room)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(Room.class, objectKeys);
            if (ObjectUtils.isNull((Object)room)) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.AssetGlobalDetail.BUILDING_ROOM_NUMBER, "error.invalid.room.code", new String[]{assetGlobalDetail.getBuildingCode(), assetGlobalDetail.getBuildingRoomNumber(), assetGlobalDetail.getCampusCode()});
                valid = false;
            } else if (!room.isActive()) {
                label = this.getBusinessObjectDictionaryService().getBusinessObjectEntry(Room.class.getName()).getAttributeDefinition("buildingRoomNumber").getLabel();
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.AssetGlobalDetail.BUILDING_ROOM_NUMBER, "error.inactive", new String[]{label});
                valid = false;
            }
        }
        return valid;
    }

    private Campus getCampus(String campusCode) {
        BusinessObjectService businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        return (Campus)businessObjectService.findBySinglePrimaryKey(Campus.class, (Object)campusCode);
    }

    protected boolean isCapitalStatus(AssetGlobal assetGlobal) {
        return this.getParameterService().getParameterValuesAsString(Asset.class, "CAPITAL_ASSET_STATUS_CODES").contains(assetGlobal.getInventoryStatusCode());
    }

    protected boolean isStatusCodeRetired(String statusCode) {
        return this.getParameterService().getParameterValuesAsString(Asset.class, "RETIRED_STATUS_CODES").contains(statusCode);
    }

    public boolean processCustomAddCollectionLineBusinessRules(MaintenanceDocument document, String collectionName, PersistableBusinessObject line) {
        AssetPaymentDetail assetPaymentDetail;
        boolean success = super.processCustomAddCollectionLineBusinessRules(document, collectionName, line);
        if (GlobalVariables.getMessageMap().hasErrors()) {
            return false;
        }
        AssetGlobal assetGlobal = (AssetGlobal)document.getNewMaintainableObject().getBusinessObject();
        List<AssetGlobalDetail> assetSharedDetails = assetGlobal.getAssetSharedDetails();
        if ("assetSharedDetails".equals(collectionName)) {
            AssetGlobalDetail assetGlobalDetail = (AssetGlobalDetail)line;
            success &= this.checkReferenceExists(assetGlobalDetail);
            success &= this.validateLocation(assetGlobal, assetGlobalDetail);
            success &= this.validateLocationQuantity(line);
        } else if (StringUtils.isNotBlank((CharSequence)collectionName) && collectionName.contains("assetGlobalUniqueDetails")) {
            AssetGlobalDetail assetUniqueDetail = (AssetGlobalDetail)line;
            String campusTagNumber = assetUniqueDetail.getCampusTagNumber();
            if (StringUtils.isNotBlank((CharSequence)campusTagNumber)) {
                success &= this.validateTagDuplication(assetSharedDetails, campusTagNumber);
            }
        } else if ("assetPaymentDetails".equals(collectionName) && (success &= this.checkReferenceExists(assetGlobal, assetPaymentDetail = (AssetPaymentDetail)line))) {
            success = this.validatePaymentLine(document, assetGlobal, assetPaymentDetail);
            success &= this.checkNegativeOrZeroPayment(document, assetPaymentDetail);
        }
        if (this.getAssetGlobalService().isAssetSeparate(assetGlobal)) {
            success &= this.validateTotalCostAmount(assetGlobal);
        }
        return success;
    }

    protected boolean validateLocationQuantity(PersistableBusinessObject line) {
        boolean success = true;
        AssetGlobalDetail assetGlobalDetail = (AssetGlobalDetail)line;
        if (assetGlobalDetail.getLocationQuantity() <= 0) {
            GlobalVariables.getMessageMap().putError(CamsPropertyConstants.AssetGlobalDetail.LOCATION_QUANTITY, "error.zero.or.negative.location.quantity", new String[]{assetGlobalDetail.getLocationQuantity().toString()});
            success = false;
        }
        return success;
    }

    protected boolean validateTagDuplication(List<AssetGlobalDetail> assetSharedDetails, String campusTagNumber) {
        boolean success = true;
        if (!campusTagNumber.equalsIgnoreCase("N")) {
            List<Asset> tagMatches;
            for (AssetGlobalDetail assetSharedDetail : assetSharedDetails) {
                List<AssetGlobalDetail> assetGlobalUniqueDetails = assetSharedDetail.getAssetGlobalUniqueDetails();
                for (AssetGlobalDetail assetSharedUniqueDetail : assetGlobalUniqueDetails) {
                    if (!campusTagNumber.equalsIgnoreCase(assetSharedUniqueDetail.getCampusTagNumber())) continue;
                    success = false;
                    GlobalVariables.getMessageMap().putError("campusTagNumber", "error.asset.campus.tag.number.duplicate", new String[]{campusTagNumber});
                }
            }
            if (success && !(tagMatches = this.getAssetService().findActiveAssetsMatchingTagNumber(campusTagNumber)).isEmpty()) {
                GlobalVariables.getMessageMap().putError("campusTagNumber", "error.asset.campus.tag.number.duplicate", new String[]{campusTagNumber});
                success = false;
            }
        }
        return success;
    }

    protected boolean validateTagDuplication(List<AssetGlobalDetail> assetSharedDetails) {
        HashSet<String> assetTags = new HashSet<String>();
        boolean success = true;
        int parentIndex = -1;
        int childIndex = -1;
        for (AssetGlobalDetail assetSharedDetail : assetSharedDetails) {
            String campusTagNumber;
            ++parentIndex;
            List<AssetGlobalDetail> assetGlobalUniqueDetails = assetSharedDetail.getAssetGlobalUniqueDetails();
            for (AssetGlobalDetail assetSharedUniqueDetail : assetGlobalUniqueDetails) {
                ++childIndex;
                campusTagNumber = assetSharedUniqueDetail.getCampusTagNumber();
                if (!StringUtils.isNotBlank((CharSequence)campusTagNumber) || assetTags.add(campusTagNumber) || campusTagNumber.equalsIgnoreCase("N")) continue;
                success = false;
                String errorPath = "document.newMaintainableObject.assetSharedDetails[" + parentIndex + "].assetGlobalUniqueDetails[" + childIndex + "]";
                GlobalVariables.getMessageMap().addToErrorPath(errorPath);
                GlobalVariables.getMessageMap().putError("campusTagNumber", "error.asset.campus.tag.number.duplicate", new String[]{campusTagNumber});
                GlobalVariables.getMessageMap().removeFromErrorPath(errorPath);
            }
            childIndex = -1;
            for (AssetGlobalDetail assetSharedUniqueDetail : assetGlobalUniqueDetails) {
                List<Asset> tagMatches;
                ++childIndex;
                campusTagNumber = assetSharedUniqueDetail.getCampusTagNumber();
                if (!StringUtils.isNotBlank((CharSequence)campusTagNumber) || campusTagNumber.equalsIgnoreCase("N") || (tagMatches = this.getAssetService().findActiveAssetsMatchingTagNumber(campusTagNumber)).isEmpty()) continue;
                success = false;
                String errorPath = "document.newMaintainableObject.assetSharedDetails[" + parentIndex + "].assetGlobalUniqueDetails[" + childIndex + "]";
                GlobalVariables.getMessageMap().addToErrorPath(errorPath);
                GlobalVariables.getMessageMap().putError("campusTagNumber", "error.asset.campus.tag.number.duplicate", new String[]{campusTagNumber});
                GlobalVariables.getMessageMap().removeFromErrorPath(errorPath);
            }
        }
        return success;
    }

    protected boolean validatePaymentLine(MaintenanceDocument maintenanceDocument, AssetGlobal assetGlobal, AssetPaymentDetail assetPaymentDetail) {
        boolean success = this.getAssetGlobalService().existsInGroup(this.getAssetGlobalService().getNewAcquisitionTypeCode(), assetGlobal.getAcquisitionTypeCode()) || !this.getAssetGlobalService().existsInGroup(this.getAssetGlobalService().getCapitalObjectAcquisitionCodeGroup(), assetGlobal.getAcquisitionTypeCode()) ? this.checkRequiredFieldsForNewOrNonCapital(assetPaymentDetail) : this.validateDocumentTypeForNonNew(assetGlobal.getAcquisitionTypeCode(), assetPaymentDetail);
        assetPaymentDetail.refreshReferenceObject("objectCode");
        return success &= this.validateObjectCode(assetPaymentDetail.getObjectCode(), assetGlobal);
    }

    protected boolean checkNegativeOrZeroPayment(MaintenanceDocument maintenanceDocument, AssetPaymentDetail assetPaymentDetail) {
        boolean success = true;
        MaintenanceDocumentAuthorizer documentAuthorizer = this.getMaintenanceDocumentAuthorizer(maintenanceDocument);
        boolean isAuthorized = documentAuthorizer.isAuthorized((BusinessObject)maintenanceDocument, "KFS-CAM", "Add Negative Payments", GlobalVariables.getUserSession().getPerson().getPrincipalId());
        if (!isAuthorized && assetPaymentDetail.getAmount() != null && assetPaymentDetail.getAmount().isNegative()) {
            GlobalVariables.getMessageMap().putError("amount", "error.payment.amount.invalid", new String[0]);
            success = false;
        }
        if (assetPaymentDetail.getAmount().isZero()) {
            GlobalVariables.getMessageMap().putError("amount", "error.payment.amount.invalid", new String[0]);
            success = false;
        }
        return success;
    }

    protected boolean checkRequiredFieldsForNewOrNonCapital(AssetPaymentDetail assetPaymentDetail) {
        boolean valid = true;
        if (StringUtils.isBlank((CharSequence)assetPaymentDetail.getExpenditureFinancialDocumentNumber())) {
            GlobalVariables.getMessageMap().putError("expenditureFinancialDocumentNumber", "error.expenditure.financial.document.number.required", new String[0]);
            valid = false;
        }
        if (assetPaymentDetail.getExpenditureFinancialDocumentPostedDate() == null) {
            GlobalVariables.getMessageMap().putError("expenditureFinancialDocumentPostedDate", "error.document.posting.date.required", new String[0]);
            valid = false;
        }
        if (StringUtils.isBlank((CharSequence)assetPaymentDetail.getExpenditureFinancialDocumentTypeCode())) {
            GlobalVariables.getMessageMap().putError("expenditureFinancialDocumentTypeCode", "error.expenditure.financial.document.type.code.required", new String[0]);
            valid = false;
        }
        return valid;
    }

    protected boolean validatePostedDate(AssetPaymentDetail assetPaymentDetail) {
        boolean valid = true;
        Date currentDate = ((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentDate();
        if (!this.getAssetPaymentService().extractPostedDatePeriod(assetPaymentDetail)) {
            GlobalVariables.getMessageMap().putError("postingYear", "error.university.not.defined.for.date", new String[]{assetPaymentDetail.getExpenditureFinancialDocumentPostedDate().toString()});
            valid = false;
        } else if (assetPaymentDetail.getExpenditureFinancialDocumentPostedDate().compareTo(currentDate) > 0) {
            GlobalVariables.getMessageMap().putError("expenditureFinancialDocumentPostedDate", "error.payment.invalid.document.postdate", new String[0]);
            valid = false;
        }
        return valid;
    }

    protected boolean validateDocumentTypeForNonNew(String acquisitionTypeCode, AssetPaymentDetail assetPaymentDetail) {
        String documentTypeCode = assetPaymentDetail.getExpenditureFinancialDocumentTypeCode();
        boolean valid = true;
        if (StringUtils.isNotBlank((CharSequence)acquisitionTypeCode) && this.getAssetGlobalService().existsInGroup(this.getAssetGlobalService().getNonNewAcquisitionCodeGroup(), acquisitionTypeCode)) {
            if (StringUtils.isNotBlank((CharSequence)documentTypeCode) && !"AA".equalsIgnoreCase(documentTypeCode)) {
                GlobalVariables.getMessageMap().putError("expenditureFinancialDocumentTypeCode", "error.document.type.code.not.allowed", new String[]{documentTypeCode});
                valid = false;
            } else {
                assetPaymentDetail.setExpenditureFinancialDocumentTypeCode("AA");
            }
        }
        return valid;
    }

    protected boolean validateObjectCode(ObjectCode objectCode, AssetGlobal assetGlobal) {
        ParameterEvaluator parameterEvaluator = ((ParameterEvaluatorService)SpringContext.getBean(ParameterEvaluatorService.class)).getParameterEvaluator(AssetGlobal.class, "VALID_OBJECT_SUB_TYPES_BY_ACQUISITION_TYPE", "INVALID_OBJECT_SUB_TYPES_BY_ACQUISITION_TYPE", assetGlobal.getAcquisitionTypeCode(), objectCode.getFinancialObjectSubTypeCode());
        return parameterEvaluator.evaluateAndAddError(ObjectCode.class, "financialObjectSubTypeCode", "financialObjectCode");
    }

    protected boolean isAccountInvalid(Account account) {
        return ObjectUtils.isNull((Object)account) || account.isExpired();
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        AssetGlobal assetGlobal = (AssetGlobal)document.getNewMaintainableObject().getBusinessObject();
        List<AssetGlobalDetail> assetSharedDetails = assetGlobal.getAssetSharedDetails();
        boolean success = super.processCustomRouteDocumentBusinessRules(document);
        if (GlobalVariables.getMessageMap().hasErrors()) {
            return false;
        }
        if (assetSharedDetails.isEmpty() || assetSharedDetails.get(0).getAssetGlobalUniqueDetails().isEmpty()) {
            this.putFieldError("assetSharedDetails", "error.document.min.one.asset.required");
            success = false;
        }
        if (this.isCapitalStatus(assetGlobal) && assetGlobal.getAssetPaymentDetails().isEmpty()) {
            this.putFieldError("assetPaymentDetails", "error.document.min.one.payment.required");
            success = false;
        }
        if (!this.getAssetGlobalService().isAssetSeparate(assetGlobal)) {
            success &= this.validateAssetTotalAmount(document);
        } else {
            KualiDecimal totalSeparateSourceAmount = this.getAssetGlobalService().getUniqueAssetsTotalAmount(assetGlobal);
            if (totalSeparateSourceAmount.isGreaterThan((AbstractKualiDecimal)assetGlobal.getTotalCostAmount())) {
                this.putFieldError("assetSharedDetails", "error.total.separate.source.amount.invalid", new String[]{assetGlobal.getSeparateSourceCapitalAssetNumber().toString()});
                success = false;
            }
            assetGlobal.refreshReferenceObject("separateSourceCapitalAsset");
            if (ObjectUtils.isNotNull((Object)((Object)assetGlobal.getSeparateSourceCapitalAsset())) && !this.getAssetService().isCapitalAsset(assetGlobal.getSeparateSourceCapitalAsset()) && StringUtils.isNotBlank((CharSequence)assetGlobal.getAcquisitionTypeCode())) {
                this.putFieldError("acquisitionTypeCode", "error.non.active.capital.asset.required");
                success = false;
            }
            int sharedIndex = 0;
            for (AssetGlobalDetail addLocationDetail : assetSharedDetails) {
                int uniqueIndex = 0;
                for (AssetGlobalDetail assetGlobalUniqueDetail : addLocationDetail.getAssetGlobalUniqueDetails()) {
                    String errorPath = "document.newMaintainableObject.assetSharedDetails[" + sharedIndex + "].assetGlobalUniqueDetails[" + uniqueIndex + "]";
                    GlobalVariables.getMessageMap().addToErrorPath(errorPath);
                    success &= this.validateCapitalAssetTypeCode(assetGlobalUniqueDetail);
                    success &= this.validateAssetType(assetGlobalUniqueDetail, sharedIndex, uniqueIndex);
                    success &= this.validateAssetDescription(assetGlobalUniqueDetail);
                    success &= this.validateManufacturer(assetGlobalUniqueDetail);
                    success &= this.validateSeparateSourceAmount(assetGlobalUniqueDetail, document);
                    GlobalVariables.getMessageMap().removeFromErrorPath(errorPath);
                    ++uniqueIndex;
                }
                ++sharedIndex;
            }
            success &= this.validateTotalCostAmount(assetGlobal);
            success &= AssetGlobalRule.validateAssetTotalCostMatchesPaymentTotalCost(assetGlobal);
            if (this.getAssetGlobalService().isAssetSeparateByPayment(assetGlobal)) {
                AssetGlobalRule.validateAssetAlreadySeparated(assetGlobal.getSeparateSourceCapitalAssetNumber());
            }
        }
        success &= this.validateLocationCollection(assetGlobal, assetSharedDetails);
        return success &= this.validateTagDuplication(assetSharedDetails);
    }

    protected boolean validateSeparateSourceAmountAboveThreshold(MaintenanceDocument document, AssetGlobalDetail assetGlobalUniqueDetail) {
        boolean success = true;
        String capitalizationThresholdAmount = this.getCapitalizationThresholdAmount();
        KualiDecimal separateAmount = assetGlobalUniqueDetail.getSeparateSourceAmount();
        if (separateAmount != null && !this.getAssetService().isDocumentEnrouting((Document)document) && !this.validateCapitalAssetAmountAboveThreshhold(document, separateAmount, capitalizationThresholdAmount)) {
            GlobalVariables.getMessageMap().putError(CamsPropertyConstants.AssetGlobalDetail.SEPARATE_SOURCE_AMOUNT, "error.separate.asset.below.threshold", new String[]{assetGlobalUniqueDetail.getCapitalAssetNumber().toString(), capitalizationThresholdAmount});
            success = false;
        }
        return success;
    }

    protected boolean validateAssetTotalAmount(MaintenanceDocument document) {
        KualiDecimal maxTotalPaymentByAsset;
        boolean success = true;
        AssetGlobal assetGlobal = (AssetGlobal)document.getNewMaintainableObject().getBusinessObject();
        KualiDecimal minTotalPaymentByAsset = this.getAssetGlobalService().totalPaymentByAsset(assetGlobal, false);
        if (minTotalPaymentByAsset.isGreaterThan((AbstractKualiDecimal)(maxTotalPaymentByAsset = this.getAssetGlobalService().totalPaymentByAsset(assetGlobal, true)))) {
            KualiDecimal totalPayment = minTotalPaymentByAsset;
            minTotalPaymentByAsset = maxTotalPaymentByAsset;
            maxTotalPaymentByAsset = totalPayment;
        }
        if (!(!this.getAssetService().isDocumentEnrouting((Document)document) || minTotalPaymentByAsset.equals((Object)assetGlobal.getMinAssetTotalAmount()) && maxTotalPaymentByAsset.equals((Object)assetGlobal.getMaxAssetTotalAmount()))) {
            String[] stringArray;
            if (!minTotalPaymentByAsset.equals((Object)assetGlobal.getMinAssetTotalAmount())) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = (String)new CurrencyFormatter().format((Object)assetGlobal.getMinAssetTotalAmount());
                stringArray = stringArray2;
                stringArray2[1] = (String)new CurrencyFormatter().format((Object)minTotalPaymentByAsset);
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = (String)new CurrencyFormatter().format((Object)assetGlobal.getMaxAssetTotalAmount());
                stringArray = stringArray3;
                stringArray3[1] = (String)new CurrencyFormatter().format((Object)maxTotalPaymentByAsset);
            }
            this.putFieldError("assetPaymentDetails", "error.change.asset.total.amount.disallow", stringArray);
            success = false;
        }
        if (!this.getAssetService().isDocumentEnrouting((Document)document)) {
            String capitalizationThresholdAmount = this.getCapitalizationThresholdAmount();
            if (this.isCapitalStatus(assetGlobal)) {
                if (!this.validateCapitalAssetAmountAboveThreshhold(document, minTotalPaymentByAsset, capitalizationThresholdAmount)) {
                    this.putFieldError("inventoryStatusCode", "error.capital.asset.payment.min.limit", capitalizationThresholdAmount);
                    success = false;
                }
            } else {
                success &= this.validateNonCapitalAssetAmountBelowThreshold(maxTotalPaymentByAsset, capitalizationThresholdAmount);
            }
        }
        return success;
    }

    protected String getCapitalizationThresholdAmount() {
        return this.getParameterService().getParameterValueAsString(AssetGlobal.class, "CAPITALIZATION_LIMIT_AMOUNT");
    }

    protected boolean validateCapitalAssetAmountAboveThreshhold(MaintenanceDocument document, KualiDecimal assetAmount, String capitalizationThresholdAmount) {
        boolean success = true;
        MaintenanceDocumentAuthorizer documentAuthorizer = this.getMaintenanceDocumentAuthorizer(document);
        boolean isOverrideAuthorized = documentAuthorizer.isAuthorized((BusinessObject)document, "KFS-CAM", "Override CAPITALIZATION_LIMIT_AMOUNT", GlobalVariables.getUserSession().getPerson().getPrincipalId());
        if (assetAmount.isLessThan((AbstractKualiDecimal)new KualiDecimal(capitalizationThresholdAmount)) && !isOverrideAuthorized) {
            success = false;
        }
        return success;
    }

    private MaintenanceDocumentAuthorizer getMaintenanceDocumentAuthorizer(MaintenanceDocument document) {
        return (MaintenanceDocumentAuthorizer)((DocumentDictionaryService)SpringContext.getBean(DocumentDictionaryService.class)).getDocumentAuthorizer((Document)document);
    }

    protected boolean validateNonCapitalAssetAmountBelowThreshold(KualiDecimal assetAmount, String capitalizationThresholdAmount) {
        boolean success = true;
        if (assetAmount.isGreaterEqual((AbstractKualiDecimal)new KualiDecimal(capitalizationThresholdAmount))) {
            this.putFieldError("inventoryStatusCode", "error.noncapital.asset.payment.max.limit", capitalizationThresholdAmount);
            success = false;
        }
        return success;
    }

    protected boolean validateTotalCostAmount(AssetGlobal assetGlobal) {
        boolean success = true;
        if (!assetGlobal.getTotalCostAmount().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
            GlobalVariables.getMessageMap().putErrorForSectionId("assetInformation", "error.zero.or.negative.dollar.amount", new String[0]);
            success = false;
        }
        return success;
    }

    protected boolean validateCapitalAssetTypeCode(AssetGlobalDetail uniqueLocationDetails) {
        boolean success = true;
        if (StringUtils.isEmpty((CharSequence)uniqueLocationDetails.getCapitalAssetTypeCode())) {
            GlobalVariables.getMessageMap().putError(CamsPropertyConstants.AssetGlobalDetail.CAPITAL_ASSET_TYPE_CODE, "error.capital.asset.type.code.required", new String[]{uniqueLocationDetails.getCapitalAssetTypeCode()});
            success = false;
        }
        return success;
    }

    protected boolean validateAssetDescription(AssetGlobalDetail uniqueLocationDetails) {
        boolean success = true;
        if (StringUtils.isEmpty((CharSequence)uniqueLocationDetails.getCapitalAssetDescription())) {
            GlobalVariables.getMessageMap().putError(CamsPropertyConstants.AssetGlobalDetail.CAPITAL_ASSET_DESCRIPTION, "error.asset.description.required", new String[]{uniqueLocationDetails.getCapitalAssetTypeCode()});
            success = false;
        }
        return success;
    }

    protected boolean validateManufacturer(AssetGlobalDetail uniqueLocationDetails) {
        boolean success = true;
        if (StringUtils.isEmpty((CharSequence)uniqueLocationDetails.getManufacturerName())) {
            GlobalVariables.getMessageMap().putError(CamsPropertyConstants.AssetGlobalDetail.MANUFACTURER_NAME, "error.manufacturer.required", new String[]{uniqueLocationDetails.getCapitalAssetTypeCode()});
            success = false;
        }
        return success;
    }

    protected boolean validateSeparateSourceAmount(AssetGlobalDetail uniqueLocationDetail, MaintenanceDocument document) {
        boolean success = true;
        KualiDecimal separateSourceAmount = uniqueLocationDetail.getSeparateSourceAmount();
        if (separateSourceAmount == null || separateSourceAmount.isLessEqual((AbstractKualiDecimal)KualiDecimal.ZERO)) {
            GlobalVariables.getMessageMap().putError(CamsPropertyConstants.AssetGlobalDetail.SEPARATE_SOURCE_AMOUNT, "error.total.separate.source.amount.required", new String[0]);
            success = false;
        } else {
            success = this.validateSeparateSourceAmountAboveThreshold(document, uniqueLocationDetail);
        }
        return success;
    }

    protected boolean validateLocationCollection(AssetGlobal assetGlobal, List<AssetGlobalDetail> assetSharedDetails) {
        boolean success = true;
        boolean isCapitalAsset = this.isCapitalStatus(assetGlobal);
        int index = 0;
        for (AssetGlobalDetail assetLocationDetail : assetSharedDetails) {
            String errorPath = "document.newMaintainableObject.assetSharedDetails[" + index + "]";
            GlobalVariables.getMessageMap().addToErrorPath(errorPath);
            success &= ((AssetLocationService)SpringContext.getBean(AssetLocationService.class)).validateLocation(LOCATION_FIELD_MAP, (BusinessObject)assetLocationDetail, isCapitalAsset, assetGlobal.getCapitalAssetType());
            GlobalVariables.getMessageMap().removeFromErrorPath(errorPath);
            ++index;
        }
        return success;
    }

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        AssetGlobal assetGlobal = (AssetGlobal)document.getNewMaintainableObject().getBusinessObject();
        boolean success = super.processCustomSaveDocumentBusinessRules(document);
        if (GlobalVariables.getMessageMap().hasErrors()) {
            return false;
        }
        String acquisitionTypeCode = assetGlobal.getAcquisitionTypeCode();
        String statusCode = assetGlobal.getInventoryStatusCode();
        if (!this.getAssetGlobalService().isAssetSeparate(assetGlobal)) {
            success &= this.validateAccount(assetGlobal);
            if (StringUtils.isNotBlank((CharSequence)acquisitionTypeCode) && StringUtils.isNotBlank((CharSequence)statusCode)) {
                success &= ((ParameterEvaluatorService)SpringContext.getBean(ParameterEvaluatorService.class)).getParameterEvaluator(AssetGlobal.class, "VALID_ASSET_STATUSES_BY_ACQUISITION_TYPE", "INVALID_ASSET_STATUSES_BY_ACQUISITION_TYPE", acquisitionTypeCode, statusCode).evaluateAndAddError(AssetGlobal.class, "inventoryStatusCode", "document.newMaintainableObject.inventoryStatusCode");
            }
            success &= this.validateAssetType(assetGlobal);
            if (this.isCapitalStatus(assetGlobal)) {
                success &= this.validateVendorAndManufacturer(assetGlobal);
            }
            success &= this.validatePaymentCollection(document, assetGlobal);
        } else if (!document.getDocumentHeader().getDocumentDescription().toLowerCase(Locale.US).contains("Separate an Asset".toLowerCase(Locale.US))) {
            Integer maxDocumentDescription = this.ddService.getAttributeMaxLength(DocumentHeader.class, "documentDescription");
            Object documentDescription = "Separate an Asset " + document.getDocumentHeader().getDocumentDescription();
            documentDescription = StringUtils.left((String)documentDescription, (int)maxDocumentDescription);
            document.getDocumentHeader().setDocumentDescription((String)documentDescription);
        }
        if (success && !this.getAssetGlobalService().isAssetSeparate(assetGlobal) && super.processCustomSaveDocumentBusinessRules(document) && this.getAssetAcquisitionTypeService().hasIncomeAssetObjectCode(acquisitionTypeCode) && this.isCapitalStatus(assetGlobal) && (success = this.validateAcquisitionIncomeObjectCode(assetGlobal))) {
            AssetGlobalGeneralLedgerPendingEntrySource assetGlobalGlPoster = new AssetGlobalGeneralLedgerPendingEntrySource((FinancialSystemDocumentHeader)document.getDocumentHeader());
            this.getAssetGlobalService().createGLPostables(assetGlobal, assetGlobalGlPoster);
            if (((GeneralLedgerPendingEntryService)SpringContext.getBean(GeneralLedgerPendingEntryService.class)).generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySource)assetGlobalGlPoster)) {
                assetGlobal.setGeneralLedgerPendingEntries(assetGlobalGlPoster.getPendingEntries());
            } else {
                assetGlobalGlPoster.getPendingEntries().clear();
            }
        }
        return success;
    }

    protected boolean setAssetLock(MaintenanceDocument document, AssetGlobal assetGlobal) {
        ArrayList<Long> capitalAssetNumbers = new ArrayList<Long>();
        if (assetGlobal.getSeparateSourceCapitalAssetNumber() != null) {
            capitalAssetNumbers.add(assetGlobal.getSeparateSourceCapitalAssetNumber());
        }
        return ((CapitalAssetManagementModuleService)SpringContext.getBean(CapitalAssetManagementModuleService.class)).storeAssetLocks(capitalAssetNumbers, document.getDocumentNumber(), "ASEP", null);
    }

    protected boolean validateAcquisitionIncomeObjectCode(AssetGlobal assetGlobal) {
        boolean valid = true;
        for (AssetPaymentDetail assetPaymentDetail : assetGlobal.getAssetPaymentDetails()) {
            ObjectCode objectCode = ((ObjectCodeService)SpringContext.getBean(ObjectCodeService.class)).getByPrimaryId(assetPaymentDetail.getPostingYear(), assetPaymentDetail.getChartOfAccountsCode(), assetGlobal.getAcquisitionType().getIncomeAssetObjectCode());
            if (ObjectUtils.isNull((Object)objectCode)) {
                this.putFieldError("acquisitionTypeCode", "error.invalid.acquisition.income.object.code", new String[]{assetGlobal.getAcquisitionType().getIncomeAssetObjectCode(), assetPaymentDetail.getPostingYear().toString(), assetPaymentDetail.getChartOfAccountsCode()});
                valid = false;
                continue;
            }
            if (objectCode.isActive()) continue;
            this.putFieldError("acquisitionTypeCode", "error.object.code.from.asset.object.code.inactive", new String[]{"Income", assetGlobal.getAcquisitionType().getIncomeAssetObjectCode(), assetPaymentDetail.getChartOfAccountsCode()});
            valid = false;
        }
        return valid;
    }

    protected boolean validatePaymentCollection(MaintenanceDocument maintenanceDocument, AssetGlobal assetGlobal) {
        boolean success = true;
        int index = 0;
        for (AssetPaymentDetail assetPaymentDetail : assetGlobal.getAssetPaymentDetails()) {
            String errorPath = "document.newMaintainableObject.assetPaymentDetails[" + index + "]";
            GlobalVariables.getMessageMap().addToErrorPath(errorPath);
            success &= this.validatePaymentLine(maintenanceDocument, assetGlobal, assetPaymentDetail);
            GlobalVariables.getMessageMap().removeFromErrorPath(errorPath);
            ++index;
        }
        return success;
    }

    protected boolean validateVendorAndManufacturer(AssetGlobal assetGlobal) {
        boolean success = true;
        if (StringUtils.isBlank((CharSequence)assetGlobal.getVendorName())) {
            this.putFieldError("vendorName", "error.capital.asset.vendor.name.required");
            success = false;
        }
        if (StringUtils.isBlank((CharSequence)assetGlobal.getManufacturerName())) {
            this.putFieldError("manufacturerName", "error.capital.asset.manufacturer.name.required");
            success = false;
        }
        return success;
    }

    public boolean processSaveDocument(Document document) {
        boolean valid = true;
        MaintenanceDocument maintenanceDocument = (MaintenanceDocument)document;
        AssetGlobal assetGlobal = (AssetGlobal)maintenanceDocument.getNewMaintainableObject().getBusinessObject();
        List<AssetGlobalDetail> assetSharedDetails = assetGlobal.getAssetSharedDetails();
        int index = 0;
        for (AssetGlobalDetail assetLocationDetail : assetSharedDetails) {
            String errorPath = "document.newMaintainableObject.assetSharedDetails[" + index + "]";
            GlobalVariables.getMessageMap().addToErrorPath(errorPath);
            valid &= this.checkReferenceExists(assetLocationDetail);
            GlobalVariables.getMessageMap().removeFromErrorPath(errorPath);
            int indexUniqueDetails = 0;
            for (AssetGlobalDetail assetGlobalUniqueDetails : assetLocationDetail.getAssetGlobalUniqueDetails()) {
                valid &= this.validateAssetType(assetGlobalUniqueDetails, index, indexUniqueDetails);
                ++indexUniqueDetails;
            }
            ++index;
        }
        if (valid && this.getAssetGlobalService().isAssetSeparate(assetGlobal)) {
            valid = this.setAssetLock(maintenanceDocument, assetGlobal);
        }
        return valid && super.processSaveDocument(document);
    }

    protected boolean validateAccount(AssetGlobal assetGlobal) {
        boolean success = true;
        assetGlobal.refreshReferenceObject("organizationOwnerAccount");
        Account organizationOwnerAccount = assetGlobal.getOrganizationOwnerAccount();
        boolean skipAccountAvailabilityCheck = StringUtils.isBlank((CharSequence)assetGlobal.getOrganizationOwnerChartOfAccountsCode()) || StringUtils.isBlank((CharSequence)assetGlobal.getOrganizationOwnerAccountNumber()) ? true : this.isOrgOwnerAccountFromCab(assetGlobal);
        if (!skipAccountAvailabilityCheck && (ObjectUtils.isNull((Object)organizationOwnerAccount) || !organizationOwnerAccount.isActive() || organizationOwnerAccount.isExpired())) {
            this.putFieldError("organizationOwnerAccountNumber", "error.asset.owner.account.not.active", new String[]{assetGlobal.getOrganizationOwnerChartOfAccountsCode(), assetGlobal.getOrganizationOwnerAccountNumber()});
            success = false;
        }
        return success;
    }

    protected boolean isOrgOwnerAccountFromCab(AssetGlobal assetGlobal) {
        String orgOwnerChartCode = assetGlobal.getOrganizationOwnerChartOfAccountsCode();
        String orgOwnerAccountNbr = assetGlobal.getOrganizationOwnerAccountNumber();
        if (StringUtils.isBlank((CharSequence)assetGlobal.getOrganizationOwnerChartOfAccountsCode()) || StringUtils.isBlank((CharSequence)assetGlobal.getOrganizationOwnerAccountNumber())) {
            return true;
        }
        if (assetGlobal.isCapitalAssetBuilderOriginIndicator()) {
            for (AssetPaymentDetail assetPaymentDetail : assetGlobal.getAssetPaymentDetails()) {
                if (!orgOwnerChartCode.equalsIgnoreCase(assetPaymentDetail.getChartOfAccountsCode()) || !orgOwnerAccountNbr.equalsIgnoreCase(assetPaymentDetail.getAccountNumber())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean validateLocation(AssetGlobal assetGlobal, AssetGlobalDetail assetGlobalDetail) {
        boolean success;
        if (StringUtils.isBlank((CharSequence)assetGlobal.getInventoryStatusCode())) {
            this.putFieldError("inventoryStatusCode", "error.asset.inventory.status.code.required");
        }
        if (success = this.validateAssetType(assetGlobal)) {
            boolean isCapitalAsset = this.isCapitalStatus(assetGlobal);
            success = ((AssetLocationService)SpringContext.getBean(AssetLocationService.class)).validateLocation(LOCATION_FIELD_MAP, (BusinessObject)assetGlobalDetail, isCapitalAsset, assetGlobal.getCapitalAssetType());
        } else {
            this.putFieldError("capitalAssetTypeCode", "error.asset.location.validation.dependency");
        }
        return success;
    }

    protected boolean validateAssetType(AssetGlobal assetGlobal) {
        boolean success = true;
        assetGlobal.refreshReferenceObject("capitalAssetType");
        if (ObjectUtils.isNull((Object)((Object)assetGlobal.getCapitalAssetType()))) {
            this.putFieldError("assetGlobalUniqueDetails", "error.valid.capital.asset.type.required");
            success = false;
        }
        return success;
    }

    protected boolean validateAssetType(AssetGlobalDetail assetGlobalUniqueDetails, Integer sharedIndex, Integer uniqueIndex) {
        AssetType assetType;
        boolean success = true;
        int sharedInd = 0;
        int uniqueInd = 0;
        if (sharedIndex != null) {
            sharedInd = sharedIndex;
        }
        if (uniqueIndex != null) {
            uniqueInd = uniqueIndex;
        }
        if (ObjectUtils.isNull((Object)((Object)assetGlobalUniqueDetails))) {
            this.putFieldError("assetGlobalUniqueDetails", "error.asset.location.validation.dependency");
            success = false;
        }
        if (StringUtils.isNotBlank((CharSequence)assetGlobalUniqueDetails.getCapitalAssetTypeCode()) && ((assetType = (AssetType)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findBySinglePrimaryKey(AssetType.class, (Object)assetGlobalUniqueDetails.getCapitalAssetTypeCode())) == null || StringUtils.isBlank((CharSequence)assetType.getCapitalAssetTypeCode()))) {
            String errorPath = "document.newMaintainableObject.assetSharedDetails[" + sharedInd + "].assetGlobalUniqueDetails[" + uniqueInd + "]";
            GlobalVariables.getMessageMap().addToErrorPath(errorPath);
            GlobalVariables.getMessageMap().putError(CamsPropertyConstants.AssetGlobalDetail.CAPITAL_ASSET_TYPE_CODE, "error.capital.asset.type.code.invalid", new String[]{assetGlobalUniqueDetails.getCapitalAssetTypeCode()});
            GlobalVariables.getMessageMap().removeFromErrorPath(errorPath);
            success = false;
        }
        return success;
    }

    public static boolean validateAssetTotalCostMatchesPaymentTotalCost(AssetGlobal assetGlobal) {
        PaymentSummaryService paymentSummaryService = (PaymentSummaryService)SpringContext.getBean(PaymentSummaryService.class);
        assetGlobal.refreshReferenceObject("separateSourceCapitalAsset");
        KualiDecimal assetTotalCost = ObjectUtils.isNull((Object)assetGlobal.getSeparateSourceCapitalAsset().getTotalCostAmount()) ? new KualiDecimal(0) : assetGlobal.getSeparateSourceCapitalAsset().getTotalCostAmount();
        KualiDecimal paymentTotalCost = paymentSummaryService.calculatePaymentTotalCost(assetGlobal.getSeparateSourceCapitalAsset());
        if (!paymentTotalCost.equals((Object)assetTotalCost)) {
            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath("document.newMaintainableObject.separateSourceCapitalAssetNumber", "error.separate.asset.total.cost.not.match.payment.total.cost", new String[0]);
            return false;
        }
        return true;
    }

    public static boolean validateAssetAlreadySeparated(Long separateSourceCapitalAssetNumber) {
        AssetService assetService = (AssetService)SpringContext.getBean(AssetService.class);
        List<String> documentNumbers = assetService.getDocumentNumbersThatSeparatedThisAsset(separateSourceCapitalAssetNumber);
        if (!documentNumbers.isEmpty()) {
            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath("document.newMaintainableObject.separateSourceCapitalAssetNumber", "error.separate.asset.already.separated", new String[]{documentNumbers.toString()});
            return false;
        }
        return true;
    }

    protected boolean dataDictionaryValidate(MaintenanceDocument document) {
        AssetGlobal assetGlobal = (AssetGlobal)document.getNewMaintainableObject().getBusinessObject();
        LOG.debug("MaintenanceDocument validation beginning");
        GlobalVariables.getMessageMap().addToErrorPath("document.newMaintainableObject");
        Maintainable newMaintainable = document.getNewMaintainableObject();
        if (newMaintainable == null) {
            GlobalVariables.getMessageMap().removeFromErrorPath("document.newMaintainableObject");
            throw new ValidationException("Maintainable object from Maintenance Document '" + document.getDocumentTitle() + "' is null, unable to proceed.");
        }
        PersistableBusinessObject businessObject = newMaintainable.getBusinessObject();
        if (businessObject == null) {
            GlobalVariables.getMessageMap().removeFromErrorPath("document.newMaintainableObject.");
            throw new ValidationException("Maintainable's component business object is null.");
        }
        this.maintDocDictionaryService.validateMaintenanceRequiredFields(document);
        this.maintDocDictionaryService.validateMaintainableCollectionsForDuplicateEntries(document);
        this.getDictionaryValidationService().validateBusinessObjectOnMaintenanceDocument((BusinessObject)businessObject, document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
        if (!this.getAssetGlobalService().isAssetSeparate(assetGlobal)) {
            this.getDictionaryValidationService().validateDefaultExistenceChecks((BusinessObject)businessObject);
        } else {
            List references = KNSServiceLocator.getMaintenanceDocumentDictionaryService().getDefaultExistenceChecks(businessObject.getClass());
            for (ReferenceDefinition reference : references) {
                this.getDictionaryValidationService().validateReferenceExists((BusinessObject)assetGlobal, reference);
            }
        }
        GlobalVariables.getMessageMap().removeFromErrorPath("document.newMaintainableObject");
        LOG.debug("MaintenanceDocument validation ending");
        return true;
    }

    protected BusinessObjectDictionaryService getBusinessObjectDictionaryService() {
        if (this.businessObjectDictionaryService == null) {
            this.businessObjectDictionaryService = (BusinessObjectDictionaryService)SpringContext.getBean(BusinessObjectDictionaryService.class);
        }
        return this.businessObjectDictionaryService;
    }

    protected ParameterService getParameterService() {
        return (ParameterService)SpringContext.getBean(ParameterService.class);
    }

    protected AssetService getAssetService() {
        return (AssetService)SpringContext.getBean(AssetService.class);
    }

    protected AssetPaymentService getAssetPaymentService() {
        return (AssetPaymentService)SpringContext.getBean(AssetPaymentService.class);
    }

    protected AssetAcquisitionTypeService getAssetAcquisitionTypeService() {
        return (AssetAcquisitionTypeService)SpringContext.getBean(AssetAcquisitionTypeService.class);
    }

    protected AssetGlobalService getAssetGlobalService() {
        return (AssetGlobalService)SpringContext.getBean(AssetGlobalService.class);
    }

    static {
        LOCATION_FIELD_MAP.put(AssetLocationService.LocationField.CAMPUS_CODE, CamsPropertyConstants.AssetGlobalDetail.CAMPUS_CODE);
        LOCATION_FIELD_MAP.put(AssetLocationService.LocationField.BUILDING_CODE, CamsPropertyConstants.AssetGlobalDetail.BUILDING_CODE);
        LOCATION_FIELD_MAP.put(AssetLocationService.LocationField.ROOM_NUMBER, CamsPropertyConstants.AssetGlobalDetail.BUILDING_ROOM_NUMBER);
        LOCATION_FIELD_MAP.put(AssetLocationService.LocationField.SUB_ROOM_NUMBER, CamsPropertyConstants.AssetGlobalDetail.BUILDING_SUB_ROOM_NUMBER);
        LOCATION_FIELD_MAP.put(AssetLocationService.LocationField.CONTACT_NAME, CamsPropertyConstants.AssetGlobalDetail.OFF_CAMPUS_NAME);
        LOCATION_FIELD_MAP.put(AssetLocationService.LocationField.STREET_ADDRESS, CamsPropertyConstants.AssetGlobalDetail.OFF_CAMPUS_ADDRESS);
        LOCATION_FIELD_MAP.put(AssetLocationService.LocationField.CITY_NAME, CamsPropertyConstants.AssetGlobalDetail.OFF_CAMPUS_CITY_NAME);
        LOCATION_FIELD_MAP.put(AssetLocationService.LocationField.STATE_CODE, CamsPropertyConstants.AssetGlobalDetail.OFF_CAMPUS_STATE_CODE);
        LOCATION_FIELD_MAP.put(AssetLocationService.LocationField.ZIP_CODE, CamsPropertyConstants.AssetGlobalDetail.OFF_CAMPUS_ZIP_CODE);
        LOCATION_FIELD_MAP.put(AssetLocationService.LocationField.COUNTRY_CODE, CamsPropertyConstants.AssetGlobalDetail.OFF_CAMPUS_COUNTRY_CODE);
    }
}

